<?php $__env->startSection('title', 'Statistics | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Statistics'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>
<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<!-- tables -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.0.1/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.2/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/autofill/2.3.9/css/autoFill.bootstrap5.min.css">
<link rel="stylesheet"
    href="https://nightly.datatables.net/fixedheader/css/fixedHeader.dataTables.css?_=f0de745b101295e88f1504c17177ff49.css"
    type="text/css" />
<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-3">

        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>">Dashboard | </a>
            <a class="text-gray-300">Month pulses</a>
        </span>

        <div class="d-flex justify-content-center mt-2 mt-md-0">

            <div class="cont-branch-calendar me-2">
                <select id="select-branch-calendar"
                    class="js-example-basic-single select2-no-search select2-hidden-accessible">
                    <option value="all">
                        All
                    </option>
                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($item->id); ?>" <?php if($branch==$item->id): ?> selected <?php endif; ?>>
                        <?php echo e($item->name); ?>

                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="calendar-datepicker">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text ps-3"><i class="bi bi-calendar2-week-fill"></i> </div>
                    </div>
                    <input id="calendar-date-input" type="text" value="<?php echo e($date); ?>"
                        class="form-control hasdatetimepicker " placeholder="MM-YYYY">
                </div>
            </div>
        </div>

    </div>

    <div class="row mb-3">
        <ul class="nav nav-tabs nav-tabs-nobg nav-tabs-cat justify-content-center pe-0" id="myTab" role="tablist">
            <li class="nav-item" role="presentation">
                <a href="<?php echo e(route('sett.pulses_day_st')); ?>" class="nav-link" id="year_invoice-tab">
                    <?php echo e(__('basic.daily st')); ?></a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="<?php echo e(route('sett.pulses_month_st')); ?>" class="nav-link active" id="specialty-tab">
                    <?php echo e(__('basic.monthly st')); ?></a>
            </li>
        </ul>
    </div>

    <div class="row">

        <div class="col-12 px-0 px-md-2">
            <div class="card card-input shadow mb-4">
                <!-- Card Body -->
                <div class="card-body">
                    <div class="row">

                        <div class="col-12 col-md-6 mb-3 mb-md-0 border-flex">
                            <div class="chart-pie pt-4 pb-2">
                                <canvas id="myChart">
                                    <!-- the code and its style is printed from js -->
                                </canvas>
                            </div>
                        </div>

                        <div class="col-12 col-md-6 text-center align-self-center">
                            <h6 class="text-gray-400">Total Pulses</h6>
                            <?php
                            //$profit = $all_pulses->sum('total_paid') - $all_pulses->sum('total_paid');
                            ?>
                            <span class="fs-1"><?php echo e($all_pulses->sum('used_pulses')); ?><small
                                    class="text-gray-300 text-xxxs">
                                    ps</small></span>
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </div>

    <div class="row">
        <div class="col-12 px-0 px-md-2 mb-4">
            <div class="card card-input shadow h-100">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> All Pulses</h6>
                </div>

                <!-- Card Body -->
                <div class="card-body overflow-scroll">

                    <div class="table-responsive">
                        <table class="table display datatable-modal" id="table-income-all" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th class="text-xs"><?php echo e(__('basic.date')); ?></th>
                                    <th class="text-xs text-center">
                                        <?php echo e(__('basic.type')); ?></th>
                                    <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                    <th class="text-xs"><?php echo e(__('basic.patient')); ?></th>
                                    <th class="text-xs text-center"><?php echo e(__('basic.doctor')); ?>

                                    </th>
                                    <th class="text-xs text-center"><?php echo e(__('patientappo.pay status')); ?>

                                    </th>
                                    <th class="text-xs"><?php echo e(__('basic.fluence')); ?></th>
                                    <th class="text-xs"><?php echo e(__('basic.pulse area')); ?></th>
                                    <th class="text-xs"><?php echo e(__('basic.spot size')); ?></th>
                                    <th class="text-xs"><?php echo e(__('basic.balance before session')); ?>

                                    </th>
                                    <th class="text-xs"><?php echo e(__('basic.used pulses')); ?></th>
                                    <th class="text-xs"><?php echo e(__('basic.add pulses')); ?></th>
                                </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                    <th class="text-center fw-bold text-s">TOTAL</th>
                                    <th class="text-center fw-bold text-s2">
                                        <?php echo e($all_pulses->sum('used_pulses')); ?> <small
                                            class="text-gray-300 text-xxxs">ps</small>
                                    </th>
                                </tr>
                            </tfoot>

                            <tbody>
                                <?php $__currentLoopData = $all_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($item->type == 0): ?>
                                <?php
                                $text_color = 'active-color-btn';
                                $msg = __('patientappo.session');
                                ?>
                                <?php elseif($item->type == 1): ?>
                                <?php
                                $text_color = 'done-color-btn';
                                $msg = __('basic.money per pulse');
                                ?>
                                <?php elseif($item->type == 2): ?>
                                <?php
                                $text_color = 'prog-color-btn';
                                $msg = __('basic.session package');
                                ?>
                                <?php elseif($item->type == 3): ?>
                                <?php
                                $text_color = 'not_accepted-color-btn';
                                $msg = __('basic.pulses package');
                                ?>
                                <?php endif; ?>

                                <?php if($item->invoice_item): ?>
                                <?php if($item->invoice_item->invoice->status == 0): ?>
                                <?php
                                $text_color_invoice = 'cancel-color-btn';
                                $msg_invoice = __('basic.not paid');
                                ?>
                                <?php elseif($item->invoice_item->invoice->status == 1): ?>
                                <?php
                                $text_color_invoice = 'pend-color-btn';
                                $msg_invoice = __('basic.pending');
                                ?>
                                <?php elseif($item->invoice_item->invoice->status == 2): ?>
                                <?php
                                $text_color_invoice = 'prog-color-btn';
                                $msg_invoice = __('basic.installment');
                                ?>
                                <?php elseif($item->invoice_item->invoice->status == 3): ?>
                                <?php
                                $text_color_invoice = 'done-color-btn';
                                $msg_invoice = __('basic.paid');
                                ?>
                                <?php elseif($item->invoice_item->invoice->status == 4): ?>
                                <?php
                                $text_color_invoice = 'cancel-color-btn';
                                $msg_invoice = __('basic.refund');
                                ?>
                                <?php endif; ?>
                                <?php
                                $invoice_url = 'href=' . route('sett.invoice.show', $item->invoice_item->invoice->id);

                                ?>
                                <?php else: ?>
                                <?php
                                $text_color_invoice = 'done-color-btn';
                                $msg_invoice = __('basic.from package');
                                $invoice_url = '';
                                ?>
                                <?php endif; ?>

                                <tr>
                                    <td><?php echo e(date('d M Y', strtotime($item->date))); ?></td>
                                    <td class="text-center"> <span
                                            class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                    </td>

                                    <td><a class="text-center text-gray-500"
                                            href="<?php echo e(route('sett.patient.show', $item->patient->id)); ?>">
                                            <?php echo e($item->patient->name); ?></a></td>

                                    <td>
                                        <?php if($item->service_item): ?>
                                        <?php echo e($item->service_item->name); ?>

                                        <?php else: ?>
                                        Taken from package
                                        <?php endif; ?>
                                    </td>

                                    <td class="text-center">
                                        <?php if($item->doctor): ?>
                                        <?php echo e($item->doctor->name); ?>

                                        <?php else: ?>
                                        No selected
                                        <?php endif; ?>
                                    </td>

                                    <td class="text-center"> <a <?php echo e($invoice_url); ?>><span
                                                class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span></a>
                                    </td>

                                    <td class="text-center">
                                        <?php echo e($item->fluence); ?>

                                    </td>
                                    <td class="text-center">
                                        <?php if($item->pulse_area): ?>
                                        <?php echo e($item->pulse_area->name); ?>

                                        <?php else: ?>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <?php echo e($item->spot_size); ?>

                                    </td>
                                    <td class="text-center">
                                        <?php echo e($item->balance_before_session); ?>

                                    </td>
                                    <td class="text-center">
                                        <?php echo e($item->used_pulses); ?>

                                    </td>
                                    <td class="text-center">
                                        <?php echo e($item->add_pulses); ?>

                                    </td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>


                </div>
            </div>
        </div>
    </div>

    <div class="row mb-4">

        <div class="col-12 col-md-6 mb-4 mb-md-0">
            <div class="card card-input shadow h-100">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> All doctor pulses
                    </h6>
                </div>

                <!-- Card Body -->
                <div class="card-body overflow-scroll">
                    <div class="table-responsive">
                        <table class="table display datatable-modal" id="table-income-totals-cat" width="100%"
                            cellspacing="0">
                            <thead>
                                <tr>
                                    <th class="text-xs text-center">Name</th>
                                    <th class="text-xs text-center">Total</th>
                                </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                    <th width="50%" class="text-center fw-bold text-s">TOTAL</th>
                                    <th width="50%" class="text-center fw-bold text-s2">
                                        <?php echo e($all_pulses->sum('used_pulses')); ?> <small class="text-gray-300 text-xxxs">
                                            ps</small>
                                    </th>
                                </tr>
                            </tfoot>

                            <tbody>
                                <?php $__currentLoopData = $doctor_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center text-truncate">
                                        <?php if($item->doctor): ?>
                                        <?php echo e($item->doctor->name); ?>

                                        <?php else: ?>
                                        No selected
                                        <?php endif; ?>
                                    </td>

                                    <td class="text-center">
                                        <?php echo e($item->total); ?> <small class="text-gray-300 text-xxxs">
                                            ps</small>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>

        <div class="col-12 col-md-6">
            <div class="card card-input shadow h-100">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> All doctor pulses
                        chart
                    </h6>
                </div>

                <!-- Card Body -->
                <div class="card-body overflow-scroll">
                    <h5 class="text-center text-gray-300"> Doctor pulses chart</h5>
                    <div class="chart-pie px-1">
                        <canvas id="myChart-doctor">
                            <!-- the code and its style is printed from js -->
                        </canvas>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <?php $__env->stopSection(); ?>

    <!-- js insert -->
    <?php $__env->startSection('js'); ?>

    <!-- select 2 -->
    <script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(document).ready(function() {
                $('.js-example-basic-single').select2();
                //hide search
                $('.select2-no-search').select2({
                    minimumResultsForSearch: -1
                });
            });
    </script>

    <script>
        $(document).ready(function() {

                //--------------------- selectors -------------------
                $(document).on('change', '#select-specialty-calendar, #select-branch-calendar', function() {
                    var date_input = $('#calendar-date-input').val();
                    var date = $('#select-branch-calendar').val();

                    var url = "<?php echo e(route('sett.pulses_month_st', [':date_input', ':date'])); ?>";

                    url = url.replace(':date_input', date_input).replace(':date', date);

                    var url = url;
                    window.location.href = url;
                });
                $(document).on('change', '#calendar-date-input', function() {
                    var date_input = $('#calendar-date-input').val();
                    var date = $('#select-branch-calendar').val();

                    var url = "<?php echo e(route('sett.pulses_month_st', [':date_input', ':date'])); ?>";

                    url = url.replace(':date_input', date_input).replace(':date', date)

                    window.location.href = url;
                });
            });
    </script>

    <!-- jquery ui datepicker -->
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>

    <script>
        $(function() {
                $('.hasdatetimepicker').datepicker({
                    todayHighlight: true,
                    format: "mm-yyyy",
                    viewMode: "months",
                    minViewMode: "months"
                });
            });
    </script>

    <!-- -- Chart.js plugin -- -->
    <script src="https://fastly.jsdelivr.net/npm/chart.js"></script>

    <?php
    $chart_color = ['#1a78f1', '#38dfa8', '#d13c62', '#12c7d9', '#03c2c3', '#5035df', '#17a673', '#2e59d9', '#9aeded',
    '#f3d56a', '#7c859d', '#a4adc5', '#80142f', '#33d293', '#bed233', '#3958e9', '#10c86f', '#654fb6', '#a44fb6',
    '#89728e', '#c85110', '#6d769d', '#1b6954', '#204494', '#94206b', '#948320', '#209493', '#292094', '#203a65',
    '#4e6fa5', '#e29031', '#e23168', '#31e0e2', '#e29131', '#319fe2', '#8131e2', '#31a8e2', '#31e2c0', '#31c3e2',
    '#e2a931', '#3157e2', '#dc3545', '#51b24b', '#a94bb2', '#4b8bb2', '#57b24b', '#a5b24b', '#b2804b', '#b24b4b',
    '#834bb2', '#b24b6a', '#574bb2', '#236368', '#232c68', '#682345', '#4b2368', '#234b68', '#306823', '#a39f39',
    '#a239a3', '#a33963', '#a33951', '#a33939', '#c73737', '#6837c7'];
    ?>

    <script>
        // --------- credit chart ---------
            var ctx_recourse = document.getElementById("myChart");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        <?php $__currentLoopData = $branch_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->branch->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $branch_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $branch_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });

            // --------- credit chart ---------
            var ctx_recourse = document.getElementById("myChart-doctor");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        <?php $__currentLoopData = $doctor_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($item->doctor): ?>
                                "<?php echo e($item->doctor->name); ?>"
                            <?php else: ?>
                                "No doctor"
                            <?php endif; ?> ,
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $doctor_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $doctor_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
    </script>

    <!-- -- datatables plugin -- -->
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.bootstrap5.min.js"></script>

    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>

    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.colVis.min.js"></script>
    <script
        src="https://nightly.datatables.net/fixedheader/js/dataTables.fixedHeader.js?_=f0de745b101295e88f1504c17177ff49">
    </script>

    <script>
        $(document).ready(function() {

                var table = $('#table-income-all').DataTable({
                        lengthChange: false,
                        "pageLength": 10,
                        "order": [
                            [0, "ASC"]
                        ],
                        buttons: {
                            dom: {
                                button: {
                                    className: 'btn btn-table-export me-0' //Primary class for all buttons
                                }
                            },
                            buttons: [{
                                    extend: 'copyHtml5',
                                    footer: true
                                },
                                {
                                    extend: 'excelHtml5',
                                    footer: true
                                },
                                {
                                    extend: 'pdfHtml5',
                                    footer: true
                                },
                                {
                                    extend: 'print',
                                    footer: true
                                }
                            ]
                        }
                    }

                );
                table.buttons().container()
                    .appendTo('#table-income-all_wrapper .col-md-6:eq(0)');

                var table = $('#table-expenses-all').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-expenses-all_wrapper .col-md-6:eq(0)');

                var table = $('#table-income-totals-cat').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-income-totals-cat_wrapper .col-md-6:eq(0)');

                var table = $('#table-expenses-totals-cat').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-expenses-totals-cat_wrapper .col-md-6:eq(0)');

                var table = $('#table-income-totals').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-income-totals_wrapper .col-md-6:eq(0)');

                var table = $('#table-expenses-totals').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-expenses-totals_wrapper .col-md-6:eq(0)');

                var table = $('#table-operation-income-all').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-operation-income-all_wrapper .col-md-6:eq(0)');

                var table = $('#table-operation-expenses-all').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-operation-expenses-all_wrapper .col-md-6:eq(0)');

            });
    </script>

    <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/medix/public_html/samirghoraba/med/resources/views/patient/pulses/monthpulses.blade.php ENDPATH**/ ?>