<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>
        <?php if($invoice->receivable): ?>
            <?php echo e($invoice->receivable->name); ?>

        <?php else: ?>
            No receiver
        <?php endif; ?> - <?php echo e($invoice->code); ?>

    </title>
    <link rel="stylesheet" href="<?php echo e(public_path('css/kv-mpdf-bootstrap.css')); ?>">

</head>

<body>

    <div class="card-body px-4">

        <div class="row mb-3 b-r-s-cont border2 py-3 px-2">

            <div class="col-xs-5 text-truncate p-0" style="">
                <div class="w-10">
                    <?php if($invoice->receivable): ?>

                        <div class="p-0" style="width: 25%;float: left;">
                            <div class="rounded-circle avatar-m2 profile_img"
                                style="background-image: url(<?php echo e(public_path('img/useravatar/' . $invoice->receivable->avatar)); ?>)">
                            </div>
                        </div>

                        <div class="text-truncate p-0" style="width: 75%;float: left;">
                            <p class="m-0 p-0 text-s">
                                <?php if($invoice->receivable_type === 'App\Models\Patient\Patient'): ?>
                                    Patient
                                <?php elseif($invoice->receivable_type === 'App\Models\User'): ?>
                                    Doctor
                                <?php elseif($invoice->receivable_type === 'App\Models\Invoice\Debtor'): ?>
                                    Debtor
                                <?php endif; ?>
                            </p>
                            <p class="m-0 p-0 text-s fw-bold2 text-truncate">
                                <?php echo e($invoice->receivable->name); ?></p>
                            <p class="m-0 p-0 text-s">
                                <?php echo e(date('d M Y h:i a', strtotime($invoice->created_at))); ?>

                            </p>
                        </div>
                    <?php else: ?>
                        The invoice is for no receiver
                    <?php endif; ?>

                </div>
            </div>

            <div class="col-xs-1 px-0" style="display: inline;">
                <p class="text-s mb-0">Type</p>
                <p class="fw-bold2">
                    <?php if($invoice->type == 0): ?>
                        Client
                    <?php else: ?>
                        Client
                    <?php endif; ?>
                </p>
            </div>

            <div class="col-xs-2 px-0" style="display: inline;">
                <p class="text-s mb-0">Specialty</p>
                <p class="fw-bold2">
                    <?php echo e($invoice->specialty->name); ?>

                </p>
            </div>

            <div class="col-xs-1 px-0 text-truncate">
                <p class="text-s mb-0 text-truncate">Branch</p>
                <p class="fw-bold2"><?php echo e($invoice->branch->name); ?></p>
            </div>

            <div class="col-xs-2">
                <p class="text-s mb-0">Paid At</p>
                <p class="fw-bold2"><?php echo e(date('d M Y h:i a', strtotime($invoice->paid_date))); ?></p>
            </div>
        </div>

        <br class="mb-5">

        <?php $__currentLoopData = $invoice->invoice_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="row px-0 mt-3">
                <div class="col-xs-6 px-0 text-center text-s2">
                    <i class="fas fa-stethoscope me-2"></i>
                    <span id="service_final_info text-l fw-bold"><?php echo e($item->categorizable->name); ?></span>
                </div>
                <div class="col-xs-6 px-0 text-center text-l2 fw-bold">
                    <div class="text-s2 fw-bold2"><?php echo e($item->price); ?><small class="text-gray-300 text-s">
                            EGP</small>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <hr>

        <div class="row px-0 px-md-3 px-lg-5 my-2">
            <div class="col-xs-6 px-0 text-center text-l text-s2">
                <i class="fas fa-coins me-2 text-gray-400"></i><span
                    id="service_final_info"><?php echo e(__('basic.subtotal')); ?></span>
            </div>
            <div class="col-xs-6 px-0 text-center text-l2 fw-bold">
                <div class="text-s2"><?php echo e($invoice->invoice_items->sum('price')); ?><small class="text-gray-300 text-xxxs">
                        <?php echo e(__('basic.egp')); ?></small>
                </div>
            </div>
        </div>

        <div class="row px-0 mb-2">
            <div class="col-xs-6 px-0 text-center text-l text-s2">
                <i class="fas fa-stethoscope me-2"></i>
                <span id="service_final_info text-l fw-bold">Discount</span>
            </div>
            <div class="col-xs-6 px-0 text-center text-l2 fw-bold">
                <div class="text-s2 fw-bold2">
                    <?php if(!empty($invoice->discount)): ?>
                        <?php echo e($invoice->discount); ?>

                        <small class="text-gray-300 text-s"> EGP</small>
                    <?php else: ?>
                        0
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-xs-6 px-0 text-center text-l text-s2">
                <i class="fas fa-dollar-sign me-2"></i>
                <span id="service_final_info"><?php echo e(__('patientappo.final price')); ?></span>
            </div>
            <div class="col-xs-6 px-0 text-center text-l2 fw-bold">
                <div class="text-s2 fw-bold" id="price_total_final_info_edit">
                    <?php echo e($invoice->final_price); ?><small class="text-gray-300 text-xxxs">
                        <?php echo e(__('basic.egp')); ?></small>
                </div>
            </div>
        </div>

        
        <?php if(count($invoice->payment) > 0): ?>

            <hr>

            <?php $__currentLoopData = $invoice->payment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item_p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    if ($item_p->method == 1) {
                        $method_payment = 'Cash';
                    } else {
                        $method_payment = 'Visa';
                    }
                ?>
                <div class="row px-0 px-md-3 px-lg-5 mt-2">
                    <div class="col-xs-6 px-0 text-center text-l text-s2">
                        <i class="fas fa-pen me-2 link-cust-text text-gray-400 clickable-item-pointer"
                            data-bs-toggle="modal" data-bs-target="#edit_inv_payment_<?php echo e($item_p->id); ?>"></i>

                        <i class="fas fa-dollar-sign me-1 text-gray-400"></i>
                        <?php if($item_p->type == 2): ?>
                            <span id="service_final_info"
                                class="pend-color"><?php echo e(date('d M Y', strtotime($item_p->installment_date))); ?>

                                Installment
                            </span>
                        <?php else: ?>
                            <span id="service_final_info"><?php echo e(date('d M Y', strtotime($item_p->paid_date))); ?>

                                via
                                <?php echo e($method_payment); ?>

                            </span>
                        <?php endif; ?>
                        <?php if($item_p->installment_date): ?>
                            <p class="mb-0">Installment:
                                <?php echo e(date('d M Y', strtotime($item_p->installment_date))); ?>

                            </p>
                        <?php endif; ?>
                        <?php if($item_p->worker): ?>
                            <p class="text-gray-400 mb-0">Shift:
                                <?php echo e($item_p->worker->name); ?>

                            </p>
                        <?php endif; ?>
                    </div>
                    <div class="col-xs-6 px-0 text-center text-l2 fw-bold">
                        <div class="text-s2"><?php echo e($item_p->amount); ?><small class="text-gray-300 text-xxxs">
                                <?php echo e(__('basic.egp')); ?></small>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <div class="row px-0 px-md-3 px-lg-5 my-2">
                <div class="col-xs-6 px-0 text-center text-l text-s2">
                    <i class="fas fa-dollar-sign me-2"></i>
                    <span id="service_final_info"><?php echo e(__('basic.total payments')); ?></span>
                </div>

                <div class="col-xs-6 px-0 text-center text-l2 fw-bold">
                    <div class="text-s2 fw-bold">
                        <?php if($invoice->sum_payment): ?>
                            <?php echo e($invoice->sum_payment); ?>

                        <?php else: ?>
                            0
                        <?php endif; ?>
                        <small class=" text-xxxs"> <?php echo e(__('basic.egp')); ?></small>
                    </div>
                </div>
            </div>

            <?php if($invoice->status !== 3): ?>
                <hr>
                <div class="row px-0 px-md-3 px-lg-5 my-2 mb-5">
                    <div class="col-xs-6 px-0 text-center text-l text-s2">
                        <i class="fas fa-money-check me-2 text-gray-400"></i>
                        <span id="service_final_info"><?php echo e(__('basic.remaining amount')); ?></span>
                    </div>
                    <div class="col-xs-6 px-0 text-center text-l2 fw-bold">
                        <div class="text-s2 fw-bold2">
                            <?php echo e($invoice->final_price - $invoice->sum_payment); ?><small class="text-gray-300 text-xxxs">
                                <?php echo e(__('basic.egp')); ?></small>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>

        <div class="row align-items-center main-color-bg b-r-s-cont border-0 text-white b-r-s-cont px-0 py-4 mt-4">
            <div class="col-xs-5 text-blue-300 mb-md-0 ps-5">
                Here is the total price that you have paid including tax with discount applied
            </div>

            <div class="col-xs-5 text-center px-0">

                <?php if($invoice->status == 0): ?>
                    <p id="date_final_info" class="fs-2 fw-bold mb-0">
                        <?php echo e(__('basic.not paid')); ?>

                    </p>
                <?php elseif(in_array($invoice->status, [1, 2])): ?>
                    <h6 class="text-xs mb-2 text-blue-300"><?php echo e(__('basic.remaining amount')); ?></h6>
                    <p class="text-l text-white fw-bold2 mb-0">
                        <?php echo e($invoice->final_price - $invoice->sum_payment); ?> <small class="text-blue-300 text-xxxs">
                            <?php echo e(__('basic.egp')); ?></small>
                    </p>
                <?php else: ?>
                    <h6 class="text-xs mb-0 text-blue-300"><?php echo e(__('patientappo.amount to pay')); ?></h6>
                    <p id="date_final_info" class="text-l text-white fw-bold2 mb-0">
                        <?php echo e($invoice->final_price); ?> <small class="text-blue-300 text-xxxs">
                            <?php echo e(__('basic.egp')); ?></small>
                    </p>
                <?php endif; ?>
            </div>

        </div>
    </div>

</body>

</html>
<?php /**PATH /home/drsamirghoraba/public_html/prox/proxima/resources/views/invoice/print.blade.php ENDPATH**/ ?>