<?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Doctor|Branch-manager|Receptionist')): ?>
<!-- Payment -->
<div class="col-lg-5 pe-0">
    <div class="card shadow mb-4">

        <div id="payment_wallet" class="carousel slide curr-treament-info-carousel" data-bs-ride="carousel"
            data-bs-interval="false">

            <div class="carousel-indicators dots-radius-carousel" style="bottom: 34px; margin-bottom: 0px;">
                <button type="button" data-bs-target="#payment_wallet" data-bs-slide-to="0" class="active"
                    aria-current="true" aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#payment_wallet" data-bs-slide-to="1"
                    aria-label="Slide 2"></button>
            </div>

            <div class="carousel-inner">

                <!-- Current treatments -->
                <div class="carousel-item active">
                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer"><?php echo e(__('basic.payment')); ?></span>
                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#payment_wallet" data-bs-slide-to="1" aria-label="Slide 2">
                                <?php echo e(__('patientappo.wallet')); ?></span>
                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#add_wallet"><?php echo e(__('basic.add wallet balance')); ?></a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->
                    <div class="card-body pb-2">

                        <?php if(count($patient->invoices) > 0): ?>
                        <div class="d-flex justify-content-between">
                            <p class="text-xs text-gray-300"><?php echo e(__('patientappo.transaction')); ?></p>
                            <p class="text-xs text-gray-300"><?php echo e(__('basic.amount')); ?></p>
                        </div>

                        <?php $__currentLoopData = $patient->invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        
                        <?php if($loop->index === 4) break; ?>

                        <?php if($item->status == 0): ?>
                        <?php
                        $text_color = 'cancel-color-btn';
                        $msg = __('basic.not paid');
                        ?>
                        <?php elseif($item->status == 1): ?>
                        <?php
                        $text_color = 'pend-color-btn';
                        $msg = __('basic.pending');
                        ?>
                        <?php elseif($item->status == 2): ?>
                        <?php
                        $text_color = 'prog-color-btn';
                        $msg = __('basic.installment');
                        ?>
                        <?php elseif($item->status == 3): ?>
                        <?php
                        $text_color = 'done-color-btn';
                        $msg = __('basic.paid');
                        ?>
                        <?php elseif($item->status == 4): ?>
                        <?php
                        $text_color = 'cancel-color-btn';
                        $msg = __('basic.refund');
                        ?>
                        <?php endif; ?>

                        <?php if($item->operation == 1): ?>
                        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Operation')): ?>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                <i class="fas fa-circle me-2 text-xxs mb-0 <?php echo e($text_color); ?>"></i>

                                <div class="text-truncate">
                                    <a href="<?php echo e(route('sett.invoice.show', $item->id)); ?>"
                                        class="text-s text-truncate link-cust-text text-gray-500 mb-0 fw-bold">
                                        <?php echo e($item->code); ?></a>
                                    <p class="text-xs text-gray-300 fw-bold mb-0"><?php echo e($msg); ?></p>
                                </div>
                            </div>

                            <div class="text-s text-gray-600 fw-bold"><?php echo e($item->final_price); ?><small
                                    class="text-gray-300 text-xxxs">
                                    <?php echo e(__('basic.egp')); ?></small>
                            </div>
                        </div>
                        <?php endif; ?>
                        <?php else: ?>
                        <div class="d-flex justify-content-between align-items-center mb-3">

                            <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                <i class="fas fa-circle me-2 text-xxs mb-0 <?php echo e($text_color); ?>"></i>

                                <div class="text-truncate">
                                    <a href="<?php echo e(route('sett.invoice.show', $item->id)); ?>"
                                        class="text-s text-truncate link-cust-text text-gray-500 mb-0 fw-bold">
                                        <?php echo e($item->service_inv_cat->name); ?></a>
                                    <p class="text-xs text-gray-300 fw-bold mb-0"><?php echo e($msg); ?></p>
                                </div>
                            </div>

                            <div class="text-s text-gray-600 fw-bold"><?php echo e($item->final_price); ?><small
                                    class="text-gray-300 text-xxxs">
                                    <?php echo e(__('basic.egp')); ?></small>
                            </div>

                        </div>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                        <div class="text-center">
                            <i class="bi bi-brightness-alt-high-fill fa-sm fa-fw fs-2"></i>
                            <p class="fw-light mb-0"><?php echo e(__('basic.nothing to show')); ?></p>
                        </div>
                        <?php endif; ?>
                    </div>

                    <!-- Card footer -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#payment_show">
                            <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                        </a>
                    </div>
                </div>
                <div class="carousel-item">
                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer"><?php echo e(__('patientappo.wallet')); ?></span>
                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#payment_wallet" data-bs-slide-to="0" aria-label="Slide 1"><?php echo e(__('basic.payment')); ?></span>
                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#add_wallet"><?php echo e(__('basic.add wallet balance')); ?></a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->
                    <div class="card-body pb-2">

                        <?php if(count($patient->wallet_reco) > 0): ?>
                        <div class="d-flex justify-content-between">
                            <p class="text-xs text-gray-300"><?php echo e(__('patientappo.transaction')); ?></p>
                            <p class="text-xs text-gray-300"><?php echo e(__('basic.amount')); ?></p>
                        </div>

                        <?php $__currentLoopData = $patient->wallet_reco; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        
                        <?php if($loop->index === 4) break; ?>

                        <?php if($item->type == 0): ?>
                        <?php
                        $text_color = 'main-color';
                        $msg = __('basic.add');
                        ?>
                        <?php elseif($item->type == 1): ?>
                        <?php
                        $text_color = 'cancel-color';
                        $msg = __('basic.withdraw');
                        ?>
                        <?php endif; ?>

                        <div class="d-flex justify-content-between align-items-center mb-3">

                            <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                <i class="fas fa-circle me-2 text-xxs mb-0 <?php echo e($text_color); ?>"></i>

                                <div class="text-truncate">
                                    <a class="text-s text-truncate link-cust-text text-gray-500 mb-0 fw-bold">
                                        <?php if($item->service): ?>
                                        <?php echo e($item->service->name); ?>

                                        <?php else: ?>
                                        Add new balance
                                        <?php endif; ?>
                                    </a>
                                    <p class="text-xs text-gray-300 fw-bold mb-0"><?php echo e($msg); ?></p>
                                </div>
                            </div>

                            <div class="text-s text-gray-600 fw-bold"><?php echo e($item->amount); ?><small
                                    class="text-gray-300 text-xxxs">
                                    <?php echo e(__('basic.egp')); ?></small>
                            </div>

                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                        <div class="text-center">
                            <i class="bi bi-brightness-alt-high-fill fa-sm fa-fw fs-2"></i>
                            <p class="fw-light mb-0"><?php echo e(__('basic.nothing to show')); ?></p>
                        </div>
                        <?php endif; ?>
                    </div>

                    <!-- Card footer -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#wallet_show">
                            <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                        </a>
                    </div>
                </div>
            </div>

            <!-- Modal show all invoices -->
            <div class="modal fade" id="payment_show" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-capsules me-1"></i>
                                <?php echo e(__('basic.payment')); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-4">

                            <div class="table-responsive">
                                <table class="table display datatable-modal" id="table-payment" width="100%"
                                    cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.type')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.discount')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('patientappo.final price')); ?>

                                            </th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.paid')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.status')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.description')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.branch')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.date')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $patient->invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($item->status == 0): ?>
                                        <?php
                                        $text_color_invoice = 'cancel-color-btn';
                                        $msg_invoice = __('basic.not paid');
                                        ?>
                                        <?php elseif($item->status == 1): ?>
                                        <?php
                                        $text_color_invoice = 'pend-color-btn';
                                        $msg_invoice = __('basic.pending');
                                        ?>
                                        <?php elseif($item->status == 2): ?>
                                        <?php
                                        $text_color_invoice = 'prog-color-btn';
                                        $msg_invoice = __('basic.installment');
                                        ?>
                                        <?php elseif($item->status == 3): ?>
                                        <?php
                                        $text_color_invoice = 'done-color-btn';
                                        $msg_invoice = __('basic.paid');
                                        ?>
                                        <?php elseif($item->status == 4): ?>
                                        <?php
                                        $text_color_invoice = 'cancel-color-btn';
                                        $msg_invoice = __('basic.refund');
                                        ?>
                                        <?php endif; ?>

                                        <?php if($item->type == 0): ?>
                                        <?php
                                        $text_color_invoice_type = 'main-color-btn';
                                        $msg_invoice_type = __('patientappo.income');
                                        ?>
                                        <?php else: ?>
                                        <?php
                                        $text_color_invoice_type = 'pend-color-btn';
                                        $msg_invoice_type = __('patientappo.expenses');
                                        ?>
                                        <?php endif; ?>

                                        <?php if($item->operation == 1): ?>
                                        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Operation')): ?>
                                        <tr>
                                            <td><a class="link-cust-text text-gray-500"
                                                    href="<?php echo e(route('sett.invoice.show', $item->id)); ?>">
                                                    <?php echo e($item->service_inv_cat->name); ?></a></td>
                                            <td class="text-center"><span
                                                    class="badge rounded-pill <?php echo e($text_color_invoice_type); ?> badge-padd-l"><?php echo e($msg_invoice_type); ?></span>
                                            </td>
                                            <td class="text-center">
                                                <?php if(!empty($item->discount)): ?>
                                                <?php echo e($item->discount); ?> <small class="text-gray-300 text-xxxs">
                                                    <?php echo e(__('basic.egp')); ?></small>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-center"><?php echo e($item->final_price); ?> <small
                                                    class="text-gray-300 text-xxxs">
                                                    <?php echo e(__('basic.egp')); ?></small></td>
                                            <td class="text-center">
                                                <?php if(!empty($item->paid)): ?>
                                                <?php echo e($item->paid); ?> <small class="text-gray-300 text-xxxs">
                                                    <?php echo e(__('basic.egp')); ?></small>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-center"> <span
                                                    class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span>
                                            </td>
                                            <td class="text-center"> <?php echo e($item->note); ?> <?php if($item->worker): ?>
                                                | shift: <?php echo e($item->worker->name); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td class="text-center"> <?php echo e($item->branch->name); ?></td>
                                            <td class="text-center">
                                                <?php echo e(date('Y-m-d', strtotime($item->paid_date))); ?> <br>
                                                <?php echo e(date('h:i a', strtotime($item->paid_date))); ?></td>
                                        </tr>
                                        <?php endif; ?>
                                        <?php else: ?>
                                        <tr>
                                            <td><a class="link-cust-text text-gray-500"
                                                    href="<?php echo e(route('sett.invoice.show', $item->id)); ?>">
                                                    <?php echo e($item->service_inv_cat->name); ?></a></td>
                                            <td class="text-center"><span
                                                    class="badge rounded-pill <?php echo e($text_color_invoice_type); ?> badge-padd-l"><?php echo e($msg_invoice_type); ?></span>
                                            <td class="text-center">
                                                <?php if(!empty($item->discount)): ?>
                                                <?php echo e($item->discount); ?> <small class="text-gray-300 text-xxxs">
                                                    <?php echo e(__('basic.egp')); ?></small>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-center"><?php echo e($item->final_price); ?> <small
                                                    class="text-gray-300 text-xxxs">
                                                    <?php echo e(__('basic.egp')); ?></small></td>
                                            <td class="text-center">
                                                <?php if(!empty($item->paid)): ?>
                                                <?php echo e($item->paid); ?> <small class="text-gray-300 text-xxxs">
                                                    <?php echo e(__('basic.egp')); ?></small>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-center"> <span
                                                    class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span>
                                            </td>
                                            <td class="text-center"> <?php echo e($item->note); ?> <?php if($item->worker): ?>
                                                | shift: <?php echo e($item->worker->name); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td class="text-center"> <?php echo e($item->branch->name); ?></td>
                                            <td class="text-center">
                                                <?php echo e(date('Y-m-d', strtotime($item->paid_date))); ?> <br>
                                                <?php echo e(date('h:i a', strtotime($item->paid_date))); ?></td>

                                        </tr>
                                        <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="button" class="btn btn-default btn-link main-color"><?php echo e(__('basic.save
                                    changes')); ?></button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>


            <!-- Modal for inserting wallet -->
            <div class="modal fade" id="add_wallet" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-wallet me-1"></i>
                                <?php echo e(__('patientappo.add wallet balance')); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="<?php echo e(route('sett.pat_add_wallet_balance', $patient->id)); ?>"
                            method="post" style="display: contents;">
                            <?php echo e(method_field('POST')); ?>

                            <?php echo e(csrf_field()); ?>


                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.branch')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-wallet-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['branch_wallet'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="branch_wallet" name="branch_wallet" required>
                                            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>">
                                                <?php echo e($item->name); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="branch_wallet_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['branch_wallet'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.type')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-wallet-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['type_wallet'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="type_wallet" name="type_wallet" required>
                                            <option value="0">
                                                <?php echo e(__('patientappo.income')); ?>

                                            </option>
                                            <option value="1">
                                                <?php echo e(__('patientappo.expenses')); ?>

                                            </option>
                                        </select>

                                        <span id="type_wallet_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['type_wallet'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.date')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="wallet_date" type="text"
                                                class="form-control datepicker_time bg-white <?php $__errorArgs = ['wallet_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="YYYY/MM/DD HM" data-enable-time="true" required>
                                        </div>
                                        <span id="wallet_date_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['wallet_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"> <?php echo e(__('patientappo.wallet balance')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                        <input name="wallet_price" type="number"
                                            class="form-control <?php $__errorArgs = ['wallet_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="Wallent balance.." required>

                                        <span id="wallet_price_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['wallet_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.note')); ?>

                                            <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                        <textarea name="balance_note" class="form-control "
                                            placeholder="Write here the invoice note .." rows="4"
                                            spellcheck="false"></textarea>
                                        <span id="note" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['balance_note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                </div>

                                <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">Add
                                        New</button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>


            <!-- Modal show all wallet -->
            <div class="modal fade" id="wallet_show" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-wallet me-1"></i>
                                <?php echo e(__('basic.wallet')); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-4">

                            <div class="table-responsive">
                                <table class="table display datatable-modal" id="table-wallet" width="100%"
                                    cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs text-center"><?php echo e(__('basic.date')); ?></th>
                                            <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.type')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.balance before')); ?>

                                            <th class="text-xs text-center"><?php echo e(__('basic.amount')); ?>

                                            <th class="text-xs text-center"><?php echo e(__('basic.branch')); ?>

                                            <th class="text-xs text-center"><?php echo e(__('basic.note')); ?>

                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $patient->wallet_reco; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($item->type == 0): ?>
                                        <?php
                                        $text_color = 'main-color-btn';
                                        $msg = __('basic.add');
                                        ?>
                                        <?php elseif($item->type == 1): ?>
                                        <?php
                                        $text_color = 'cancel-color-btn';
                                        $msg = __('basic.withdraw');
                                        ?>
                                        <?php endif; ?>

                                        <tr>
                                            <td class="text-center">
                                                <?php echo e(date('d M Y', strtotime($item->date))); ?>

                                            </td>
                                            <td class="text-center"><a class="link-cust-text text-gray-500">
                                                    <?php if($item->service): ?>
                                                    <?php echo e($item->service->name); ?>

                                                    <?php else: ?>
                                                    Add new balance
                                                    <?php endif; ?>
                                                </a></td>
                                            <td class="text-center"><span
                                                    class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                            </td>
                                            <td class="text-center">
                                                <?php echo e($item->balance_before_tran); ?> <small class="text-gray-300 text-xxxs">
                                                    <?php echo e(__('basic.egp')); ?></small>
                                            </td>
                                            <td class="text-center">
                                                <?php echo e($item->amount); ?> <small class="text-gray-300 text-xxxs">
                                                    <?php echo e(__('basic.egp')); ?></small>
                                            </td>

                                            <td class="text-center">
                                                <?php echo e($item->branch->name); ?>

                                            </td>

                                            <td class="text-center">
                                                <?php echo e($item->note); ?>

                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="button" class="btn btn-default btn-link main-color"><?php echo e(__('basic.save
                                    changes')); ?></button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>


        </div>
    </div>
    <?php endif; ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/patient/component/payment.blade.php ENDPATH**/ ?>