<!-- Examination -->
<div class="col-12 col-lg-4">
    <div class="card shadow mb-4">

        <div id="examin-medc" class="carousel slide curr-treament-info-carousel" data-bs-ride="carousel"
            data-bs-interval="false">

            <div class="carousel-indicators dots-radius-carousel" style="bottom: 34px; margin-bottom: 0px;">
                <button type="button" data-bs-target="#examin-medc" data-bs-slide-to="0" class="active"
                    aria-current="true" aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#examin-medc" data-bs-slide-to="1" aria-label="Slide 2"></button>
            </div>

            <div class="carousel-inner">

                <!-- Current examination -->
                <div class="carousel-item active">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer"><?php echo e(__('basic.examination')); ?></span>
                            <span class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#examin-medc" data-bs-slide-to="1" aria-label="Slide 2">
                                <?php echo e(__('basic.medicines')); ?></span>
                        </div>

                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer add_exam_modal" data-type="ex"><?php echo e(__('patientappo.new examination')); ?></a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->

                    <?php if(count($patient->diseases) > 0): ?>
                    <div class="card-body pb-4">
                        <div class="row">
                            <div class="col align-self-center text-center">
                                <svg id="Capa_1" fill="#151515" height="141" width="141" viewBox="0 0 512 512"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="m410.109 441.591-5.948-20.515c-1.808-6.232-6.302-11.185-12.329-13.586-6.029-2.402-12.695-1.898-18.293 1.385-7.104 4.165-14.647 7.412-22.506 9.724-.365-3.277-1.648-6.416-3.785-9.055-2.48-3.064-5.856-5.152-9.602-6.025 1.499-2.772 3.268-8.014 3.256-13.37 0-5.168-1.435-10.007-3.925-14.142 2.389-1.115 4.525-2.765 6.232-4.886 3.339-4.147 4.602-9.511 3.464-14.712l-2.718-12.427 6.442-3.776c10.502-6.156 22.482-9.631 34.647-10.048 6.757-.231 12.907-3.503 16.874-8.978 3.967-5.474 5.162-12.337 3.279-18.829l-4.392-15.145c-1.883-6.493-6.564-11.651-12.845-14.153-6.278-2.502-13.226-1.977-19.058 1.441-6.938 4.067-14.328 7.075-22.049 9.022-.464-2.994-1.686-5.852-3.646-8.286-2.614-3.248-6.233-5.391-10.235-6.177 1.472-2.753 3.211-7.952 3.198-13.257 0-4.92-1.305-9.538-3.578-13.537 2.526-.966 4.788-2.575 6.536-4.751 2.957-3.679 4.072-8.432 3.059-13.04l-3.26-14.833c9.359-4.056 19.621-6.369 29.895-6.705 6.228-.202 11.837-3.166 15.39-8.131 3.393-4.741 4.369-10.636 2.681-16.172l-5.351-17.554c-1.678-5.499-5.771-9.915-11.229-12.115-5.653-2.275-11.933-1.886-17.234 1.069-3.655 2.037-7.459 3.816-11.373 5.343l.481-2.19c1.014-4.609-.102-9.362-3.059-13.041-1.586-1.973-3.597-3.477-5.841-4.464 1.712-2.91 3.746-8.472 3.742-14.23 0-5.946-1.903-11.453-5.124-15.956 1.008-.783 1.938-1.684 2.759-2.704 3.148-3.914 4.336-8.974 3.258-13.881l-4.317-19.649c8.486-3.755 17.488-5.835 26.814-6.155 5.82-.199 11.118-3.018 14.536-7.733 3.419-4.716 4.449-10.629 2.827-16.224l-5.002-17.253c-1.621-5.594-5.654-10.039-11.064-12.195-5.415-2.157-11.398-1.703-16.422 1.242-2.3 1.348-4.669 2.579-7.09 3.702-.345-3.065-1.546-6.001-3.538-8.478-3.148-3.916-7.834-6.161-12.857-6.161h-27.534c-4.143 0-7.5 3.357-7.5 7.5s3.357 7.5 7.5 7.5h27.534c.594 0 .963.305 1.168.56.206.256.424.683.297 1.263l-4.854 22.094c-2.236 10.178-2.236 20.936 0 31.113l4.854 22.094c.127.58-.091 1.007-.297 1.263-.205.255-.574.56-1.168.56h-131.618c-.594 0-.963-.305-1.168-.56-.206-.256-.424-.683-.297-1.263l4.854-22.094c2.236-10.178 2.236-20.936 0-31.113l-4.854-22.094c-.127-.58.091-1.007.297-1.263.205-.255.574-.56 1.168-.56h69.02c4.143 0 7.5-3.357 7.5-7.5s-3.357-7.5-7.5-7.5h-69.02c-5.023 0-9.709 2.245-12.857 6.16-1.992 2.477-3.194 5.413-3.538 8.479-2.42-1.123-4.79-2.354-7.09-3.701-5.023-2.945-11.008-3.399-16.42-1.243-5.41 2.155-9.444 6.6-11.066 12.194l-5.004 17.255c-1.622 5.594-.592 11.507 2.827 16.223 3.418 4.716 8.716 7.534 14.535 7.733 9.326.321 18.329 2.401 26.815 6.156l-4.317 19.649c-1.078 4.907.109 9.967 3.258 13.881.821 1.021 1.75 1.921 2.759 2.704-3.221 4.503-5.124 10.01-5.124 15.956-.043 3.82.992 9.311 3.742 14.23-2.244.987-4.255 2.491-5.841 4.464-2.957 3.679-4.072 8.432-3.059 13.04l.482 2.191c-3.915-1.527-7.719-3.306-11.372-5.342-5.304-2.956-11.586-3.346-17.235-1.069-5.458 2.2-9.551 6.616-11.229 12.117l-5.351 17.55c-1.688 5.538-.712 11.433 2.681 16.173 3.553 4.966 9.163 7.93 15.39 8.132 10.276.336 20.539 2.649 29.895 6.706l-3.26 14.832c-1.014 4.609.102 9.362 3.059 13.041 1.749 2.175 4.01 3.784 6.536 4.751-2.272 4-3.578 8.618-3.578 13.537-.04 3.537.835 8.609 3.198 13.257-4.002.786-7.621 2.929-10.235 6.177-1.96 2.435-3.182 5.293-3.646 8.287-7.721-1.947-15.11-4.956-22.049-9.021-5.831-3.419-12.777-3.944-19.058-1.442s-10.962 7.66-12.845 14.153l-4.392 15.145c-1.883 6.492-.688 13.355 3.279 18.829 3.967 5.475 10.117 8.746 16.874 8.978 12.165.417 24.146 3.892 34.647 10.048l6.442 3.776-2.718 12.427c-1.138 5.201.125 10.564 3.464 14.712 1.707 2.121 3.843 3.771 6.232 4.886-2.49 4.135-3.925 8.973-3.925 14.142-.04 3.57.851 8.69 3.256 13.37-3.747.874-7.122 2.961-9.602 6.025-2.137 2.64-3.42 5.779-3.785 9.057-7.859-2.312-15.402-5.562-22.506-9.727-5.599-3.279-12.267-3.784-18.293-1.384-6.027 2.401-10.521 7.354-12.329 13.586l-5.948 20.515c-1.808 6.231-.661 12.818 3.146 18.072s9.71 8.396 16.196 8.618c14.521.498 28.822 4.645 41.356 11.993l.8.469-2.153 10.114c-1.104 5.189.177 10.531 3.516 14.655 3.338 4.123 8.295 6.488 13.601 6.488h31.329c4.143 0 7.5-3.357 7.5-7.5s-3.357-7.5-7.5-7.5h-31.329c-1.037 0-1.662-.581-1.942-.927-.28-.347-.719-1.079-.502-2.094l4.996-23.468c1.834-8.616 1.834-17.354 0-25.968l-4.996-23.469c-.217-1.015.222-1.747.502-2.094.28-.346.905-.927 1.942-.927h155.295c1.037 0 1.662.581 1.942.927.28.347.719 1.079.502 2.094l-4.996 23.468c-1.834 8.615-1.834 17.353 0 25.969l4.996 23.468c.217 1.015-.222 1.747-.502 2.094-.28.346-.905.927-1.942.927h-89.005c-4.143 0-7.5 3.357-7.5 7.5s3.357 7.5 7.5 7.5h89.005c5.306 0 10.263-2.365 13.601-6.488 3.339-4.124 4.62-9.466 3.516-14.655l-2.153-10.114.801-.469c12.533-7.348 26.834-11.494 41.356-11.992 6.485-.223 12.388-3.364 16.195-8.618s4.954-11.846 3.146-18.077zm-211.51-38.536c-6.2.112-12.668-5.818-12.5-12.906 0-6.893 5.607-12.5 12.5-12.5h50.04c4.143 0 7.5-3.357 7.5-7.5s-3.357-7.5-7.5-7.5h-66.215c-1.041 0-1.667-.584-1.947-.933-.28-.348-.717-1.084-.494-2.102l4.188-19.148c2.474-11.312 2.474-23.269 0-34.58l-4.188-19.148c-.223-1.018.214-1.754.494-2.102.28-.349.906-.933 1.947-.933h147.152c1.041 0 1.667.584 1.947.933.28.348.717 1.084.494 2.102l-4.188 19.148c-2.474 11.312-2.474 23.269 0 34.58l4.188 19.148c.223 1.018-.214 1.754-.494 2.102-.28.349-.906.933-1.947.933h-45.896c-4.143 0-7.5 3.357-7.5 7.5s3.357 7.5 7.5 7.5h29.721c6.893 0 12.5 5.607 12.5 12.5.294 6.059-5.26 12.85-12.5 12.906zm-7.77-146.852c-.294-6.059 5.26-12.85 12.5-12.906h105.342c6.893 0 12.5 5.607 12.5 12.5.294 6.059-5.26 12.85-12.5 12.906h-105.342c-6.892 0-12.5-5.607-12.5-12.5zm-5.879-27.906c-.071 0-.239 0-.39-.187s-.114-.351-.099-.421l3.28-14.922c3.444-15.664 3.444-32.223 0-47.886l-3.28-14.924c-.016-.069-.052-.233.099-.42s.318-.187.39-.187h48.433c4.143 0 7.5-3.357 7.5-7.5s-3.357-7.5-7.5-7.5h-30.914c-6.2.112-12.668-5.818-12.5-12.906 0-6.893 5.607-12.5 12.5-12.5h107.063c6.893 0 12.5 5.607 12.5 12.5.294 6.059-5.26 12.85-12.5 12.906h-41.042c-4.143 0-7.5 3.357-7.5 7.5s3.357 7.5 7.5 7.5h58.561c.071 0 .239 0 .39.187s.114.351.099.421l-3.28 14.922c-3.444 15.664-3.444 32.223 0 47.886l3.28 14.924c.016.069.052.233-.099.42s-.318.187-.39.187zm191.538 59.139c1.811-1.061 3.97-1.225 5.92-.447 1.951.777 3.405 2.38 3.99 4.396l4.392 15.145c.585 2.017.214 4.148-1.019 5.85-1.232 1.7-3.144 2.717-5.242 2.788-14.647.503-29.074 4.686-41.72 12.098l-1.624.952c-.485-6.399-.068-12.882 1.298-19.126l2.124-9.708c11.248-2.12 21.952-6.128 31.881-11.948zm-16.104-124.306c1.324-.737 2.9-.829 4.324-.258.724.292 2.011 1.016 2.487 2.577l5.351 17.554c.411 1.347-.062 2.411-.531 3.067-.814 1.138-2.155 1.818-3.682 1.868-10.749.351-21.494 2.535-31.504 6.36-.41-7.307.006-14.668 1.24-21.863 7.784-2.265 15.281-5.384 22.315-9.305zm-7.504-139.253c1.376-.808 2.647-.502 3.283-.248.635.253 1.767.906 2.211 2.438l5.004 17.253c.443 1.531-.164 2.689-.565 3.244-.401.554-1.313 1.491-2.905 1.546-9.723.333-19.158 2.244-28.15 5.678.046-3.922.474-7.839 1.312-11.653l2.232-10.157c6.104-2.116 12.006-4.834 17.578-8.101zm-203.692 22.686c-.401-.555-1.009-1.713-.565-3.243l5.004-17.254c.444-1.531 1.576-2.185 2.212-2.438s1.907-.56 3.282.249c5.571 3.266 11.472 5.979 17.578 8.096l2.233 10.161c.838 3.813 1.266 7.73 1.312 11.653-8.992-3.434-18.427-5.345-28.15-5.679-1.594-.053-2.505-.991-2.906-1.545zm-9.203 139.507c-.47-.656-.942-1.721-.531-3.069l5.351-17.55c.477-1.563 1.764-2.287 2.487-2.579 1.427-.573 3.002-.479 4.325.258 7.031 3.92 14.527 7.039 22.314 9.305 1.234 7.195 1.65 14.556 1.24 21.863-10.01-3.824-20.756-6.008-31.506-6.359-1.524-.05-2.865-.731-3.68-1.869zm-12.514 129.098c-2.099-.072-4.01-1.089-5.242-2.789-1.232-1.701-1.604-3.833-1.019-5.85l4.392-15.145c.585-2.017 2.039-3.619 3.99-4.396 1.95-.778 4.107-.614 5.921.448 9.928 5.819 20.632 9.827 31.88 11.946l2.124 9.709c1.366 6.244 1.783 12.727 1.298 19.126l-1.624-.952c-12.646-7.412-27.073-11.595-41.72-12.097zm-5.723 138.123c-1.828-.063-3.491-.948-4.564-2.43-1.073-1.48-1.396-3.336-.887-5.093l5.948-20.515c.51-1.756 1.776-3.152 3.475-3.829 1.7-.677 3.579-.534 5.155.391 10.177 5.965 21.135 10.294 32.607 12.931l2.751 12.922c1.249 5.864 1.369 11.802.379 17.683-13.798-7.362-29.219-11.524-44.864-12.06zm273.068-2.43c-1.073 1.481-2.736 2.366-4.563 2.43-15.646.536-31.068 4.698-44.865 12.06-.99-5.881-.87-11.819.379-17.684l2.75-12.918c11.474-2.637 22.432-6.968 32.607-12.933 1.576-.925 3.455-1.067 5.155-.391 1.698.677 2.965 2.073 3.475 3.829l5.948 20.515c.511 1.756.188 3.612-.886 5.092z" />
                                </svg>
                            </div>

                            <div class="col">

                                <div class="col">
                                    <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('basic.examination')); ?>

                                    </h6>
                                    <p class="text-gray-700 text-xs fw-bold">
                                        <?php echo e($patient->diseases[0]->diseasecats->name); ?></p>
                                </div>
                                <div class="col">
                                    <h6 class="text-gray-300 text-xs mb-1">
                                        <?php echo e(__('patientappo.started on')); ?></h6>
                                    <p class="text-gray-700 text-xs fw-bold">
                                        <?php echo e(date('d M Y', strtotime($patient->diseases[0]->start))); ?></p>
                                </div>

                                <?php if($patient->diseases[0]->status == 0): ?>
                                <?php
                                $msg = __('patientappo.still');
                                ?>
                                <?php elseif($patient->diseases[0]->status == 1): ?>
                                <?php
                                $msg = __('patientappo.healed');
                                ?>
                                <?php endif; ?>

                                <div class="col">
                                    <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('basic.status')); ?>

                                    </h6>
                                    <p class="text-gray-700 text-xs fw-bold"><?php echo e($msg); ?></p>
                                </div>

                            </div>
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="card-body align-items-center text-center position-relative">
                        <a class="add-new-item stretched-link link-cust-text text-gray-400 clickable-item-pointer add_exam_modal"
                            data-type="ex">
                            <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                            <p class="fw-light mb-0">You can put your Examination</p>
                        </a>
                    </div>
                    <?php endif; ?>

                    <!-- Card footer -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300 clickable-item-pointer" data-bs-toggle="modal"
                            data-bs-target="#disease_show">
                            <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                        </a>
                    </div>

                </div> <!-- end of exmenation item crousel -->

                <!-- Current Medicines -->
                <div class="carousel-item">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer"><?php echo e(__('basic.medicines')); ?></span>
                            <span class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#examin-medc" data-bs-slide-to="0" aria-label="Slide 1">
                                <?php echo e(__('basic.examination')); ?></span>
                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#addmedic"><?php echo e(__('patientappo.add medicine')); ?></a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->

                    <?php if(!$patient->prescriptions->isEmpty()): ?>
                    <div id="medicine_card_home" class="card-body align-items-center">

                        <?php $__currentLoopData = $patient->prescriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($item->status == 0): ?>
                        <?php
                        $text_color = 'main-color';
                        $msg = __('patientappo.on medicine');
                        ?>
                        <?php elseif($item->status == 1): ?>
                        <?php
                        $text_color = 'cancel-color';
                        $msg = __('patientappo.no result');
                        ?>
                        <?php elseif($item->status == 2): ?>
                        <?php
                        $text_color = 'done-color';
                        $msg = __('patientappo.done');
                        ?>
                        <?php endif; ?>

                        
                        <?php if($loop->index === 3) break; ?>

                        <div class="d-flex justify-content-between align-items-center mb-3">

                            <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                <i class="fas fa-circle me-2 text-xxs mb-0 <?php echo e($text_color); ?>"></i>

                                <div class="text-truncate">
                                    <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                        <?php echo e($item->medicinescats->name); ?></p>
                                    <p class="text-xs text-gray-300 fw-bold mb-0"><?php echo e($msg); ?></p>
                                </div>
                            </div>

                            <div class="text-s text-gray-600 fw-bold">
                                <?php echo e(date('d M Y', strtotime($item->end))); ?>

                            </div>

                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php else: ?>
                    <div class="card-body align-items-center text-center position-relative">
                        <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                            data-bs-toggle="modal" data-bs-target="#addmedic">
                            <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                            <p class="fw-light mb-0"><?php echo e(__('patientappo.you can add new medicines')); ?></p>
                        </a>
                    </div>

                    <?php endif; ?>

                    <!-- Card footer medicine -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#medicine_show">
                            <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                        </a>
                    </div>

                </div><!-- end of medicens crousel -->

            </div>
        </div> <!-- end of exmeination and medicens col -->

    </div> <!-- end of row -->

    <!----------------- exmeination and medciens modals ----------------->

    <!---------------------------------->

    <!----------------- show all exmeniation ----------------->

    <!-- Modal show all examination -->
    <div class="modal fade" id="disease_show" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-x-ray me-1"></i>
                        <?php echo e(__('basic.examination')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-4">

                    <h5 class="mb-3 text-gray-400"><i class="far fa-question-circle"></i>
                        Initial Examination</h5>

                    <div class="d-flex justify-content-center mb-3 flex-wrap">

                        <div class="d-flex justify-content-center flex-wrap me-0 me-md-5 mb-3 mb-xl-0">

                            <div class="mb-3 mb-md-0"
                                style="background-image: url('<?php echo e(asset('img/dashboard/system/human_front.jpg')); ?>'); width:255px; height:457px; position: relative;">
                                <?php if(!empty($patient->disease_draws[0]->front)): ?>
                                <img src="<?php echo e(URL::asset('img/diseasedraw/' . $patient->disease_draws[0]->front)); ?>"
                                    width="255" height="457" style=" solid;position: absolute;top:0;left:0;">
                                <?php else: ?>
                                <div class="ms-4 text-center main-color-bg text-white p-2 b-r-s-cont"
                                    style=" solid;position: absolute;top:13rem;left:3rem;">
                                    <?php echo e(__('patientappo.no back draw')); ?>

                                </div>
                                <?php endif; ?>
                            </div>

                            <div class="mb-3 mb-md-0"
                                style="background-image: url('<?php echo e(asset('img/dashboard/system/human_back.jpg')); ?>'); width:255px; height:457px; position: relative;">

                                <?php if(!empty($patient->disease_draws[0]->back)): ?>
                                <img src="<?php echo e(URL::asset('img/diseasedraw/' . $patient->disease_draws[0]->back)); ?>"
                                    width="255" height="457" style=" solid;position: absolute;top:0;left:0;">
                                <?php else: ?>
                                <div class="ms-4 text-center main-color-bg text-white p-2 b-r-s-cont"
                                    style=" solid;position: absolute;top:13rem;left:3rem;">
                                    <?php echo e(__('patientappo.no front draw')); ?>

                                </div>
                                <?php endif; ?>
                            </div>

                        </div>

                        <div class="d-flex d-xl-block p-4 main-color-bg b-r-s-cont flex-wrap justify-content-center">
                            <h5 class="mb-3 text-white me-2 me-xl-0"><i class="far fa-question-circle"></i>
                                <?php echo e(__('patientappo.last examination info')); ?></h5>

                            <div class="">
                                <div class="mb-2 me-3 me-xl-5">
                                    <label class="form-label text-blue-300 mb-1"><?php echo e(__('patientappo.examination note')); ?>:</label>
                                    <div class="form-control-textarea overflow-auto text-white"
                                        style="width: 241px; border-radius: 13px !important; border: 1px solid #6fa2ea;">
                                        <?php if(!empty($patient->disease_draws[0]->note)): ?>
                                        <?php echo e($patient->disease_draws[0]->note); ?>

                                        <?php else: ?>
                                        No Note
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="mb-2 me-3 me-xl-5">
                                    <label class="form-label text-blue-300 mb-1">
                                        <?php echo e(__('patientappo.appointment date')); ?>:</label>
                                    <div class="text-white">
                                        <?php if(!empty($patient->disease_draws[0]->appointment->start_at)): ?>
                                        <?php echo e($patient->disease_draws[0]->appointment->start_at); ?>

                                        <?php else: ?>
                                        <?php echo e(__('basic.not selected')); ?>

                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="mb-2">
                                    <label class="form-label text-blue-300 mb-1"><?php echo e(__('basic.doctor')); ?>:</label>
                                    <div class="text-white">
                                        <?php if(!empty($patient->disease_draws[0]->appointment->doctor->name)): ?>
                                        <?php echo e($patient->disease_draws[0]->appointment->doctor->name); ?>

                                        <?php else: ?>
                                        <?php echo e(__('basic.not selected')); ?>

                                        <?php endif; ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="table-responsive">
                        <table class="table display datatable-modal" id="table-disease" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th class="text-xs w-25"><?php echo e(__('basic.name')); ?>

                                    </th>
                                    <th class="text-xs text-center">
                                        <?php echo e(__('basic.start')); ?></th>
                                    <th class="text-xs text-center">
                                        <?php echo e(__('basic.end')); ?></th>
                                    <th class="text-xs text-center">
                                        <?php echo e(__('basic.status')); ?></th>
                                    <th class="text-xs text-center">
                                        <?php echo e(__('basic.handle')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $patient->diseases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($item->status == 0): ?>
                                <?php
                                $text_color = 'active-color-btn';
                                $msg = __('patientappo.still');
                                ?>
                                <?php elseif($item->status == 1): ?>
                                <?php
                                $text_color = 'done-color-btn';
                                $msg = __('patientappo.healed');
                                ?>
                                <?php endif; ?>

                                <tr>
                                    <td class="w-25">
                                        <?php echo e($item->diseasecats->name); ?></td>
                                    <td><?php echo e($item->start); ?></td>
                                    <td class="text-center"><?php echo e($item->end); ?>

                                    </td>
                                    <td class="text-center"> <span
                                            class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                    </td>

                                    <td class="text-center">
                                        <a data-disease_id="<?php echo e($item->id); ?>"
                                            data-diseasecats_id="<?php echo e($item->diseasecats->id); ?>"
                                            data-status_disease="<?php echo e($item->status); ?>" data-start="<?php echo e($item->start); ?>"
                                            data-end="<?php echo e($item->end); ?>"
                                            class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 disease_edit_click"
                                            title="edit"><i class="fas fa-pencil-alt"></i>
                                            <?php echo e(__('basic.edit')); ?> </a>

                                        <a data-disease_id="<?php echo e($item->id); ?>"
                                            class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 disease_delete_click"
                                            title="delete" data-effect="effect-scale"><i class="fas fa-trash"></i>
                                            <?php echo e(__('basic.delete')); ?>

                                        </a>

                                    </td>

                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>


                </div>

                <div class="modal-footer">
                    <div class="left-side">
                        <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                    </div>
                    <div class="divider"></div>
                    <div class="right-side">
                        <button type="button" class="btn btn-default btn-link main-color">Add
                            New</button>
                    </div>
                </div>

            </div>
        </div>

    </div>

    <!-- Modal examination insert data -->
    <div class="modal fade" id="adddisease" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
            <div class="modal-content b-r-s-cont border-0">

                <form action="<?php echo e(route('sett.disease.store')); ?>" method="post" style="display: contents;">
                    <?php echo e(method_field('POST')); ?>

                    <?php echo e(csrf_field()); ?>


                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-x-ray me-1"></i>
                            <?php echo e(__('patientappo.new examination')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="row mb-2 justify-content-center">

                            <div class="col-12 mb-4">
                                <div class="d-flex justify-content-center flex-wrap">

                                    <div class="mb-3 mb-md-0"
                                        style="background-image: url('<?php echo e(asset('img/dashboard/system/human_front.jpg')); ?>'); width:255px; height:457px; position: relative;">

                                        <canvas class="canvas" id="canvas" width="255" height="457"
                                            style=" solid;position: absolute;top:0;left:0;"></canvas>

                                        <div id="canvas-clear" class="btn btn-primary"
                                            style="position: absolute; bottom:40px; left:0px;"><i
                                                class="fas fa-eraser"></i>
                                        </div>

                                        <div id="imgsave" class="btn btn-danger"
                                            style="position: absolute; bottom:0px; left:0px;"><i id="icon_save"
                                                class="fas fa-check"></i>
                                        </div>

                                        <div style="position: absolute; bottom:100px; left:0px;">
                                            <div class="d-flex mb-1">
                                                <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#000000"
                                                    style="width:10px;height:10px;background:#000000;">
                                                </div>
                                                <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#0cb6ed"
                                                    style="width:10px;height:10px;background:#0cb6ed;">
                                                </div>
                                                <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#17c34e"
                                                    style="width:10px;height:10px;background:#17c34e;">
                                                </div>
                                            </div>
                                            <div class="d-flex">
                                                <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#dc3545"
                                                    style="width:10px;height:10px;background:#dc3545;">
                                                </div>
                                                <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#ffd807"
                                                    style="width:10px;height:10px;background:#ffd807;">
                                                </div>
                                                <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#ff6d00"
                                                    style="width:10px;height:10px;background:#ff6d00;">
                                                </div>
                                            </div>
                                        </div>

                                    </div>

                                    <div
                                        style="background-image: url('<?php echo e(asset('img/dashboard/system/human_back.jpg')); ?>'); width:255px; height:457px; position: relative;">
                                        <canvas class="canvas" id="canvas_b" width="255" height="457"
                                            style=" solid;position: absolute;top:0;left:0;"></canvas>

                                        <div id="canvas-clear_b" class="btn btn-primary"
                                            style="position: absolute; bottom:40px; left:0px;"><i
                                                class="fas fa-eraser"></i>
                                        </div>

                                        <div id="imgsave_b" class="btn btn-danger"
                                            style="position: absolute; bottom:0px; left:0px;"><i id="icon_save_b"
                                                class="fas fa-check"></i>
                                        </div>


                                        <div style="position: absolute; bottom:100px; left:0px;">
                                            <div class="d-flex mb-1">
                                                <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#000000"
                                                    style="width:10px;height:10px;background:#000000;">
                                                </div>
                                                <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#0cb6ed"
                                                    style="width:10px;height:10px;background:#0cb6ed;">
                                                </div>
                                                <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#17c34e"
                                                    style="width:10px;height:10px;background:#17c34e;">
                                                </div>
                                            </div>
                                            <div class="d-flex">
                                                <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#dc3545"
                                                    style="width:10px;height:10px;background:#dc3545;">
                                                </div>
                                                <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#ffd807"
                                                    style="width:10px;height:10px;background:#ffd807;">
                                                </div>
                                                <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#ff6d00"
                                                    style="width:10px;height:10px;background:#ff6d00;">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <input name="front" id="front_input" type="hidden">
                                <input name="back" id="back_input" type="hidden">
                            </div>

                            <div class="col-12 col-md-8 mb-2">
                                <label class="form-label"><?php echo e(__('basic.disease')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <select
                                    class="myselect2-disease-insert select2-hidden-accessible <?php $__errorArgs = ['disease_cat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="disease_cat" multiple="" name="disease_cat[]" style="position: relative"
                                    required>
                                    <?php $__currentLoopData = $disease_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>">
                                        <?php echo e($item->name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <span id="disease_cat_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['disease_cat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>

                            <div class="col-12 col-md-8 mb-2">
                                <label class="form-label"><?php echo e(__('basic.start')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                        </div>
                                    </div>
                                    <input name="disease_start" value="<?php echo e(date('Y-m-d')); ?>" type="text"
                                        class="form-control hasdatetimepicker <?php $__errorArgs = ['disease_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="YYYY/MM/DD" required>
                                </div>
                                <span id="disease_start_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['disease_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 col-md-8 mb-2" id="exam-op-appointment">
                                <label class="form-label"><?php echo e(__('basic.appointment')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <select
                                    class="myselect2-disease-insert select2-hidden-accessible <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="last_appointment_id_op_app" name="last_appointment_id" required>
                                    <?php $__currentLoopData = $patient->appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>">
                                        <?php echo e($item->start_at); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <span id="last_appointment_id_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>

                            <div class="col-12 col-md-8 mb-2">
                                <label class="form-label"><?php echo e(__('basic.note')); ?>

                                    <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                <textarea name="note_diseases" class="form-control "
                                    placeholder="Write here your note .." rows="4" spellcheck="false"></textarea>
                                <span id="note_diseases_lab_error" class="error-msg-form"></span>
                            </div>

                            <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">
                            <input name="exam-op-id" value="" type="hidden">
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">Add
                                New</button>
                        </div>
                    </div>

                </form>

            </div>
        </div>

    </div>

    <!-- Modal examination update data -->
    <div class="modal fade" id="disease_edit" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                        Update Examination</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form class="mb-0" action="<?php echo e(route('sett.disease.update', '21')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="row mb-2">

                            <div class="col-12 mb-2">
                                <label class="form-label">Disease
                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <select
                                    class="myselect2-disease-update select2-hidden-accessible <?php $__errorArgs = ['disease_cat_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="disease_cat_update" name="disease_cat_update" required>
                                    <?php $__currentLoopData = $disease_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>">
                                        <?php echo e($item->name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <span id="disease_cat_update_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['disease_cat_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>


                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.status')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <select
                                    class="myselect2_disease select2-hidden-accessible select2-no-search-disease <?php $__errorArgs = ['status_medicine_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="status_disease_update" name="status_disease_update" required>
                                    <option value="0">
                                        <?php echo e(__('patientappo.still')); ?>

                                    </option>
                                    <option value="1">
                                        <?php echo e(__('patientappo.healed')); ?>

                                    </option>
                                </select>

                                <span id="status_disease_update_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['status_disease_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.start')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                        </div>
                                    </div>
                                    <input name="disease_start_update" type="text"
                                        class="form-control hasdatetimepicker <?php $__errorArgs = ['disease_start_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="YYYY/MM/DD" required>
                                </div>
                                <span id="disease_start_update_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['disease_start_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.end')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                        </div>
                                    </div>
                                    <input name="disease_end_update" type="text"
                                        class="form-control hasdatetimepicker <?php $__errorArgs = ['disease_end_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="YYYY/MM/DD">
                                </div>

                                <?php $__errorArgs = ['disease_end_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                <span id="medicine_end_update_error" class="error-msg-form"></span>
                            </div>


                        </div>

                        <input name="disease_id_update" value="" type="hidden">

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color"><?php echo e(__('basic.update')); ?></button>
                        </div>
                    </div>
                </form>

            </div>
        </div>

    </div>

    <!-- examination Modal delete -->
    <div class="modal fade" id="disease_delete" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

            <div class="modal-content shadow-lgg b-r-s-cont border-0">

                <div class="modal-header">
                    <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                        Disease delete</div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form action="<?php echo e(route('sett.disease.destroy', 'test')); ?>" method="post">
                    <?php echo e(method_field('delete')); ?>

                    <?php echo e(csrf_field()); ?>


                    <!-- Modal content -->
                    <div class="modal-body px-4">

                        <div class="modal-body delete-conf-input text-center py-0">
                            <p class="mb-0">ِAre
                                you sure you want to delete
                                this
                                examination?</p><br>
                            <input type="hidden" name="disease_id_delete" value="">
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link text-red"><?php echo e(__('basic.delete')); ?>

                            </button>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>

    <!---------------------------------->

    <!----------------- show all medicines ----------------->

    <!-- Modal show all medicines -->
    <div class="modal fade" id="medicine_show" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-capsules me-1"></i>
                        <?php echo e(__('patientappo.current medicines')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-4">

                    <div class="table-responsive">
                        <table class="table display datatable-modal" id="table-medicine" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th class="text-xs w-25"><?php echo e(__('basic.name')); ?></th>
                                    <th class="text-xs text-center"><?php echo e(__('basic.start')); ?>

                                    </th>
                                    <th class="text-xs text-center"><?php echo e(__('basic.end')); ?></th>
                                    <th class="text-xs text-center"><?php echo e(__('basic.status')); ?>

                                    </th>
                                    <th class="text-xs text-center"><?php echo e(__('basic.handle')); ?>

                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $patient->prescriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($item->status == 0): ?>
                                <?php
                                $text_color = 'active-color-btn';
                                $msg = __('patientappo.on medicine');
                                ?>
                                <?php elseif($item->status == 1): ?>
                                <?php
                                $text_color = 'cancel-color-btn';
                                $msg = __('patientappo.no result');
                                ?>
                                <?php elseif($item->status == 2): ?>
                                <?php
                                $text_color = 'done-color-btn';
                                $msg = __('patientappo.done');
                                ?>
                                <?php endif; ?>

                                <tr>
                                    <td class="w-25">
                                        <?php echo e($item->medicinescats->name); ?></td>
                                    <td><?php echo e($item->start); ?></td>
                                    <td class="text-center"><?php echo e($item->end); ?></td>
                                    <td class="text-center"> <span
                                            class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                    </td>

                                    <td class="text-center">
                                        <a data-medicine_id="<?php echo e($item->id); ?>"
                                            data-medicinescats_id="<?php echo e($item->medicinescats->id); ?>"
                                            data-status_medicine="<?php echo e($item->status); ?>" data-start="<?php echo e($item->start); ?>"
                                            data-end="<?php echo e($item->end); ?>"
                                            class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 medicine_edit_click"
                                            title="edit"><i class="fas fa-pencil-alt"></i>
                                            <?php echo e(__('basic.edit')); ?> </a>

                                        <a data-medicine_id="<?php echo e($item->id); ?>"
                                            class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 medicine_delete_click"
                                            title="delete" data-effect="effect-scale" data-bs-toggle="modal"
                                            data-bs-target="#delete1"><i class="fas fa-trash"></i>
                                            <?php echo e(__('basic.delete')); ?>

                                        </a>

                                    </td>

                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="modal-footer">
                    <div class="left-side">
                        <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                    </div>
                    <div class="divider"></div>
                    <div class="right-side">
                        <button type="button" class="btn btn-default btn-link main-color"><?php echo e(__('basic.save changes')); ?></button>
                    </div>
                </div>

            </div>
        </div>

    </div>

    <!-- Modal Medicine insert data -->
    <div class="modal fade" id="addmedic" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                        <?php echo e(__('patientappo.add new medicines')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form id="add_new_medicine_modal" class="mb-0" action="<?php echo e(route('sett.medicine.store')); ?>" method="post"
                    style="display: contents">
                    <?php echo e(method_field('POST')); ?>

                    <?php echo e(csrf_field()); ?>


                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="row mb-2">

                            <div class="col-12" id="medicine_cont">


                                <div class="table-responsive px-0" id="medicine_cont_table" style="display: none">
                                    <table class="table display datatable-modal border-0" width="100%" cellspacing="0">
                                        <thead>
                                            <tr>
                                                <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                                <th class="text-xs text-center"><?php echo e(__('basic.status')); ?></th>
                                                <th class="text-xs text-center"><?php echo e(__('basic.from')); ?>

                                                </th>
                                                <th class="text-xs text-center"><?php echo e(__('basic.to')); ?></th>
                                                <th class="text-xs text-center"></th>
                                            </tr>
                                        </thead>
                                        <tbody id="medicine_cont_table_td">

                                        </tbody>
                                    </table>
                                </div>


                                <div class="text-center" id="medicine_cont_status">
                                    <h4><i class="fas fa-capsules"></i></h4>
                                    <h5 class=" text-gray-400">You have to add new medicines</h5>
                                </div>

                            </div>
                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.medicines')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <select
                                    class="myselect2-medicine-insert select2-hidden-accessible <?php $__errorArgs = ['medicine_pills'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="medicine_pills" name="medicine_pills" required>
                                    <?php $__currentLoopData = $medicine_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>">
                                        <?php echo e($item->name . ' - ' . $item->price . 'EGP'); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <span id="medicine_pills_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['medicine_pills'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.status')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <select
                                    class="myselect2-medicine-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['medicine_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="medicine_status" name="medicine_status" required>
                                    <option value="0">
                                        <?php echo e(__('patientappo.on medicine')); ?>

                                    </option>
                                    <option value="1">
                                        <?php echo e(__('patientappo.no result')); ?>

                                    </option>
                                    <option value="2">
                                        <?php echo e(__('patientappo.done')); ?>

                                    </option>
                                </select>

                                <span id="medicine_status_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['medicine_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.start')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                        </div>
                                    </div>
                                    <input name="medicine_start" type="text" id="medicine_start"
                                        class="form-control hasdatetimepicker <?php $__errorArgs = ['medicine_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="YYYY/MM/DD" required>
                                </div>
                                <span id="medicine_start_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['medicine_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.end')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                        </div>
                                    </div>
                                    <input name="medicine_end" type="text" id="medicine_end"
                                        class="form-control hasdatetimepicker <?php $__errorArgs = ['medicine_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="YYYY/MM/DD" required>
                                </div>

                                <?php $__errorArgs = ['medicine_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                <span id="medicine_end_error" class="error-msg-form"></span>
                            </div>


                            <div class="col-12 mb-4">
                                <label class="form-label"><?php echo e(__('basic.appointment')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <select
                                    class="myselect2-medicine-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="last_appointment_id_medi" name="last_appointment_id" required>
                                    <?php $__currentLoopData = $patient->appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>">
                                        <?php echo e($item->start_at); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <span id="last_appointment_id_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <button id="add_new_medicine_prescription" class="main-color-btn border-0 b-r-l-cont p-3"><i
                                    class="fas fa-plus"></i> Add new
                                medicine Prescription</button>
                        </div>

                        <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">Create New
                                Prescription</button>
                        </div>
                    </div>
                </form>

            </div>
        </div>

    </div>

    <!-- Modal Medicine update data -->
    <div class="modal fade" id="medicine_edit" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                        <?php echo e(__('patientappo.update medicines')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form class="mb-0" action="<?php echo e(route('sett.medicine.update', '21')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="row mb-2">

                            <div class="col-12 mb-2">
                                <label class="form-label">Medicine
                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <select
                                    class="myselect2-medicine-update select2-hidden-accessible <?php $__errorArgs = ['medicine_pills_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="medicine_pills_update" name="medicine_pills_update" required>
                                    <?php $__currentLoopData = $medicine_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>">
                                        <?php echo e($item->name . ' - ' . $item->price . 'EGP'); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <span id="medicine_pills_update_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['medicine_pills_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>


                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.status')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <select
                                    class="myselect2-medicine-update select2-hidden-accessible select2-no-search-medicine <?php $__errorArgs = ['status_medicine_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="status_medicine_update" name="status_medicine_update" required>
                                    <option value="0">
                                        On medicine
                                    </option>
                                    <option value="1">
                                        No result
                                    </option>
                                    <option value="2">
                                        Done
                                    </option>
                                </select>

                                <span id="status_update_update_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['status_update_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.start')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                        </div>
                                    </div>
                                    <input name="medicine_start_update" type="text"
                                        class="form-control hasdatetimepicker <?php $__errorArgs = ['medicine_start_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="YYYY/MM/DD" required>
                                </div>
                                <span id="medicine_start_update_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['medicine_start_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.end')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                        </div>
                                    </div>
                                    <input name="medicine_end_update" type="text"
                                        class="form-control hasdatetimepicker <?php $__errorArgs = ['medicine_end_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="YYYY/MM/DD" required>
                                </div>

                                <?php $__errorArgs = ['medicine_end_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                <span id="medicine_end_update_error" class="error-msg-form"></span>
                            </div>


                        </div>

                        <input name="medicine_id_update" value="" type="hidden">

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">Never
                                Mind</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">Update</button>
                        </div>
                    </div>
                </form>

            </div>
        </div>

    </div>

    <!-- Modal delete -->
    <div class="modal fade" id="medicine_delete" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

            <div class="modal-content shadow-lgg b-r-s-cont border-0">

                <div class="modal-header">
                    <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                        Medicine delete</div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form class="mb-0" action="<?php echo e(route('sett.medicine.destroy', 'test')); ?>" method="post">
                    <?php echo e(method_field('delete')); ?>

                    <?php echo e(csrf_field()); ?>


                    <!-- Modal content -->
                    <div class="modal-body px-4">

                        <div class="modal-body delete-conf-input text-center py-0">
                            <p class="mb-0">ِAre
                                you sure you want to delete
                                this
                                medicine?</p><br>
                            <input type="hidden" name="medicine_id_delete" value="">
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">Never
                                Mind</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link text-red">Delete
                            </button>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>

</div><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/patient/component/exm_med.blade.php ENDPATH**/ ?>