<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($patient->first_name); ?> Prescription</title>
    <link rel="stylesheet" href="<?php echo e(public_path('css/kv-mpdf-bootstrap.css')); ?>">

</head>

<body>

    <!-- Patient Info -->
    <div class="card-body px-4">

        <div class="row mb-3 b-r-s-cont border2 py-3 px-2">

            <div class="col-xs-5 text-truncate p-0" style="">
                <div class="w-10">
                    <div class="p-0" style="width: 25%;float: left;">
                        <div class="rounded-circle avatar-m2 profile_img"
                            style="background-image: url(<?php echo e(public_path('img/useravatar/' . $patient->avatar)); ?>)">
                        </div>
                    </div>

                    <div class="text-truncate p-0" style="width: 75%;float: left;">
                        <p class="m-0 p-0 text-s">
                            Patient</p>
                        <p class="m-0 p-0 text-s fw-bold2 text-truncate">
                            <?php echo e($patient->first_name . ' ' . $patient->second_name); ?></p>
                        <p class="m-0 p-0 text-s"><?php echo e($patient->city->name); ?> <?php echo e($patient->country->name); ?></p>
                    </div>
                </div>
            </div>

            <div class="col-xs-2 px-0" style="display: inline;">
                <p class="text-s mb-0">Age</p>
                <p class="fw-bold2">
                    <?php echo e(\Carbon\Carbon::parse($patient->birthday)->diff(\Carbon\Carbon::now())->format('%y')); ?>

                </p>
            </div>

            <div class="col-xs-2 px-0 text-truncate">
                <p class="text-s mb-0 text-truncate">Insurance</p>
                <p class="fw-bold2"><?php echo e($patient->insurance); ?></p>
            </div>
            <div class="col-xs-2">
                <p class="text-s mb-0">Phone Number</p>
                <p class="fw-bold2"><?php echo e($patient->phone_number); ?></p>
            </div>
        </div>

        <!-- Medicenes -->
        <div class="row mb-3">
            <div class="col-xs-12">
                <h4 class="">Medicenes</h4>
                <div class="table-responsive">
                    <table class="table-responsive text-s table-bordered2 bordered w-100">
                        <thead>
                            <tr>
                                <th style="width:40%;">Name</th>
                                <th style="width:20%;">From</th>
                                <th style="width:20%;">To</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $patient->medicines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr style="word-wrap: break-word;">
                                    <td style="width:40%;">
                                        <?php echo e($item->medicinescats->name); ?>

                                    </td>
                                    <td style="width:20%;">
                                        <?php echo e($item->start); ?></td>
                                    <td style="width:20%;"><?php echo e($item->end); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                </div>
            </div>
        </div>
        <?php if($appo_last_med): ?>
            <?php
                $start_at = $appo_last_med->appointment->start_at;
            ?>
            <?php if($appo_last_med->appointment->doctor): ?>
                <?php
                    $doctor_name = $appo_last_med->appointment->doctor->name;
                ?>
            <?php else: ?>
                <?php
                    $doctor_name = 'Not Selected';
                ?>
            <?php endif; ?>
        <?php else: ?>
            <?php
                $start_at = 'Not Selected';
                $doctor_name = 'Not Selected';
            ?>
        <?php endif; ?>

        <h4 class="text-s mt-5">Appointment data: <?php echo e($start_at); ?></h4>
        <h4 class="text-s">Responsible Doctor: <?php echo e($doctor_name); ?></h4>
    </div>


</body>

</html>
<?php /**PATH /home/drsamirghoraba/public_html/prox/proxima/resources/views/patient/print_pre.blade.php ENDPATH**/ ?>