<?php $__env->startSection('title', $patient->first_name . ' ' . $patient->second_name . ' | Proxima - Medical Management app'); ?>
<?php $__env->startSection('title-topbar', __('patientappo.patient profile')); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<!-- datepicker time and date -->
<link rel="stylesheet" href="https://fastly.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

<!-- tables -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.0.1/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.2/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/autofill/2.3.9/css/autoFill.bootstrap5.min.css">


<script type="text/javascript" language="javascript"
    src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>


<!-- toaster -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css" rel="stylesheet" />
<?php $__env->stopSection(); ?>


<?php $__env->startSection('fixedcontent'); ?>

<!-- session successful message -->
<?php if(Session::has('success')): ?>
<div id="flash-msg" class=" shadow-lg pt-3">
    <div class="d-flex justify-content-between mb-2">
        <i class="fas fs-1 fa-check"></i>
        <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
    </div>
    <h3>Done</h3>
    <p class="text-blue-300"><?php echo e(Session::get('success')); ?></p>
</div>
<?php else: ?>

<?php endif; ?>

<!-- session successful message -->
<?php if(Session::has('error_delete')): ?>
<div id="flash-msg" class="shadow pt-3" style="background-color:#ff4152;">
    <div class="d-flex justify-content-between mb-2">
        <i class="fas fs-1 fa-times"></i>
        <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"
                style="color:#ffb4bc"></i></a>
    </div>
    <h3>Can not be deleted</h3>
    <p style="color:#ffb4bc"><?php echo e(Session::get('error_delete')); ?></p>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>

<div class="container-fluid px-0">

    <!-- msg success -->
    <div id="flash-msg-cont"></div>

    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="text-red"><i class="fas fa-exclamation me-1"></i> <?php echo e($error); ?></div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <!-- page title link -->
    <div class="d-flex flex-wrap align-items-center justify-content-between mb-3">

        <!-- page title link -->
        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>"><?php echo e(__('basic.dashboard')); ?>

                |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.patient.index')); ?>"><?php echo e(__('basic.patient')); ?> | </a>
            <a class="text-gray-300"><?php echo e($patient->first_name); ?></a>
        </span>

        <div class="d-flex flex-wrap justify-content-center mt-2">


            <?php if(auth()->check() && auth()->user()->hasRole('Super-admin|Doctor|Branch-manager|Receptionist|Operation')): ?>
            <a data-bs-toggle="modal" data-bs-target="#send_sms"
                class="bg-white text-gray-400 btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-2 mb-2 mb-md-0"><i
                    class="fas fa-mobile-alt fa-sm me-1"></i> SMS</a>

            <div class="modal fade" id="send_sms" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                    <form class="mb-0" action="<?php echo e(route('sett.pat_sms_form_profile', $patient->id)); ?>" method="GET"
                        style="display: contents">

                        <div class="modal-content b-r-s-cont border-0">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-mobile-alt me-1"></i>
                                    <?php echo e(__('patientappo.send sms')); ?></h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">
                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('patientappo.sms content')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <textarea name="sms_content" class="form-control"
                                            placeholder="Write here your the sms content .." rows="4"
                                            spellcheck="false"></textarea>

                                        <?php $__errorArgs = ['sms_content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                </div>

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color"><?php echo e(__('basic.send')); ?></button>
                                </div>
                            </div>

                        </div>
                    </form>

                </div>

            </div>

            <?php if(auth()->check() && auth()->user()->hasRole('Super-admin|Branch-manager|Operation|Receptionist')): ?>
            <a data-bs-toggle="modal" data-bs-target="#edit_recom"
                class="bg-white text-gray-400 btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-2 mb-2 mb-md-0"><i
                    class="fas fa-pen fa-sm me-1"></i> <?php echo e(__('basic.slight edit')); ?></a>

            <!-- Modal for inserting the past appointments -->
            <div class="modal fade" id="edit_recom" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-pen me-1"></i>
                                <?php echo e(__('basic.edit')); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="<?php echo e(route('sett.pat_slight_edit')); ?>" method="post">
                            <?php echo e(method_field('PATCH')); ?>

                            <?php echo e(csrf_field()); ?>


                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.type')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-recom-insert select2-hidden-accessible <?php $__errorArgs = ['edit_type_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="edit_type_status" name="edit_type_status" required>
                                            <option <?php if($patient->type == 1): ?> selected <?php endif; ?> value="1">
                                                <?php echo e(__('basic.patients')); ?>

                                            </option>
                                            <option <?php if($patient->type == 2): ?> selected <?php endif; ?> value="2">
                                                <?php echo e(__('basic.leads')); ?>

                                            </option>
                                            <option <?php if($patient->type == 3): ?> selected <?php endif; ?> value="3">
                                                <?php echo e(__('basic.leads interested')); ?>

                                            </option>
                                            <option <?php if($patient->type == 4): ?> selected <?php endif; ?> value="4">
                                                <?php echo e(__('basic.leads not interested')); ?>

                                            </option>
                                        </select>

                                        <span id="edit_type_status_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['edit_type_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.recommendation')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-recom-insert select2-hidden-accessible <?php $__errorArgs = ['edit_recom_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="edit_recom_status" name="edit_recom_status" required>
                                            <option <?php if($patient->recommendation == 1): ?> selected <?php endif; ?> value="1">
                                                <?php echo e(__('basic.normal')); ?>

                                            </option>
                                            <option <?php if($patient->recommendation == 2): ?> selected <?php endif; ?> value="2">
                                                <?php echo e(__('basic.recommended')); ?>

                                            </option>
                                            <option <?php if($patient->recommendation == 3): ?> selected <?php endif; ?> value="3">
                                                <?php echo e(__('basic.not recommended')); ?>

                                            </option>
                                        </select>

                                        <span id="edit_recom_status_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['edit_recom_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>


                                    <?php if(auth()->check() && auth()->user()->hasRole('Super-admin|Branch-manager|Operation')): ?>
                                    <div class="col-12 mb-2">
                                        <label class="form-label"> <?php echo e(__('patientappo.wallet')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                        <input name="wallet_recom" type="text"
                                            class="form-control <?php $__errorArgs = ['wallet_recom'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="Wallet amunt ..." value="<?php echo e($patient->wallet); ?>" required>

                                        <span id="wallet_recom_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['wallet_recom'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-12 mb-2">
                                        <label class="form-label"> <?php echo e(__('basic.balance')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                        <input name="balance_recom" type="text"
                                            class="form-control <?php $__errorArgs = ['balance_recom'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="balance amunt ..." value="<?php echo e($patient->balance); ?>" required>

                                        <span id="balance_recom_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['balance_recom'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <?php endif; ?>

                                </div>

                                <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">Edit
                                    </button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>

            <?php endif; ?>

            <a href="<?php echo e(route('sett.patient.edit', $patient->id)); ?>"
                class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 me-2 mb-2 mb-md-0"><i
                    class="fas fa-user-edit fa-sm text-gray-300 me-1"></i> <?php echo e(__('basic.edit')); ?></a>


            <div class="dropdown no-arrow">
                <a href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown" aria-haspopup="true"
                    aria-expanded="false"
                    class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 me-2 mb-2 mb-md-0"><i
                        class="fas fa-capsules fa-sm text-gray-300 me-2"></i> <?php echo e(__('patientappo.presc')); ?></a>
                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                    aria-labelledby="dropdownMenuLink">
                    <div class="dropdown-header">Type Of Prints:</div>
                    <a class="dropdown-item clickable-item-pointer" target="_blank"
                        href="<?php echo e(route('pat_patient_print_pre_no_frame', $patient->code)); ?>">
                        <?php echo e(__('basic.prescription with no frame A5')); ?></a>
                    <a class="dropdown-item clickable-item-pointer" target="_blank"
                        href="<?php echo e(route('pat_patient_print_pre', $patient->code)); ?>">
                        <?php echo e(__('basic.prescription with frame A5')); ?></a>
                </div>
            </div>

            <a id="print_qr" data-id="<?php echo e($patient->id); ?>"
                class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 ms-2"><i
                    class="fas fa-sticky-note fa-sm text-gray-300 me-1"></i> <?php echo e(__('basic.barcode')); ?></a>


            <!-- confirm Modal -->
            <div class="modal fade" id="print_qty_qr" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable ">
                    <div class="modal-content b-r-s-cont border-0">

                        <div class="modal-header">
                            <div class="modal-title" id="exampleModalLabel"><i class="fas fa-box-open me-1"></i>
                                <?php echo e(__('basic.how many sticker you want to print')); ?></div>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-4">

                            <div class="modal-body delete-conf-input text-center d-flex py-0">

                                <select id="print_sticker_qty"
                                    class="myselect2-record-insert myselect2-sticker-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['qty'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="type" name="print_sticker_qty" required>
                                    <?php for($i = 1; $i <= 20; $i++): ?> <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                        <?php endfor; ?>
                                </select>
                                <input type="hidden" name="print_sticker_patient_id" id="print_sticker_patient_id"
                                    value="">
                            </div>
                        </div>

                        <div class="modal-footer">
                            <div class="right-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                            </div>
                            <div class="divider"></div>
                            <div class="left-side">
                                <button id="print_qr_btn"
                                    class="btn btn-default btn-link text-green"><?php echo e(__('basic.print')); ?>

                                </button>
                            </div>
                        </div>

                    </div>
                </div>
            </div>


            <a href="<?php echo e(route('sett.pat_patient_print', $patient->id)); ?>"
                class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400"><i
                    class="fas fa-download fa-sm text-gray-300 me-2"></i> <?php echo e(__('basic.print')); ?></a>
            <?php endif; ?>


            <?php if(auth()->check() && auth()->user()->hasRole('Super-admin')): ?>
            <a data-bs-toggle="modal" data-bs-target="#delete_patient"
                class="bg-white text-gray-400 btn btn-sm shadow-sm b-r-l-cont p-2 px-4 ms-2 mb-2 mb-md-0"><i
                    class="fas fa-trash-alt fa-sm me-1"></i> Delete</a>

            <div class="modal fade" id="delete_patient" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                    <form class="mb-0" action="<?php echo e(route('sett.patient.destroy', $patient->id)); ?>" method="post"
                        style="display: contents">
                        <?php echo e(method_field('delete')); ?>

                        <?php echo e(csrf_field()); ?>


                        <div class="modal-content b-r-s-cont border-0">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-trash-alt me-1"></i>
                                    <?php echo e(__('basic.delete patient')); ?></h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">

                                    <div class="col-12 mb-2">
                                        هل انت متاكد من حذف المريض؟ سوف يتم مسح معظم عملياته في النظام
                                    </div>

                                </div>

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color"><?php echo e(__('basic.delete')); ?></button>
                                </div>
                            </div>

                        </div>
                    </form>

                </div>

            </div>
            <?php endif; ?>
        </div>

    </div>

    <!-- welcome msg & note -->
    <div class="row mb-4">
        <div class="col-lg-8 col-sm-12">
            <div class="card shadow mb-4 mb-lg-0">

                <!-- Card Body -->
                <div class="card-body row">
                    <div class="col align-self-center border-flex ps-3">

                        <div class="d-flex mb-4 align-items-center">
                            <div class="position-relative">
                                <?php if($patient->recommendation == 1): ?>
                                <?php
                                $recom_color = 'main-color-bg-200';
                                $recom_msg = __('basic.normal');
                                ?>
                                <?php elseif($patient->recommendation == 2): ?>
                                <?php
                                $recom_color = 'text-green-ligh-bg';
                                $recom_msg = __('basic.recommended');
                                ?>
                                <?php elseif($patient->recommendation == 3): ?>
                                <?php
                                $recom_color = 'text-red-bg';
                                $recom_msg = __('basic.not recommended');
                                ?>
                                <?php endif; ?>
                                <img class="rounded-circle avatar-lg me-3"
                                    src="<?php echo e(URL::asset('img/useravatar/' . $patient->avatar)); ?>">
                                <div data-toggle="tooltip" data-placement="top" title="<?php echo e($recom_msg); ?>"
                                    class="status-indicator-img <?php echo e($recom_color); ?>"></div>
                            </div>
                            <div class="">
                                <h5 class="mb-1 fw-bold text-gray-600">
                                    <?php echo e($patient->first_name . ' ' . $patient->second_name); ?></h5>
                                <p class="mb-0 text-xs text-gray-400"><?php echo e(__('basic.file number')); ?>: <strong>
                                        <?php echo e($patient->new_id); ?></strong></p>
                                <p class="mb-0 text-xs text-gray-400"><?php echo e(__('basic.code')); ?>: <strong>
                                        <?php echo e($patient->code); ?></strong></p>
                            </div>

                        </div>

                        <div class="d-flex ps-2 justify-content-between">

                            <div class="align-items-center text-center">
                                <p class="text-xxs fw-normal mb-1 text-gray-400"><?php echo e(__('patientappo.weight')); ?></p>
                                <span class="text-s2 fw-bold text-gray-600"><i
                                        class="fas fa-child fa-sm fa-fw text-gray-300"></i>
                                    <?php echo e($patient->height); ?><small class="text-xxs text-gray-200">cm</small></span>
                            </div>

                            <div class="align-items-center text-center me-2">
                                <p class="text-xxs fw-normal mb-1 text-gray-400"><?php echo e(__('patientappo.height')); ?></p>
                                <span class="text-s2 fw-bold text-gray-600"><i
                                        class="fas fa-weight-hanging fa-sm fa-fw text-gray-300"></i>
                                    <?php echo e($patient->weight); ?><small class="text-xxs text-gray-200">kg</small></span>
                            </div>

                            <div class="align-items-center text-center  ">
                                <p class="text-xxs fw-normal mb-1 text-gray-400">P <?php echo e(__('basic.balance')); ?></p>
                                <span class="text-s2 fw-bold text-gray-600"><i
                                        class="fas fa-thermometer fa-sm fa-fw text-gray-300"></i>
                                    <?php echo e($patient->balance); ?><small class="text-xxs text-gray-200">pts</small></span>
                            </div>

                            <div class="align-items-center text-center  ">
                                <p class="text-xxs fw-normal mb-1 text-gray-400"><?php echo e(__('patientappo.wallet')); ?></p>
                                <span class="text-s2 fw-bold text-gray-600"><i
                                        class="fas fa-wallet fa-sm fa-fw text-gray-300"></i>
                                    <?php echo e($patient->wallet); ?><small class="text-xxs text-gray-200">egp</small></span>
                            </div>

                        </div>
                    </div>


                    <div class="col-12 col-sm ps-4 pt-3">

                        <div id="patient-info-caro" class="carousel slide" data-bs-ride="carousel"
                            data-bs-interval="false">

                            <div class="carousel-indicators dots-radius-carousel"
                                style="bottom: -28px; margin-bottom: 0px;">
                                <button type="button" data-bs-target="#patient-info-caro" data-bs-slide-to="0"
                                    class="active" aria-current="true" aria-label="Slide 1"></button>
                                <button type="button" data-bs-target="#patient-info-caro" data-bs-slide-to="1"
                                    aria-label="Slide 2"></button>
                            </div>

                            <div class="carousel-inner mb-3">

                                <!-- info 1 -->
                                <div class="carousel-item active">

                                    <div class="row mb-2">
                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('patientappo.age')); ?></h6>
                                            <p class="text-gray-600 text-s fw-bold">
                                                <?php echo e(\Carbon\Carbon::parse($patient->birthday)->diff(\Carbon\Carbon::now())->format('%y
                                                Years')); ?>

                                            </p>
                                        </div>
                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('basic.address')); ?></h6>
                                            <p class="text-gray-600 text-s fw-bold"><?php echo e($patient->city->name); ?> ,
                                                <?php echo e($patient->country->name); ?></p>
                                        </div>
                                    </div>

                                    <div class="row mb-2">
                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('patientappo.ph number')); ?>

                                            </h6>
                                            <p class="text-gray-600 text-xs fw-bold"><?php echo e($patient->phone_number); ?>

                                            </p>
                                        </div>
                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('basic.branch')); ?>

                                            </h6>
                                            <p class="text-gray-600 text-s fw-bold"><?php echo e($patient->branch->name); ?></p>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('basic.file branch number')); ?>

                                            </h6>
                                            <p class="text-gray-600 text-s fw-bold"><?php echo e($patient->new_branch_id); ?>

                                            </p>
                                        </div>

                                        <div class="col pt-3">
                                            <p class="<?php if($patient->note): ?> text-green-ligh
                                                    <?php else: ?>
                                                    main-color <?php endif; ?>
                                                    text-xs fw-bold clickable-item-pointer" data-bs-toggle="modal"
                                                data-bs-target="#patient_note"><i class="fas fa-comment-alt"></i>
                                                <?php echo e(__('basic.note')); ?>


                                                <?php if($patient->note): ?>
                                                <span class="badge rounded badge-danger badge-counter"
                                                    style="border-radius: 50% !important;height: 15px;width: 15px;padding: 3px !important;">1</span>
                                                <?php endif; ?>

                                            </p>

                                            <!-- Modal -->
                                            <div class="modal fade" id="patient_note" tabindex="-1"
                                                aria-labelledby="exampleModalLabel2" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                                                    <div class="modal-content b-r-s-cont border-0">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLabel2"><i
                                                                    class="fas fa-quote-left me-1"></i>
                                                                <?php echo e(__('patientappo.patient note')); ?></h5>
                                                            <button type="button" class="btn-close"
                                                                data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>

                                                        <!-- Modal content -->
                                                        <div class="modal-body px-4">
                                                            <div class="mb-3">
                                                                <label class="form-label"><?php echo e(__('basic.note')); ?>

                                                                    <small></small></label>
                                                                <textarea name="note" class="form-control"
                                                                    placeholder="Write here your notes .." rows="4"
                                                                    spellcheck="false"
                                                                    date-text="Write here your notes .."><?php echo e($patient->note); ?></textarea>
                                                            </div>
                                                        </div>

                                                        <div class="modal-footer">
                                                            <div class="left-side">
                                                                <button type="button" class="btn btn-default btn-link"
                                                                    data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                                            </div>
                                                            <div class="divider"></div>
                                                            <div class="right-side">
                                                                <button type="button" id="note_ajax"
                                                                    class="btn btn-default btn-link main-color"
                                                                    data-bs-dismiss="modal"><?php echo e(__('basic.save changes')); ?></button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- info 2 -->
                                <div class="carousel-item">

                                    <div class="row mb-2">

                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1">
                                                <?php echo e(__('patientappo.sec ph number')); ?>

                                            </h6>
                                            <p class="text-gray-600 text-xs fw-bold">
                                                <?php echo e($patient->sec_phone_number); ?>

                                            </p>
                                        </div>


                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('patientappo.resource')); ?>

                                            </h6>
                                            <p class="text-gray-600 text-s fw-bold"><?php echo e($patient->recourse->name); ?>

                                            </p>
                                        </div>
                                    </div>

                                    <div class="row mb-2">
                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('patientappo.insurance')); ?>

                                            </h6>
                                            <p class="text-gray-600 text-s fw-bold"><?php echo e($patient->insurance); ?></p>
                                        </div>

                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1">
                                                <?php echo e(__('basic.status')); ?></h6>
                                            <p class="text-gray-600 text-s fw-bold">
                                                <?php if($patient->type == 1): ?>
                                                <?php echo e(__('basic.patient')); ?>

                                                <?php elseif($patient->type == 2): ?>
                                                <?php echo e(__('basic.leads no action')); ?>

                                                <?php elseif($patient->type == 3): ?>
                                                <?php echo e(__('basic.leads interested')); ?>

                                                <?php elseif($patient->type == 4): ?>
                                                <?php echo e(__('basic.leads not interested')); ?>

                                                <?php endif; ?>
                                            </p>
                                        </div>
                                    </div>

                                    <div class="row mb-2">
                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('patientappo.gendar')); ?>

                                            </h6>
                                            <p class="text-gray-600 text-s fw-bold"><?php echo e($patient->gendar); ?></p>
                                        </div>
                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('patientappo.blood')); ?>

                                            </h6>
                                            <p class="text-gray-600 text-s fw-bold"><?php echo e($patient->blood_type); ?></p>
                                        </div>
                                    </div>

                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="col">

            <div class="row h-100">

                <div class="col-6 pe-2">
                    <div class="card h-100 shadow text-white" style="background-color: #FF7777;">
                        <!-- Card Header - Dropdown -->
                        <div
                            class="card-header py-3 d-flex flex-row align-items-center justify-content-between bg-transparent border-bottom-0">
                            <h6 class="m-0 fw-bold">Heart Rate</h6>
                            <div class="dropdown no-arrow">
                                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                    data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fas fa-ellipsis-v fa-sm fa-fw text-white"></i>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                    aria-labelledby="dropdownMenuLink">
                                    <a class="dropdown-item" href="#">Action</a>
                                </div>
                            </div>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body d-flex align-self-center align-items-center text-center p-0">
                            <div class="mb-2">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                    aria-hidden="true" role="img" width="5em" height="5em"
                                    preserveAspectRatio="xMidYMid meet" viewBox="0 0 24 24">
                                    <path
                                        d="M21 11h-3.94a.78.78 0 0 0-.21 0h-.17a1.3 1.3 0 0 0-.15.1a1.67 1.67 0 0 0-.16.12a1 1 0 0 0-.09.13a1.32 1.32 0 0 0-.12.2l-1.6 4.41l-4.17-11.3a1 1 0 0 0-1.88 0L6.2 11H3a1 1 0 0 0 0 2H7.3a.86.86 0 0 0 .16-.1a1.67 1.67 0 0 0 .16-.12l.09-.13a1 1 0 0 0 .12-.2l1.62-4.53l4.16 11.42a1 1 0 0 0 .94.66a1 1 0 0 0 .94-.66l2.3-6.34H21a1 1 0 0 0 0-2z"
                                        fill="currentColor" />
                                </svg>
                                <h1 class="fw-bold mb-3">
                                    <?php if(empty($patient->heart_rate)): ?>
                                    <h5 class="fw-light">Not Yet</h5>
                                    <?php else: ?>
                                    <?php echo e($patient->heart_rate); ?> <small class="text-xs fw-normal">bpm</small>
                                    <?php endif; ?>
                                </h1>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-6 ps-2">
                    <div class="card h-100 shadow min-height-card text-white" style="background-color: #77BEFF;">
                        <!-- Card Header - Dropdown -->
                        <div
                            class="card-header py-3 d-flex flex-row align-items-center justify-content-between bg-transparent border-bottom-0">
                            <h6 class="m-0 fw-bold">BL Pressure</h6>
                            <div class="dropdown no-arrow">
                                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                    data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fas fa-ellipsis-v fa-sm fa-fw text-white"></i>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                    aria-labelledby="dropdownMenuLink">
                                    <div class="dropdown-header">Dropdown Header:</div>
                                    <a class="dropdown-item" href="#">Action</a>
                                    <a class="dropdown-item" href="#">Another action</a>
                                    <div class="dropdown-divider"></div>
                                    <a class="dropdown-item" href="#">Something else here</a>
                                </div>
                            </div>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body d-flex align-self-center align-items-center text-center p-0">
                            <div class="mb-2">
                                <svg width="5em" height="5em" viewBox="0 0 48 48" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M9 19.0345C9 13.3091 12.8117 8 18.0312 8C21.6533 8 24.341 10.382 26 13.7611C27.6589 10.3822 30.3466 8 33.9688 8C39.1889 8 43 13.31 43 19.0345C43 31.2888 26 40 26 40C26 40 14.5487 34.4872 10.4431 25.4444H20.5848L22.1968 22.5788L24.0797 29.1692L28.4891 23.5H34V21.5H27.5109L24.9203 24.8308L22.8032 17.4212L19.4152 23.4444H9.67984C9.89182 24.1288 10.1486 24.7957 10.4431 25.4444L6 25.4443V23.4443L9.67984 23.4444C9.24643 22.0453 9 20.5731 9 19.0345Z"
                                        fill="#ffffff" />
                                </svg>
                                <h2 class="fw-bold mt-3 mb-3">
                                    <?php if(empty($patient->bl_pressure)): ?>
                                    <h5 class="fw-light">Not Yet</h5>
                                    <?php else: ?>
                                    <?php echo e($patient->bl_pressure); ?>

                                    <?php endif; ?>
                                </h2>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>

    <?php if(auth()->check() && auth()->user()->hasRole('Super-admin|Doctor|Branch-manager|Receptionist|Operation|Operation_doctor')): ?>
    <!-- Content Row,  -->
    <div class="row">
        <!------ all patient js code ------>
        <?php echo $__env->make('patient.component.clients.samir_ghoraba.exm_med', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('patient.component.clients.samir_ghoraba.lab', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('patient.component.clients.samir_ghoraba.treat_sess', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <?php endif; ?>

    <!-- Content Row,  -->
    <div class="row pe-0">
        <?php echo $__env->make('patient.component.clients.samir_ghoraba.appointment', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('patient.component.clients.samir_ghoraba.payment', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

</div> <!-- end of container-fluid -->


<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>

<!-- select 2 -->
<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<!-- datapicker date and time -->
<script src="https://fastly.jsdelivr.net/npm/flatpickr"></script>

<!-- jquery ui datepicker -->
<script type="text/javascript"
    src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>

<script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/dataTables.bootstrap5.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.bootstrap5.min.js"></script>

<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>

<script type="text/javascript" language="javascript"
    src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

<script type="text/javascript" language="javascript"
    src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.colVis.min.js"></script>


<!-- Toastr alert -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script>
    toastr.options = {
            "closeButton": false,
            "debug": false,
            "newestOnTop": false,
            "progressBar": true,
            "positionClass": "toast-bottom-left",
            "preventDuplicates": false,
            "onclick": null,
            "showDuration": "300",
            "hideDuration": "1000",
            "timeOut": "5000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }

        <?php if(Session::has('success')): ?>
            toastr.success("<?php echo e(Session::get('success')); ?>");
        <?php endif; ?>

        <?php if(Session::has('errors')): ?>
            toastr.error("<?php echo e(session()->get('errors')->first()); ?>");
        <?php endif; ?>

        <?php if(Session::has('info')): ?>
            toastr.info("<?php echo e(session('info')); ?>");
        <?php endif; ?>

        <?php if(Session::has('warning')): ?>
            toastr.warning("<?php echo e(session('warning')); ?>");
        <?php endif; ?>
</script>


<script type="text/javascript" language="javascript"
    src="https://cdnjs.cloudflare.com/ajax/libs/jQuery.print/1.6.2/jQuery.print.min.js">
</script>


<!-- Validator plugin -->
<script src="https://fastly.jsdelivr.net/npm/jquery-validation@1.19.3/dist/jquery.validate.min.js"
    type="text/javascript">
</script>

<script>
    //Rules for the Validator plugin
        var $validator = $('.myform').validate({
            rules: {
                favorite_address: {
                    maxlength: 50,
                },
                name_street: {
                    maxlength: 50,
                },
                address_details: {
                    maxlength: 50,
                },
                building_number: {
                    maxlength: 50,
                },
                apartment_number: {
                    maxlength: 50,
                },
                phone: {
                    maxlength: 50,
                },

            },
            //for inserting erros for some inputs that makes posation problem such as selector 2 and bt datapicker
            errorPlacement: function(error, element) {
                switch (element.attr("name")) {
                    case 'permissions':
                        error.insertAfter($("#permissions-js-error-valid"));
                        break;

                    default:
                        error.insertAfter(element);
                }

            },
        });
</script>

<!------ all patient js code ------>
<?php echo $__env->make('patient.component.patientjs', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/medix/public_html/samirghoraba/med/resources/views/patient/show_samir_ghoraba.blade.php ENDPATH**/ ?>