<?php $__env->startSection('title', 'Edit Lab | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Edit Lab'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

    <!-- select 2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!-- boostrap datepicker -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />


<?php $__env->stopSection(); ?>


<!-- content insert -->
<?php $__env->startSection('content'); ?>

    <div class="container-fluid px-0 px-md-2 mt-3">

        <!-- page title link -->
        <div class="d-sm-flex align-items-center justify-content-between mb-3">
            <span class="mb-0">
                <a class="link-cust-text text-gray-200 fw-light"
                    href="<?php echo e(route('sett.home')); ?>"><?php echo e(__('basic.dashboard')); ?> |</a>
                <a class="link-cust-text text-gray-200 fw-light"
                    href="<?php echo e(route('sett.lab.index')); ?>"><?php echo e(__('basic.lab')); ?> | </a>
                <a class="text-gray-300"><?php echo e(__('patientappo.edit lab result')); ?></a>
            </span>
        </div>

        <div class="card card-input shadow mb-3 pb-3">
            <!-- Card Header - Dropdown -->
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-x-ray me-1"></i>
                    <?php echo e(__('patientappo.edit lab result')); ?></h6>
            </div>


            <!-- Card Body -->
            <div class="card-body px-4 px-md-5">

                <form id="myform" method="POST" action="<?php echo e(route('sett.lab.update', $lab->id)); ?>"
                    enctype="multipart/form-data">

                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div class="row mb-1">

                        <div class="col-12 col-md-7 mb-2 pt-3">

                            <div class="row mb-2">
                                <div class="d-flex mb-2 align-items-center">

                                    <img class="rounded-circle avatar-lg me-3"
                                        src="<?php echo e(URL::asset('img/useravatar/' . $lab->patient->avatar)); ?>">
                                    <div class="">
                                        <p class=" mb-0 text-xs text-gray-300">
                                            <?php echo e(__('basic.patient')); ?></p>
                                        <a class="mb-1 fw-bold fs-5 text-gray-600"
                                            href="<?php echo e(route('sett.patient.show', $lab->patient->id)); ?>">
                                            <?php echo e($lab->patient->name); ?></a>
                                        <p class="mb-0 text-xs text-gray-400"><?php echo e(__('basic.id')); ?> <strong>
                                                <?php echo e($lab->patient->id); ?></strong>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="row mb-2">
                                <div class="col">
                                    <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('basic.name')); ?></h6>
                                    <p class="text-gray-600 text-s fw-bold">
                                        <?php echo e($lab->service_cat->name); ?>

                                    </p>
                                </div>
                                <div class="col">
                                    <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('basic.code')); ?></h6>
                                    <p class="text-gray-600 text-s fw-bold">
                                        <?php echo e($lab->code); ?>

                                    </p>
                                </div>
                            </div>

                            <div class="row mb-2">
                                <div class="col">
                                    <h6 class="text-gray-300 text-s mb-1"><?php echo e(__('basic.created')); ?></h6>
                                    <p class="text-gray-600 text-s fw-bold">
                                        <?php echo e(date('d M Y h:i a', strtotime($lab->created_at))); ?>

                                    </p>
                                </div>
                                <div class="col">
                                    <h6 class="text-gray-300 text-s mb-1"><?php echo e(__('patientappo.appointment date')); ?></h6>
                                    <p class="text-gray-600 text-s fw-bold">
                                        <?php echo e(date('d M Y h:i a', strtotime($lab->appointment->start_at))); ?>

                                    </p>
                                </div>

                            </div>

                            <div class="row mb-2">
                                <div class="col">

                                    <?php if($lab->invoice_item->invoice->status == 0): ?>
                                        <?php
                                            $text_color_invoice = 'cancel-color-btn';
                                            $msg_invoice = __('basic.not paid');
                                        ?>
                                    <?php elseif($lab->invoice_item->invoice->status == 1): ?>
                                        <?php
                                            $text_color_invoice = 'done-color-btn';
                                            $msg_invoice = __('basic.paid');
                                        ?>
                                    <?php endif; ?>

                                    <h6 class="text-gray-300 text-s mb-2"><?php echo e(__('basic.payment status')); ?></h6>
                                    <span
                                        class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span>
                                </div>
                                <div class="col">
                                    <h6 class="text-gray-300 text-s mb-1"><?php echo e(__('basic.payment code')); ?></h6>
                                    <p class="text-gray-600 text-s fw-bold">
                                        <?php echo e($lab->invoice_item->invoice->code); ?>

                                    </p>
                                </div>
                            </div>

                        </div>

                        <div class="col-12 col-md-5 align-self-center mb-2">
                            <div class="avatar-update-container">
                                <div class="picture picture-lab">
                                    <?php if(!empty($lab->xray_file)): ?>
                                        <?php
                                            $img_url = URL::asset('img/lab/' . $lab->xray_file);
                                        ?>
                                    <?php else: ?>
                                        <?php
                                            $img_url = URL::asset('img/dashboard/cloud-upload-1912186-1617655.png');
                                        ?>
                                    <?php endif; ?>

                                    <img src="<?php echo e($img_url); ?>" class="picture-src" id="mib_PicturePreview"
                                        title="" />
                                    <input type="file" name='x_ray_file' accept="image/*" id="mib_img_input">
                                </div>
                                <h6 class="text-gray-300"><?php echo e(__('basic.choose pic')); ?></h6>

                                <?php $__errorArgs = ['x_ray_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error-msg-form">
                                        <?php echo e($message); ?>

                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>


                    </div>

                    <hr>
                    <div class="row mb-2">
                        <div class="col-12 col-md-6 mb-2">
                            <label class="form-label"><?php echo e(__('basic.doctor note')); ?></label>
                            <div class="form-control-textarea overflow-auto">
                                <?php echo e($lab->note_doctor); ?></div>
                        </div>
                        <div class="col-12 col-md-6 mb-2">
                            <label class="form-label"><?php echo e(__('patientappo.lab note')); ?>

                                <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                            <textarea name="lab_note" class="form-control" placeholder="Write here your notes .." rows="4"
                                spellcheck="false"><?php echo e($lab->note_lab); ?></textarea>

                            <?php $__errorArgs = ['lab_note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                    </div>

                    <input type="hidden" name="responsible_doctor" class="form-control" value="<?php echo e(Auth::id()); ?>">

                    <div class="d-flex justify-content-end mt-4 mb-2">
                        <input type="submit" name="next" class="next-form-steps btn btn-primary action-button-next"
                            value="<?php echo e(__('basic.update')); ?>">
                    </div>

                </form>
            </div>

        </div>

    </div>

<?php $__env->stopSection(); ?>

<!-- js insert -->
<?php $__env->startSection('js'); ?>

    <!-- select 2 -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.js-example-basic-single').select2();
            //hide search
            $('.select2-no-search').select2({
                minimumResultsForSearch: -1
            });
        });
    </script>

    <!-- jquery ui datepicker -->
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
    <script>
        $(function() {
            $('.hasdatetimepicker').datepicker({
                todayHighlight: true,
                format: "yyyy-mm-dd",
            });
        });
    </script>

    <!-- validate jquery -->
    <script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.3/dist/jquery.validate.min.js" type="text/javascript">
    </script>
    <script>
        //Rules for the Validator plugin
        var $validator = $('#myform').validate({
            rules: {
                first_name: {
                    minlength: 3,
                },
                second_name: {
                    minlength: 3,
                },
                email: {
                    email: true,
                },
                password: {
                    minlength: 7,
                    maxlength: 100,
                },
                password_confirmation: {
                    minlength: 7,
                    maxlength: 100,
                    equalTo: '#password',
                },
            },
            messages: {
                email: {
                    required: "We need your email address to contact you",
                    email: "Your email address must be in the format of name@domain.com"
                },
                password_confirmation: {
                    equalTo: "Password does not match",
                }
            },
            //for inserting erros for some inputs that makes posation problem such as selector 2 and bt datapicker
            errorPlacement: function(error, element) {
                switch (element.attr("name")) {
                    case 'role':
                        error.insertAfter($("#role-js-error-valid"));
                        break;
                    case 'gendar':
                        error.insertAfter($("#gendar-js-error-valid"));
                        break;
                    default:
                        error.insertAfter(element);
                }

            },
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/lab/edit.blade.php ENDPATH**/ ?>