<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($patient->first_name); ?> Profile</title>
    <link rel="stylesheet" href="<?php echo e(public_path('css/kv-mpdf-bootstrap.css')); ?>">

</head>

<body>

    <!-- Patient Info -->
    <div class="card-body px-4">

        <div class="row mb-3 b-r-s-cont border2 py-3 px-2">

            <div class="col-xs-5 text-truncate p-0" style="">
                <div class="w-10">
                    <div class="p-0" style="width: 25%;float: left;">
                        <div class="rounded-circle avatar-m2 profile_img"
                            style="background-image: url(<?php echo e(public_path('img/useravatar/' . $patient->avatar)); ?>)">
                        </div>
                    </div>

                    <div class="text-truncate p-0" style="width: 75%;float: left;">
                        <p class="m-0 p-0 text-s">
                            Patient</p>
                        <p class="m-0 p-0 text-s fw-bold2 text-truncate">
                            <?php echo e($patient->first_name . ' ' . $patient->second_name); ?></p>
                        <p class="m-0 p-0 text-s"><?php echo e($patient->city->name); ?> <?php echo e($patient->country->name); ?></p>
                    </div>
                </div>
            </div>

            <div class="col-xs-2 px-0" style="display: inline;">
                <p class="text-s mb-0">Age</p>
                <p class="fw-bold2">
                    <?php echo e(\Carbon\Carbon::parse($patient->birthday)->diff(\Carbon\Carbon::now())->format('%y')); ?>

                </p>
            </div>

            <div class="col-xs-2 px-0 text-truncate">
                <p class="text-s mb-0 text-truncate">Insurance</p>
                <p class="fw-bold2"><?php echo e($patient->insurance); ?></p>
            </div>
            <div class="col-xs-2">
                <p class="text-s mb-0">Phone Number</p>
                <p class="fw-bold2"><?php echo e($patient->phone_number); ?></p>
            </div>
        </div>

        <!-- Examination -->
        <div class="row justify-content-center mb-2">
            <span class="text-s2">Last Examination:</span>
            <div class="col-xs-6 p-0"
                style="background-image: url('<?php echo e(public_path('img/dashboard/system/human_front2.jpg')); ?>'); width:181px; height:325px; position: relative; background-repeat: no-repeat; margin-left: 25%;">
                <?php if(!empty($disease_draw->front)): ?>
                    <img src="<?php echo e(public_path('img/diseasedraw/' . $disease_draw->front)); ?>" width="181" height="325"
                        style=" solid;position: absolute;top:0;left:0;">
                <?php else: ?>
                    <div class="ms-4 text-center main-color-bg text-white p-2 b-r-s-cont"
                        style=" solid;position: absolute;top:13rem;left:3rem;">
                        No Back Draw
                    </div>
                <?php endif; ?>
            </div>

            <div class="col-xs-6 p-0"
                style="background-image: url('<?php echo e(public_path('img/dashboard/system/human_back2.jpg')); ?>'); width:181px; height:325px; position: relative; background-repeat: no-repeat;">

                <?php if(!empty($disease_draw->back)): ?>
                    <img src="<?php echo e(public_path('img/diseasedraw/' . $disease_draw->back)); ?>" width="181" height="325"
                        style=" solid;position: absolute;top:0;left:0;">
                <?php else: ?>
                    <div class="ms-4 text-center main-color-bg text-white p-2 b-r-s-cont"
                        style=" solid;position: absolute;top:13rem;left:3rem;">
                        No Back Draw
                    </div>
                <?php endif; ?>
            </div>

        </div>


        <div class="p-4 main-color-bg b-r-s-cont flex-wrap justify-content-center mb-3">
            <div class="row text-s">
                <div class="col-xs-12 mb-2 me-3 me-xl-5">
                    <span class="form-label text-blue-300 mb-1">Examination
                        Note:</span>
                    <div id="exam-note" class="form-control-textarea overflow-auto text-white fw-bold2"
                        style="width: 241px;">
                        <?php if(!empty($disease_draw->note)): ?>
                            <?php echo e($disease_draw->note); ?>

                        <?php else: ?>
                            No Note
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-xs-3 mb-2 me-3 me-xl-5">
                    <span class="form-label text-blue-300 mb-1">Appointment
                        Date:</span>
                    <div id="exam-date" class="text-white fw-bold2">
                        <?php if(!empty($disease_draw->appointment->start_at)): ?>
                            <?php echo e($disease_draw->appointment->start_at); ?>

                        <?php else: ?>
                            Not Selected
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-xs-3 mb-2">
                    <span class="form-label text-blue-300 mb-1">Doctor:</span>
                    <div id="exam-doctor" class="text-white fw-bold2">
                        <?php if(!empty($disease_draw->appointment->doctor->name)): ?>
                            <?php echo e($disease_draw->appointment->doctor->name); ?>

                        <?php else: ?>
                            Not Selected
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>


        <!-- All exminations -->
        <div class="row mb-3">
            <div class="col-xs-12">
                <h4 class="">Examinations</h4>
                <div class="table-responsive">
                    <table class="table-responsive text-s table-bordered2 bordered w-100">
                        <thead>
                            <tr>
                                <th style="width:40%;">Name</th>
                                <th style="width:20%;">Start</th>
                                <th style="width:20%;">End</th>
                                <th style="width:20%;">Status</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $disease; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($item->status == 0): ?>
                                    <?php
                                        $text_color = 'active-color-btn';
                                        $msg = 'Still';
                                    ?>
                                <?php elseif($item->status == 1): ?>
                                    <?php
                                        $text_color = 'done-color-btn';
                                        $msg = 'Healed';
                                    ?>
                                <?php endif; ?>


                                <tr style="word-wrap: break-word;">
                                    <td style="width:30%;"><?php echo e($item->diseasecats->name); ?></td>
                                    <td style="width:20%;"><?php echo e($item->start); ?></td>
                                    <td style="width:20%;"><?php echo e($item->end); ?></td>
                                    <td style="width:20%;"><span
                                            class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                    </td>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                </div>
            </div>
        </div>

        <!-- Treatments -->
        <div class="row mb-3">
            <div class="col-xs-12">
                <h4 class="">Treatments</h4>
                <div class="table-responsive">
                    <table class="table-responsive text-s table-bordered2 bordered w-100">
                        <thead>
                            <tr>
                                <th style="width:30%;">Name</th>
                                <th style="width:20%;">From</th>
                                <th style="width:20%;">To</th>
                                <th style="width:15%;">Sessions</th>
                                <th style="width:15%;">Status</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $treatment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($item->status == 0): ?>
                                    <?php
                                        $text_color = 'active-color-btn';
                                        $msg = 'In prog';
                                    ?>
                                <?php elseif($item->status == 1): ?>
                                    <?php
                                        $text_color = 'done-color-btn';
                                        $msg = 'Done';
                                    ?>
                                <?php endif; ?>

                                <tr style="word-wrap: break-word;">
                                    <td style="width:30%;"><?php echo e($item->treatment_cat->name); ?></td>
                                    <td style="width:20%;"><?php echo e($item->start); ?></td>
                                    <td style="width:20%;"><?php echo e($item->end); ?></td>
                                    <td style="width:15%;"><?php echo e($item->sessions_done); ?></td>
                                    <td style="width:15%;"><span
                                            class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                    </td>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                </div>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-xs-12">
                <h4 class="">Medicenes</h4>
                <div class="table-responsive">
                    <table class="table-responsive text-s table-bordered2 bordered w-100">
                        <thead>
                            <tr>
                                <th style="width:40%;">Name</th>
                                <th style="width:20%;">From</th>
                                <th style="width:20%;">To</th>
                                <th style="width:20%;">Status</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $medicine; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($item->status == 0): ?>
                                    <?php
                                        $text_color = 'active-color-btn';
                                        $msg = 'On medicine';
                                    ?>
                                <?php elseif($item->status == 1): ?>
                                    <?php
                                        $text_color = 'cancel-color-btn';
                                        $msg = 'No result';
                                    ?>
                                <?php elseif($item->status == 2): ?>
                                    <?php
                                        $text_color = 'done-color-btn';
                                        $msg = 'Done';
                                    ?>
                                <?php endif; ?>

                                <tr style="word-wrap: break-word;">
                                    <td style="width:40%;">
                                        <?php echo e($item->medicinescats->name); ?>

                                    </td>
                                    <td style="width:20%;">
                                        <?php echo e($item->start); ?></td>
                                    <td style="width:20%;"><?php echo e($item->end); ?>

                                    </td>
                                    <td style="width:20%;">
                                        <span
                                            class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-xs-12">
                <h4 class="">Lab</h4>
                <div class="table-responsive">
                    <table class="table-responsive text-s table-bordered2 bordered w-100">
                        <thead>
                            <tr>
                                <th style="width:30%;">Name</th>
                                <th style="width:20%;">Code</th>
                                <th style="width:30%;">Note</th>
                                <th style="width:20%;">Created</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $lab; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($item->status == 0): ?>
                                    <?php
                                        $text_color = 'active-color-btn';
                                        $msg = 'Sent';
                                    ?>
                                <?php elseif($item->status == 1): ?>
                                    <?php
                                        $text_color = 'done-color-btn';
                                        $msg = 'Done';
                                    ?>
                                <?php endif; ?>

                                <?php if($item->invoice_item->invoice->status == 0): ?>
                                    <?php
                                        $text_color_invoice = 'cancel-color-btn';
                                        $msg_invoice = 'Not Paid';
                                    ?>
                                <?php elseif($item->invoice_item->invoice->status == 1): ?>
                                    <?php
                                        $text_color_invoice = 'pend-color-btn';
                                        $msg_invoice = __('basic.pending');
                                    ?>
                                <?php elseif($item->invoice_item->invoice->status == 2): ?>
                                    <?php
                                        $text_color_invoice = 'done-color-btn';
                                        $msg_invoice = 'Paid';
                                    ?>
                                <?php endif; ?>

                                <tr style="word-wrap: break-word;">
                                    <td style="width:30%;"><?php echo e($item->service_item->name); ?></td>
                                    <td style="width:20%;"><?php echo e($item->code); ?></td>
                                    <td style="width:30%;"><?php echo e($item->note_lab); ?></td>
                                    <td style="width:20%;"><?php echo e(date('d M Y', strtotime($item->created_at))); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                </div>
            </div>
        </div>

    </div>


</body>

</html>
<?php /**PATH /home/drsamirghoraba/public_html/prox/proxima/resources/views/patient/print.blade.php ENDPATH**/ ?>