<?php $__env->startSection('title', 'Lab result | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Lab result'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>


<!-- content insert -->
<?php $__env->startSection('content'); ?>

    <div class="container-fluid px-0 px-md-2 mt-3">

        <!-- page title link -->
        <div class="d-flex align-items-center justify-content-between mb-3">
            <span class="mb-0">
                <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>">
                    <?php echo e(__('basic.dashboard')); ?> |</a>
                <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.lab.index')); ?>">
                    <?php echo e(__('basic.lab')); ?> | </a>
                <a class="text-gray-300"><?php echo e(__('patientappo.lab results')); ?></a>
            </span>

            <?php if($lab->invoice_item->invoice->status == 1): ?>
                <div class="d-flex justify-content-center">
                    <?php if($lab->status == 1): ?>
                        <a href="<?php echo e(route('sett.lab_lab_print', $lab->id)); ?>"
                            class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 me-2"><i
                                class="fas fa-download fa-sm text-gray-300 me-2"></i> <?php echo e(__('basic.print')); ?></a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('sett.lab.edit', $lab->id)); ?>"
                        class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400"><i
                            class="fas fa-marker fa-sm text-gray-300 me-1"></i> <?php echo e(__('basic.edit')); ?></a>

                </div>
            <?php endif; ?>

        </div>

        <div class="card card-input shadow mb-3 pb-3">
            <!-- Card Header - Dropdown -->
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-x-ray me-1"></i>
                    <?php echo e(__('patientappo.lab result')); ?>

                </h6>
            </div>


            <!-- Card Body -->
            <div class="card-body px-4 px-md-5">

                <div class="row mb-1">

                    <div class="col-12 col-md-7 mb-2 pt-3 border-flex">

                        <div class="row mb-4">
                            <div class="col-8">
                                <div class="d-flex mb-2 align-items-center">

                                    <img class="rounded-circle avatar-lg me-3"
                                        src="<?php echo e(URL::asset('img/useravatar/' . $lab->patient->avatar)); ?>">
                                    <div class="">
                                        <p class=" mb-0 text-xs text-gray-300">
                                            <?php echo e(__('basic.patient')); ?></p>
                                        <a class="mb-1 fw-bold fs-5 text-gray-600"
                                            href="<?php echo e(route('sett.patient.show', $lab->patient->id)); ?>">
                                            <?php echo e($lab->patient->name); ?></a>
                                        <p class="mb-0 text-xs text-gray-400"><?php echo e(__('basic.id')); ?> <strong>
                                                <?php echo e($lab->patient->id); ?></strong>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="container-fluid px-0 text-center">
                                    <div class="visible-print text-center">
                                        <?php echo QrCode::color(68, 95, 129)->size(80)->style('round')->eye('circle')->generate($lab->code); ?>

                                        <p class="mt-1 mb-0 text-s fw-bold text-gray-300"><?php echo e($lab->code); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-2">
                            <div class="col">
                                <h6 class="text-gray-300 text-xs mb-1"> <?php echo e(__('basic.name')); ?></h6>
                                <p class="text-gray-600 text-s fw-bold">
                                    <?php echo e($lab->service_item->name); ?>

                                </p>
                            </div>
                            <div class="col">
                                <h6 class="text-gray-300 text-xs mb-1"> <?php echo e(__('basic.branch')); ?></h6>
                                <p class="text-gray-600 text-s fw-bold">
                                    <?php echo e($lab->branch->name); ?>

                                </p>
                            </div>
                        </div>

                        <div class="row mb-2">
                            <div class="col">
                                <h6 class="text-gray-300 text-s mb-1"> <?php echo e(__('basic.created')); ?></h6>
                                <p class="text-gray-600 text-s fw-bold">
                                    <?php echo e(date('d M Y h:i a', strtotime($lab->created_at))); ?>

                                </p>
                            </div>
                            <div class="col">
                                <h6 class="text-gray-300 text-s mb-1"> <?php echo e(__('patientappo.appointment date')); ?></h6>
                                <p class="text-gray-600 text-s fw-bold">
                                    <?php echo e(date('d M Y h:i a', strtotime($lab->appointment->start_at))); ?>

                                </p>
                            </div>

                        </div>

                        <div class="row mb-2">
                            <div class="col">
                                <?php if($lab->invoice_item->invoice->status == 0): ?>
                                    <?php
                                        $text_color_invoice = 'cancel-color-btn';
                                        $msg_invoice = __('basic.not paid');
                                    ?>
                                <?php elseif($lab->invoice_item->invoice->status == 1): ?>
                                    <?php
                                        $text_color_invoice = 'pend-color-btn';
                                        $msg_invoice = __('basic.pending');
                                    ?>
                                <?php elseif($lab->invoice_item->invoice->status == 2): ?>
                                    <?php
                                        $text_color_invoice = 'done-color-btn';
                                        $msg_invoice = __('basic.paid');
                                    ?>
                                <?php endif; ?>

                                <h6 class="text-gray-300 text-s mb-2"><?php echo e(__('basic.payment status')); ?></h6>
                                <span
                                    class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span>
                            </div>
                            <div class="col">
                                <h6 class="text-gray-300 text-s mb-1"><?php echo e(__('basic.payment code')); ?></h6>
                                <p class="text-gray-600 text-s fw-bold">
                                    <?php echo e($lab->invoice_item->invoice->code); ?>

                                </p>
                            </div>
                        </div>

                    </div>

                    <div class="col-12 col-md-5 align-self-center mb-2">
                        <div class="avatar-update-container" style="cursor: auto !important;">


                            <?php if(!empty($lab->xray_file)): ?>
                                <div class="picture picture-lab mb-3">

                                    <img src="<?php echo e(URL::asset('img/lab/' . $lab->xray_file)); ?>" class="picture-src"
                                        id="mib_PicturePreview" title="" />
                                </div>
                                <a href="<?php echo e(URL::asset('img/lab/' . $lab->xray_file)); ?>">
                                    <span class="text-s badge rounded-pill active-color-btn badge-padd-l"><i
                                            class="fas fa-arrow-circle-down me-1"></i><?php echo e(__('basic.download')); ?></span>
                                </a>
                            <?php else: ?>
                                <div class="picture picture-lab mb-3">

                                    <img src="<?php echo e(URL::asset('img/dashboard/cloud-upload-1912186-1617655.png')); ?>"
                                        class="picture-src" id="mib_PicturePreview" title="" />
                                </div>

                                <a>
                                    <span class="text-s badge rounded-pill active-color-btn badge-padd-l"></i>No File
                                        Uploaded yet</span>
                                </a>
                            <?php endif; ?>

                        </div>
                    </div>


                </div>

                <hr>

                <div class="row mb-2">
                    <div class="col">
                        <?php if($lab->status == 0): ?>
                            <?php
                                $text_color = 'cancel-color-btn';
                                $msg = 'Not Done';
                            ?>
                        <?php elseif($lab->status == 1): ?>
                            <?php
                                $text_color = 'done-color-btn';
                                $msg = 'Done';
                            ?>
                        <?php endif; ?>

                        <h6 class="text-gray-300 text-s mb-2"><?php echo e(__('basic.status')); ?></h6>
                        <span class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                    </div>
                    <div class="col">
                        <h6 class="text-gray-300 text-s mb-1"><?php echo e(__('basic.responsible doctor')); ?></h6>
                        <p class="text-gray-600 text-s fw-bold">
                            <?php if(isset($lab->doctor->name)): ?>
                                <?php echo e($lab->doctor->name); ?>

                            <?php endif; ?>
                        </p>
                    </div>
                </div>

                <hr>

                <div class="row mb-2">
                    <div class="col-12 col-md-6 mb-2">
                        <label class="form-label"><?php echo e(__('basic.doctor note')); ?></label>
                        <div class="form-control-textarea overflow-auto">
                            <?php echo e($lab->note_doctor); ?></div>
                    </div>
                    <div class="col-12 col-md-6 mb-2">
                        <label class="form-label"><?php echo e(__('patientappo.lab note')); ?></label>
                        <div class="form-control-textarea overflow-auto">
                            <?php echo e($lab->note_lab); ?></div>
                    </div>

                </div>
            </div>

        </div>

    </div>

<?php $__env->stopSection(); ?>

<!-- js insert -->
<?php $__env->startSection('js'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/lab/show.blade.php ENDPATH**/ ?>