 <!-- Appointments -->
 <div class="<?php if(Auth::user()->hasRole('Call-center')): ?> col <?php else: ?> col-lg-7 <?php endif; ?> page-break pe-0 pe-md-3">
     <div class="card shadow mb-4">
         <!-- Card Header - Dropdown -->
         <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
             <h6 class="m-0 fw-bold"><?php echo e(__('patientappo.appointment timeline')); ?></h6>
             <div class="dropdown no-arrow">
                 <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown"
                     aria-haspopup="true" aria-expanded="false">
                     <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                 </a>
                 <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                     aria-labelledby="dropdownMenuLink">
                     <div class="dropdown-header">Appointment controller:</div>
                     <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#add_past_app">Add
                         past Appointment</a>
                     <a
                         class="dropdown-item add_info_old_appo clickable-item-pointer"><?php echo e(__('patientappo.old appointment info')); ?></a>
                     <a
                         class="dropdown-item add_info_exsit_appo clickable-item-pointer"><?php echo e(__('patientappo.exist appointment info')); ?></a>
                 </div>
             </div>
         </div>

         <!-- Card Body -->
         <div class="card-body pb-2 overflow-scroll">

             <?php if(count($patient->appointments) > 0): ?>
                 <ul class="list-group patient-timeline">

                     <?php $__currentLoopData = $patient->appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                         <?php if($item->status == 0): ?>
                             <?php
                                 $text_color = 'not_accepted-color';
                                 $msg = __('patientappo.not accepted');
                             ?>
                         <?php elseif($item->status == 1): ?>
                             <?php
                                 $text_color = 'main-color';
                                 $msg = __('patientappo.accepted');
                             ?>
                         <?php elseif($item->status == 2): ?>
                             <?php
                                 $text_color = 'arrived-color';
                                 $msg = __('patientappo.arrived');
                             ?>
                         <?php elseif($item->status == 3): ?>
                             <?php
                                 $text_color = 'inprog-color';
                                 $msg = __('patientappo.with doctor');
                             ?>
                         <?php elseif($item->status == 4): ?>
                             <?php
                                 $text_color = 'done-color';
                                 $msg = __('patientappo.done appointment');
                             ?>
                         <?php elseif($item->status == 5): ?>
                             <?php
                                 $text_color = 'notresp-color';
                                 $msg = __('patientappo.not respond');
                             ?>
                         <?php elseif($item->status == 6): ?>
                             <?php
                                 $text_color = 'cancel-color';
                                 $msg = __('patientappo.canceled');
                             ?>
                         <?php endif; ?>

                         <?php if($item->invoice_item): ?>
                             <?php if($item->invoice_item->invoice->status == 0): ?>
                                 <?php
                                     $msg_invoice = __('basic.not paid');
                                 ?>
                             <?php elseif($item->invoice_item->invoice->status == 1): ?>
                                 <?php
                                     $msg_invoice = __('basic.pending');
                                 ?>
                             <?php elseif($item->invoice_item->invoice->status == 2): ?>
                                 <?php
                                     $msg_invoice = __('basic.installment');
                                 ?>
                             <?php elseif($item->invoice_item->invoice->status == 3): ?>
                                 <?php
                                     $msg_invoice = __('basic.paid');
                                 ?>
                             <?php elseif($item->invoice_item->invoice->status == 4): ?>
                                 <?php
                                     $msg_invoice = __('basic.refund');
                                 ?>
                             <?php endif; ?>
                         <?php else: ?>
                             <?php
                                 $msg_invoice = 'No fees';
                             ?>
                         <?php endif; ?>

                         
                     <?php if($loop->index === 3) break; ?>

                         <?php if($item->note_doctor): ?>
                             <?php
                                 $icon_note = 'fa-user-check text-blue-400';
                             ?>
                         <?php else: ?>
                             <?php
                                 $icon_note = 'fa-user-edit text-grey-400';
                             ?>
                         <?php endif; ?>

                         <li class="row flex-nowrap list-group-item d-flex justify-content-between position-relative">

                             <i
                                 class="col patient-timeline-pointer fas fa-circle text-xxs mb-0 <?php echo e($text_color); ?>"></i>

                             <div class="col me-1">
                                 <p class="text-xxs text-gray-200 mb-0">
                                     <?php echo e(date('h:i a', strtotime($item->start_at))); ?></p>
                                 <h6 class="text-s fw-bold <?php echo e($text_color); ?> mb-0">
                                     <?php echo e(date('d M Y', strtotime($item->start_at))); ?></h6>
                                 <p class="text-xs <?php echo e($text_color); ?> fw-bold mb-0">
                                     <?php echo e($msg . ', ' . $msg_invoice); ?>

                                 </p>
                             </div>

                             <div class="col text-center align-self-center me-1">
                                 <p class="text-xs text-gray-200 mb-0"><?php echo e(__('basic.type')); ?></p>
                                 <h6 class="text-s text-gray-400"><?php echo e($item->service_item->name); ?></h6>
                             </div>

                             <div class="col text-center align-self-center me-1">
                                 <p class="text-xs text-gray-200 mb-0"><?php echo e(__('basic.doctor')); ?></p>
                                 <h6 class="text-s text-gray-400 text-truncate">
                                     <?php if(isset($item->doctor->first_name)): ?>
                                         <?php echo e($item->doctor->first_name); ?>

                                     <?php else: ?>
                                         Not selected
                                     <?php endif; ?>
                                 </h6>
                             </div>

                             <div class="col text-center align-self-center">
                                 <p class="text-xs text-gray-200 mb-0"><?php echo e(__('basic.handle')); ?></p>
                                 <a data-id="<?php echo e($item->id); ?>" data-note_doctor="<?php echo e($item->note_doctor); ?>"
                                     class="text-s text-gray-400 clickable-item-pointer get_all_info_appointment">
                                     <i class="fas fa-info-circle m-1 fs-6"></i>
                                 </a>
                                 <a data-id="<?php echo e($item->id); ?>" data-note_doctor="<?php echo e($item->note_doctor); ?>"
                                     class="text-s text-gray-400 clickable-item-pointer appointment_note_click">
                                     <i class="fas <?php echo e($icon_note); ?> m-1 fs-6"></i>
                                 </a>
                             </div>

                         </li>
                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                 </ul>
             <?php else: ?>
                 <div class="text-center">
                     <i class="bi bi-brightness-alt-high-fill fa-sm fa-fw fs-2"></i>
                     <p class="fw-light mb-0"><?php echo e(__('basic.nothing to show')); ?></p>
                 </div>
             <?php endif; ?>
         </div>

         <!-- Card footer -->
         <div class="card-footer text-center ">
             <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                 data-bs-target="#appointment_show">
                 <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

             </a>
         </div>

     </div>

     <!-- Modal show all appointment -->
     <div class="modal fade" id="appointment_show" tabindex="-1" aria-labelledby="exampleModalLabel"
         aria-hidden="true">
         <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
             <div class="modal-content b-r-s-cont border-0">
                 <div class="modal-header">
                     <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-capsules me-1"></i>
                         <?php echo e(__('basic.appointments')); ?></h5>
                     <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                 </div>

                 <!-- Modal content -->
                 <div class="modal-body px-4">

                     <div class="table-responsive">
                         <table class="table display datatable-modal" id="table-appointment" width="100%"
                             cellspacing="0">
                             <thead>
                                 <tr>
                                     <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                     <th class="text-xs text-center"><?php echo e(__('basic.branch')); ?></th>
                                     <th class="text-xs text-center"><?php echo e(__('basic.doctor')); ?></th>
                                     <th class="text-xs text-center"><?php echo e(__('basic.start')); ?></th>
                                     <th class="text-xs text-center"><?php echo e(__('basic.end')); ?></th>
                                     <th class="text-xs text-center"><?php echo e(__('basic.status')); ?></th>
                                     <th class="text-xs text-center"><?php echo e(__('patientappo.pay status')); ?>

                                     </th>
                                     <th class="text-xs text-center"><?php echo e(__('patientappo.pay code')); ?></th>
                                     <th class="text-xs text-center"><?php echo e(__('basic.handle')); ?></th>
                                 </tr>
                             </thead>
                             <tbody>
                                 <?php $__currentLoopData = $patient->appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                     <?php if($item->status == 0): ?>
                                         <?php
                                             $text_color = 'not_accepted-color-btn';
                                             $msg = __('patientappo.not accepted');
                                         ?>
                                     <?php elseif($item->status == 1): ?>
                                         <?php
                                             $text_color = 'main-color-btn';
                                             $msg = __('patientappo.accepted');
                                         ?>
                                     <?php elseif($item->status == 2): ?>
                                         <?php
                                             $text_color = 'active-color-btn';
                                             $msg = __('patientappo.arrived');
                                         ?>
                                     <?php elseif($item->status == 3): ?>
                                         <?php
                                             $text_color = 'prog-color-btn';
                                             $msg = __('patientappo.with doctor');
                                         ?>
                                     <?php elseif($item->status == 4): ?>
                                         <?php
                                             $text_color = 'done-color-btn';
                                             $msg = __('patientappo.done appointment');
                                         ?>
                                     <?php elseif($item->status == 5): ?>
                                         <?php
                                             $text_color = 'pend-color-btn';
                                             $msg = __('patientappo.not respond');
                                         ?>
                                     <?php elseif($item->status == 6): ?>
                                         <?php
                                             $text_color = 'cancel-color-btn';
                                             $msg = __('patientappo.canceled');
                                         ?>
                                     <?php endif; ?>

                                     <?php if($item->invoice_item): ?>
                                         <?php if($item->invoice_item->invoice->status == 0): ?>
                                             <?php
                                                 $msg_invoice = __('basic.not paid');
                                                 $text_color_invoice = 'cancel-color-btn';
                                             ?>
                                         <?php elseif($item->invoice_item->invoice->status == 1): ?>
                                             <?php
                                                 $text_color_invoice = 'pend-color-btn';
                                                 $msg_invoice = __('basic.pending');
                                             ?>
                                         <?php elseif($item->invoice_item->invoice->status == 2): ?>
                                             <?php
                                                 $text_color_invoice = 'prog-color-btn';
                                                 $msg_invoice = __('basic.installment');
                                             ?>
                                         <?php elseif($item->invoice_item->invoice->status == 3): ?>
                                             <?php
                                                 $text_color_invoice = 'done-color-btn';
                                                 $msg_invoice = __('basic.paid');
                                             ?>
                                         <?php elseif($item->invoice_item->invoice->status == 4): ?>
                                             <?php
                                                 $msg_invoice = __('basic.refund');
                                                 $text_color_invoice = 'cancel-color-btn';
                                             ?>
                                         <?php endif; ?>
                                     <?php else: ?>
                                         <?php
                                             $msg_invoice = 'No fees';
                                             $text_color_invoice = 'done-color-btn';
                                         ?>
                                     <?php endif; ?>

                                     <?php if($item->note_doctor): ?>
                                         <?php
                                             $icon_note = 'fa-user-check text-blue-400';
                                         ?>
                                     <?php else: ?>
                                         <?php
                                             $icon_note = 'fa-user-edit text-grey-400';
                                         ?>
                                     <?php endif; ?>

                                     <tr>
                                         <td><?php echo e($item->service_item->name); ?></td>
                                         <td class="text-center"><?php echo e($item->branch->name); ?></td>
                                         <td class="text-center">
                                             <?php if(isset($item->doctor->first_name)): ?>
                                                 <?php echo e($item->doctor->first_name); ?>

                                             <?php endif; ?>
                                         </td>
                                         <td class="text-center">
                                             <?php echo e(date('Y-m-d', strtotime($item->start_at))); ?> <br>
                                             <?php echo e(date('h:i a', strtotime($item->start_at))); ?></td>
                                         <td class="text-center">
                                             <?php echo e(date('Y-m-d', strtotime($item->end_at))); ?> <br>
                                             <?php echo e(date('h:i a', strtotime($item->end_at))); ?></td>
                                         <td class="text-center"> <span
                                                 class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                         </td>
                                         <td class="text-center"> <span
                                                 class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span>
                                         </td>
                                         <td class="text-center">
                                             <?php if($item->invoice_item): ?>
                                                 <?php echo e($item->invoice_item->invoice->code); ?>

                                             <?php endif; ?>
                                         </td>

                                         <td class="text-center d-flex justify-content-center">
                                             <a data-id="<?php echo e($item->id); ?>"
                                                 data-note_doctor="<?php echo e($item->note_doctor); ?>"
                                                 class="text-s text-gray-400 clickable-item-pointer get_all_info_appointment">
                                                 <i class="fas fa-info-circle m-1 fs-6"></i>
                                             </a>
                                             <a data-id="<?php echo e($item->id); ?>"
                                                 data-note_doctor="<?php echo e($item->note_doctor); ?>"
                                                 class="text-s text-gray-400 clickable-item-pointer appointment_note_click">
                                                 <i class="fas <?php echo e($icon_note); ?> m-1 fs-6"></i>
                                             </a>
                                         </td>

                                     </tr>
                                 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                             </tbody>
                         </table>
                     </div>
                 </div>

                 <div class="modal-footer">
                     <div class="left-side">
                         <button type="button" class="btn btn-default btn-link"
                             data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                     </div>
                     <div class="divider"></div>
                     <div class="right-side">
                         <button type="button"
                             class="btn btn-default btn-link main-color"><?php echo e(__('basic.save changes')); ?></button>
                     </div>
                 </div>

             </div>
         </div>

     </div>

     <!-- Modal for inserting the past appointments -->
     <div class="modal fade" id="add_past_app" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
         aria-hidden="true">
         <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
             <div class="modal-content b-r-s-cont border-0">
                 <div class="modal-header">
                     <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                         <?php echo e(__('patientappo.last appointment')); ?></h5>
                     <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                 </div>

                 <form class="mb-0" action="<?php echo e(route('sett.app_past_appointment')); ?>" method="post">
                     <?php echo e(method_field('POST')); ?>

                     <?php echo e(csrf_field()); ?>


                     <!-- Modal content -->
                     <div class="modal-body px-5 py-3">

                         <div class="row mb-2">
                             <div class="col-12 mb-2">
                                 <label class="form-label"><?php echo e(__('basic.branch')); ?>

                                     <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                 <select
                                     class="myselect2-appo-insert select2-hidden-accessible <?php $__errorArgs = ['branch_appo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                     id="branch_appo" name="branch_appo" required>
                                     <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                         <option value="<?php echo e($item->id); ?>">
                                             <?php echo e($item->name); ?>

                                         </option>
                                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 </select>

                                 <span id="branch_appo_error" class="error-msg-form"></span>

                                 <?php $__errorArgs = ['branch_appo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                     <span class="error-msg-form">
                                         <?php echo e($message); ?>

                                     </span>
                                 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                             </div>

                             <div class="col-12 mb-2">
                                 <label class="form-label"><?php echo e(__('basic.doctor')); ?>

                                     <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                 <select
                                     class="myselect2-appo-insert select2-hidden-accessible <?php $__errorArgs = ['responsible_doc_app'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                     id="responsible_doc_app" name="responsible_doc_app" required>
                                     <?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                         <option value="<?php echo e($item->id); ?>">
                                             <?php echo e($item->name); ?>

                                         </option>
                                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 </select>

                                 <span id="responsible_doc_app_error" class="error-msg-form"></span>

                                 <?php $__errorArgs = ['responsible_doc_app'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                     <span class="error-msg-form">
                                         <?php echo e($message); ?>

                                     </span>
                                 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                             </div>

                             <div class="col-12 mb-2">
                                 <label class="form-label"><?php echo e(__('basic.start')); ?>

                                     <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                 <div class="input-group">
                                     <div class="input-group-prepend">
                                         <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                         </div>
                                     </div>
                                     <input name="appo_date" type="text"
                                         class="form-control datepicker_time bg-white <?php $__errorArgs = ['appo_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                         placeholder="YYYY/MM/DD HM" data-enable-time="true" required>
                                 </div>
                                 <span id="appo_date_error" class="error-msg-form"></span>

                                 <?php $__errorArgs = ['appo_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                     <span class="error-msg-form">
                                         <?php echo e($message); ?>

                                     </span>
                                 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                             </div>

                         </div>

                         <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                     </div>

                     <div class="modal-footer">
                         <div class="left-side">
                             <button type="button" class="btn btn-default btn-link"
                                 data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                         </div>
                         <div class="divider"></div>
                         <div class="right-side">
                             <button type="submit" class="btn btn-default btn-link main-color">Add
                                 New</button>
                         </div>
                     </div>
                 </form>

             </div>
         </div>

     </div>

     <!-- doctor note Modal -->
     <div class="modal fade" id="appointment_note" tabindex="-1" aria-labelledby="exampleModalLabel2"
         aria-hidden="true">
         <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
             <div class="modal-content b-r-s-cont border-0">
                 <div class="modal-header">
                     <h5 class="modal-title" id="exampleModalLabel2"><i class="fas fa-quote-left me-1"></i>
                         Appointment Doctor Note</h5>
                     <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                 </div>

                 <form class="mb-0" action="<?php echo e(route('sett.app_appointment_note', 'sd')); ?>" method="POST">
                     <?php echo csrf_field(); ?>
                     <?php echo method_field('PUT'); ?>

                     <!-- Modal content -->
                     <div class="modal-body px-4">
                         <div class="mb-3">
                             <label class="form-label"><?php echo e(__('basic.note')); ?>

                                 <small></small></label>
                             <textarea id="appointment_note_input" name="note_appointment" class="form-control"
                                 placeholder="Write here your note .." rows="4" spellcheck="false" date-text="Write here your note .."></textarea>
                         </div>
                         <input type="hidden" name="note_appointment_id">
                     </div>

                     <div class="modal-footer">
                         <div class="left-side">
                             <button type="button" class="btn btn-default btn-link"
                                 data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                         </div>
                         <div class="divider"></div>
                         <div class="right-side">
                             <button type="submit"
                                 class="btn btn-default btn-link main-color"><?php echo e(__('basic.save changes')); ?></button>
                         </div>
                     </div>
                 </form>
             </div>
         </div>

     </div>

     <!-- inserting new examination, treatment, medicnes and etc.. from exist or old appointment -->
     <div class="modal fade" id="new_appo_patient" tabindex="-1" role="dialog"
         aria-labelledby="exampleModalLabel" aria-hidden="true">
         <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
             <div class="modal-content b-r-s-cont border-0">
                 <div class="modal-header">
                     <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                         <?php echo e(__('patientappo.last appointment')); ?></h5>
                     <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                 </div>

                 <!-- Modal content -->
                 <div class="modal-body px-3 py-3 pt-1 pb-4">

                     <div class="multi-setps-form-calander col-12">

                         <form id="myform" method="POST"
                             action="<?php echo e(route('sett.pat_add_all_pt_info_appo', $patient->id)); ?>"
                             enctype="multipart/form-data">
                             <?php echo csrf_field(); ?>

                             <!-- progressbar -->
                             <ul class="ps-0 progressbar_5icons progressbar" id="progressbar">
                                 <li class="active">
                                     <a>
                                         <!-- in case we want to use prog selector href="#clinics" -->
                                         <div
                                             class="icon-circle checked d-flex align-items-center justify-content-center">
                                             <i class="bi bi-calendar-range"></i>
                                         </div>
                                         <span><?php echo e(__('basic.appointment')); ?></span>
                                     </a>
                                 </li>

                                 <li>
                                     <a>
                                         <div class="icon-circle d-flex align-items-center justify-content-center">
                                             <i class="fas fa-stethoscope"></i>
                                         </div>
                                         <span><?php echo e(__('basic.examination')); ?></span>
                                     </a>
                                 </li>

                                 <li>
                                     <a>
                                         <div class="icon-circle d-flex align-items-center justify-content-center">
                                             <i class="bi bi-file-medical"></i>
                                         </div>
                                         <span><?php echo e(__('basic.treatment')); ?></span>
                                     </a>
                                 </li>

                                 <li>
                                     <a>
                                         <div class="icon-circle d-flex align-items-center justify-content-center">
                                             <i class="fas fa-capsules"></i>
                                         </div>
                                         <span><?php echo e(__('basic.medicines')); ?></span>
                                     </a>
                                 </li>

                                 <li>
                                     <a>
                                         <div class="icon-circle d-flex align-items-center justify-content-center">
                                             <i class="fas fa-vial"></i>
                                         </div>
                                         <span><?php echo e(__('patientappo.sessions')); ?></span>
                                     </a>
                                 </li>
                             </ul>

                             <!-- content -->

                             <div class="cont_tap px-2 px-md-3" id="clinics">

                                 <div class="row">

                                     <div class="col-6 border-right-gray">

                                         <div id="patient_add_info_exist_appo" style="display: none">
                                             <h6 class="text-gray-300 mb-2">Exist appointment</h6>

                                             <div class="col-12">
                                                 <label class="form-label"><?php echo e(__('basic.appointment')); ?>

                                                     <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                 <select
                                                     class="select2-no-search-appo-patient select2-hidden-accessible <?php $__errorArgs = ['exist_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                     id="exist_appointment_id_input" name="exist_appointment_id"
                                                     required>
                                                     <?php $__currentLoopData = $patient->appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                         <option value="<?php echo e($item->id); ?>">
                                                             <?php echo e($item->start_at); ?>

                                                         </option>
                                                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                 </select>

                                                 <span id="exist_appointment_id_error" class="error-msg-form"></span>

                                                 <?php $__errorArgs = ['exist_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                     <span class="error-msg-form">
                                                         <?php echo e($message); ?>

                                                     </span>
                                                 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                             </div>
                                         </div>

                                         <div id="patient_add_info_old_appo">

                                             <h6 class="text-gray-300 mb-2">Create old Appointment</h6>

                                             <div class="col-12 mb-2">
                                                 <label class="form-label"><?php echo e(__('basic.branch')); ?>

                                                     <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                 <select
                                                     class="myselect2-appo-patient select2-hidden-accessible <?php $__errorArgs = ['branch_appo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                     id="branch_appo_new" name="branch_appo" required>
                                                     <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                         <option value="<?php echo e($item->id); ?>">
                                                             <?php echo e($item->name); ?>

                                                         </option>
                                                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                 </select>

                                                 <span id="branch_appo_error" class="error-msg-form"></span>

                                                 <?php $__errorArgs = ['branch_appo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                     <span class="error-msg-form">
                                                         <?php echo e($message); ?>

                                                     </span>
                                                 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                             </div>

                                             <div class="col-12 mb-2">
                                                 <label class="form-label"><?php echo e(__('basic.doctor')); ?>

                                                     <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                                 <select
                                                     class="myselect2-appo-patient select2-hidden-accessible <?php $__errorArgs = ['responsible_doc_app'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                     id="responsible_doc_app_new" name="responsible_doc_app" required>
                                                     <?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                         <option value="<?php echo e($item->id); ?>">
                                                             <?php echo e($item->name); ?>

                                                         </option>
                                                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                 </select>

                                                 <span id="responsible_doc_app_error" class="error-msg-form"></span>

                                                 <?php $__errorArgs = ['responsible_doc_app'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                     <span class="error-msg-form">
                                                         <?php echo e($message); ?>

                                                     </span>
                                                 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                             </div>

                                             <div class="col-12 mb-2">
                                                 <label class="form-label"><?php echo e(__('basic.start')); ?>

                                                     <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                 <div class="input-group">
                                                     <div class="input-group-prepend">
                                                         <div class="input-group-text"><i
                                                                 class="bi bi-calendar2-week-fill"></i>
                                                         </div>
                                                     </div>
                                                     <input name="appo_date" type="text"
                                                         class="form-control datepicker_time bg-white <?php $__errorArgs = ['appo_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                         placeholder="YYYY/MM/DD HM" data-enable-time="true" required>
                                                 </div>
                                                 <span id="appo_date_error" class="error-msg-form"></span>

                                                 <?php $__errorArgs = ['appo_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                     <span class="error-msg-form">
                                                         <?php echo e($message); ?>

                                                     </span>
                                                 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                             </div>
                                         </div>
                                     </div>

                                     <div class="col-6">

                                         <div class="row">

                                             <h6 class="text-gray-300 mb-2">Basic Info</h6>

                                             <div class="col-12 mb-2">
                                                 <label class="form-label"> <?php echo e(__('patientappo.weight')); ?>

                                                     <small>(<?php echo e(__('basic.optional')); ?>)</small></label>

                                                 <input name="weight_appo" type="number"
                                                     class="form-control <?php $__errorArgs = ['weight_appo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                     placeholder="Patient weight.." value="<?php echo e($patient->weight); ?>">

                                                 <span id="weight_appo_error" class="error-msg-form"></span>

                                                 <?php $__errorArgs = ['weight_appo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                     <span class="error-msg-form">
                                                         <?php echo e($message); ?>

                                                     </span>
                                                 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                             </div>

                                             <div class="col-12 mb-2">
                                                 <label class="form-label"> <?php echo e(__('patientappo.heart rate')); ?>

                                                     <small>(<?php echo e(__('basic.optional')); ?>)</small></label>

                                                 <input name="heart_rate" type="number"
                                                     class="form-control <?php $__errorArgs = ['heart_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                     placeholder="Patient heart rate.."
                                                     value="<?php echo e($patient->heart_rate); ?>">

                                                 <span id="heart_rate_error" class="error-msg-form"></span>

                                                 <?php $__errorArgs = ['heart_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                     <span class="error-msg-form">
                                                         <?php echo e($message); ?>

                                                     </span>
                                                 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                             </div>

                                             <div class="col-12 mb-2">
                                                 <label class="form-label"> <?php echo e(__('patientappo.bl pressure')); ?>

                                                     <small>(<?php echo e(__('basic.optional')); ?>)</small></label>

                                                 <input name="bl_pressure" type="text"
                                                     class="form-control <?php $__errorArgs = ['bl_pressure'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                     placeholder="Patient bl pressure.."
                                                     value="<?php echo e($patient->bl_pressure); ?>">

                                                 <span id="bl_pressure_error" class="error-msg-form"></span>

                                                 <?php $__errorArgs = ['bl_pressure'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                     <span class="error-msg-form">
                                                         <?php echo e($message); ?>

                                                     </span>
                                                 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                             </div>

                                         </div>

                                     </div>
                                 </div>

                                 <div class="d-flex justify-content-end mt-3 align-items-center">
                                     <input type="button" name="next"
                                         class="next-form-steps btn btn-primary action-button-next"
                                         value="Continue" />
                                 </div>
                             </div>


                             <div class="cont_tap" id="time">

                                 <div class="row mb-2 justify-content-center">

                                     <div class="col-12 mb-4">
                                         <div class="d-flex justify-content-center flex-wrap">

                                             <div class="mb-3 mb-md-0"
                                                 style="background-image: url('<?php echo e(asset('img/dashboard/system/human_front.jpg')); ?>'); width:255px; height:457px; position: relative;">

                                                 <canvas class="canvas" id="canvas_appo" width="255"
                                                     height="457"
                                                     style=" solid;position: absolute;top:0;left:0;"></canvas>

                                                 <div id="canvas-clear_appo" class="btn btn-primary"
                                                     style="position: absolute; bottom:40px; left:0px;"><i
                                                         class="fas fa-eraser"></i>
                                                 </div>

                                                 <div id="imgsave_appo" class="btn btn-danger"
                                                     style="position: absolute; bottom:0px; left:0px;"><i
                                                         id="icon_save_appo" class="fas fa-check"></i>
                                                 </div>

                                                 <div style="position: absolute; bottom:100px; left:0px;">
                                                     <div class="d-flex mb-1">
                                                         <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                             data-color="#000000"
                                                             style="width:10px;height:10px;background:#000000;">
                                                         </div>
                                                         <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                             data-color="#0cb6ed"
                                                             style="width:10px;height:10px;background:#0cb6ed;">
                                                         </div>
                                                         <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                             data-color="#17c34e"
                                                             style="width:10px;height:10px;background:#17c34e;">
                                                         </div>
                                                     </div>
                                                     <div class="d-flex">
                                                         <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                             data-color="#dc3545"
                                                             style="width:10px;height:10px;background:#dc3545;">
                                                         </div>
                                                         <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                             data-color="#ffd807"
                                                             style="width:10px;height:10px;background:#ffd807;">
                                                         </div>
                                                         <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                             data-color="#ff6d00"
                                                             style="width:10px;height:10px;background:#ff6d00;">
                                                         </div>
                                                     </div>
                                                 </div>

                                             </div>

                                             <div
                                                 style="background-image: url('<?php echo e(asset('img/dashboard/system/human_back.jpg')); ?>'); width:255px; height:457px; position: relative;">
                                                 <canvas class="canvas" id="canvas_b_appo" width="255"
                                                     height="457"
                                                     style=" solid;position: absolute;top:0;left:0;"></canvas>

                                                 <div id="canvas-clear_b_appo" class="btn btn-primary"
                                                     style="position: absolute; bottom:40px; left:0px;"><i
                                                         class="fas fa-eraser"></i>
                                                 </div>

                                                 <div id="imgsave_b_appo" class="btn btn-danger"
                                                     style="position: absolute; bottom:0px; left:0px;"><i
                                                         id="icon_save_b_appo" class="fas fa-check"></i>
                                                 </div>


                                                 <div style="position: absolute; bottom:100px; left:0px;">
                                                     <div class="d-flex mb-1">
                                                         <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                             data-color="#000000"
                                                             style="width:10px;height:10px;background:#000000;">
                                                         </div>
                                                         <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                             data-color="#0cb6ed"
                                                             style="width:10px;height:10px;background:#0cb6ed;">
                                                         </div>
                                                         <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                             data-color="#17c34e"
                                                             style="width:10px;height:10px;background:#17c34e;">
                                                         </div>
                                                     </div>
                                                     <div class="d-flex">
                                                         <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                             data-color="#dc3545"
                                                             style="width:10px;height:10px;background:#dc3545;">
                                                         </div>
                                                         <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                             data-color="#ffd807"
                                                             style="width:10px;height:10px;background:#ffd807;">
                                                         </div>
                                                         <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                             data-color="#ff6d00"
                                                             style="width:10px;height:10px;background:#ff6d00;">
                                                         </div>
                                                     </div>
                                                 </div>
                                             </div>
                                         </div>
                                         <input name="front" id="front_input_appo" type="hidden">
                                         <input name="back" id="back_input_appo" type="hidden">
                                     </div>

                                     <div class="col-12 col-md-8 mb-2">
                                         <label class="form-label"><?php echo e(__('basic.disease')); ?>

                                             <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                         <select
                                             class="myselect2-appo-patient select2-hidden-accessible <?php $__errorArgs = ['disease_cat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                             id="disease_cat_appo" multiple="" name="disease_cat[]"
                                             style="position: relative" required>
                                             <?php $__currentLoopData = $disease_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                 <option value="<?php echo e($item->id); ?>">
                                                     <?php echo e($item->name); ?>

                                                 </option>
                                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                         </select>

                                         <span id="disease_cat_error" class="error-msg-form"></span>

                                         <?php $__errorArgs = ['disease_cat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="error-msg-form">
                                                 <?php echo e($message); ?>

                                             </span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                     </div>

                                     <div class="col-12 col-md-8 mb-2">
                                         <label class="form-label"><?php echo e(__('basic.start')); ?>

                                             <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                         <div class="input-group">
                                             <div class="input-group-prepend">
                                                 <div class="input-group-text"><i
                                                         class="bi bi-calendar2-week-fill"></i>
                                                 </div>
                                             </div>
                                             <input name="disease_start" type="text"
                                                 class="form-control hasdatetimepicker <?php $__errorArgs = ['disease_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                 placeholder="YYYY/MM/DD" required>
                                         </div>
                                         <span id="disease_start_error" class="error-msg-form"></span>

                                         <?php $__errorArgs = ['disease_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="error-msg-form">
                                                 <?php echo e($message); ?>

                                             </span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                     </div>

                                     <div class="col-12 col-md-8 mb-2">
                                         <label class="form-label"><?php echo e(__('basic.note')); ?>

                                             <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                         <textarea name="note_diseases" class="form-control " placeholder="Write here your note .." rows="4"
                                             spellcheck="false"></textarea>
                                         <span id="note_diseases_lab_error" class="error-msg-form"></span>
                                     </div>

                                 </div>

                                 <div class="d-flex justify-content-between mt-3 align-items-center">
                                     <input type="button" name="previous"
                                         class="previous-form-steps btn btn-secondary action-button-previous"
                                         value="Previous" />
                                     <div>
                                         <span class="next-form-steps text-gray-300 me-3 clickable-item-pointer"
                                             data-skip="true">Skip</span>
                                         <input type="button" name="next"
                                             class="next-form-steps btn btn-primary action-button-next"
                                             value="Continue" />
                                     </div>
                                 </div>

                             </div>

                             <div class="cont_tap" id="treatment">

                                 <div class="row mb-2">

                                     <div class="col-12 mb-2">
                                         <label class="form-label"><?php echo e(__('basic.treatment')); ?>

                                             <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                         <select
                                             class="myselect2-appo-patient select2-hidden-accessible <?php $__errorArgs = ['treatment_cat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                             id="treatment_cat_appo" name="treatment_cat" required>
                                             <option selected disabled>Not Selected</option>
                                             <?php $__currentLoopData = $treatment_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                 <option value="<?php echo e($item->id); ?>">
                                                     <?php echo e($item->name); ?>

                                                 </option>
                                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                         </select>

                                         <span id="treatment_cat_error" class="error-msg-form"></span>

                                         <?php $__errorArgs = ['treatment_cat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="error-msg-form">
                                                 <?php echo e($message); ?>

                                             </span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                     </div>

                                     <div class="col-12 mb-2">
                                         <label class="form-label"> <?php echo e(__('patientappo.sessions')); ?>

                                             <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                         <input name="treatment_session" type="number"
                                             class="form-control <?php $__errorArgs = ['treatment_session'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                             placeholder="How many session?" required>

                                         <span id="treatment_session_error" class="error-msg-form"></span>

                                         <?php $__errorArgs = ['treatment_session'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="error-msg-form">
                                                 <?php echo e($message); ?>

                                             </span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                     </div>

                                     <div class="col-12 mb-2">
                                         <label class="form-label"><?php echo e(__('basic.start')); ?>

                                             <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                         <div class="input-group">
                                             <div class="input-group-prepend">
                                                 <div class="input-group-text"><i
                                                         class="bi bi-calendar2-week-fill"></i>
                                                 </div>
                                             </div>
                                             <input name="treatment_start" type="text"
                                                 class="form-control hasdatetimepicker <?php $__errorArgs = ['treatment_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                 placeholder="YYYY/MM/DD" required>
                                         </div>
                                         <span id="treatment_start_error" class="error-msg-form"></span>

                                         <?php $__errorArgs = ['treatment_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="error-msg-form">
                                                 <?php echo e($message); ?>

                                             </span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                     </div>

                                     <div class="col-12 mb-2">
                                         <label class="form-label"><?php echo e(__('basic.end')); ?>

                                             <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                         <div class="input-group">
                                             <div class="input-group-prepend">
                                                 <div class="input-group-text"><i
                                                         class="bi bi-calendar2-week-fill"></i> </div>
                                             </div>
                                             <input name="treatment_end" type="text"
                                                 class="form-control hasdatetimepicker <?php $__errorArgs = ['treatment_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                 placeholder="YYYY/MM/DD">
                                         </div>
                                         <span id="treatment_end_error" class="error-msg-form"></span>

                                         <?php $__errorArgs = ['treatment_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="error-msg-form">
                                                 <?php echo e($message); ?>

                                             </span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                     </div>
                                 </div>

                                 <div class="d-flex justify-content-between mt-3 align-items-center">
                                     <input type="button" name="previous"
                                         class="previous-form-steps btn btn-secondary action-button-previous"
                                         value="Previous" />
                                     <div>
                                         <span class="next-form-steps text-gray-300 me-3 clickable-item-pointer"
                                             data-skip="true">Skip</span>
                                         <input type="button" name="next"
                                             class="next-form-steps btn btn-primary action-button-next"
                                             value="Continue" />
                                     </div>
                                 </div>
                             </div>

                             <div class="cont_tap" id="medicines">

                                 <div class="row mb-2">
                                     <div class="col-12 mb-2">
                                         <label class="form-label"><?php echo e(__('basic.medicines')); ?>

                                             <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                         <select
                                             class="myselect2-appo-patient select2-hidden-accessible <?php $__errorArgs = ['medicine_pills'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                             multiple="" id="medicine_pills_appo" name="medicine_pills[]"
                                             required>
                                             <?php $__currentLoopData = $medicine_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                 <option value="<?php echo e($item->id); ?>">
                                                     <?php echo e($item->name . ' - ' . $item->price . 'EGP'); ?>

                                                 </option>
                                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                         </select>

                                         <span id="medicine_pills_error" class="error-msg-form"></span>

                                         <?php $__errorArgs = ['medicine_pills'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="error-msg-form">
                                                 <?php echo e($message); ?>

                                             </span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                     </div>

                                     <div class="col-12 mb-2">
                                         <label class="form-label"><?php echo e(__('basic.status')); ?>

                                             <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                         <select
                                             class="select2-no-search-appo-patient select2-hidden-accessible <?php $__errorArgs = ['medicine_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                             id="medicine_status_appo" name="medicine_status" required>
                                             <option value="0">
                                                 <?php echo e(__('patientappo.on medicine')); ?>

                                             </option>
                                             <option value="1">
                                                 <?php echo e(__('patientappo.no result')); ?>

                                             </option>
                                             <option value="2">
                                                 <?php echo e(__('patientappo.done')); ?>

                                             </option>
                                         </select>

                                         <span id="medicine_status_error" class="error-msg-form"></span>

                                         <?php $__errorArgs = ['medicine_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="error-msg-form">
                                                 <?php echo e($message); ?>

                                             </span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                     </div>

                                     <div class="col-12 mb-2">
                                         <label class="form-label"><?php echo e(__('basic.start')); ?>

                                             <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                         <div class="input-group">
                                             <div class="input-group-prepend">
                                                 <div class="input-group-text"><i
                                                         class="bi bi-calendar2-week-fill"></i>
                                                 </div>
                                             </div>
                                             <input name="medicine_start" type="text"
                                                 class="form-control hasdatetimepicker <?php $__errorArgs = ['medicine_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                 placeholder="YYYY/MM/DD" required>
                                         </div>
                                         <span id="medicine_start_error" class="error-msg-form"></span>

                                         <?php $__errorArgs = ['medicine_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="error-msg-form">
                                                 <?php echo e($message); ?>

                                             </span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                     </div>

                                     <div class="col-12 mb-2">
                                         <label class="form-label"><?php echo e(__('basic.end')); ?>

                                             <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                         <div class="input-group">
                                             <div class="input-group-prepend">
                                                 <div class="input-group-text"><i
                                                         class="bi bi-calendar2-week-fill"></i>
                                                 </div>
                                             </div>
                                             <input name="medicine_end" type="text"
                                                 class="form-control hasdatetimepicker <?php $__errorArgs = ['medicine_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                 placeholder="YYYY/MM/DD" required>
                                         </div>

                                         <?php $__errorArgs = ['medicine_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="error-msg-form">
                                                 <?php echo e($message); ?>

                                             </span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                         <span id="medicine_end_error" class="error-msg-form"></span>
                                     </div>
                                 </div>

                                 <div class="d-flex justify-content-between mt-3 align-items-center">
                                     <input type="button" name="previous"
                                         class="previous-form-steps btn btn-secondary action-button-previous"
                                         value="Previous" />
                                     <div>
                                         <span class="next-form-steps text-gray-300 me-3 clickable-item-pointer"
                                             data-skip="true">Skip</span>
                                         <input type="button" name="next"
                                             class="next-form-steps btn btn-primary action-button-next"
                                             value="Continue" />
                                     </div>
                                 </div>
                             </div>

                             <div class="cont_tap" id="session">
                                 <div class="row mb-2">
                                     <div class="col-12 mb-2">
                                         <label class="form-label"><?php echo e(__('patientappo.session')); ?>

                                             <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                         <select
                                             class="myselect2-appo-patient select2-hidden-accessible <?php $__errorArgs = ['session_cat_service'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                             id="session_cat_service" name="session_cat_service" required>
                                             <?php $__currentLoopData = $service_cat_ses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                 <option disabled selected> -- select Session -- </option>
                                                 <option value="<?php echo e($item->id); ?>"
                                                     data-price="<?php echo e($item->price); ?>">
                                                     <?php echo e($item->name . ' - ' . $item->price . 'EGP'); ?>

                                                 </option>
                                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                         </select>

                                         <span id="session_cat_service_error" class="error-msg-form"></span>

                                         <?php $__errorArgs = ['session_cat_service'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="error-msg-form">
                                                 <?php echo e($message); ?>

                                             </span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                     </div>

                                     <div class="col-12 mb-2">
                                         <label class="form-label"><?php echo e(__('basic.status')); ?>

                                             <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                         <select
                                             class="select2-no-search-appo-patient select2-hidden-accessible <?php $__errorArgs = ['session_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                             id="session_status_appo" name="session_status" required>
                                             <option value="0">
                                                 <?php echo e(__('patientappo.not done')); ?>

                                             </option>
                                             <option value="1">
                                                 <?php echo e(__('patientappo.done')); ?>

                                             </option>
                                         </select>

                                         <span id="session_status_error" class="error-msg-form"></span>

                                         <?php $__errorArgs = ['session_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="error-msg-form">
                                                 <?php echo e($message); ?>

                                             </span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                     </div>

                                     <div class="col-12 mb-2">
                                         <label class="form-label"><?php echo e(__('patientappo.related to treatment')); ?>

                                             <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                         <select
                                             class="myselect2-appo-patient select2-hidden-accessible <?php $__errorArgs = ['related_treatment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                             id="related_treatment_id_appo" name="related_treatment_id">
                                             <option disabled selected> -- select treatment -- </option>
                                             <?php $__currentLoopData = $patient->treatments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                 <?php if($item->status == 0): ?>
                                                     <option value="<?php echo e($item->id); ?>">
                                                         <?php echo e($item->treatment_cat->name . ' - ' . $item->start); ?>

                                                     </option>
                                                 <?php endif; ?>
                                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                         </select>

                                         <span id="related_treatment_id_error" class="error-msg-form"></span>

                                         <?php $__errorArgs = ['related_treatment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="error-msg-form">
                                                 <?php echo e($message); ?>

                                             </span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                     </div>

                                     <div class="col-12 mb-2">
                                         <label class="form-label"><?php echo e(__('basic.date')); ?>

                                             <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                         <div class="input-group">
                                             <div class="input-group-prepend">
                                                 <div class="input-group-text"><i
                                                         class="bi bi-calendar2-week-fill"></i>
                                                 </div>
                                             </div>
                                             <input name="session_date" type="text"
                                                 class="form-control hasdatetimepicker <?php $__errorArgs = ['session_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                 placeholder="YYYY/MM/DD" required>
                                         </div>
                                         <span id="session_date_error" class="error-msg-form"></span>

                                         <?php $__errorArgs = ['session_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                             <span class="error-msg-form">
                                                 <?php echo e($message); ?>

                                             </span>
                                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                     </div>

                                     <hr class="mt-2">

                                     <div class="row">
                                         <div class="col-12 mb-2">
                                             <label class="form-label"><?php echo e(__('basic.final note appointment')); ?>

                                                 <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                             <textarea name="appo_note" class="form-control " placeholder="Write here the appointment note .." rows="4"
                                                 spellcheck="false"></textarea>
                                             <span id="appo_note_lab_error" class="error-msg-form"></span>
                                         </div>
                                     </div>
                                 </div>

                                 <div class="d-flex justify-content-between mt-3 align-items-center">
                                     <input type="button" name="previous"
                                         class="previous-form-steps btn btn-secondary action-button-previous"
                                         value="Previous" />
                                     <div>
                                         <input type="submit" name="next" style=""
                                             class="next-form-steps btn text-gray-300 btn-default" data-skip="true"
                                             value="Send Without Session" />
                                         <input type="submit" name="next"
                                             class="next-form-steps btn btn-primary action-button-next"
                                             value="Send" />
                                     </div>
                                 </div>
                             </div>

                             <div class="cont_tap" id="sending">
                                 <div class="d-flex justify-content-center p2">
                                     <img src="<?php echo e(URL::asset('img/dashboard/system/loading-dash.svg')); ?>"
                                         style="width: 195px;" alt="Loading" />
                                 </div>
                             </div>

                         </form>
                     </div>


                 </div>

             </div>
         </div>

     </div>

     <!-- get all related info appointment -->
     <div class="modal fade" id="all_info_appointment" tabindex="-1" role="dialog"
         aria-labelledby="all_info_appointment" aria-hidden="true">
         <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
             <div class="modal-content b-r-s-cont border-0">
                 <div class="modal-header">
                     <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                         <?php echo e(__('patientappo.last appointment')); ?></h5>
                     <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                 </div>

                 <!-- Modal content -->
                 <div class="modal-body px-3 py-3 pt-1 pb-4">

                     <div class="multi-setps-form-calander col-12">

                         <form id="myform" method="POST"
                             action="<?php echo e(route('sett.pat_add_all_pt_info_appo', $patient->id)); ?>"
                             enctype="multipart/form-data">
                             <?php echo csrf_field(); ?>

                             <!-- progressbar -->
                             <ul class="ps-0 progressbar_5icons progressbar" id="progressbar_patient">
                                 <li class="active">
                                     <a>
                                         <!-- in case we want to use prog selector href="#clinics" -->
                                         <div
                                             class="icon-circle checked d-flex align-items-center justify-content-center">
                                             <i class="bi bi-calendar-range"></i>
                                         </div>
                                         <span><?php echo e(__('basic.appointment')); ?>aa</span>
                                     </a>
                                 </li>

                                 <li>
                                     <a>
                                         <div class="icon-circle d-flex align-items-center justify-content-center">
                                             <i class="fas fa-stethoscope"></i>
                                         </div>
                                         <span><?php echo e(__('basic.examination')); ?></span>
                                     </a>
                                 </li>

                                 <li>
                                     <a>
                                         <div class="icon-circle d-flex align-items-center justify-content-center">
                                             <i class="bi bi-file-medical"></i>
                                         </div>
                                         <span><?php echo e(__('basic.treatment')); ?></span>
                                     </a>
                                 </li>

                                 <li>
                                     <a>
                                         <div class="icon-circle d-flex align-items-center justify-content-center">
                                             <i class="fas fa-capsules"></i>
                                         </div>
                                         <span><?php echo e(__('basic.medicines')); ?></span>
                                     </a>
                                 </li>

                                 <li>
                                     <a>
                                         <div class="icon-circle d-flex align-items-center justify-content-center">
                                             <i class="fas fa-vial"></i>
                                         </div>
                                         <span><?php echo e(__('patientappo.sessions')); ?></span>
                                     </a>
                                 </li>
                             </ul>

                             <!-- content -->

                             <div class="cont_tap_patient" id="all_info_basic">

                                 <div class="row">
                                     <div class="col-6 border-flex">
                                         <p class="text-gray-500 mb-2">Basic Info</p>
                                         <div class="mb-2">
                                             <h6 class="text-gray-300 text-s mb-1">Appointment start</h6>
                                             <p class="text-gray-600 text-s fw-bold" id="start_appo_all_info">
                                             </p>
                                         </div>
                                         <div class="mb-2">
                                             <h6 class="text-gray-300 text-s mb-1">Appointment End</h6>
                                             <p class="text-gray-600 text-s fw-bold" id="end_appo_all_info">
                                             </p>
                                         </div>
                                         <div class="mb-2">
                                             <h6 class="text-gray-300 text-s mb-1">Branch</h6>
                                             <p class="text-gray-600 text-s fw-bold" id="branch_appo_all_info">
                                             </p>
                                         </div>
                                     </div>

                                     <div class="col-6">
                                         <div class="mb-2">
                                             <h6 class="text-gray-300 text-s mb-1">Responsible doctor</h6>
                                             <p class="text-gray-600 text-s fw-bold" id="respdoctor_appo_all_info">
                                             </p>
                                         </div>
                                         <div class="">
                                             <label class="form-label">Note</label>
                                             <div class="form-control-textarea overflow-auto" id="note_appo_all_info">
                                             </div>
                                         </div>
                                     </div>
                                 </div>

                                 <div class="d-flex justify-content-between mt-3 align-items-center">
                                     <div></div>
                                     <div>
                                         <input type="button" name="next"
                                             class="next-form-steps_patient btn btn-primary action-button-next"
                                             value="Continue" />
                                     </div>
                                 </div>

                             </div>

                             <div class="cont_tap_patient px-2 px-md-3" id="all_info_examination">

                                 <div class="row">

                                     <div class="d-flex justify-content-center mb-3 flex-wrap">

                                         <div
                                             class="d-flex justify-content-center flex-wrap me-0 me-md-5 mb-3 mb-xl-0">

                                             <div id="exam-front" class="mb-3 mb-md-0"
                                                 style="background-image: url('<?php echo e(asset('img/dashboard/system/human_front.jpg')); ?>'); width:255px; height:457px; position: relative;">

                                             </div>

                                             <div id="exam-back" class="mb-3 mb-md-0"
                                                 style="background-image: url('<?php echo e(asset('img/dashboard/system/human_back.jpg')); ?>'); width:255px; height:457px; position: relative;">

                                             </div>

                                         </div>

                                         <div
                                             class="d-flex d-xl-block p-4 main-color-bg b-r-s-cont flex-wrap justify-content-center">
                                             <h5 class="mb-3 text-white me-2 me-xl-0"><i
                                                     class="far fa-question-circle"></i>
                                                 <?php echo e(__('patientappo.last examination info')); ?></h5>

                                             <div class="">
                                                 <div class="mb-2 me-3 me-xl-5">
                                                     <label
                                                         class="form-label text-blue-300 mb-1"><?php echo e(__('patientappo.examination note')); ?>:</label>
                                                     <div id="exam-note"
                                                         class="form-control-textarea overflow-auto text-white"
                                                         style="width: 241px; border-radius: 13px !important; border: 1px solid #6fa2ea;">

                                                     </div>
                                                 </div>
                                                 <div class="mb-2 me-3 me-xl-5">
                                                     <label
                                                         class="form-label text-blue-300 mb-1"><?php echo e(__('patientappo.appointment date')); ?>:</label>
                                                     <div id="exam-date" class="text-white">

                                                     </div>
                                                 </div>
                                                 <div class="mb-2">
                                                     <label
                                                         class="form-label text-blue-300 mb-1"><?php echo e(__('basic.doctor')); ?>:</label>
                                                     <div id="exam-doctor" class="text-white">


                                                     </div>
                                                 </div>
                                             </div>
                                         </div>
                                     </div>


                                     <h5 class="mb-3 text-gray-400"><i class="far fa-question-circle"></i>
                                         Initial Examination</h5>

                                     <div class="table-responsive">
                                         <table class="table display datatable-modal" id="table-disease-exam"
                                             width="100%" cellspacing="0">
                                             <thead>
                                                 <tr>
                                                     <th class="text-xs w-25"><?php echo e(__('basic.name')); ?></th>
                                                     <th class="text-xs text-center"><?php echo e(__('basic.start')); ?>

                                                     </th>
                                                     <th class="text-xs text-center"><?php echo e(__('basic.end')); ?></th>
                                                     <th class="text-xs text-center"><?php echo e(__('basic.status')); ?>

                                                     </th>
                                                     <th class="text-xs text-center"><?php echo e(__('basic.handle')); ?>

                                                     </th>
                                                 </tr>
                                             </thead>
                                             <tbody id="exam-table">
                                                 <!-- it is sent by ajax -->
                                             </tbody>
                                         </table>
                                     </div>
                                 </div>

                                 <div class="d-flex justify-content-between mt-3 align-items-center">
                                     <input type="button" name="previous"
                                         class="previous-form-steps_patient btn btn-secondary action-button-previous"
                                         value="Previous" />
                                     <div>
                                         <input type="button" name="next"
                                             class="next-form-steps_patient btn btn-primary action-button-next"
                                             value="Continue" />
                                     </div>
                                 </div>
                             </div>

                             <div class="cont_tap_patient" id="all_info_treatment">

                                 <div class="row">
                                     <div class="table-responsive">
                                         <table class="table display datatable-modal" id="table-treatment"
                                             width="100%" cellspacing="0">
                                             <thead>
                                                 <tr>
                                                     <th class="text-xs"><?php echo e(__('basic.id')); ?></th>
                                                     <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                                     <th class="text-xs text-center"><?php echo e(__('basic.start')); ?></th>
                                                     <th class="text-xs text-center"><?php echo e(__('basic.end')); ?></th>
                                                     <th class="text-xs text-center">
                                                         <?php echo e(__('patientappo.sessions')); ?>

                                                     </th>
                                                     <th class="text-xs text-center">
                                                         <?php echo e(__('patientappo.sessions done')); ?></th>
                                                     <th class="text-xs text-center"><?php echo e(__('basic.status')); ?></th>
                                                     <th class="text-xs text-center"><?php echo e(__('basic.handle')); ?></th>
                                                 </tr>
                                             </thead>
                                             <tbody id="treatment-table">
                                                 <!-- it is sent by ajax -->
                                             </tbody>
                                         </table>
                                     </div>
                                 </div>

                                 <div class="d-flex justify-content-between mt-3 align-items-center">
                                     <input type="button" name="previous"
                                         class="previous-form-steps_patient btn btn-secondary action-button-previous"
                                         value="Previous" />
                                     <div>
                                         <input type="button" name="next"
                                             class="next-form-steps_patient btn btn-primary action-button-next"
                                             value="Continue" />
                                     </div>
                                 </div>
                             </div>

                             <div class="cont_tap_patient" id="all_info_medicines">

                                 <div class="row">

                                     <div class="table-responsive">
                                         <table class="table display datatable-modal" id="table-medicine"
                                             width="100%" cellspacing="0">
                                             <thead>
                                                 <tr>
                                                     <th class="text-xs w-25"><?php echo e(__('basic.name')); ?></th>
                                                     <th class="text-xs text-center"><?php echo e(__('basic.start')); ?>

                                                     </th>
                                                     <th class="text-xs text-center"><?php echo e(__('basic.end')); ?></th>
                                                     <th class="text-xs text-center"><?php echo e(__('basic.status')); ?>

                                                     </th>
                                                     <th class="text-xs text-center"><?php echo e(__('basic.handle')); ?>

                                                     </th>
                                                 </tr>
                                             </thead>
                                             <tbody id="medic-table">
                                                 <!-- it is sent by ajax -->
                                             </tbody>
                                         </table>
                                     </div>
                                 </div>

                                 <div class="d-flex justify-content-between mt-3 align-items-center">
                                     <input type="button" name="previous"
                                         class="previous-form-steps_patient btn btn-secondary action-button-previous"
                                         value="Previous" />
                                     <div>
                                         <input type="button" name="next"
                                             class="next-form-steps_patient btn btn-primary action-button-next"
                                             value="Continue" />
                                     </div>
                                 </div>
                             </div>

                             <div class="cont_tap_patient" id="all_info_session">

                                 <div class="row">
                                     <div class="table-responsive">
                                         <table class="table display datatable-modal" id="table-session"
                                             width="100%" cellspacing="0">
                                             <thead>
                                                 <tr>
                                                     <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                                     <th class="text-xs text-center">
                                                         <?php echo e(__('patientappo.session status')); ?></th>
                                                     <th class="text-xs text-center">
                                                         <?php echo e(__('patientappo.pay status')); ?>

                                                     </th>
                                                     <th class="text-xs text-center">
                                                         <?php echo e(__('patientappo.pay Code')); ?>

                                                     </th>
                                                     <th class="text-xs text-center"><?php echo e(__('basic.handle')); ?></th>
                                                 </tr>
                                             </thead>
                                             <tbody id="session-table">
                                                 <!-- it is sent by ajax -->
                                             </tbody>
                                         </table>
                                     </div>
                                 </div>

                                 <div class="d-flex justify-content-between mt-3 align-items-center">
                                     <input type="button" name="previous"
                                         class="previous-form-steps_patient btn btn-secondary action-button-previous"
                                         value="Previous" />
                                     <div>
                                     </div>
                                 </div>
                             </div>

                         </form>
                     </div>


                 </div>

             </div>
         </div>

     </div> <!-- end of all info appointment -->

 </div>
<?php /**PATH /home/drsamirghoraba/public_html/prox/proxima/resources/views/patient/component/appointment.blade.php ENDPATH**/ ?>