<?php $__env->startSection('title', 'Operations | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', __('basic.operations')); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

    <!-- select 2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!-- boostrap datepicker -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<?php $__env->stopSection(); ?>




<?php $__env->startSection('fixedcontent'); ?>

    <div id="add_buttn_fixed">
        <a href="<?php echo e(route('sett.appointment.create')); ?>" class="text-white">
            <i class="fas fa-plus"></i>
        </a>
    </div>

    <!-- session successful message -->
    <?php if(Session::has('success')): ?>
        <div id="flash-msg" class="shadow pt-3">
            <div class="d-flex justify-content-between mb-2">
                <i class="fas fs-1 fa-check"></i>
                <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
            </div>
            <h3>Sent Successfully</h3>
            <p class="text-blue-300"><?php echo e(Session::get('success')); ?></p>
        </div>
    <?php endif; ?>

<?php $__env->stopSection(); ?>


<!-- content insert -->
<?php $__env->startSection('content'); ?>

    <div class="container-fluid px-1 mt-3">

        <!-- page title link -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4 mb-md-3">

            <div class="calendar-datepicker mb-2 mb-md-0">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text ps-3"><i class="bi bi-calendar2-week-fill"></i> </div>
                    </div>
                    <input id="calendar-date-input" type="text" class="form-control hasdatetimepicker"
                        placeholder="YYYY/MM/DD">
                </div>
            </div>

            <div class="d-flex justify-content-center flex-wrap">

                <div class="cont-branch-calendar me-2">
                    <select id="select-specialty-calendar" data-type="timeline" data-order="date"
                        class="js-example-basic-single_branch select2-no-search_branch select2-hidden-accessible">
                        <option value="all">All</option>
                        <?php $__currentLoopData = $specialties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $iteam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($iteam->id); ?>" data-branch_name="<?php echo e($iteam->name); ?>"
                                data-branch_address="<?php echo e($iteam->address); ?>">
                                <?php echo e($iteam->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="cont-branch-calendar me-2">
                    <select id="select-branch-calendar" data-type="timeline" data-order="date"
                        class="js-example-basic-single_branch select2-no-search_branch select2-hidden-accessible">
                        <option value="all">All</option>
                        <?php $__currentLoopData = $oper_place; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $iteam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($iteam->id); ?>" data-branch_name="<?php echo e($iteam->name); ?>"
                                data-branch_address="<?php echo e($iteam->address); ?>">
                                <?php echo e($iteam->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <a href="<?php echo e(route('sett.operation.create')); ?>"
                    class="bg-white d-none d-md-block btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400"><i
                        class="fas fa-plus fa-sm text-gray-300 me-1"></i> <?php echo e(__('basic.new')); ?></a>
            </div>

        </div>

        <div class="card shadow mb-3 pb-2">

            <!-- Card Header - Dropdown -->
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-0 pb-0">

                <div class="dropdown no-arrow">
                    <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown"
                        aria-haspopup="true" aria-expanded="false">
                        <div class="d-flex align-self-center me-2">
                            <h4 class="m-0 fw-bold clickable-item-pointer me-2 text-gray-200" id="click_monthly_calendar"><i
                                    class="bi bi-view-list"></i></h4>
                            <h4 class="m-0 fw-bold text-gray-700 clickable-item-pointer" id="click_timeline_calendar"><i
                                    class="bi bi-list-nested"></i></h4>
                        </div>
                    </a>
                </div>

                <div class="dropdown no-arrow text-truncate" style="margin-top: -62px;">
                    <a class="dropdown-toggle text-truncate" href="#" role="button" id="dropdownMenuLink"
                        data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <div class="d-flex align-self-center me-2 text-truncate">
                            <a href="<?php echo e(route('sett.appointment.index')); ?>"
                                class="m-0 me-2 link-cust-text text-gray-200 text-truncate">Appointments</a>
                            <a href="<?php echo e(route('sett.operation.index')); ?>"
                                class="m-0 fw-bold main-color text-truncate">Operations <i
                                    class="fas text-xs fa-circle"></i></a>
                        </div>
                    </a>
                </div>

                <div class="dropdown no-arrow">
                    <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown"
                        aria-haspopup="true" aria-expanded="false">
                        <div class="d-flex align-self-center me-2">
                            <h4 class="m-0 fw-bold clickable-item-pointer me-2 text-gray-200" id="click_status_order"><i
                                    class="bi bi-list-check"></i></h4>
                            <h4 class="m-0 fw-bold text-gray-700 clickable-item-pointer" id="click_date_order"><i
                                    class="bi bi-stopwatch"></i></h4>
                        </div>
                    </a>
                </div>
            </div>


            <!-- showing waiting during ajax performance -->
            <div id="waiting" class="w-100 h-100 text-center"
                style="position: absolute; top:0px; left:0px;z-index:999999; background-color: #ffffffba;">
                <div class="spinner-grow text-primary" role="status"
                    style="position: relative; top: 50%; transform: translateY(-50%);">
                    <span class="sr-only">Loading...</span>
                </div>
            </div>


            <!-- Card Body for week calendar-->
            <div class="card-body pt-0" id="content_body_timeline">

                <div class="table-responsive">

                    <table class="table table-bordered table-weekly-calender">
                        <thead>
                            <tr id="calander_cont_header">
                                <!-- week calaendar content from ajax -->
                            </tr>
                        </thead>
                    </table>

                </div>

                <div class="row">

                    <div class="col-12 col-md px-2 pe-0 pe-md-5 px-2 px-md-4" id="timeslots_calendar_cont">
                        <!-- timeslots and appointment info content from ajax -->
                    </div>

                    <div id="welcome_cont" class="col-12 col-md-5 px-3 align-self-start"
                        style="margin-left: auto;margin-right: auto;" id="welc_msg_div">
                        <div id="welc_msg_avatar"></div>

                        <div class="d-flex justify-content-between">
                            <div class="fs-4 text-gray-300 me-3">
                                <h4 id="day_name_welcome"></h4>
                                <p id="day_number_welcome" class="fs-1 text-gray-500 me-3"></p>
                            </div>
                            <div id="welc_msg_timeslot" class="fs-4 text-gray-300 text-end"></div>
                        </div>
                        <div id="patient_show_calendar">
                            <img class="img-fluid p-md-2 mb-2"
                                src="<?php echo e(URL::asset('img/dashboard/undraw_chore_list_re_2lq8.svg')); ?>" alt=""
                                style="margin-top:-51px;">
                            <h2 class="welcome-msg-text text-center fw-light text-gray-300">
                                <?php echo e(__('patientappo.welcome calaendar')); ?></h2>
                            <hr>
                            <p id="total_num_services" class="text-gray-300 text-s text-center"></p>
                        </div>
                    </div>

                </div>

            </div>

            <!-- Card Body for monthly calendar-->
            <div class="card-body pt-0 px-1 px-md-4" id="content_body_month_cont" style="display: none">

                <div id="content_body_month">

                </div>

                <div class="row p-3 p-md-4">
                    <span class="col text-s text-gray-400"><i class="fas fa-circle not_accepted-color"></i>
                        <?php echo e(__('patientappo.not accepted')); ?></span>
                    <span class="col text-s text-gray-400"><i class="fas fa-circle main-color"></i>
                        <?php echo e(__('patientappo.accepted')); ?></span>
                    <span class="col text-s text-gray-400"><i class="fas fa-circle arrived-color"></i>
                        <?php echo e(__('patientappo.arrived')); ?>

                    </span>
                    <span class="col text-s text-gray-400"><i class="fas fa-circle inprog-color"></i>
                        <?php echo e(__('patientappo.with doctor')); ?></span>
                    <span class="col text-s text-gray-400"><i class="fas fa-circle done-color"></i>
                        <?php echo e(__('patientappo.done')); ?></span>
                    <span class="col text-s text-gray-400 mt-2 mt-md-0"><i class="fas fa-circle notresp-color"></i>
                        <?php echo e(__('patientappo.not respond')); ?></span>
                    <span class="col text-s text-gray-400"><i class="fas fa-circle cancel-color"></i>
                        <?php echo e(__('patientappo.canceled')); ?>

                    </span>
                </div>

            </div>

        </div>



        <!-- Modal for appointment info -->
        <div class="modal side_modal_prox fade" id="sidemodal" tabindex="-1" aria-labelledby="exampleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog shadow modal-dialog-scrollable">
                <div class="modal-content shadow" id="sidemodal_content">
                    <!-- the data comes from ajax -->
                </div>
            </div>
        </div>

    </div>

<?php $__env->stopSection(); ?>

<!-- js insert -->
<?php $__env->startSection('js'); ?>

    <!-- select 2 -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.js-example-basic-single_branch').select2();
            //hide search
            $('.select2-no-search_branch').select2({
                minimumResultsForSearch: -1
            });
        });
    </script>

    <!-- jquery ui datepicker -->
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
    <script>
        $(function() {
            $('.hasdatetimepicker').datepicker({
                todayHighlight: true,
                format: "yyyy-mm-dd",
            });
        });
    </script>

    <!-- delete confirmation modal -->
    <script>
        $('.delete-conf').click(function(event) {
            var user_id = $(this).data("user_id");
            var username = $(this).data("username");
            console.log(user_id);
            var modal = $('.delete-conf-input [name="user_id"]')
            modal.val(user_id);
            $('#username').val(username);
        })
    </script>


    <script>
        //--------------------- calander arrows appointment ajax -------------------
        $(document).ready(function() {

            fetchWeeklyCalander();

            function fetchWeeklyCalander(yearin = null, weekin = null) {

                var url = "<?php echo e(route('sett.app_weekly_calender', [':year', ':week'])); ?>";
                url = url.replace(':year', yearin).replace(':week', weekin);

                $.ajax({
                    url: url,
                    type: "GET",
                    success: function(data) {
                        $("#calander_cont_header").html(data);
                    }
                });
            };

            //reinsert the calander week days when the month arrows are clicked
            $(document).on('click', '#change_week', function() {
                var yearin = $(this).data('year');
                var weekin = $(this).data('week');
                fetchWeeklyCalander(yearin, weekin)
            });

            //------ appointment time slots ------

            var branch_id = $('#select-branch-calendar').val();
            var specialty_id = $('#select-specialty-calendar').val();

            fetchTimeslotsCalander();

            //for showing loading icon until the ajax is done
            $(document).ajaxStart(function() {
                $("#waiting").show();
            });

            $(document).ajaxStop(function() {
                $("#waiting").hide();
            });

            function fetchTimeslotsCalander(year = <?php echo e(date('Y')); ?>, month = <?php echo e(date('m')); ?>, day =
                <?php echo e(date('d')); ?>, specialty = $('#select-specialty-calendar').val(), branch = $(
                    '#select-branch-calendar').val(), order = $('#select-specialty-calendar').attr('data-order')) {

                var url =
                    "<?php echo e(route('sett.app_weekly_calender_date_operation', [':year_re', ':month_re', ':day_re', ':specialty_id', ':branch_id', ':order_re'])); ?>";
                url = url.replace(':year_re', year).replace(':month_re', month).replace(':day_re', day).replace(
                    ':specialty_id', specialty).replace(':branch_id', branch).replace(':order_re', order);

                var url2 =
                    "<?php echo e(route('sett.app_weekly_calender_date_total_services', [':year_re', ':month_re', ':day_re', ':specialty_id', ':branch_id'])); ?>";
                url2 = url2.replace(':year_re', year).replace(':month_re', month).replace(':day_re', day).replace(
                    ':specialty_id', specialty).replace(':branch_id', branch);

                $("#day_name_welcome").html(day_name_welcome)
                $.ajax({
                    url: url,
                    type: "GET",
                    success: function(data) {
                        $("#timeslots_calendar_cont").html(data);

                        var day_number_welcome = $('#fetch-date-calendar-branch').data('day');
                        var day_name_welcome = $('#fetch-date-calendar-branch').data('day_name');

                        $("#day_name_welcome").html(day_name_welcome);
                        $("#day_number_welcome").html(day_number_welcome);

                        $.ajax({
                            url: url2,
                            type: "GET",
                            success: function(data) {
                                var total_num = '';
                                $.each(data, function(key, value) {
                                    total_num +=
                                        '<span class="me-1"><i class="fas fa-circle text-xxs me-1 text-gray-200"></i>' +
                                        value
                                        .service_item.name +
                                        ': ' + value.total + '</span>';
                                })

                                $("#total_num_services").html(total_num);



                            }
                        });

                        window.timer = setTimeout(function() {
                            fetchTimeslotsCalander();
                        }, 1000000);
                    }
                });

            };

            //reinsert the timeslots when the days arrows are clicked
            $(document).on('click', '#change_calendar_timeslots', function() {

                var year = $(this).data('year');
                var month = $(this).data('month');
                var day = $(this).data('day');

                $('.calendar_weekly_normal').removeClass('calendar_weekly_selected');
                $(this).addClass('calendar_weekly_selected');
                var branch_id = $('#select-branch-calendar').val();
                var specialty_id = $('#select-specialty-calendar').val();

                clearTimeout(window.timer);

                fetchTimeslotsCalander(year, month, day, specialty_id, branch_id)
            });



            //reinsert timeslots appointment when branch selector is changed
            $(document).on('change', '#select-specialty-calendar', function() {

                var type = $(this).attr('data-type');

                if (type === 'timeline') {
                    var year = $('#fetch-date-calendar-branch').data('year');
                    var month = $('#fetch-date-calendar-branch').data('month');
                    var day = $('#fetch-date-calendar-branch').data('day');
                    var specialty = $(this).val();
                    var branch = $('#select-branch-calendar').val();
                    var order = $(this).attr('data-order');

                    clearTimeout(window.timer);
                    fetchTimeslotsCalander(year, month, day, specialty, branch, order)

                } else {
                    var month = $(this).attr('data-month');
                    var year = $(this).attr('data-year');
                    var specialty = $(this).val();
                    var branch = $('#select-branch-calendar').val();
                    clearTimeout(window.timer);
                    monthly_calendar(month, year, specialty, branch);
                }

            });

            //reinsert timeslots appointment when branch selector is changed
            $(document).on('change', '#select-branch-calendar', function() {

                var type = $(this).attr('data-type');

                if (type === 'timeline') {
                    var year = $('#fetch-date-calendar-branch').data('year');
                    var month = $('#fetch-date-calendar-branch').data('month');
                    var day = $('#fetch-date-calendar-branch').data('day');
                    var specialty = $('#select-specialty-calendar').val();
                    var branch = $(this).val();
                    clearTimeout(window.timer);
                    var order = $(this).attr('data-order');

                    fetchTimeslotsCalander(year, month, day, specialty, branch, order)
                } else {
                    var month = $(this).attr('data-month');
                    var year = $(this).attr('data-year');
                    var specialty = $('#select-specialty-calendar').val();
                    var branch = $(this).val();

                    clearTimeout(window.timer);
                    monthly_calendar(month, year, specialty, branch);
                }

            });

            //reinsert the timeslots table when the date paicker are changed
            $(document).on('change', '#calendar-date-input', function() {
                var date = $(this).val().split('-');
                var year = date[0];
                var month = date[1];
                var day = date[2];
                var branch_id = $('#select-branch-calendar').val();
                var specialty_id = $('#select-specialty-calendar').val();

                clearTimeout(window.timer);
                clearTimeout(timer);

                fetchTimeslotsCalander(year, month, day, specialty_id, branch_id);
            });

            //get the appontment info in wlc msg place when the appointment in timeslots is clicked
            $(document).on('click', '#weekly_calendar_fetch_pat', function() {

                paying_txt = "<?php echo e(__('basic.paying')); ?>";

                var id = $(this).data('id');
                var year = $(this).data('year');
                var month = $(this).data('month');
                var day = $(this).data('day');

                var url = "<?php echo e(route('sett.app_appointment_info_ajax_operation', ':id')); ?>";
                url = url.replace(':id', id);

                //$(window).scrollTop($('#welc_msg_avatar').position().top);

                $.ajax({
                    url: url,
                    type: "GET",
                    dataType: "json",
                    success: function(data) {
                        avatar_url = '<?php echo e(URL::asset('img/useravatar')); ?>';
                        edit_url =
                            '<?php echo e(route('sett.operation.edit', ':id')); ?>';
                        edit_url = edit_url.replace(':id', data.appointment.id);

                        if (data.appointment.invoice_item) {
                            url_invoice =
                                '<?php echo e(route('sett.invoice.show', ':id')); ?>';
                            url_invoice = url_invoice.replace(':id', data.appointment
                                .invoice_item
                                .invoice.id);
                        } else {
                            url_invoice = "";
                        }

                        url_patient =
                            '<?php echo e(route('sett.patient.show', ':id')); ?>';
                        url_patient = url_patient.replace(':id', data.appointment.patient_id);

                        url_appointment =
                            '<?php echo e(route('sett.operation.show', ':id')); ?>';
                        url_appointment = url_appointment.replace(':id', data.appointment.id);

                        var doctors_ajax = '';

                        if (data.appointment.doctor !== null) {
                            var doctor_name = data.appointment.doctor.name;
                            var doctor_id = data.appointment.doctor.id;
                        } else {
                            var doctor_name = '<?php echo e(__('basic.not selected')); ?>';
                        }

                        if (data.appointment.creator !== null) {
                            var creator_name = data.appointment.creator.name;
                        } else {
                            var creator_name = '<?php echo e(__('basic.patient')); ?>';
                        }

                        if (data.appointment.invoice_item) {

                            var url_invoice_html = '<a href="' + url_invoice +
                                '" class="dropdown-item btn modal-effect text-gray-400 text-xs"><i class="fas fa-file-invoice-dollar me-1"></i><?php echo e(__('basic.invoice')); ?></a>';

                            if (data.appointment.invoice_item.invoice.status == 0) {
                                var payment_status = data.appointment.invoice_item.invoice.code;
                                var edit_appointment = '<a href="' + edit_url +
                                    '" class="dropdown-item btn modal-effect text-gray-400 text-xs"><i class="bi bi-calendar2-week-fill me-1"></i><?php echo e(__('basic.edit date')); ?></a>';
                            } else {
                                var payment_status = '<?php echo e(__('basic.paid')); ?>';
                                var edit_appointment = '';
                            }
                        } else {
                            var url_invoice_html = '';
                            var payment_status = 'Old Appointment';
                            var edit_appointment = '';
                        }

                        $.each(data.doctors, function(key, value) {
                            doctors_ajax += '<option value="' + value.id + '"' +
                                (value.id == doctor_id ? 'selected' :
                                    'another possibility') +
                                '>' + value.name + ' </option>';
                        })

                        $("#sidemodal_content").html(
                            '<div class="modal-header">' +
                            '<h5 class="modal-title" id="exampleModalLabel">Operation Info</h5>' +
                            '<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>' +
                            '</div>' +
                            '<div class="modal-body px-5">' +
                            '<div id="welc_msg_avatar"><div class="row">' +
                            '<div class="col text-center mb-2">' +

                            '<div class="text-end position-relative">' +
                            '<div class="dropdown no-arrow">' +
                            '<a class="dropdown-toggle" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">' +
                            '<i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300" style=" width: 38px; height: 18px; "></i></a>' +
                            '<div class="dropdown-menu shadow animated--fade-in" aria-labelledby="dropdownMenuLink">' +
                            '<a href="' + url_appointment +
                            '" class="dropdown-item btn modal-effect text-gray-400 text-xs"><i class="bi bi-calendar2-week-fill me-1"></i>Show</a>' +
                            edit_appointment + url_invoice_html +
                            '</div></div></div>' +
                            '<img class="rounded-circle avatar-lg mb-2"' +
                            'src=' + avatar_url + '/' + data.appointment.patient.avatar +
                            '> <div><p class = "mb-0 text-xs text-gray-300 "><?php echo e(__('basic.patient')); ?> </p> <a href="' +
                            url_patient + '" class="mb-0 text-m fw-bold text-gray-600 " >' +
                            data.appointment.patient.name +
                            '</a> <p class = "mb-0 text-xs text-gray-400 fw-bold">' +
                            data.appointment.patient.phone_number +
                            '</p> </div> </div>' +
                            '</div><hr>' +

                            '<div class="d-flex justify-content-between">' +
                            '<div class="fs-4 text-gray-300 me-3"><h4>' + data.day_name +
                            '<h4>' +
                            '<p class="fs-1 text-gray-500 me-3"> ' + data.day_month +
                            ' </p>' +
                            '</div>' +
                            '<div id="welc_msg_timeslot" class="fs-4 text-gray-300 text-end align-self-center">' +
                            '<div class="mb-1"><span class="text-s"><?php echo e(__('basic.from')); ?> </span><span>' +
                            data.start +
                            '</span></div><div class=""><span class="text-s"><?php echo e(__('basic.to')); ?> </span><span>' +
                            data.end +
                            '</span></div></div>' +
                            '</div>' +
                            '</div>' +
                            '<hr>' +

                            '<div id="patient_show_calendar" class="text-center">' +

                            '<div class="text-center d-flex justify-content-between mt-2">' +

                            '<div class="text-start mb-2"> <div class="text-xs text-gray-300 mb-1"><?php echo e(__('basic.service')); ?></div>  <div class="text-s text-gray-600 mb-1">' +
                            data.appointment.service_item.name +
                            '</div> </div>' +
                            '<div class="text-start mb-2"> <div class="text-xs text-gray-300 mb-1"><?php echo e(__('basic.payment')); ?></div>  <div class="text-s text-gray-600 mb-1">' +
                            payment_status +
                            '</div> </div>' +
                            '<div class="text-start mb-2"> <div class="text-xs text-gray-300 mb-1"><?php echo e(__('basic.creator')); ?></div>  <div class="text-s text-gray-600 mb-1">' +
                            creator_name +
                            '</div> </div>' +

                            '</div>' +
                            //update

                            '<hr>' +

                            '<div class="text-center cont-branch-calendar mt-2">' +

                            '<div class="text-start mb-3"> <div class="text-xs text-gray-300 mb-1"><?php echo e(__('basic.status')); ?></div>' +

                            '<select id="select-status-calendar" class="js-example-basic-single select2-no-search select2-hidden-accessible">' +

                            '<option value="0"' +
                            (data.appointment.status == 0 ? 'selected' :
                                'another possibility') +
                            '><?php echo e(__('patientappo.not scheduled')); ?></option>' +

                            '<option value="1"' +
                            (data.appointment.status == 1 ? 'selected' :
                                'another possibility') +
                            '><?php echo e(__('patientappo.scheduled')); ?></option>' +

                            '<option value="2"' +
                            (data.appointment.status == 2 ? 'selected' :
                                'another possibility') +
                            '><?php echo e(__('patientappo.accepted')); ?></option>' +

                            '<option value="3"' +
                            (data.appointment.status == 3 ? 'selected' :
                                'another possibility') +
                            '><?php echo e(__('patientappo.done')); ?></option>' +

                            '<option value="4"' +
                            (data.appointment.status == 4 ? 'selected' :
                                'another possibility') +
                            '><?php echo e(__('patientappo.not respond')); ?></option>' +

                            '<option value="5"' +
                            (data.appointment.status == 5 ? 'selected' :
                                'another possibility') +
                            '><?php echo e(__('patientappo.postponed')); ?></option>' +

                            '<option value="6"' +
                            (data.appointment.status == 6 ? 'selected' :
                                'another possibility') +
                            '><?php echo e(__('patientappo.canceled')); ?></option>' +

                            '</select>' +

                            '</div><div class="text-start mb-4"> <div class="text-xs text-gray-300 mb-1"><?php echo e(__('basic.doctor')); ?></div>' +


                            '<select id="select-doctor-calendar" class="js-example-basic-single select2-no-search select2-hidden-accessible">' +
                            '<option disabled selected><?php echo e(__('basic.not selected')); ?></option>' +
                            doctors_ajax +
                            '</select>' +

                            '</div>' +
                            //  end of docto selector
                            '</div>' +

                            '<div class="text-start mb-3"> <div class="text-xs text-gray-300 mb-1"><?php echo e(__('basic.note')); ?></div>' +

                            '<textarea id="select-note-calendar" name="note" class="form-control" placeholder="Write here your notes .." rows="4" spellcheck="false">' +
                            data.appointment.note +
                            '</textarea>' +

                            //  end of note
                            '</div>' +

                            '</div>' +

                            '</div>' +
                            '<div class="modal-footer">' +
                            '<span class="text-gray-300 clickable-item-pointer me-3" data-bs-dismiss="modal">Close</span>' +
                            '<button type="button" id="calendar_info_sub" data-id="' + data
                            .appointment.id +
                            '" data-year="' +
                            year + '" data-month="' + month + '" data-day="' + day +
                            '" class="btn btn-primary px-5" >Save changes</button>' +
                            '</div>'
                        );

                        $('#sidemodal').modal('show');

                        $('.js-example-basic-single').select2({
                            dropdownParent: $("#sidemodal")
                        });
                        //hide search
                        $('.select2-no-search').select2({
                            dropdownParent: $("#sidemodal"),
                            minimumResultsForSearch: -1
                        });

                    }
                });


            });


            //reinsert the calander when the date paicker are changed
            $(document).on('click', '#calendar_info_sub', function() {

                var appointment_id = $(this).data('id');
                var status = $(this).parent().parent().find('.modal-body').find('#select-status-calendar')
                    .val();
                var doctor = $(this).parent().parent().find('.modal-body').find('#select-doctor-calendar')
                    .val();;

                var note = $(this).parent().parent().find('.modal-body').find('#select-note-calendar')
                    .val();;

                var year = $(this).data('year');
                var month = $(this).data('month');
                var day = $(this).data('day');

                var url = "<?php echo e(route('sett.app_update_status_doctor_operation', ':id')); ?>";
                url = url.replace(':id', appointment_id);

                $.ajax({
                    url: url,
                    type: "POST",
                    data: {
                        '_token': "<?php echo e(csrf_token()); ?>",
                        '_method': "PATCH",
                        'status': status,
                        'doctor': doctor,
                        'note': note,
                    },
                    success: function(data) {
                        if (data.querystatue == true) {
                            var branch_id = $('#select-branch-calendar').val();
                            fetchTimeslotsCalander(year, month, day, branch_id);
                            $('#sidemodal').modal('hide');
                        }
                    }
                });

            });


            // ----- change timeline slots order -----

            //reinsert calander when branch selector is changed (#branches_selc_form)
            $(document).on('click', '#click_date_order', function() {

                $('#fetch-date-calendar-branch').attr('order', 'date');

                //change color on click
                $(this).toggleClass('text-gray-200 text-gray-700');
                $('#click_status_order').toggleClass('text-gray-700 text-gray-200');

                var year = $('#fetch-date-calendar-branch').data('year');
                var month = $('#fetch-date-calendar-branch').data('month');
                var day = $('#fetch-date-calendar-branch').data('day');
                var specialty_id = $('#select-specialty-calendar').val();
                var branch_id = $('#select-branch-calendar').val();
                var order = 'date';

                //change the branch selector data attr to change the calendar
                $('#select-branch-calendar').attr('data-type', 'timeline');

                clearTimeout(window.timer);
                fetchTimeslotsCalander(year, month, day, specialty_id, branch_id, order);
            });

            $(document).on('click', '#click_status_order', function() {

                $('#fetch-date-calendar-branch').attr('order', 'status');

                //change color on click
                $(this).toggleClass('text-gray-200 text-gray-700');
                $('#click_date_order').toggleClass('text-gray-700 text-gray-200');

                var year = $('#fetch-date-calendar-branch').data('year');
                var month = $('#fetch-date-calendar-branch').data('month');
                var day = $('#fetch-date-calendar-branch').data('day');
                var specialty_id = $('#select-specialty-calendar').val();
                var branch_id = $('#select-branch-calendar').val();
                var order = 'status';

                //change the branch selector data attr to change the calendar
                $('#select-branch-calendar').attr('data-type', 'timeline');

                clearTimeout(window.timer);
                fetchTimeslotsCalander(year, month, day, specialty_id, branch_id, order);
            });


            // ------------------ monthly calendar ------------------

            //--------------------- fetch appoingtments -------------------

            //reinsert calander when branch selector is changed (#branches_selc_form)
            $(document).on('click', '#click_timeline_calendar', function() {

                $('#content_body_month_cont').hide();
                $('#content_body_timeline').show();

                //change color on click
                $(this).toggleClass('text-gray-200 text-gray-700');
                $('#click_monthly_calendar').toggleClass('text-gray-700 text-gray-200');

                //change the branch selector data attr to change the calendar
                $('#select-branch-calendar').attr('data-type', 'timeline');
                $('#select-specialty-calendar').attr('data-type', 'timeline');

                clearTimeout(window.timer);
                fetchTimeslotsCalander();
            });


            //reinsert calander when branch selector is changed (#branches_selc_form)
            $(document).on('click', '#click_monthly_calendar', function() {

                $('#content_body_month_cont').show();
                $('#content_body_timeline').hide();

                $(this).toggleClass('text-gray-200 text-gray-700');
                $('#click_timeline_calendar').toggleClass('text-gray-700 text-gray-200');


                $('#select-branch-calendar').attr('data-type', 'month');
                $('#select-specialty-calendar').attr('data-type', 'month');

                clearTimeout(window.timer);

                monthly_calendar();
            });



            function monthly_calendar(month = <?php echo e(date('m')); ?>, year = <?php echo e(date('Y')); ?>, specialty = $(
                '#select-specialty-calendar').val(), branch = $(
                '#select-branch-calendar').val()) {

                var url =
                    "<?php echo e(route('sett.app_monthly_calendar_data_operation', [':year_re', ':month_re', ':speicilty_re', ':branch_re'])); ?>";
                url = url.replace(':year_re', year).replace(':month_re', month).replace(':speicilty_re', specialty)
                    .replace(':branch_re', branch)

                $.ajax({
                    url: url,
                    type: "GET",
                    success: function(data) {

                        $('#content_body_month').html(data);

                    }

                })
            };

            //reinsert the month calander when the month arrows are clicked
            $(document).on('click', '#change_month', function() {

                var month = $(this).data('month');
                var year = $(this).data('year');
                var branch = $('#select-branch-calendar').val();

                $('#select-branch-calendar').attr('data-month', month)
                $('#select-branch-calendar').attr('data-year', year)

                monthly_calendar(month, year, branch)
            });


            //go from the day of monthly calendar to the same day of the timeline
            $(document).on('click', '.monthly_to_timeline_calendar', function() {

                var timeslot = $(this).data('timeslot');
                var specilty_id = $(this).data('specialty');
                var branch_id = $(this).data('branch');
                var arr = timeslot.split('-');

                var year = arr[0];
                var month = arr[1];
                var day = arr[2];

                //to show the timeline div and hide the monthly div
                $('#content_body_month_cont').hide();
                $('#content_body_timeline').show();

                //change color on click
                $('#click_timeline_calendar').toggleClass('text-gray-200 text-gray-700');
                $('#click_monthly_calendar').toggleClass('text-gray-700 text-gray-200');

                //change the branch selector data attr to change the calendar
                $('#select-specialty-calendar').attr('data-type', 'timeline');
                $('#select-branch-calendar').attr('data-type', 'timeline');

                clearTimeout(window.timer);
                fetchTimeslotsCalander(year, month, day, specilty_id, branch_id);

            });

        })
    </script>

    <!-- jquery ui datepicker -->
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
    <script>
        $(function() {
            $('.hasdatetimepicker').datepicker({
                todayHighlight: true,
                format: "yyyy-mm-dd",
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/drsamirghoraba/public_html/prox/proxima/resources/views/branch/operation/index.blade.php ENDPATH**/ ?>