<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($patient->first_name); ?> Profile</title>
    <link rel="stylesheet" href="<?php echo e(public_path('css/kv-mpdf-bootstrap.css')); ?>">

</head>

<body>

    <!-- Patient Info -->
    <div class="card-body px-4">

        <div class="row mb-1 b-r-s-cont border2 py-3 px-2">

            <div class="col-xs-4 text-truncate p-0" style="">
                <div class="w-10">
                    <div class="p-0" style="width: 30%;float: left;">
                        <div class="rounded-circle avatar-m2 profile_img"
                            style="background-image: url(<?php echo e(public_path('img/useravatar/' . $patient->avatar)); ?>)">
                        </div>
                    </div>

                    <div class="text-truncate p-0" style="width: 70%;float: left;">
                        <p class="m-0 p-0 text-s fw-bold2 text-truncate">
                            <?php echo e($patient->first_name . ' ' . $patient->second_name); ?></p>
                        <p class="m-0 p-0 text-xs">AFN <span class="fw-bold2"><?php echo e($patient->new_id); ?></span></p>
                        <p class="m-0 p-0 text-xs">BFN <span class="fw-bold2"><?php echo e($patient->new_branch_id); ?></span></p>
                    </div>
                </div>
            </div>

            <div class="col-xs-2 px-0 text-truncate">
                <p class="text-s mb-0 text-truncate">Date</p>
                <?php if(count($patient->investigation) > 0 && $cat == 1): ?>
                <p class="fw-bold2"><?php echo e($patient->investigation[0]->date); ?></p>
                <?php else: ?>
                <?php if(count($patient->investigation) > 0): ?>
                <p class="fw-bold2"><?php echo e($patient->investigation_lab[0]->date); ?></p>
                <?php endif; ?>
                <?php endif; ?>
            </div>


            <div class="col-xs-4 text-right">
                <img src="data:image/png;base64,<?php echo e(DNS2D::getBarcodePNG($patient->new_id,'QRCODE')); ?>" height="70"
                    width="70" /><br />
                <p class="m-0 p-0 text-xxs text-right"><?php echo e($patient->new_id); ?></p>
            </div>

        </div>


        <!-- All exminations -->
        <div class="row mb-3">
            <div class="col-xs-12">
                <?php if($cat == 1): ?>
                <h5 class="">Radiology Investigation</h5>
                <?php else: ?>
                <h5 class="">Lab Investigation</h5>
                <?php endif; ?>
                <div class="table-responsive">
                    <table class="table-responsive text-s table-bordered2 bordered w-100">
                        <thead>
                            <tr>
                                <th class="fw-bold2" style="width:40%;">Name</th>
                                <th sclass="fw-bold2" tyle="width:20%;">Value</th>
                            </tr>
                        </thead>

                        <tbody>

                            <?php if(count($patient->investigation) > 0 && $cat == 1): ?>
                            <?php $__currentLoopData = $patient->investigation[0]->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="w-25 fw-bold2"><?php echo e($item->name); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($item->value); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <?php if(count($patient->investigation) > 0): ?>
                            <?php $__currentLoopData = $patient->investigation_lab[0]->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="w-25 fw-bold2"><?php echo e($item->name); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2">
                                    <?php if($item->value): ?>
                                    Check
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <?php endif; ?>
                        </tbody>

                    </table>
                </div>
            </div>
        </div>



    </div>


</body>

</html><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/patient/print_investigation.blade.php ENDPATH**/ ?>