<?php $__env->startSection('title', $patient->first_name . ' ' . $patient->second_name . ' | Proxima - Medical Management app'); ?>
<?php $__env->startSection('title-topbar', __('patientappo.patient profile')); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

    <!-- select 2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!-- boostrap datepicker -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

    <!-- datepicker time and date -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

    <!-- tables -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.0.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.2/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/autofill/2.3.9/css/autoFill.bootstrap5.min.css">

<?php $__env->stopSection(); ?>


<?php $__env->startSection('fixedcontent'); ?>

    <!-- session successful message -->
    <?php if(Session::has('success')): ?>
        <div id="flash-msg" class="shadow pt-3">
            <div class="d-flex justify-content-between mb-2">
                <i class="fas fs-1 fa-check"></i>
                <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
            </div>
            <h3><?php echo e(__('patientappo.patient search msg')); ?></h3>
            <p class="text-blue-300"><?php echo e(Session::get('success')); ?></p>
        </div>
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>

    <div class="container-fluid px-0">

        <!-- msg success -->
        <div id="flash-msg-cont"></div>

        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="text-red"><i class="fas fa-exclamation me-1"></i> <?php echo e($error); ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <!-- page title link -->
        <div class="d-flex align-items-center justify-content-between mb-3">

            <!-- page title link -->
            <span class="mb-0">
                <a class="link-cust-text text-gray-200 fw-light"
                    href="<?php echo e(route('sett.home')); ?>"><?php echo e(__('basic.dashboard')); ?> |</a>
                <a class="link-cust-text text-gray-200 fw-light"
                    href="<?php echo e(route('sett.patient.index')); ?>"><?php echo e(__('basic.patient')); ?> | </a>
                <a class="text-gray-300"><?php echo e($patient->first_name); ?></a>
            </span>

            <div class="d-flex justify-content-center mt-2">
                <?php if(auth()->check() && auth()->user()->hasRole('Super-admin|Doctor|Receptionist')): ?>
                    <a href="<?php echo e(route('sett.patient.edit', $patient->id)); ?>"
                        class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 me-2"><i
                            class="fas fa-user-edit fa-sm text-gray-300 me-1"></i> <?php echo e(__('basic.edit')); ?></a>
                    <a href="<?php echo e(route('sett.pat_patient_print_pre', $patient->id)); ?>"
                        class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 me-2"><i
                            class="fas fa-capsules fa-sm text-gray-300 me-2"></i> <?php echo e(__('patientappo.presc')); ?></a>

                    <a href="<?php echo e(route('sett.pat_patient_print', $patient->id)); ?>"
                        class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400"><i
                            class="fas fa-download fa-sm text-gray-300 me-2"></i> <?php echo e(__('basic.print')); ?></a>
                <?php endif; ?>
            </div>

        </div>

        <!-- welcome msg & note -->
        <div class="row mb-4">
            <div class="col-lg-8 col-sm-12">
                <div class="card shadow mb-4 mb-lg-0">

                    <!-- Card Body -->
                    <div class="card-body row">
                        <div class="col align-self-center border-flex ps-3">

                            <div class="d-flex mb-4 align-items-center">
                                <img class="rounded-circle avatar-lg me-3"
                                    src="<?php echo e(URL::asset('img/useravatar/' . $patient->avatar)); ?>">
                                <div class="">
                                    <p class=" mb-0 text-xs text-gray-300">
                                        <?php echo e(__('basic.patient')); ?></p>
                                    <h5 class="mb-1 fw-bold text-gray-600">
                                        <?php echo e($patient->first_name . ' ' . $patient->second_name); ?></h5>
                                    <p class="mb-0 text-xs text-gray-400"><?php echo e(__('basic.id')); ?> <strong>
                                            <?php echo e($patient->id); ?></strong></p>
                                </div>
                            </div>

                            <div class="d-flex ps-2 justify-content-between">

                                <div class="align-items-center text-center  ">
                                    <p class="text-xxs fw-normal mb-1 text-gray-400"><?php echo e(__('patientappo.blood')); ?></p>
                                    <span class="text-s2 fw-bold text-gray-600"><i
                                            class="fas fa-tint fa-sm fa-fw text-gray-300"></i>
                                        <?php echo e($patient->blood_type); ?></span>
                                </div>

                                <div class="align-items-center text-center">
                                    <p class="text-xxs fw-normal mb-1 text-gray-400"><?php echo e(__('patientappo.weight')); ?></p>
                                    <span class="text-s2 fw-bold text-gray-600"><i
                                            class="fas fa-child fa-sm fa-fw text-gray-300"></i>
                                        <?php echo e($patient->height); ?><small class="text-xxs text-gray-200">cm</small></span>
                                </div>

                                <div class="align-items-center text-center me-2">
                                    <p class="text-xxs fw-normal mb-1 text-gray-400"><?php echo e(__('patientappo.height')); ?></p>
                                    <span class="text-s2 fw-bold text-gray-600"><i
                                            class="fas fa-weight-hanging fa-sm fa-fw text-gray-300"></i>
                                        <?php echo e($patient->weight); ?><small class="text-xxs text-gray-200">kg</small></span>
                                </div>

                            </div>
                        </div>


                        <div class="col-12 col-sm ps-4 pt-3">

                            <div id="patient-info-caro" class="carousel slide" data-bs-ride="carousel"
                                data-bs-interval="false">

                                <div class="carousel-indicators dots-radius-carousel"
                                    style="bottom: -28px; margin-bottom: 0px;">
                                    <button type="button" data-bs-target="#patient-info-caro" data-bs-slide-to="0"
                                        class="active" aria-current="true" aria-label="Slide 1"></button>
                                    <button type="button" data-bs-target="#patient-info-caro" data-bs-slide-to="1"
                                        aria-label="Slide 2"></button>
                                </div>

                                <div class="carousel-inner mb-3">

                                    <!-- info 1 -->
                                    <div class="carousel-item active">

                                        <div class="row mb-2">
                                            <div class="col">
                                                <h6 class="text-gray-300 text-xs mb-1">
                                                    <?php echo e(__('patientappo.date of birth')); ?></h6>
                                                <p class="text-gray-600 text-s fw-bold">
                                                    <?php echo e($patient->birthday); ?>

                                                </p>
                                            </div>
                                            <div class="col">
                                                <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('patientappo.age')); ?></h6>
                                                <p class="text-gray-600 text-s fw-bold">
                                                    <?php echo e(\Carbon\Carbon::parse($patient->birthday)->diff(\Carbon\Carbon::now())->format('%y Years')); ?>

                                                </p>
                                            </div>

                                        </div>

                                        <div class="row mb-2">
                                            <div class="col">
                                                <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('patientappo.gendar')); ?>

                                                </h6>
                                                <p class="text-gray-600 text-s fw-bold"><?php echo e($patient->gendar); ?></p>
                                            </div>
                                            <div class="col">
                                                <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('basic.address')); ?></h6>
                                                <p class="text-gray-600 text-s fw-bold"><?php echo e($patient->city->name); ?> ,
                                                    <?php echo e($patient->country->name); ?></p>
                                            </div>
                                        </div>

                                        <div class="row">

                                            <div class="col">
                                                <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('patientappo.ph number')); ?>

                                                </h6>
                                                <p class="text-gray-600 text-xs fw-bold"><?php echo e($patient->phone_number); ?></p>
                                            </div>

                                            <?php if(auth()->check() && auth()->user()->hasRole('Super-admin|Doctor')): ?>

                                                <div class="col pt-3">
                                                    <p class="main-color text-xs fw-bold clickable-item-pointer"
                                                        data-bs-toggle="modal" data-bs-target="#patient_note"><i
                                                            class="fas fa-comment-alt"></i>
                                                        <?php echo e(__('basic.note')); ?></p>


                                                    <!-- Modal -->
                                                    <div class="modal fade" id="patient_note" tabindex="-1"
                                                        aria-labelledby="exampleModalLabel2" aria-hidden="true">
                                                        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                                                            <div class="modal-content b-r-s-cont border-0">
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title" id="exampleModalLabel2"><i
                                                                            class="fas fa-quote-left me-1"></i>
                                                                        <?php echo e(__('patientappo.patient note')); ?></h5>
                                                                    <button type="button" class="btn-close"
                                                                        data-bs-dismiss="modal" aria-label="Close"></button>
                                                                </div>

                                                                <!-- Modal content -->
                                                                <div class="modal-body px-4">
                                                                    <div class="mb-3">
                                                                        <label class="form-label"><?php echo e(__('basic.note')); ?>

                                                                            <small></small></label>
                                                                        <textarea name="note" class="form-control"
                                                                            placeholder="Write here your notes .." rows="4"
                                                                            spellcheck="false"
                                                                            date-text="Write here your notes .."><?php echo e($patient->note); ?></textarea>
                                                                    </div>
                                                                </div>


                                                                <div class="modal-footer">
                                                                    <div class="left-side">
                                                                        <button type="button" class="btn btn-default btn-link"
                                                                            data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                                                    </div>
                                                                    <div class="divider"></div>
                                                                    <div class="right-side">
                                                                        <button type="button" id="note_ajax"
                                                                            class="btn btn-default btn-link main-color"
                                                                            data-bs-dismiss="modal"><?php echo e(__('basic.save changes')); ?></button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>

                                            <?php endif; ?>

                                        </div>
                                    </div>

                                    <!-- info 2 -->
                                    <div class="carousel-item">

                                        <div class="row mb-2">

                                            <div class="col">
                                                <h6 class="text-gray-300 text-xs mb-1">
                                                    <?php echo e(__('patientappo.sec ph number')); ?>

                                                </h6>
                                                <p class="text-gray-600 text-xs fw-bold">
                                                    <?php echo e($patient->sec_phone_number); ?>

                                                </p>
                                            </div>

                                            <div class="col">
                                                <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('patientappo.username')); ?>

                                                </h6>
                                                <p class="text-gray-600 text-s fw-bold"><?php echo e($patient->username); ?>

                                                </p>
                                            </div>
                                        </div>

                                        <div class="row mb-2">

                                            <div class="col">
                                                <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('patientappo.insurance')); ?>

                                                </h6>
                                                <p class="text-gray-600 text-s fw-bold"><?php echo e($patient->insurance); ?></p>
                                            </div>

                                            <div class="col">
                                                <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('patientappo.resource')); ?>

                                                </h6>
                                                <p class="text-gray-600 text-s fw-bold"><?php echo e($patient->recourse->name); ?>

                                                </p>
                                            </div>

                                        </div>


                                    </div>

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <div class="col">

                <div class="row h-100">

                    <div class="col-6 pe-2">
                        <div class="card h-100 shadow text-white" style="background-color: #FF7777;">
                            <!-- Card Header - Dropdown -->
                            <div
                                class="card-header py-3 d-flex flex-row align-items-center justify-content-between bg-transparent border-bottom-0">
                                <h6 class="m-0 fw-bold">Heart Rate</h6>
                                <div class="dropdown no-arrow">
                                    <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                        data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <i class="fas fa-ellipsis-v fa-sm fa-fw text-white"></i>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                        aria-labelledby="dropdownMenuLink">
                                        <div class="dropdown-header">Dropdown Header:</div>
                                        <a class="dropdown-item" href="#">Action</a>
                                        <a class="dropdown-item" href="#">Another action</a>
                                        <div class="dropdown-divider"></div>
                                        <a class="dropdown-item" href="#">Something else here</a>
                                    </div>
                                </div>
                            </div>

                            <!-- Card Body -->
                            <div class="card-body d-flex align-self-center align-items-center text-center p-0">
                                <div class="mb-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                        aria-hidden="true" role="img" width="5em" height="5em"
                                        preserveAspectRatio="xMidYMid meet" viewBox="0 0 24 24">
                                        <path
                                            d="M21 11h-3.94a.78.78 0 0 0-.21 0h-.17a1.3 1.3 0 0 0-.15.1a1.67 1.67 0 0 0-.16.12a1 1 0 0 0-.09.13a1.32 1.32 0 0 0-.12.2l-1.6 4.41l-4.17-11.3a1 1 0 0 0-1.88 0L6.2 11H3a1 1 0 0 0 0 2H7.3a.86.86 0 0 0 .16-.1a1.67 1.67 0 0 0 .16-.12l.09-.13a1 1 0 0 0 .12-.2l1.62-4.53l4.16 11.42a1 1 0 0 0 .94.66a1 1 0 0 0 .94-.66l2.3-6.34H21a1 1 0 0 0 0-2z"
                                            fill="currentColor" />
                                    </svg>
                                    <h1 class="fw-bold mb-3">120<small class="text-xs fw-normal">bpm</small>
                                    </h1>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-6 ps-2">
                        <div class="card h-100 shadow min-height-card text-white" style="background-color: #77BEFF;">
                            <!-- Card Header - Dropdown -->
                            <div
                                class="card-header py-3 d-flex flex-row align-items-center justify-content-between bg-transparent border-bottom-0">
                                <h6 class="m-0 fw-bold">BL Pressure</h6>
                                <div class="dropdown no-arrow">
                                    <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                        data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <i class="fas fa-ellipsis-v fa-sm fa-fw text-white"></i>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                        aria-labelledby="dropdownMenuLink">
                                        <div class="dropdown-header">Dropdown Header:</div>
                                        <a class="dropdown-item" href="#">Action</a>
                                        <a class="dropdown-item" href="#">Another action</a>
                                        <div class="dropdown-divider"></div>
                                        <a class="dropdown-item" href="#">Something else here</a>
                                    </div>
                                </div>
                            </div>

                            <!-- Card Body -->
                            <div class="card-body d-flex align-self-center align-items-center text-center p-0">
                                <div class="mb-2">
                                    <svg width="5em" height="5em" viewBox="0 0 48 48" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M9 19.0345C9 13.3091 12.8117 8 18.0312 8C21.6533 8 24.341 10.382 26 13.7611C27.6589 10.3822 30.3466 8 33.9688 8C39.1889 8 43 13.31 43 19.0345C43 31.2888 26 40 26 40C26 40 14.5487 34.4872 10.4431 25.4444H20.5848L22.1968 22.5788L24.0797 29.1692L28.4891 23.5H34V21.5H27.5109L24.9203 24.8308L22.8032 17.4212L19.4152 23.4444H9.67984C9.89182 24.1288 10.1486 24.7957 10.4431 25.4444L6 25.4443V23.4443L9.67984 23.4444C9.24643 22.0453 9 20.5731 9 19.0345Z"
                                            fill="#ffffff" />
                                    </svg>
                                    <h2 class="fw-bold mt-3 mb-3">70/120</h2>
                                </div>
                            </div>
                        </div>
                    </div>



                </div>

            </div>
        </div>


        <?php if(auth()->check() && auth()->user()->hasRole('Super-admin|Doctor')): ?>

            <!-- Content Row,  -->
            <div class="row">

                <!-- Examination -->
                <div class="col-12 col-lg-4">
                    <div class="card shadow mb-4">

                        <div id="examin-medc" class="carousel slide curr-treament-info-carousel" data-bs-ride="carousel"
                            data-bs-interval="false">

                            <div class="carousel-indicators dots-radius-carousel" style="bottom: 34px; margin-bottom: 0px;">
                                <button type="button" data-bs-target="#examin-medc" data-bs-slide-to="0" class="active"
                                    aria-current="true" aria-label="Slide 1"></button>
                                <button type="button" data-bs-target="#examin-medc" data-bs-slide-to="1"
                                    aria-label="Slide 2"></button>
                            </div>

                            <div class="carousel-inner">

                                <!-- Current examination -->
                                <div class="carousel-item active">

                                    <!-- Card Header - Dropdown -->
                                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                        <div class="d-flex align-items-center">
                                            <span
                                                class="m-0 fs-6 me-2 fw-bold clickable-item-pointer"><?php echo e(__('basic.examination')); ?></span>
                                            <span
                                                class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                                data-bs-target="#examin-medc" data-bs-slide-to="1" aria-label="Slide 2">
                                                <?php echo e(__('basic.medicines')); ?></span>
                                        </div>

                                        <div class="dropdown no-arrow">
                                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                                aria-labelledby="dropdownMenuLink">
                                                <div class="dropdown-header">Dropdown Header:</div>
                                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                                    data-bs-target="#adddisease"><?php echo e(__('patientappo.new examination')); ?></a>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Card Body -->

                                    <?php if(count($disease) > 0): ?>
                                        <div class="card-body pb-4">
                                            <div class="row">
                                                <div class="col align-self-center text-center">


                                                    <svg id="Capa_1" fill="#151515" height="141" width="141"
                                                        viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="m410.109 441.591-5.948-20.515c-1.808-6.232-6.302-11.185-12.329-13.586-6.029-2.402-12.695-1.898-18.293 1.385-7.104 4.165-14.647 7.412-22.506 9.724-.365-3.277-1.648-6.416-3.785-9.055-2.48-3.064-5.856-5.152-9.602-6.025 1.499-2.772 3.268-8.014 3.256-13.37 0-5.168-1.435-10.007-3.925-14.142 2.389-1.115 4.525-2.765 6.232-4.886 3.339-4.147 4.602-9.511 3.464-14.712l-2.718-12.427 6.442-3.776c10.502-6.156 22.482-9.631 34.647-10.048 6.757-.231 12.907-3.503 16.874-8.978 3.967-5.474 5.162-12.337 3.279-18.829l-4.392-15.145c-1.883-6.493-6.564-11.651-12.845-14.153-6.278-2.502-13.226-1.977-19.058 1.441-6.938 4.067-14.328 7.075-22.049 9.022-.464-2.994-1.686-5.852-3.646-8.286-2.614-3.248-6.233-5.391-10.235-6.177 1.472-2.753 3.211-7.952 3.198-13.257 0-4.92-1.305-9.538-3.578-13.537 2.526-.966 4.788-2.575 6.536-4.751 2.957-3.679 4.072-8.432 3.059-13.04l-3.26-14.833c9.359-4.056 19.621-6.369 29.895-6.705 6.228-.202 11.837-3.166 15.39-8.131 3.393-4.741 4.369-10.636 2.681-16.172l-5.351-17.554c-1.678-5.499-5.771-9.915-11.229-12.115-5.653-2.275-11.933-1.886-17.234 1.069-3.655 2.037-7.459 3.816-11.373 5.343l.481-2.19c1.014-4.609-.102-9.362-3.059-13.041-1.586-1.973-3.597-3.477-5.841-4.464 1.712-2.91 3.746-8.472 3.742-14.23 0-5.946-1.903-11.453-5.124-15.956 1.008-.783 1.938-1.684 2.759-2.704 3.148-3.914 4.336-8.974 3.258-13.881l-4.317-19.649c8.486-3.755 17.488-5.835 26.814-6.155 5.82-.199 11.118-3.018 14.536-7.733 3.419-4.716 4.449-10.629 2.827-16.224l-5.002-17.253c-1.621-5.594-5.654-10.039-11.064-12.195-5.415-2.157-11.398-1.703-16.422 1.242-2.3 1.348-4.669 2.579-7.09 3.702-.345-3.065-1.546-6.001-3.538-8.478-3.148-3.916-7.834-6.161-12.857-6.161h-27.534c-4.143 0-7.5 3.357-7.5 7.5s3.357 7.5 7.5 7.5h27.534c.594 0 .963.305 1.168.56.206.256.424.683.297 1.263l-4.854 22.094c-2.236 10.178-2.236 20.936 0 31.113l4.854 22.094c.127.58-.091 1.007-.297 1.263-.205.255-.574.56-1.168.56h-131.618c-.594 0-.963-.305-1.168-.56-.206-.256-.424-.683-.297-1.263l4.854-22.094c2.236-10.178 2.236-20.936 0-31.113l-4.854-22.094c-.127-.58.091-1.007.297-1.263.205-.255.574-.56 1.168-.56h69.02c4.143 0 7.5-3.357 7.5-7.5s-3.357-7.5-7.5-7.5h-69.02c-5.023 0-9.709 2.245-12.857 6.16-1.992 2.477-3.194 5.413-3.538 8.479-2.42-1.123-4.79-2.354-7.09-3.701-5.023-2.945-11.008-3.399-16.42-1.243-5.41 2.155-9.444 6.6-11.066 12.194l-5.004 17.255c-1.622 5.594-.592 11.507 2.827 16.223 3.418 4.716 8.716 7.534 14.535 7.733 9.326.321 18.329 2.401 26.815 6.156l-4.317 19.649c-1.078 4.907.109 9.967 3.258 13.881.821 1.021 1.75 1.921 2.759 2.704-3.221 4.503-5.124 10.01-5.124 15.956-.043 3.82.992 9.311 3.742 14.23-2.244.987-4.255 2.491-5.841 4.464-2.957 3.679-4.072 8.432-3.059 13.04l.482 2.191c-3.915-1.527-7.719-3.306-11.372-5.342-5.304-2.956-11.586-3.346-17.235-1.069-5.458 2.2-9.551 6.616-11.229 12.117l-5.351 17.55c-1.688 5.538-.712 11.433 2.681 16.173 3.553 4.966 9.163 7.93 15.39 8.132 10.276.336 20.539 2.649 29.895 6.706l-3.26 14.832c-1.014 4.609.102 9.362 3.059 13.041 1.749 2.175 4.01 3.784 6.536 4.751-2.272 4-3.578 8.618-3.578 13.537-.04 3.537.835 8.609 3.198 13.257-4.002.786-7.621 2.929-10.235 6.177-1.96 2.435-3.182 5.293-3.646 8.287-7.721-1.947-15.11-4.956-22.049-9.021-5.831-3.419-12.777-3.944-19.058-1.442s-10.962 7.66-12.845 14.153l-4.392 15.145c-1.883 6.492-.688 13.355 3.279 18.829 3.967 5.475 10.117 8.746 16.874 8.978 12.165.417 24.146 3.892 34.647 10.048l6.442 3.776-2.718 12.427c-1.138 5.201.125 10.564 3.464 14.712 1.707 2.121 3.843 3.771 6.232 4.886-2.49 4.135-3.925 8.973-3.925 14.142-.04 3.57.851 8.69 3.256 13.37-3.747.874-7.122 2.961-9.602 6.025-2.137 2.64-3.42 5.779-3.785 9.057-7.859-2.312-15.402-5.562-22.506-9.727-5.599-3.279-12.267-3.784-18.293-1.384-6.027 2.401-10.521 7.354-12.329 13.586l-5.948 20.515c-1.808 6.231-.661 12.818 3.146 18.072s9.71 8.396 16.196 8.618c14.521.498 28.822 4.645 41.356 11.993l.8.469-2.153 10.114c-1.104 5.189.177 10.531 3.516 14.655 3.338 4.123 8.295 6.488 13.601 6.488h31.329c4.143 0 7.5-3.357 7.5-7.5s-3.357-7.5-7.5-7.5h-31.329c-1.037 0-1.662-.581-1.942-.927-.28-.347-.719-1.079-.502-2.094l4.996-23.468c1.834-8.616 1.834-17.354 0-25.968l-4.996-23.469c-.217-1.015.222-1.747.502-2.094.28-.346.905-.927 1.942-.927h155.295c1.037 0 1.662.581 1.942.927.28.347.719 1.079.502 2.094l-4.996 23.468c-1.834 8.615-1.834 17.353 0 25.969l4.996 23.468c.217 1.015-.222 1.747-.502 2.094-.28.346-.905.927-1.942.927h-89.005c-4.143 0-7.5 3.357-7.5 7.5s3.357 7.5 7.5 7.5h89.005c5.306 0 10.263-2.365 13.601-6.488 3.339-4.124 4.62-9.466 3.516-14.655l-2.153-10.114.801-.469c12.533-7.348 26.834-11.494 41.356-11.992 6.485-.223 12.388-3.364 16.195-8.618s4.954-11.846 3.146-18.077zm-211.51-38.536c-6.2.112-12.668-5.818-12.5-12.906 0-6.893 5.607-12.5 12.5-12.5h50.04c4.143 0 7.5-3.357 7.5-7.5s-3.357-7.5-7.5-7.5h-66.215c-1.041 0-1.667-.584-1.947-.933-.28-.348-.717-1.084-.494-2.102l4.188-19.148c2.474-11.312 2.474-23.269 0-34.58l-4.188-19.148c-.223-1.018.214-1.754.494-2.102.28-.349.906-.933 1.947-.933h147.152c1.041 0 1.667.584 1.947.933.28.348.717 1.084.494 2.102l-4.188 19.148c-2.474 11.312-2.474 23.269 0 34.58l4.188 19.148c.223 1.018-.214 1.754-.494 2.102-.28.349-.906.933-1.947.933h-45.896c-4.143 0-7.5 3.357-7.5 7.5s3.357 7.5 7.5 7.5h29.721c6.893 0 12.5 5.607 12.5 12.5.294 6.059-5.26 12.85-12.5 12.906zm-7.77-146.852c-.294-6.059 5.26-12.85 12.5-12.906h105.342c6.893 0 12.5 5.607 12.5 12.5.294 6.059-5.26 12.85-12.5 12.906h-105.342c-6.892 0-12.5-5.607-12.5-12.5zm-5.879-27.906c-.071 0-.239 0-.39-.187s-.114-.351-.099-.421l3.28-14.922c3.444-15.664 3.444-32.223 0-47.886l-3.28-14.924c-.016-.069-.052-.233.099-.42s.318-.187.39-.187h48.433c4.143 0 7.5-3.357 7.5-7.5s-3.357-7.5-7.5-7.5h-30.914c-6.2.112-12.668-5.818-12.5-12.906 0-6.893 5.607-12.5 12.5-12.5h107.063c6.893 0 12.5 5.607 12.5 12.5.294 6.059-5.26 12.85-12.5 12.906h-41.042c-4.143 0-7.5 3.357-7.5 7.5s3.357 7.5 7.5 7.5h58.561c.071 0 .239 0 .39.187s.114.351.099.421l-3.28 14.922c-3.444 15.664-3.444 32.223 0 47.886l3.28 14.924c.016.069.052.233-.099.42s-.318.187-.39.187zm191.538 59.139c1.811-1.061 3.97-1.225 5.92-.447 1.951.777 3.405 2.38 3.99 4.396l4.392 15.145c.585 2.017.214 4.148-1.019 5.85-1.232 1.7-3.144 2.717-5.242 2.788-14.647.503-29.074 4.686-41.72 12.098l-1.624.952c-.485-6.399-.068-12.882 1.298-19.126l2.124-9.708c11.248-2.12 21.952-6.128 31.881-11.948zm-16.104-124.306c1.324-.737 2.9-.829 4.324-.258.724.292 2.011 1.016 2.487 2.577l5.351 17.554c.411 1.347-.062 2.411-.531 3.067-.814 1.138-2.155 1.818-3.682 1.868-10.749.351-21.494 2.535-31.504 6.36-.41-7.307.006-14.668 1.24-21.863 7.784-2.265 15.281-5.384 22.315-9.305zm-7.504-139.253c1.376-.808 2.647-.502 3.283-.248.635.253 1.767.906 2.211 2.438l5.004 17.253c.443 1.531-.164 2.689-.565 3.244-.401.554-1.313 1.491-2.905 1.546-9.723.333-19.158 2.244-28.15 5.678.046-3.922.474-7.839 1.312-11.653l2.232-10.157c6.104-2.116 12.006-4.834 17.578-8.101zm-203.692 22.686c-.401-.555-1.009-1.713-.565-3.243l5.004-17.254c.444-1.531 1.576-2.185 2.212-2.438s1.907-.56 3.282.249c5.571 3.266 11.472 5.979 17.578 8.096l2.233 10.161c.838 3.813 1.266 7.73 1.312 11.653-8.992-3.434-18.427-5.345-28.15-5.679-1.594-.053-2.505-.991-2.906-1.545zm-9.203 139.507c-.47-.656-.942-1.721-.531-3.069l5.351-17.55c.477-1.563 1.764-2.287 2.487-2.579 1.427-.573 3.002-.479 4.325.258 7.031 3.92 14.527 7.039 22.314 9.305 1.234 7.195 1.65 14.556 1.24 21.863-10.01-3.824-20.756-6.008-31.506-6.359-1.524-.05-2.865-.731-3.68-1.869zm-12.514 129.098c-2.099-.072-4.01-1.089-5.242-2.789-1.232-1.701-1.604-3.833-1.019-5.85l4.392-15.145c.585-2.017 2.039-3.619 3.99-4.396 1.95-.778 4.107-.614 5.921.448 9.928 5.819 20.632 9.827 31.88 11.946l2.124 9.709c1.366 6.244 1.783 12.727 1.298 19.126l-1.624-.952c-12.646-7.412-27.073-11.595-41.72-12.097zm-5.723 138.123c-1.828-.063-3.491-.948-4.564-2.43-1.073-1.48-1.396-3.336-.887-5.093l5.948-20.515c.51-1.756 1.776-3.152 3.475-3.829 1.7-.677 3.579-.534 5.155.391 10.177 5.965 21.135 10.294 32.607 12.931l2.751 12.922c1.249 5.864 1.369 11.802.379 17.683-13.798-7.362-29.219-11.524-44.864-12.06zm273.068-2.43c-1.073 1.481-2.736 2.366-4.563 2.43-15.646.536-31.068 4.698-44.865 12.06-.99-5.881-.87-11.819.379-17.684l2.75-12.918c11.474-2.637 22.432-6.968 32.607-12.933 1.576-.925 3.455-1.067 5.155-.391 1.698.677 2.965 2.073 3.475 3.829l5.948 20.515c.511 1.756.188 3.612-.886 5.092z" />
                                                    </svg>
                                                </div>

                                                <div class="col">

                                                    <div class="col">
                                                        <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('basic.examination')); ?>

                                                        </h6>
                                                        <p class="text-gray-700 text-xs fw-bold">
                                                            <?php echo e($disease[0]->diseasecats->name); ?></p>
                                                    </div>
                                                    <div class="col">
                                                        <h6 class="text-gray-300 text-xs mb-1">
                                                            <?php echo e(__('patientappo.started on')); ?></h6>
                                                        <p class="text-gray-700 text-xs fw-bold">
                                                            <?php echo e(date('d M Y', strtotime($disease[0]->start))); ?></p>
                                                    </div>

                                                    <?php if($disease[0]->status == 0): ?>
                                                        <?php
                                                            $msg = __('patientappo.still');
                                                        ?>
                                                    <?php elseif($disease[0]->status == 1): ?>
                                                        <?php
                                                            $msg = __('patientappo.healed');
                                                        ?>
                                                    <?php endif; ?>

                                                    <div class="col">
                                                        <h6 class="text-gray-300 text-xs mb-1"><?php echo e(__('basic.status')); ?>

                                                        </h6>
                                                        <p class="text-gray-700 text-xs fw-bold"><?php echo e($msg); ?></p>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <div class="card-body align-items-center text-center position-relative">
                                            <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                                                data-bs-toggle="modal" data-bs-target="#adddisease">
                                                <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                                                <p class="fw-light mb-0">You can put your notes</p>
                                            </a>
                                        </div>
                                    <?php endif; ?>

                                    <!-- Card footer -->
                                    <div class="card-footer text-center ">
                                        <a class="text-xs link-cust-text text-gray-300 clickable-item-pointer"
                                            data-bs-toggle="modal" data-bs-target="#disease_show">
                                            <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                                        </a>
                                    </div>

                                </div>


                                <!-- Modal show all examination -->
                                <div class="modal fade" id="disease_show" tabindex="-1" aria-labelledby="exampleModalLabel"
                                    aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
                                        <div class="modal-content b-r-s-cont border-0">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel"><i
                                                        class="fas fas fa-x-ray me-1"></i>
                                                    <?php echo e(__('basic.examination')); ?></h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="Close"></button>
                                            </div>

                                            <!-- Modal content -->
                                            <div class="modal-body px-4">

                                                <ul class="nav nav-tabs mb-4" id="myTab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="year_invoice-tab"
                                                            data-bs-toggle="tab" data-bs-target="#year_invoice" type="button"
                                                            role="tab" aria-controls="year_invoice" aria-selected="true"
                                                            class="text-gray-500"><i class="fas fa-users me-1"></i>
                                                            <?php echo e(__('patientappo.last appointment')); ?></button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="home-tab" data-bs-toggle="tab"
                                                            data-bs-target="#home" type="button" role="tab" aria-controls="home"
                                                            aria-selected="true" class="text-gray-500"><i
                                                                class="fas fa-wallet me-1"></i>
                                                            <?php echo e(__('patientappo.other appointments')); ?></button>
                                                    </li>
                                                </ul>

                                                <div class="tab-content" id="myTabContent">

                                                    <div class="tab-pane fade show active" id="year_invoice" role="tabpanel"
                                                        aria-labelledby="year_invoice">


                                                        <div class="d-flex justify-content-center mb-3 flex-wrap">

                                                            <div
                                                                class="d-flex justify-content-center flex-wrap me-0 me-md-5 mb-3 mb-xl-0">

                                                                <div class="mb-3 mb-md-0"
                                                                    style="background-image: url('<?php echo e(asset('img/dashboard/system/human_front.jpg')); ?>'); width:255px; height:457px; position: relative;">
                                                                    <?php if(!empty($disease_draw->front)): ?>
                                                                        <img src="<?php echo e(URL::asset('img/diseasedraw/' . $disease_draw->front)); ?>"
                                                                            width="255" height="457"
                                                                            style=" solid;position: absolute;top:0;left:0;">
                                                                    <?php else: ?>
                                                                        <div class="ms-4 text-center main-color-bg text-white p-2 b-r-s-cont"
                                                                            style=" solid;position: absolute;top:13rem;left:3rem;">
                                                                            <?php echo e(__('patientappo.no back draw')); ?>

                                                                        </div>
                                                                    <?php endif; ?>
                                                                </div>

                                                                <div class="mb-3 mb-md-0"
                                                                    style="background-image: url('<?php echo e(asset('img/dashboard/system/human_back.jpg')); ?>'); width:255px; height:457px; position: relative;">

                                                                    <?php if(!empty($disease_draw->back)): ?>
                                                                        <img src="<?php echo e(URL::asset('img/diseasedraw/' . $disease_draw->back)); ?>"
                                                                            width="255" height="457"
                                                                            style=" solid;position: absolute;top:0;left:0;">
                                                                    <?php else: ?>
                                                                        <div class="ms-4 text-center main-color-bg text-white p-2 b-r-s-cont"
                                                                            style=" solid;position: absolute;top:13rem;left:3rem;">
                                                                            <?php echo e(__('patientappo.no front draw')); ?>

                                                                        </div>
                                                                    <?php endif; ?>
                                                                </div>

                                                            </div>

                                                            <div
                                                                class="d-flex d-xl-block p-4 main-color-bg b-r-s-cont flex-wrap justify-content-center">
                                                                <h5 class="mb-3 text-white me-2 me-xl-0"><i
                                                                        class="far fa-question-circle"></i>
                                                                    <?php echo e(__('patientappo.last examination info')); ?></h5>

                                                                <div class="">
                                                                    <div class="mb-2 me-3 me-xl-5">
                                                                        <label
                                                                            class="form-label text-blue-300 mb-1"><?php echo e(__('patientappo.examination note')); ?>:</label>
                                                                        <div class="form-control-textarea overflow-auto text-white"
                                                                            style="width: 241px; border-radius: 13px !important; border: 1px solid #6fa2ea;">
                                                                            <?php if(!empty($disease_draw->note)): ?>
                                                                                <?php echo e($disease_draw->note); ?>

                                                                            <?php else: ?>
                                                                                No Note
                                                                            <?php endif; ?>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mb-2 me-3 me-xl-5">
                                                                        <label class="form-label text-blue-300 mb-1">
                                                                            <?php echo e(__('patientappo.appointment date')); ?>:</label>
                                                                        <div class="text-white">
                                                                            <?php if(!empty($disease_draw->appointment->start_at)): ?>
                                                                                <?php echo e($disease_draw->appointment->start_at); ?>

                                                                            <?php else: ?>
                                                                                <?php echo e(__('basic.not selected')); ?>

                                                                            <?php endif; ?>
                                                                        </div>
                                                                    </div>
                                                                    <div class="mb-2">
                                                                        <label
                                                                            class="form-label text-blue-300 mb-1"><?php echo e(__('basic.doctor')); ?>:</label>
                                                                        <div class="text-white">
                                                                            <?php if(!empty($disease_draw->appointment->doctor->name)): ?>
                                                                                <?php echo e($disease_draw->appointment->doctor->name); ?>

                                                                            <?php else: ?>
                                                                                <?php echo e(__('basic.not selected')); ?>

                                                                            <?php endif; ?>

                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>


                                                        <h5 class="mb-3 text-gray-400"><i class="far fa-question-circle"></i>
                                                            Initial Examination</h5>

                                                        <div class="table-responsive">
                                                            <table class="table display datatable-modal" id="table-disease"
                                                                width="100%" cellspacing="0">
                                                                <thead>
                                                                    <tr>
                                                                        <th class="text-xs w-25"><?php echo e(__('basic.name')); ?>

                                                                        </th>
                                                                        <th class="text-xs text-center">
                                                                            <?php echo e(__('basic.start')); ?></th>
                                                                        <th class="text-xs text-center">
                                                                            <?php echo e(__('basic.end')); ?></th>
                                                                        <th class="text-xs text-center">
                                                                            <?php echo e(__('basic.status')); ?></th>
                                                                        <th class="text-xs text-center">
                                                                            <?php echo e(__('basic.handle')); ?></th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php $__currentLoopData = $disease; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <?php if($item->status == 0): ?>
                                                                            <?php
                                                                                $text_color = 'active-color-btn';
                                                                                $msg = __('patientappo.still');
                                                                            ?>
                                                                        <?php elseif($item->status == 1): ?>
                                                                            <?php
                                                                                $text_color = 'done-color-btn';
                                                                                $msg = __('patientappo.healed');
                                                                            ?>
                                                                        <?php endif; ?>

                                                                        <tr>
                                                                            <td class="w-25">
                                                                                <?php echo e($item->diseasecats->name); ?></td>
                                                                            <td><?php echo e($item->start); ?></td>
                                                                            <td class="text-center"><?php echo e($item->end); ?>

                                                                            </td>
                                                                            <td class="text-center"> <span
                                                                                    class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                                                            </td>

                                                                            <td class="text-center">
                                                                                <a data-disease_id="<?php echo e($item->id); ?>"
                                                                                    data-diseasecats_id="<?php echo e($item->diseasecats->id); ?>"
                                                                                    data-status_disease="<?php echo e($item->status); ?>"
                                                                                    data-start="<?php echo e($item->start); ?>"
                                                                                    data-end="<?php echo e($item->end); ?>"
                                                                                    class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 disease_edit_click"
                                                                                    title="edit"><i
                                                                                        class="fas fa-pencil-alt"></i>
                                                                                    <?php echo e(__('basic.edit')); ?> </a>

                                                                                <a data-disease_id="<?php echo e($item->id); ?>"
                                                                                    class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 disease_delete_click"
                                                                                    title="delete" data-effect="effect-scale"><i
                                                                                        class="fas fa-trash"></i>
                                                                                    <?php echo e(__('basic.delete')); ?>

                                                                                </a>

                                                                            </td>

                                                                        </tr>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>

                                                    <div class="tab-pane fade" id="home" role="tabpanel"
                                                        aria-labelledby="home-tab">
                                                        <h5 class="text-gray-400">
                                                            <?php echo e(__('patientappo.old examinations')); ?>:</h5>
                                                        <div class="d-flex flex-wrap justify-content-center">
                                                            <?php $__currentLoopData = $appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div data-id="<?php echo e($item->id); ?>"
                                                                    class="exam_appointment d-flex b-r-s-cont shadow p-3 mb-2 me-3 clickable-item-pointer align-items-center">
                                                                    <i class="fas fa-calendar-alt fs-2 me-3"></i>
                                                                    <h6 class="mb-0 text-gray-500">
                                                                        <?php echo e(date('d M Y', strtotime($item->start_at))); ?></h6>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                    </div>

                                                </div>

                                            </div>

                                            <div class="modal-footer">
                                                <div class="left-side">
                                                    <button type="button" class="btn btn-default btn-link"
                                                        data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                                </div>
                                                <div class="divider"></div>
                                                <div class="right-side">
                                                    <button type="button" class="btn btn-default btn-link main-color">Add
                                                        New</button>
                                                </div>
                                            </div>

                                        </div>
                                    </div>

                                </div>


                                <!-- Modal show specific appointment examination -->
                                <div class="modal fade" id="disease_exam_show" tabindex="-1"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
                                        <div class="modal-content b-r-s-cont border-0">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel"><i
                                                        class="fas fas fa-x-ray me-1"></i>
                                                    <?php echo e(__('basic.examination')); ?></h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="Close"></button>
                                            </div>

                                            <!-- Modal content -->
                                            <div class="modal-body px-4">

                                                <div class="d-flex justify-content-center mb-3 flex-wrap">

                                                    <div
                                                        class="d-flex justify-content-center flex-wrap me-0 me-md-5 mb-3 mb-xl-0">

                                                        <div id="exam-front" class="mb-3 mb-md-0"
                                                            style="background-image: url('<?php echo e(asset('img/dashboard/system/human_front.jpg')); ?>'); width:255px; height:457px; position: relative;">

                                                        </div>

                                                        <div id="exam-back" class="mb-3 mb-md-0"
                                                            style="background-image: url('<?php echo e(asset('img/dashboard/system/human_back.jpg')); ?>'); width:255px; height:457px; position: relative;">

                                                        </div>

                                                    </div>

                                                    <div
                                                        class="d-flex d-xl-block p-4 main-color-bg b-r-s-cont flex-wrap justify-content-center">
                                                        <h5 class="mb-3 text-white me-2 me-xl-0"><i
                                                                class="far fa-question-circle"></i>
                                                            <?php echo e(__('patientappo.last examination info')); ?></h5>

                                                        <div class="">
                                                            <div class="mb-2 me-3 me-xl-5">
                                                                <label
                                                                    class="form-label text-blue-300 mb-1"><?php echo e(__('patientappo.examination note')); ?>:</label>
                                                                <div id="exam-note"
                                                                    class="form-control-textarea overflow-auto text-white"
                                                                    style="width: 241px; border-radius: 13px !important; border: 1px solid #6fa2ea;">

                                                                </div>
                                                            </div>
                                                            <div class="mb-2 me-3 me-xl-5">
                                                                <label
                                                                    class="form-label text-blue-300 mb-1"><?php echo e(__('patientappo.appointment date')); ?>:</label>
                                                                <div id="exam-date" class="text-white">

                                                                </div>
                                                            </div>
                                                            <div class="mb-2">
                                                                <label
                                                                    class="form-label text-blue-300 mb-1"><?php echo e(__('basic.doctor')); ?>:</label>
                                                                <div id="exam-doctor" class="text-white">


                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                <h5 class="mb-3 text-gray-400"><i class="far fa-question-circle"></i>
                                                    Initial Examination</h5>

                                                <div class="table-responsive">
                                                    <table class="table display datatable-modal" id="table-disease-exam"
                                                        width="100%" cellspacing="0">
                                                        <thead>
                                                            <tr>
                                                                <th class="text-xs w-25"><?php echo e(__('basic.name')); ?></th>
                                                                <th class="text-xs text-center"><?php echo e(__('basic.start')); ?>

                                                                </th>
                                                                <th class="text-xs text-center"><?php echo e(__('basic.end')); ?></th>
                                                                <th class="text-xs text-center"><?php echo e(__('basic.status')); ?>

                                                                </th>
                                                                <th class="text-xs text-center"><?php echo e(__('basic.handle')); ?>

                                                                </th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="exam-table">

                                                        </tbody>
                                                    </table>
                                                </div>

                                            </div>

                                            <div class="modal-footer">
                                                <div class="left-side">
                                                    <button type="button" class="btn btn-default btn-link"
                                                        data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                                </div>
                                                <div class="divider"></div>
                                                <div class="right-side">
                                                    <button type="button" class="btn btn-default btn-link main-color">Add
                                                        New</button>
                                                </div>
                                            </div>

                                        </div>
                                    </div>

                                </div>


                                <!-- Modal examination insert data -->
                                <div class="modal fade" id="adddisease" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
                                        <div class="modal-content b-r-s-cont border-0">

                                            <form action="<?php echo e(route('sett.disease.store')); ?>" method="post"
                                                style="display: contents;">
                                                <?php echo e(method_field('POST')); ?>

                                                <?php echo e(csrf_field()); ?>


                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel"><i
                                                            class="fas fas fa-x-ray me-1"></i>
                                                        <?php echo e(__('patientappo.new examination')); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>

                                                <!-- Modal content -->
                                                <div class="modal-body px-5 py-3">

                                                    <div class="row mb-2 justify-content-center">

                                                        <div class="col-12 mb-4">
                                                            <div class="d-flex justify-content-center flex-wrap">

                                                                <div class="mb-3 mb-md-0"
                                                                    style="background-image: url('<?php echo e(asset('img/dashboard/system/human_front.jpg')); ?>'); width:255px; height:457px; position: relative;">

                                                                    <canvas class="canvas" id="canvas" width="255"
                                                                        height="457"
                                                                        style=" solid;position: absolute;top:0;left:0;"></canvas>

                                                                    <div id="canvas-clear" class="btn btn-primary"
                                                                        style="position: absolute; bottom:40px; left:0px;"><i
                                                                            class="fas fa-eraser"></i>
                                                                    </div>

                                                                    <div id="imgsave" class="btn btn-danger"
                                                                        style="position: absolute; bottom:0px; left:0px;"><i
                                                                            id="icon_save" class="fas fa-check"></i>
                                                                    </div>

                                                                    <div style="position: absolute; bottom:100px; left:0px;">
                                                                        <div class="d-flex mb-1">
                                                                            <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                                                data-color="#000000"
                                                                                style="width:10px;height:10px;background:#000000;">
                                                                            </div>
                                                                            <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                                                data-color="#0cb6ed"
                                                                                style="width:10px;height:10px;background:#0cb6ed;">
                                                                            </div>
                                                                            <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                                                data-color="#17c34e"
                                                                                style="width:10px;height:10px;background:#17c34e;">
                                                                            </div>
                                                                        </div>
                                                                        <div class="d-flex">
                                                                            <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                                                data-color="#dc3545"
                                                                                style="width:10px;height:10px;background:#dc3545;">
                                                                            </div>
                                                                            <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                                                data-color="#ffd807"
                                                                                style="width:10px;height:10px;background:#ffd807;">
                                                                            </div>
                                                                            <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                                                data-color="#ff6d00"
                                                                                style="width:10px;height:10px;background:#ff6d00;">
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                </div>

                                                                <div
                                                                    style="background-image: url('<?php echo e(asset('img/dashboard/system/human_back.jpg')); ?>'); width:255px; height:457px; position: relative;">
                                                                    <canvas class="canvas" id="canvas_b" width="255"
                                                                        height="457"
                                                                        style=" solid;position: absolute;top:0;left:0;"></canvas>

                                                                    <div id="canvas-clear_b" class="btn btn-primary"
                                                                        style="position: absolute; bottom:40px; left:0px;"><i
                                                                            class="fas fa-eraser"></i>
                                                                    </div>

                                                                    <div id="imgsave_b" class="btn btn-danger"
                                                                        style="position: absolute; bottom:0px; left:0px;"><i
                                                                            id="icon_save_b" class="fas fa-check"></i>
                                                                    </div>


                                                                    <div style="position: absolute; bottom:100px; left:0px;">
                                                                        <div class="d-flex mb-1">
                                                                            <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                                                data-color="#000000"
                                                                                style="width:10px;height:10px;background:#000000;">
                                                                            </div>
                                                                            <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                                                data-color="#0cb6ed"
                                                                                style="width:10px;height:10px;background:#0cb6ed;">
                                                                            </div>
                                                                            <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                                                data-color="#17c34e"
                                                                                style="width:10px;height:10px;background:#17c34e;">
                                                                            </div>
                                                                        </div>
                                                                        <div class="d-flex">
                                                                            <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                                                data-color="#dc3545"
                                                                                style="width:10px;height:10px;background:#dc3545;">
                                                                            </div>
                                                                            <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                                                data-color="#ffd807"
                                                                                style="width:10px;height:10px;background:#ffd807;">
                                                                            </div>
                                                                            <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                                                data-color="#ff6d00"
                                                                                style="width:10px;height:10px;background:#ff6d00;">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <input name="front" id="front_input" type="hidden">
                                                            <input name="back" id="back_input" type="hidden">
                                                        </div>

                                                        <div class="col-12 col-md-8 mb-2">
                                                            <label class="form-label"><?php echo e(__('basic.disease')); ?>

                                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                            <select
                                                                class="myselect2-disease-insert select2-hidden-accessible <?php $__errorArgs = ['disease_cat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                id="disease_cat" multiple="" name="disease_cat[]"
                                                                style="position: relative" required>
                                                                <?php $__currentLoopData = $disease_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($item->id); ?>">
                                                                        <?php echo e($item->name); ?>

                                                                    </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>

                                                            <span id="disease_cat_error" class="error-msg-form"></span>

                                                            <?php $__errorArgs = ['disease_cat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span class="error-msg-form">
                                                                    <?php echo e($message); ?>

                                                                </span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                        </div>

                                                        <div class="col-12 col-md-8 mb-2">
                                                            <label class="form-label"><?php echo e(__('basic.start')); ?>

                                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                            <div class="input-group">
                                                                <div class="input-group-prepend">
                                                                    <div class="input-group-text"><i
                                                                            class="bi bi-calendar2-week-fill"></i> </div>
                                                                </div>
                                                                <input name="disease_start" type="text"
                                                                    class="form-control hasdatetimepicker <?php $__errorArgs = ['disease_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                    placeholder="YYYY/MM/DD" required>
                                                            </div>
                                                            <span id="disease_start_error" class="error-msg-form"></span>

                                                            <?php $__errorArgs = ['disease_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span class="error-msg-form">
                                                                    <?php echo e($message); ?>

                                                                </span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </div>

                                                        <div class="col-12 col-md-8 mb-2">
                                                            <label class="form-label"><?php echo e(__('basic.appointment')); ?>

                                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                            <select
                                                                class="myselect2-disease-insert select2-hidden-accessible <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                id="last_appointment_id" name="last_appointment_id" required>
                                                                <?php $__currentLoopData = $appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($item->id); ?>">
                                                                        <?php echo e($item->start_at); ?>

                                                                    </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>

                                                            <span id="last_appointment_id_error" class="error-msg-form"></span>

                                                            <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span class="error-msg-form">
                                                                    <?php echo e($message); ?>

                                                                </span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                        </div>

                                                        <div class="col-12 col-md-8 mb-2">
                                                            <label class="form-label"><?php echo e(__('basic.note')); ?>

                                                                <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                                            <textarea name="note_diseases" class="form-control "
                                                                placeholder="Write here your note .." rows="4"
                                                                spellcheck="false"></textarea>
                                                            <span id="note_diseases_lab_error" class="error-msg-form"></span>
                                                        </div>

                                                        <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">
                                                    </div>
                                                </div>

                                                <div class="modal-footer">
                                                    <div class="left-side">
                                                        <button type="button" class="btn btn-default btn-link"
                                                            data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                                    </div>
                                                    <div class="divider"></div>
                                                    <div class="right-side">
                                                        <button type="submit" class="btn btn-default btn-link main-color">Add
                                                            New</button>
                                                    </div>
                                                </div>

                                            </form>

                                        </div>
                                    </div>

                                </div>


                                <!-- Modal examination update data -->
                                <div class="modal fade" id="disease_edit" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                                        <div class="modal-content b-r-s-cont border-0">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel"><i
                                                        class="fas fa-capsules me-1"></i>
                                                    Update Examination</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="Close"></button>
                                            </div>

                                            <form class="mb-0" action="<?php echo e(route('sett.disease.update', '21')); ?>"
                                                method="POST">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>

                                                <!-- Modal content -->
                                                <div class="modal-body px-5 py-3">

                                                    <div class="row mb-2">

                                                        <div class="col-12 mb-2">
                                                            <label class="form-label">Disease
                                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                            <select
                                                                class="myselect2-disease-update select2-hidden-accessible <?php $__errorArgs = ['disease_cat_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                id="disease_cat_update" name="disease_cat_update" required>
                                                                <?php $__currentLoopData = $disease_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($item->id); ?>">
                                                                        <?php echo e($item->name); ?>

                                                                    </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>

                                                            <span id="disease_cat_update_error" class="error-msg-form"></span>

                                                            <?php $__errorArgs = ['disease_cat_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span class="error-msg-form">
                                                                    <?php echo e($message); ?>

                                                                </span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                        </div>


                                                        <div class="col-12 mb-2">
                                                            <label class="form-label"><?php echo e(__('basic.status')); ?>

                                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                            <select
                                                                class="myselect2_disease select2-hidden-accessible select2-no-search-disease <?php $__errorArgs = ['status_medicine_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                id="status_disease_update" name="status_disease_update"
                                                                required>
                                                                <option value="0">
                                                                    <?php echo e(__('patientappo.still')); ?>

                                                                </option>
                                                                <option value="1">
                                                                    <?php echo e(__('patientappo.healed')); ?>

                                                                </option>
                                                            </select>

                                                            <span id="status_disease_update_error"
                                                                class="error-msg-form"></span>

                                                            <?php $__errorArgs = ['status_disease_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span class="error-msg-form">
                                                                    <?php echo e($message); ?>

                                                                </span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                        </div>

                                                        <div class="col-12 mb-2">
                                                            <label class="form-label"><?php echo e(__('basic.start')); ?>

                                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                            <div class="input-group">
                                                                <div class="input-group-prepend">
                                                                    <div class="input-group-text"><i
                                                                            class="bi bi-calendar2-week-fill"></i> </div>
                                                                </div>
                                                                <input name="disease_start_update" type="text"
                                                                    class="form-control hasdatetimepicker <?php $__errorArgs = ['disease_start_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                    placeholder="YYYY/MM/DD" required>
                                                            </div>
                                                            <span id="disease_start_update_error"
                                                                class="error-msg-form"></span>

                                                            <?php $__errorArgs = ['disease_start_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span class="error-msg-form">
                                                                    <?php echo e($message); ?>

                                                                </span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </div>

                                                        <div class="col-12 mb-2">
                                                            <label class="form-label"><?php echo e(__('basic.end')); ?>

                                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                            <div class="input-group">
                                                                <div class="input-group-prepend">
                                                                    <div class="input-group-text"><i
                                                                            class="bi bi-calendar2-week-fill"></i> </div>
                                                                </div>
                                                                <input name="disease_end_update" type="text"
                                                                    class="form-control hasdatetimepicker <?php $__errorArgs = ['disease_end_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                    placeholder="YYYY/MM/DD">
                                                            </div>

                                                            <?php $__errorArgs = ['disease_end_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span class="error-msg-form">
                                                                    <?php echo e($message); ?>

                                                                </span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                            <span id="medicine_end_update_error" class="error-msg-form"></span>
                                                        </div>


                                                    </div>

                                                    <input name="disease_id_update" value="" type="hidden">

                                                </div>

                                                <div class="modal-footer">
                                                    <div class="left-side">
                                                        <button type="button" class="btn btn-default btn-link"
                                                            data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                                    </div>
                                                    <div class="divider"></div>
                                                    <div class="right-side">
                                                        <button type="submit"
                                                            class="btn btn-default btn-link main-color"><?php echo e(__('basic.update')); ?></button>
                                                    </div>
                                                </div>
                                            </form>

                                        </div>
                                    </div>

                                </div>

                                <!-- examination Modal delete -->
                                <div class="modal fade" id="disease_delete" tabindex="-1"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

                                        <div class="modal-content shadow-lgg b-r-s-cont border-0">

                                            <div class="modal-header">
                                                <div class="modal-title" id="exampleModalLabel"><i
                                                        class="fas fa-trash me-1"></i>
                                                    Disease delete</div>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="Close"></button>
                                            </div>

                                            <form action="<?php echo e(route('sett.disease.destroy', 'test')); ?>" method="post">
                                                <?php echo e(method_field('delete')); ?>

                                                <?php echo e(csrf_field()); ?>


                                                <!-- Modal content -->
                                                <div class="modal-body px-4">

                                                    <div class="modal-body delete-conf-input text-center py-0">
                                                        <p class="mb-0">ِAre
                                                            you sure you want to delete
                                                            this
                                                            examination?</p><br>
                                                        <input type="hidden" name="disease_id_delete" value="">
                                                    </div>
                                                </div>

                                                <div class="modal-footer">
                                                    <div class="left-side">
                                                        <button type="button" class="btn btn-default btn-link"
                                                            data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                                    </div>
                                                    <div class="divider"></div>
                                                    <div class="right-side">
                                                        <button type="submit"
                                                            class="btn btn-default btn-link text-red"><?php echo e(__('basic.delete')); ?>

                                                        </button>
                                                    </div>

                                                </div>
                                            </form>

                                        </div>
                                    </div>
                                </div>


                                <!-- Current Medicines -->
                                <div class="carousel-item">

                                    <!-- Card Header - Dropdown -->
                                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                        <div class="d-flex align-items-center">
                                            <span
                                                class="m-0 fs-6 me-2 fw-bold clickable-item-pointer"><?php echo e(__('basic.medicines')); ?></span>
                                            <span
                                                class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                                data-bs-target="#examin-medc" data-bs-slide-to="0" aria-label="Slide 1">
                                                <?php echo e(__('basic.examination')); ?></span>
                                        </div>
                                        <div class="dropdown no-arrow">
                                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                                aria-labelledby="dropdownMenuLink">
                                                <div class="dropdown-header">Dropdown Header:</div>
                                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                                    data-bs-target="#addmedic"><?php echo e(__('patientappo.add medicine')); ?></a>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Card Body -->

                                    <?php if(!$medicine->isEmpty()): ?>
                                        <div id="medicine_card_home" class="card-body align-items-center">

                                            <?php $__currentLoopData = $medicine; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <?php if($item->status == 0): ?>
                                                    <?php
                                                        $text_color = 'main-color';
                                                        $msg = __('patientappo.on medicine');
                                                    ?>
                                                <?php elseif($item->status == 1): ?>
                                                    <?php
                                                        $text_color = 'cancel-color';
                                                        $msg = __('patientappo.no result');
                                                    ?>
                                                <?php elseif($item->status == 2): ?>
                                                    <?php
                                                        $text_color = 'done-color';
                                                        $msg = __('patientappo.done');
                                                    ?>
                                                <?php endif; ?>

                                            <?php if($loop->index === 3) break; ?>

                                            <div class="d-flex justify-content-between align-items-center mb-3">

                                                <div class="me-1 d-flex align-self-center align-items-end me-2 text-truncate">
                                                    <i class="fas fa-circle me-2 text-xxs mb-0 <?php echo e($text_color); ?>"></i>

                                                    <div class="text-truncate">
                                                        <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                                            <?php echo e($item->medicinescats->name); ?></p>
                                                        <p class="text-xs text-gray-300 fw-bold mb-0"><?php echo e($msg); ?></p>
                                                    </div>
                                                </div>

                                                <div class="text-s text-gray-600 fw-bold">
                                                    <?php echo e(date('d M Y', strtotime($item->end))); ?>

                                                </div>

                                            </div>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                            <?php else: ?>
                                <div class="card-body align-items-center text-center">
                                    <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                                        data-bs-toggle="modal" data-bs-target="#addmedic">
                                        <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                                        <p class="fw-light mb-0"><?php echo e(__('patientappo.you can add new medicines')); ?></p>
                                    </a>
                                </div>

                                <?php endif; ?>

                                <!-- Card footer medicine -->
                                <div class="card-footer text-center ">
                                    <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                                        data-bs-target="#medicine_show">
                                        <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                                    </a>
                                </div>

                                <!-- Modal show all medicines -->
                                <div class="modal fade" id="medicine_show" tabindex="-1"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
                                        <div class="modal-content b-r-s-cont border-0">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel"><i
                                                        class="fas fas fa-capsules me-1"></i>
                                                    <?php echo e(__('patientappo.current medicines')); ?></h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="Close"></button>
                                            </div>

                                            <!-- Modal content -->
                                            <div class="modal-body px-4">


                                                <div class="table-responsive">
                                                    <table class="table display datatable-modal" id="table-medicine"
                                                        width="100%" cellspacing="0">
                                                        <thead>
                                                            <tr>
                                                                <th class="text-xs w-25"><?php echo e(__('basic.name')); ?></th>
                                                                <th class="text-xs text-center"><?php echo e(__('basic.start')); ?>

                                                                </th>
                                                                <th class="text-xs text-center"><?php echo e(__('basic.end')); ?></th>
                                                                <th class="text-xs text-center"><?php echo e(__('basic.status')); ?>

                                                                </th>
                                                                <th class="text-xs text-center"><?php echo e(__('basic.handle')); ?>

                                                                </th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php $__currentLoopData = $medicine; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($item->status == 0): ?>
                                                                    <?php
                                                                        $text_color = 'active-color-btn';
                                                                        $msg = __('patientappo.on medicine');
                                                                    ?>
                                                                <?php elseif($item->status == 1): ?>
                                                                    <?php
                                                                        $text_color = 'cancel-color-btn';
                                                                        $msg = __('patientappo.no result');
                                                                    ?>
                                                                <?php elseif($item->status == 2): ?>
                                                                    <?php
                                                                        $text_color = 'done-color-btn';
                                                                        $msg = __('patientappo.done');
                                                                    ?>
                                                                <?php endif; ?>

                                                                <tr>
                                                                    <td class="w-25">
                                                                        <?php echo e($item->medicinescats->name); ?></td>
                                                                    <td><?php echo e($item->start); ?></td>
                                                                    <td class="text-center"><?php echo e($item->end); ?></td>
                                                                    <td class="text-center"> <span
                                                                            class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                                                    </td>

                                                                    <td class="text-center">
                                                                        <a data-medicine_id="<?php echo e($item->id); ?>"
                                                                            data-medicinescats_id="<?php echo e($item->medicinescats->id); ?>"
                                                                            data-status_medicine="<?php echo e($item->status); ?>"
                                                                            data-start="<?php echo e($item->start); ?>"
                                                                            data-end="<?php echo e($item->end); ?>"
                                                                            class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 medicine_edit_click"
                                                                            title="edit"><i class="fas fa-pencil-alt"></i>
                                                                            <?php echo e(__('basic.edit')); ?> </a>

                                                                        <a data-medicine_id="<?php echo e($item->id); ?>"
                                                                            class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 medicine_delete_click"
                                                                            title="delete" data-effect="effect-scale"
                                                                            data-bs-toggle="modal" data-bs-target="#delete1"><i
                                                                                class="fas fa-trash"></i>
                                                                            <?php echo e(__('basic.delete')); ?>

                                                                        </a>

                                                                    </td>

                                                                </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>

                                            <div class="modal-footer">
                                                <div class="left-side">
                                                    <button type="button" class="btn btn-default btn-link"
                                                        data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                                </div>
                                                <div class="divider"></div>
                                                <div class="right-side">
                                                    <button type="button"
                                                        class="btn btn-default btn-link main-color"><?php echo e(__('basic.save changes')); ?></button>
                                                </div>
                                            </div>

                                        </div>
                                    </div>

                                </div>

                                <!-- Modal Medicine insert data -->
                                <div class="modal fade" id="addmedic" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                                        <div class="modal-content b-r-s-cont border-0">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel"><i
                                                        class="fas fa-capsules me-1"></i>
                                                    <?php echo e(__('patientappo.add new medicines')); ?></h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="Close"></button>
                                            </div>

                                            <form class="mb-0" action="<?php echo e(route('sett.medicine.store')); ?>"
                                                method="post">
                                                <?php echo e(method_field('POST')); ?>

                                                <?php echo e(csrf_field()); ?>


                                                <!-- Modal content -->
                                                <div class="modal-body px-5 py-3">

                                                    <div class="row mb-2">
                                                        <div class="col-12 mb-2">
                                                            <label class="form-label"><?php echo e(__('basic.medicines')); ?>

                                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                            <select
                                                                class="myselect2-medicine-insert select2-hidden-accessible <?php $__errorArgs = ['medicine_pills'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                multiple="" id="medicine_pills" name="medicine_pills[]"
                                                                required>
                                                                <?php $__currentLoopData = $medicine_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($item->id); ?>">
                                                                        <?php echo e($item->name . ' - ' . $item->price . 'EGP'); ?>

                                                                    </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>

                                                            <span id="medicine_pills_error" class="error-msg-form"></span>

                                                            <?php $__errorArgs = ['medicine_pills'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span class="error-msg-form">
                                                                    <?php echo e($message); ?>

                                                                </span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                        </div>

                                                        <div class="col-12 mb-2">
                                                            <label class="form-label"><?php echo e(__('basic.status')); ?>

                                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                            <select
                                                                class="myselect2-medicine-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['medicine_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                id="medicine_status" name="medicine_status" required>
                                                                <option value="0">
                                                                    <?php echo e(__('patientappo.on medicine')); ?>

                                                                </option>
                                                                <option value="1">
                                                                    <?php echo e(__('patientappo.no result')); ?>

                                                                </option>
                                                                <option value="2">
                                                                    <?php echo e(__('patientappo.done')); ?>

                                                                </option>
                                                            </select>

                                                            <span id="medicine_status_error" class="error-msg-form"></span>

                                                            <?php $__errorArgs = ['medicine_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span class="error-msg-form">
                                                                    <?php echo e($message); ?>

                                                                </span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                        </div>

                                                        <div class="col-12 mb-2">
                                                            <label class="form-label"><?php echo e(__('basic.start')); ?>

                                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                            <div class="input-group">
                                                                <div class="input-group-prepend">
                                                                    <div class="input-group-text"><i
                                                                            class="bi bi-calendar2-week-fill"></i> </div>
                                                                </div>
                                                                <input name="medicine_start" type="text"
                                                                    class="form-control hasdatetimepicker <?php $__errorArgs = ['medicine_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                    placeholder="YYYY/MM/DD" required>
                                                            </div>
                                                            <span id="medicine_start_error" class="error-msg-form"></span>

                                                            <?php $__errorArgs = ['medicine_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span class="error-msg-form">
                                                                    <?php echo e($message); ?>

                                                                </span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </div>

                                                        <div class="col-12 mb-2">
                                                            <label class="form-label"><?php echo e(__('basic.end')); ?>

                                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                            <div class="input-group">
                                                                <div class="input-group-prepend">
                                                                    <div class="input-group-text"><i
                                                                            class="bi bi-calendar2-week-fill"></i> </div>
                                                                </div>
                                                                <input name="medicine_end" type="text"
                                                                    class="form-control hasdatetimepicker <?php $__errorArgs = ['medicine_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                    placeholder="YYYY/MM/DD" required>
                                                            </div>

                                                            <?php $__errorArgs = ['medicine_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span class="error-msg-form">
                                                                    <?php echo e($message); ?>

                                                                </span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                            <span id="medicine_end_error" class="error-msg-form"></span>
                                                        </div>

                                                    </div>

                                                    <?php if(isset($appointments[0]->id)): ?>
                                                        <input name="last_appointment_id" value="<?php echo e($appointments[0]->id); ?>"
                                                            type="hidden">
                                                    <?php else: ?>
                                                        <input name="last_appointment_id" value="null" type="hidden">
                                                    <?php endif; ?>

                                                    <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                                                </div>

                                                <div class="modal-footer">
                                                    <div class="left-side">
                                                        <button type="button" class="btn btn-default btn-link"
                                                            data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                                    </div>
                                                    <div class="divider"></div>
                                                    <div class="right-side">
                                                        <button type="submit" class="btn btn-default btn-link main-color">Add
                                                            New</button>
                                                    </div>
                                                </div>
                                            </form>

                                        </div>
                                    </div>

                                </div>

                                <!-- Modal Medicine update data -->
                                <div class="modal fade" id="medicine_edit" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                                        <div class="modal-content b-r-s-cont border-0">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel"><i
                                                        class="fas fa-capsules me-1"></i>
                                                    <?php echo e(__('patientappo.update medicines')); ?></h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="Close"></button>
                                            </div>

                                            <form class="mb-0" action="<?php echo e(route('sett.medicine.update', '21')); ?>"
                                                method="POST">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>

                                                <!-- Modal content -->
                                                <div class="modal-body px-5 py-3">

                                                    <div class="row mb-2">

                                                        <div class="col-12 mb-2">
                                                            <label class="form-label">Medicine
                                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                            <select
                                                                class="myselect2-medicine-update select2-hidden-accessible <?php $__errorArgs = ['medicine_pills_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                id="medicine_pills_update" name="medicine_pills_update"
                                                                required>
                                                                <?php $__currentLoopData = $medicine_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($item->id); ?>">
                                                                        <?php echo e($item->name . ' - ' . $item->price . 'EGP'); ?>

                                                                    </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>

                                                            <span id="medicine_pills_update_error"
                                                                class="error-msg-form"></span>

                                                            <?php $__errorArgs = ['medicine_pills_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span class="error-msg-form">
                                                                    <?php echo e($message); ?>

                                                                </span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                        </div>


                                                        <div class="col-12 mb-2">
                                                            <label class="form-label"><?php echo e(__('basic.status')); ?>

                                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                            <select
                                                                class="myselect2-medicine-update select2-hidden-accessible select2-no-search-medicine <?php $__errorArgs = ['status_medicine_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                id="status_medicine_update" name="status_medicine_update"
                                                                required>
                                                                <option value="0">
                                                                    On medicine
                                                                </option>
                                                                <option value="1">
                                                                    No result
                                                                </option>
                                                                <option value="2">
                                                                    Done
                                                                </option>
                                                            </select>

                                                            <span id="status_update_update_error"
                                                                class="error-msg-form"></span>

                                                            <?php $__errorArgs = ['status_update_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span class="error-msg-form">
                                                                    <?php echo e($message); ?>

                                                                </span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                        </div>

                                                        <div class="col-12 mb-2">
                                                            <label class="form-label"><?php echo e(__('basic.start')); ?>

                                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                            <div class="input-group">
                                                                <div class="input-group-prepend">
                                                                    <div class="input-group-text"><i
                                                                            class="bi bi-calendar2-week-fill"></i> </div>
                                                                </div>
                                                                <input name="medicine_start_update" type="text"
                                                                    class="form-control hasdatetimepicker <?php $__errorArgs = ['medicine_start_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                    placeholder="YYYY/MM/DD" required>
                                                            </div>
                                                            <span id="medicine_start_update_error"
                                                                class="error-msg-form"></span>

                                                            <?php $__errorArgs = ['medicine_start_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span class="error-msg-form">
                                                                    <?php echo e($message); ?>

                                                                </span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                        </div>

                                                        <div class="col-12 mb-2">
                                                            <label class="form-label"><?php echo e(__('basic.end')); ?>

                                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                            <div class="input-group">
                                                                <div class="input-group-prepend">
                                                                    <div class="input-group-text"><i
                                                                            class="bi bi-calendar2-week-fill"></i> </div>
                                                                </div>
                                                                <input name="medicine_end_update" type="text"
                                                                    class="form-control hasdatetimepicker <?php $__errorArgs = ['medicine_end_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                    placeholder="YYYY/MM/DD" required>
                                                            </div>

                                                            <?php $__errorArgs = ['medicine_end_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                <span class="error-msg-form">
                                                                    <?php echo e($message); ?>

                                                                </span>
                                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                            <span id="medicine_end_update_error" class="error-msg-form"></span>
                                                        </div>


                                                    </div>

                                                    <input name="medicine_id_update" value="" type="hidden">

                                                </div>

                                                <div class="modal-footer">
                                                    <div class="left-side">
                                                        <button type="button" class="btn btn-default btn-link"
                                                            data-bs-dismiss="modal">Never
                                                            Mind</button>
                                                    </div>
                                                    <div class="divider"></div>
                                                    <div class="right-side">
                                                        <button type="submit"
                                                            class="btn btn-default btn-link main-color">Update</button>
                                                    </div>
                                                </div>
                                            </form>

                                        </div>
                                    </div>

                                </div>

                                <!-- Modal delete -->
                                <div class="modal fade" id="medicine_delete" tabindex="-1"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

                                        <div class="modal-content shadow-lgg b-r-s-cont border-0">

                                            <div class="modal-header">
                                                <div class="modal-title" id="exampleModalLabel"><i
                                                        class="fas fa-trash me-1"></i>
                                                    Medicine delete</div>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="Close"></button>
                                            </div>

                                            <form class="mb-0"
                                                action="<?php echo e(route('sett.medicine.destroy', 'test')); ?>" method="post">
                                                <?php echo e(method_field('delete')); ?>

                                                <?php echo e(csrf_field()); ?>


                                                <!-- Modal content -->
                                                <div class="modal-body px-4">

                                                    <div class="modal-body delete-conf-input text-center py-0">
                                                        <p class="mb-0">ِAre
                                                            you sure you want to delete
                                                            this
                                                            medicine?</p><br>
                                                        <input type="hidden" name="medicine_id_delete" value="">
                                                    </div>
                                                </div>

                                                <div class="modal-footer">
                                                    <div class="left-side">
                                                        <button type="button" class="btn btn-default btn-link"
                                                            data-bs-dismiss="modal">Never
                                                            Mind</button>
                                                    </div>
                                                    <div class="divider"></div>
                                                    <div class="right-side">
                                                        <button type="submit" class="btn btn-default btn-link text-red">Delete
                                                        </button>
                                                    </div>

                                                </div>
                                            </form>

                                        </div>
                                    </div>
                                </div>


                            </div>

                        </div>
                    </div>


                </div>
            </div>

            <!-- treatments and sessions -->
            <div class="col-12 col-lg-4">
                <div class="card shadow mb-4">

                    <div id="treat-session" class="carousel slide curr-treament-info-carousel" data-bs-ride="carousel"
                        data-bs-interval="false">

                        <div class="carousel-indicators dots-radius-carousel" style="bottom: 34px; margin-bottom: 0px;">
                            <button type="button" data-bs-target="#treat-session" data-bs-slide-to=" 0" class="active"
                                aria-current="true" aria-label="Slide 1"></button>
                            <button type="button" data-bs-target="#treat-session" data-bs-slide-to=" 1"
                                aria-label="Slide 2"></button>
                        </div>

                        <div class="carousel-inner">

                            <!-- Current treatments -->
                            <div class="carousel-item active">

                                <!-- Card Header - Dropdown -->
                                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                    <div class="d-flex align-items-center">
                                        <span
                                            class="m-0 fs-6 me-2 fw-bold clickable-item-pointer"><?php echo e(__('basic.treatments')); ?></span>
                                        <span
                                            class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                            data-bs-target="#treat-session" data-bs-slide-to="1" aria-label="Slide 2">
                                            <?php echo e(__('patientappo.sessions')); ?></span>
                                    </div>
                                    <div class="dropdown no-arrow">
                                        <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                            data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                                        </a>
                                        <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                            aria-labelledby="dropdownMenuLink">
                                            <div class="dropdown-header">Dropdown Header:</div>
                                            <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                                data-bs-target="#addtreatment"><?php echo e(__('patientappo.new treatment')); ?></a>
                                        </div>
                                    </div>
                                </div>

                                <!-- Card Body -->

                                <?php if(!$treatment->isEmpty()): ?>
                                    <div class="card-body pb-4">

                                        <?php $__currentLoopData = $treatment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                            <?php if($item->status == 0): ?>
                                                <?php
                                                    $text_color = 'main-color';
                                                    $msg = __('basic.in prog');
                                                ?>
                                            <?php elseif($item->status == 1): ?>
                                                <?php
                                                    $text_color = 'done-color-btn';
                                                    $msg = __('patientappo.done');
                                                ?>
                                            <?php endif; ?>

                                        <?php if($loop->index === 3) break; ?>

                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                                <i class="fas fa-circle me-2 text-xxs mb-0 <?php echo e($text_color); ?>"></i>

                                                <div class="text-truncate">
                                                    <h6 class="text-s fw-bold text-gray-700  mb-0">
                                                        <?php echo e($item->treatment_cat->name); ?></h6>
                                                    <p class="text-xs text-gray-300 fw-bold mb-0"><?php echo e($msg); ?></p>
                                                </div>
                                            </div>

                                            <div class="text-s text-gray-600 fw-bold"><?php echo e($item->sessions); ?><small
                                                    class="text-gray-300 text-xxxs">
                                                    Sesi</small>
                                            </div>
                                        </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php else: ?>
                            <div class="card-body align-items-center text-center position-relative">
                                <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                                    data-bs-toggle="modal" data-bs-target="#addtreatment">
                                    <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                                    <p class="fw-light mb-0">You can put your Treatment</p>
                                </a>
                            </div>
                            <?php endif; ?>

                            <!-- Card footer -->
                            <div class="card-footer text-center ">
                                <a class="text-xs link-cust-text text-gray-300 clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#treatment_show">
                                    <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                                </a>
                            </div>

                        </div>

                        <!-- Modal show all treatment -->
                        <div class="modal fade" id="treatment_show" tabindex="-1" aria-labelledby="exampleModalLabel"
                            aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
                                <div class="modal-content b-r-s-cont border-0">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel"><i
                                                class="fas fas fa-x-ray me-1"></i>
                                            Treatment</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>

                                    <!-- Modal content -->
                                    <div class="modal-body px-4">

                                        <div class="table-responsive">
                                            <table class="table display datatable-modal" id="table-treatment" width="100%"
                                                cellspacing="0">
                                                <thead>
                                                    <tr>
                                                        <th class="text-xs"><?php echo e(__('basic.id')); ?></th>
                                                        <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                                        <th class="text-xs text-center"><?php echo e(__('basic.start')); ?></th>
                                                        <th class="text-xs text-center"><?php echo e(__('basic.end')); ?></th>
                                                        <th class="text-xs text-center"><?php echo e(__('patientappo.sessions')); ?>

                                                        </th>
                                                        <th class="text-xs text-center">
                                                            <?php echo e(__('patientappo.sessions done')); ?></th>
                                                        <th class="text-xs text-center"><?php echo e(__('basic.status')); ?></th>
                                                        <th class="text-xs text-center"><?php echo e(__('basic.handle')); ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__currentLoopData = $treatment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($item->status == 0): ?>
                                                            <?php
                                                                $text_color = 'active-color-btn';
                                                                $msg = __('basic.in prog');
                                                            ?>

                                                        <?php elseif($item->status == 1): ?>
                                                            <?php
                                                                $text_color = 'done-color-btn';
                                                                $msg = __('patientappo.done');
                                                            ?>
                                                        <?php endif; ?>

                                                        <tr>
                                                            <td><?php echo e($item->id); ?></td>
                                                            <td class="">
                                                                <?php echo e($item->treatment_cat->name); ?></td>
                                                            <td><?php echo e($item->start); ?></td>
                                                            <td class="text-center"><?php echo e($item->end); ?></td>
                                                            <td class="text-center"><?php echo e($item->sessions); ?></td>
                                                            <td class="text-center"><?php echo e($item->sessions_done); ?></td>
                                                            <td class="text-center"> <span
                                                                    class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                                            </td>

                                                            <td class="text-center">
                                                                <a data-treatment_id="<?php echo e($item->id); ?>"
                                                                    data-treatment_cat_id="<?php echo e($item->treatment_cat->id); ?>"
                                                                    data-status_treatment="<?php echo e($item->status); ?>"
                                                                    data-sessions="<?php echo e($item->sessions); ?>"
                                                                    data-sessions_done="<?php echo e($item->sessions_done); ?>"
                                                                    data-start="<?php echo e($item->start); ?>"
                                                                    data-end="<?php echo e($item->end); ?>"
                                                                    class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 treatment_edit_click"
                                                                    title="edit"><i class="fas fa-pencil-alt"></i>
                                                                    <?php echo e(__('basic.edit')); ?> </a>

                                                                <a data-treatment_id="<?php echo e($item->id); ?>"
                                                                    class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 treatment_newsession_click"
                                                                    title="edit"><i class="fas fa-pencil-alt"></i>
                                                                    <?php echo e(__('patientappo.new session')); ?> </a>

                                                                <a data-treatment_id="<?php echo e($item->id); ?>"
                                                                    class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 treatment_delete_click"
                                                                    title="delete" data-effect="effect-scale"><i
                                                                        class="fas fa-trash"></i>
                                                                    <?php echo e(__('basic.delete')); ?>

                                                                </a>

                                                            </td>

                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                    <div class="modal-footer">
                                        <div class="left-side">
                                            <button type="button" class="btn btn-default btn-link"
                                                data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                        </div>
                                        <div class="divider"></div>
                                        <div class="right-side">
                                            <button type="button"
                                                class="btn btn-default btn-link main-color"><?php echo e(__('basic.save changes')); ?></button>
                                        </div>
                                    </div>

                                </div>
                            </div>

                        </div>

                        <!-- Modal treatment insert data -->
                        <div class="modal fade" id="addtreatment" tabindex="-1" role="dialog"
                            aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                                <div class="modal-content b-r-s-cont border-0">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel"><i
                                                class="fas fas fa-x-ray me-1"></i>
                                            <?php echo e(__('patientappo.new treatment')); ?></h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>

                                    <form action="<?php echo e(route('sett.treatment.store')); ?>" method="post">
                                        <?php echo e(method_field('POST')); ?>

                                        <?php echo e(csrf_field()); ?>


                                        <!-- Modal content -->
                                        <div class="modal-body px-5 py-3">

                                            <div class="row mb-2">

                                                <div class="col-12 mb-2">
                                                    <label class="form-label"><?php echo e(__('basic.treatment')); ?>

                                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                    <select
                                                        class="myselect2-treatment-insert select2-hidden-accessible <?php $__errorArgs = ['treatment_cat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        id="treatment_cat" name="treatment_cat" required>
                                                        <?php $__currentLoopData = $treatment_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($item->id); ?>">
                                                                <?php echo e($item->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>

                                                    <span id="treatment_cat_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['treatment_cat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="error-msg-form">
                                                            <?php echo e($message); ?>

                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                </div>

                                                <div class="col-12 mb-2">
                                                    <label class="form-label"> <?php echo e(__('patientappo.sessions')); ?>

                                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                                    <input name="treatment_session" type="number"
                                                        class="form-control <?php $__errorArgs = ['treatment_session'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="How many session?" required>

                                                    <span id="treatment_session_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['treatment_session'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="error-msg-form">
                                                            <?php echo e($message); ?>

                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-12 mb-2">
                                                    <label class="form-label"><?php echo e(__('basic.start')); ?>

                                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                    <div class="input-group">
                                                        <div class="input-group-prepend">
                                                            <div class="input-group-text"><i
                                                                    class="bi bi-calendar2-week-fill"></i> </div>
                                                        </div>
                                                        <input name="treatment_start" type="text"
                                                            class="form-control hasdatetimepicker <?php $__errorArgs = ['treatment_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                            placeholder="YYYY/MM/DD" required>
                                                    </div>
                                                    <span id="treatment_start_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['treatment_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="error-msg-form">
                                                            <?php echo e($message); ?>

                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-12 mb-2">
                                                    <label class="form-label"><?php echo e(__('basic.end')); ?>

                                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                    <div class="input-group">
                                                        <div class="input-group-prepend">
                                                            <div class="input-group-text"><i
                                                                    class="bi bi-calendar2-week-fill"></i> </div>
                                                        </div>
                                                        <input name="treatment_end" type="text"
                                                            class="form-control hasdatetimepicker <?php $__errorArgs = ['treatment_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                            placeholder="YYYY/MM/DD">
                                                    </div>
                                                    <span id="treatment_end_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['treatment_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="error-msg-form">
                                                            <?php echo e($message); ?>

                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>

                                            <?php if(isset($appointments[0]->id)): ?>
                                                <input name="last_appointment_id" value="<?php echo e($appointments[0]->id); ?>"
                                                    type="hidden">
                                            <?php else: ?>
                                                <input name="last_appointment_id" value="null" type="hidden">
                                            <?php endif; ?>

                                            <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                                        </div>

                                        <div class="modal-footer">
                                            <div class="left-side">
                                                <button type="button" class="btn btn-default btn-link"
                                                    data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                            </div>
                                            <div class="divider"></div>
                                            <div class="right-side">
                                                <button type="submit" class="btn btn-default btn-link main-color">Add
                                                    New</button>
                                            </div>
                                        </div>
                                    </form>

                                </div>
                            </div>

                        </div>

                        <!-- Modal treatment update data -->
                        <div class="modal fade" id="treatment_edit" tabindex="-1" role="dialog"
                            aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                                <div class="modal-content b-r-s-cont border-0">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                            Edit treatment</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>

                                    <form class="mb-0" action="<?php echo e(route('sett.treatment.update', '21')); ?>"
                                        method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PUT'); ?>

                                        <!-- Modal content -->
                                        <div class="modal-body px-5 py-3">

                                            <div class="row mb-2">

                                                <div class="col-12 mb-2">
                                                    <label class="form-label"><?php echo e(__('basic.treatment')); ?>

                                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                                    <select
                                                        class="myselect2-treatment-update select2-hidden-accessible <?php $__errorArgs = ['treatment_cat_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        id="treatment_cat_update" name="treatment_cat_update" required>
                                                        <?php $__currentLoopData = $treatment_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($item->id); ?>">
                                                                <?php echo e($item->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>

                                                    <span id="treatment_cat_update_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['treatment_cat_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="error-msg-form">
                                                            <?php echo e($message); ?>

                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                </div>


                                                <div class="col-12 mb-2">
                                                    <label class="form-label"> <?php echo e(__('patientappo.sessions')); ?>

                                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                                    <input name="treatment_session_update" type="number"
                                                        class="form-control <?php $__errorArgs = ['treatment_session_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="How many session?" required>

                                                    <span id="treatment_session_update_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['treatment_session_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="error-msg-form">
                                                            <?php echo e($message); ?>

                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-12 mb-2">
                                                    <label class="form-label">Sessions Done
                                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                                    <input name="treatment_session_done_update" type="number"
                                                        class="form-control <?php $__errorArgs = ['treatment_session_done_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="How many session?">

                                                    <span id="treatment_session_done_update_error"
                                                        class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['treatment_session_done_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="error-msg-form">
                                                            <?php echo e($message); ?>

                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-12 mb-2">
                                                    <label class="form-label"><?php echo e(__('basic.status')); ?>

                                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                    <select
                                                        class="select2-no-search-treatment select2-hidden-accessible select2-no-search-treatment <?php $__errorArgs = ['status_treatment_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        id="status_treatment_update" name="status_treatment_update" required>
                                                        <option value="0">
                                                            <?php echo e(__('basic.in prog')); ?>

                                                        </option>
                                                        <option value="1">
                                                            <?php echo e(__('patientappo.done')); ?>

                                                        </option>
                                                    </select>

                                                    <span id="status_treatment_update_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['status_treatment_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="error-msg-form">
                                                            <?php echo e($message); ?>

                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                </div>

                                                <div class="col-12 mb-2">
                                                    <label class="form-label"><?php echo e(__('basic.start')); ?>

                                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                    <div class="input-group">
                                                        <div class="input-group-prepend">
                                                            <div class="input-group-text"><i
                                                                    class="bi bi-calendar2-week-fill"></i> </div>
                                                        </div>
                                                        <input name="treatment_start_update" type="text"
                                                            class="form-control hasdatetimepicker <?php $__errorArgs = ['treatment_start_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                            placeholder="YYYY/MM/DD" required>
                                                    </div>
                                                    <span id="treatment_start_update_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['treatment_start_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="error-msg-form">
                                                            <?php echo e($message); ?>

                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-12 mb-2">
                                                    <label class="form-label"><?php echo e(__('basic.end')); ?>

                                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                    <div class="input-group">
                                                        <div class="input-group-prepend">
                                                            <div class="input-group-text"><i
                                                                    class="bi bi-calendar2-week-fill"></i> </div>
                                                        </div>
                                                        <input name="treatment_end_update" type="text"
                                                            class="form-control hasdatetimepicker <?php $__errorArgs = ['treatment_end_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                            placeholder="YYYY/MM/DD" required>
                                                    </div>

                                                    <?php $__errorArgs = ['treatment_end_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="error-msg-form">
                                                            <?php echo e($message); ?>

                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                    <span id="treatment_end_update_error" class="error-msg-form"></span>
                                                </div>


                                            </div>

                                            <input name="treatment_id_update" value="" type="hidden">

                                        </div>

                                        <div class="modal-footer">
                                            <div class="left-side">
                                                <button type="button" class="btn btn-default btn-link"
                                                    data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                            </div>
                                            <div class="divider"></div>
                                            <div class="right-side">
                                                <button type="submit"
                                                    class="btn btn-default btn-link main-color"><?php echo e(__('basic.update')); ?></button>
                                            </div>
                                        </div>
                                    </form>

                                </div>
                            </div>

                        </div>

                        <!-- treatment Modal delete -->
                        <div class="modal fade" id="treatment_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
                            aria-hidden="true">
                            <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

                                <div class="modal-content shadow-lgg b-r-s-cont border-0">

                                    <div class="modal-header">
                                        <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                                            <?php echo e(__('basic.delete')); ?></div>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>

                                    <form action="<?php echo e(route('sett.treatment.destroy', 'test')); ?>" method="post">
                                        <?php echo e(method_field('delete')); ?>

                                        <?php echo e(csrf_field()); ?>


                                        <!-- Modal content -->
                                        <div class="modal-body px-4">

                                            <div class="modal-body delete-conf-input text-center py-0">
                                                <p class="mb-0">ِAre
                                                    you sure you want to delete
                                                    this
                                                    treatment?</p><br>
                                                <input type="hidden" name="treatment_id_delete" value="">
                                            </div>
                                        </div>

                                        <div class="modal-footer">
                                            <div class="left-side">
                                                <button type="button" class="btn btn-default btn-link"
                                                    data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                            </div>
                                            <div class="divider"></div>
                                            <div class="right-side">
                                                <button type="submit"
                                                    class="btn btn-default btn-link text-red"><?php echo e(__('basic.delete')); ?>

                                                </button>
                                            </div>

                                        </div>
                                    </form>

                                </div>
                            </div>
                        </div>

                        <!----------- sessions start content ----------->
                        <div class="carousel-item">

                            <!-- Card Header - Dropdown -->
                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                <div class="d-flex align-items-center">
                                    <span
                                        class="m-0 fs-6 me-2 fw-bold clickable-item-pointer"><?php echo e(__('patientappo.sessions')); ?></span>
                                    <span class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                        data-bs-target="#treat-session" data-bs-slide-to="0" aria-label="Slide 1">
                                        <?php echo e(__('basic.treatments')); ?></span>
                                </div>
                                <div class="dropdown no-arrow">
                                    <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                        data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                        aria-labelledby="dropdownMenuLink">
                                        <div class="dropdown-header">Dropdown Header:</div>
                                        <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                            data-bs-target="#addsession"><?php echo e(__('patientappo.new session')); ?></a>
                                    </div>
                                </div>
                            </div>

                            <!-- Card Body -->
                            <?php if(!$session_pat->isEmpty()): ?>
                                <div id="medicine_card_home" class="card-body align-items-center">

                                    <?php $__currentLoopData = $session_pat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <?php if($item->status == 0): ?>
                                            <?php
                                                $text_color = 'main-color';
                                                $msg = __('patientappo.not done');
                                            ?>
                                        <?php elseif($item->status == 1): ?>
                                            <?php
                                                $text_color = 'done-color-btn';
                                                $msg = __('patientappo.done');
                                            ?>
                                        <?php endif; ?>

                                        <?php if($item->invoice): ?>
                                            <?php if($item->invoice->status == 0): ?>
                                                <?php
                                                    $text_color_invoice = 'cancel-color-btn';
                                                    $msg_invoice = __('basic.not paid');
                                                ?>
                                            <?php elseif($item->invoice->status == 1): ?>
                                                <?php
                                                    $text_color_invoice = 'done-color-btn';
                                                    $msg_invoice = __('basic.paid');
                                                ?>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <?php
                                                $text_color_invoice = 'done-color-btn';
                                                $msg_invoice = __('patientappo.old record');
                                            ?>
                                        <?php endif; ?>

                                    <?php if($loop->index === 3) break; ?>

                                    <div class="d-flex justify-content-between align-items-center mb-3">

                                        <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                            <i class="fas fa-circle me-2 text-xxs mb-0 <?php echo e($text_color); ?>"></i>

                                            <div class="text-truncate">
                                                <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                                    <?php echo e($item->service_cat->name); ?></p>
                                                <p class="text-xs text-gray-300 fw-bold mb-0"><?php echo e($msg); ?></p>
                                            </div>
                                        </div>

                                        <span
                                            class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span>

                                    </div>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                    <?php else: ?>
                        <div class="card-body align-items-center text-center">
                            <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#" data-bs-toggle="modal"
                                data-bs-target="#addsession">
                                <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                                <p class="fw-light mb-0"><?php echo e(__('patientappo.new session')); ?></p>
                            </a>
                        </div>

                        <?php endif; ?>

                        <!-- Card footer session -->
                        <div class="card-footer text-center ">
                            <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                                data-bs-target="#session_show">
                                <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                            </a>
                        </div>

                        <!-- Modal show all session -->
                        <div class="modal fade" id="session_show" tabindex="-1" aria-labelledby="exampleModalLabel"
                            aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
                                <div class="modal-content b-r-s-cont border-0">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel"><i
                                                class="fas fas fa-capsules me-1"></i>
                                            <?php echo e(__('patientappo.sesstions')); ?></h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>

                                    <!-- Modal content -->
                                    <div class="modal-body px-4">

                                        <div class="table-responsive">
                                            <table class="table display datatable-modal" id="table-session" width="100%"
                                                cellspacing="0">
                                                <thead>
                                                    <tr>
                                                        <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                                        <th class="text-xs text-center">
                                                            <?php echo e(__('patientappo.session status')); ?></th>
                                                        <th class="text-xs text-center"><?php echo e(__('patientappo.pay status')); ?>

                                                        </th>
                                                        <th class="text-xs text-center"><?php echo e(__('patientappo.pay Code')); ?>

                                                        </th>
                                                        <th class="text-xs text-center"><?php echo e(__('patientappo.treat id')); ?>

                                                        </th>
                                                        <th class="text-xs text-center">
                                                            <?php echo e(__('patientappo.treat sessions')); ?></th>
                                                        <th class="text-xs text-center"><?php echo e(__('basic.handle')); ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__currentLoopData = $session_pat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($item->status == 0): ?>
                                                            <?php
                                                                $text_color = 'active-color-btn';
                                                                $msg = __('patientappo.not done');
                                                            ?>
                                                        <?php elseif($item->status == 1): ?>
                                                            <?php
                                                                $text_color = 'done-color-btn';
                                                                $msg = __('basic.done');
                                                            ?>
                                                        <?php endif; ?>

                                                        <?php if($item->invoice): ?>
                                                            <?php if($item->invoice->status == 0): ?>
                                                                <?php
                                                                    $text_color_invoice = 'cancel-color-btn';
                                                                    $msg_invoice = __('basic.not paid');
                                                                ?>
                                                            <?php elseif($item->invoice->status == 1): ?>
                                                                <?php
                                                                    $text_color_invoice = 'done-color-btn';
                                                                    $msg_invoice = __('basic.paid');
                                                                ?>
                                                            <?php endif; ?>

                                                        <?php else: ?>
                                                            <?php
                                                                $text_color_invoice = 'done-color-btn';
                                                                $msg_invoice = __('patientappo.old record');
                                                            ?>
                                                        <?php endif; ?>

                                                        <tr>
                                                            <td><?php echo e($item->service_cat->name); ?></td>
                                                            <td class="text-center"> <span
                                                                    class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                                            </td>
                                                            <td class="text-center"> <span
                                                                    class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span>
                                                            </td>
                                                            <td class="text-center"><?php if($item->invoice): ?> <?php echo e($item->invoice->code); ?> <?php else: ?> <?php echo e(__('patientappo.old record')); ?><?php endif; ?></td>
                                                            <td class="text-center"><?php if(!empty($item->treatment->id)): ?> <?php echo e($item->treatment->id); ?> <?php endif; ?></td>
                                                            <td class="text-center"><?php if(!empty($item->treatment->sessions)): ?> <?php echo e($item->treatment->sessions); ?> <?php endif; ?> </td>

                                                            <td class="text-center">
                                                                <a data-session_id="<?php echo e($item->id); ?>"
                                                                    data-status_session="<?php echo e($item->status); ?>"
                                                                    data-treat_id="<?php if(!empty($item->treatment->id)): ?><?php echo e($item->treatment->id); ?><?php endif; ?>"
                                                                    class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 session_edit_click"
                                                                    title="edit"><i class="fas fa-pencil-alt"></i>
                                                                    <?php echo e(__('basic.edit')); ?> </a>

                                                                <?php if($item->invoice): ?>
                                                                    <?php if($item->invoice->status == 0): ?>
                                                                        <a data-session_id="<?php echo e($item->id); ?>"
                                                                            class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 session_delete_click"
                                                                            title="delete" data-effect="effect-scale"
                                                                            data-bs-toggle="modal" data-bs-target="#delete1"><i
                                                                                class="fas fa-trash"></i>
                                                                            <?php echo e(__('basic.delete')); ?>

                                                                        </a>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>

                                                            </td>

                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>

                                    <div class="modal-footer">
                                        <div class="left-side">
                                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">
                                                <?php echo e(__('basic.never mind')); ?></button>
                                        </div>
                                        <div class="divider"></div>
                                        <div class="right-side">
                                            <button type="button"
                                                class="btn btn-default btn-link main-color"><?php echo e(__('basic.save changes')); ?></button>
                                        </div>
                                    </div>

                                </div>
                            </div>

                        </div>

                        <!-- Modal session update data -->
                        <div class="modal fade" id="session_edit" tabindex="-1" role="dialog"
                            aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                                <div class="modal-content b-r-s-cont border-0">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                            Update Session</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>

                                    <form class="mb-0" action="<?php echo e(route('sett.session.update', '21')); ?>"
                                        method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PUT'); ?>

                                        <!-- Modal content -->
                                        <div class="modal-body px-5 py-3">

                                            <div class="row mb-2">


                                                <div class="col-12 mb-2">
                                                    <label class="form-label"><?php echo e(__('basic.status')); ?>

                                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                    <select
                                                        class="select2-no-search-session select2-hidden-accessible select2-no-search-medicine <?php $__errorArgs = ['status_session_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        id="status_session_update" name="status_session_update" required>
                                                        <option value="0">
                                                            <?php echo e(__('patientappo.not done')); ?>

                                                        </option>
                                                        <option value="1">
                                                            <?php echo e(__('patientappo.done')); ?>

                                                        </option>
                                                    </select>

                                                    <span id="status_update_update_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['status_update_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="error-msg-form">
                                                            <?php echo e($message); ?>

                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                </div>


                                                <div class="col-12 mb-2">
                                                    <label
                                                        class="form-label"><?php echo e(__('patientappo.related to treatment')); ?>

                                                        <small>( <?php echo e(__('basic.required')); ?>)</small></label>

                                                    <select
                                                        class="myselect2-session-update select2-hidden-accessible <?php $__errorArgs = ['related_treatment_id_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        id="related_treatment_id_update" name="related_treatment_id_update">
                                                        <?php $__currentLoopData = $treatment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if($item->status == 0): ?>
                                                                <option value="<?php echo e($item->id); ?>">
                                                                    <?php echo e($item->treatment_cat->name . ' - ' . $item->start); ?>

                                                                </option>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>

                                                    <span id="related_treatment_id_update_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['related_treatment_id_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="error-msg-form">
                                                            <?php echo e($message); ?>

                                                        </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                                </div>


                                            </div>

                                            <input name="session_id_update" value="" type="hidden">

                                        </div>

                                        <div class="modal-footer">
                                            <div class="left-side">
                                                <button type="button" class="btn btn-default btn-link"
                                                    data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                            </div>
                                            <div class="divider"></div>
                                            <div class="right-side">
                                                <button type="submit"
                                                    class="btn btn-default btn-link main-color"><?php echo e(__('basic.update')); ?></button>
                                            </div>
                                        </div>
                                    </form>

                                </div>
                            </div>

                        </div>

                        <!-- session delete -->
                        <div class="modal fade" id="session_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
                            aria-hidden="true">
                            <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

                                <div class="modal-content shadow-lgg b-r-s-cont border-0">

                                    <div class="modal-header">
                                        <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                                            <?php echo e(__('patientappo.session delete')); ?></div>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>

                                    <form class="mb-0" action="<?php echo e(route('sett.session.destroy', 'test')); ?>"
                                        method="post">
                                        <?php echo e(method_field('delete')); ?>

                                        <?php echo e(csrf_field()); ?>


                                        <!-- Modal content -->
                                        <div class="modal-body px-4">

                                            <div class="modal-body delete-conf-input text-center py-0">
                                                <p class="mb-0">ِAre
                                                    you sure you want to delete
                                                    this
                                                    session?</p><br>
                                                <input type="hidden" name="session_id_delete" value="">
                                            </div>
                                        </div>

                                        <div class="modal-footer">
                                            <div class="left-side">
                                                <button type="button" class="btn btn-default btn-link"
                                                    data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                            </div>
                                            <div class="divider"></div>
                                            <div class="right-side">
                                                <button type="submit"
                                                    class="btn btn-default btn-link text-red"><?php echo e(__('basic.delete')); ?>

                                                </button>
                                            </div>

                                        </div>
                                    </form>

                                </div>
                            </div>
                        </div>


                    </div>

                    <!-- Modal add new session insert data -->
                    <div class="modal fade" id="addsession" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                        aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                            <div class="modal-content b-r-s-cont border-0">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                        <?php echo e(__('patientappo.new session')); ?></h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>

                                <form class="mb-0" action="<?php echo e(route('sett.session.store')); ?>" method="post">
                                    <?php echo e(method_field('POST')); ?>

                                    <?php echo e(csrf_field()); ?>


                                    <!-- Modal content -->
                                    <div class="modal-body px-5 py-3">

                                        <div class="row mb-2">
                                            <div class="col-12 mb-2">
                                                <label class="form-label"><?php echo e(__('patientappo.sesstion')); ?>

                                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                <select
                                                    class="myselect2-session-insert select2-hidden-accessible <?php $__errorArgs = ['session_cat_service'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                    id="session_cat_service" name="session_cat_service" required>
                                                    <?php $__currentLoopData = $service_cat_ses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($item->id); ?>"
                                                            data-price="<?php echo e($item->price); ?>">
                                                            <?php echo e($item->name . ' - ' . $item->price . 'EGP'); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>

                                                <span id="session_cat_service_error" class="error-msg-form"></span>

                                                <?php $__errorArgs = ['session_cat_service'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-12 mb-2">
                                                <label class="form-label"><?php echo e(__('basic.status')); ?>

                                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                <select
                                                    class="myselect2-session-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['session_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                    id="session_status" name="session_status" required>
                                                    <option value="0">
                                                        <?php echo e(__('patientappo.not done')); ?>

                                                    </option>
                                                    <option value="1">
                                                        <?php echo e(__('patientappo.done')); ?>

                                                    </option>
                                                </select>

                                                <span id="session_status_error" class="error-msg-form"></span>

                                                <?php $__errorArgs = ['session_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                            </div>

                                            <div class="col-12 mb-2">
                                                <label class="form-label"><?php echo e(__('patientappo.related to treatment')); ?>

                                                    <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                                <select
                                                    class="myselect2-session-insert select2-hidden-accessible <?php $__errorArgs = ['related_treatment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                    id="related_treatment_id" name="related_treatment_id">
                                                    <option disabled selected value> -- select treatment -- </option>
                                                    <?php $__currentLoopData = $treatment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($item->status == 0): ?>
                                                            <option value="<?php echo e($item->id); ?>">
                                                                <?php echo e($item->treatment_cat->name . ' - ' . $item->start); ?>

                                                            </option>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>

                                                <span id="related_treatment_id_error" class="error-msg-form"></span>

                                                <?php $__errorArgs = ['related_treatment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-12 mb-2">
                                                <label class="form-label"><?php echo e(__('basic.date')); ?>

                                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <div class="input-group-text"><i
                                                                class="bi bi-calendar2-week-fill"></i> </div>
                                                    </div>
                                                    <input name="session_date" type="text"
                                                        class="form-control hasdatetimepicker <?php $__errorArgs = ['session_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="YYYY/MM/DD" required>
                                                </div>
                                                <span id="session_date_error" class="error-msg-form"></span>

                                                <?php $__errorArgs = ['session_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                        </div>

                                        <?php if(isset($appointments[0]->id)): ?>
                                            <input name="last_appointment_id" value="<?php echo e($appointments[0]->id); ?>"
                                                type="hidden">
                                        <?php else: ?>
                                            <input name="last_appointment_id" value="null" type="hidden">
                                        <?php endif; ?>

                                        <?php if(isset($appointments[0]->branch_id)): ?>
                                            <input name="last_branch_appoint_id" value="<?php echo e($appointments[0]->branch_id); ?>"
                                                type="hidden">
                                        <?php else: ?>
                                            <input name="last_branch_appoint_id" value="null" type="hidden">
                                        <?php endif; ?>

                                        <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                                    </div>

                                    <div class="modal-footer">
                                        <div class="left-side">
                                            <button type="button" class="btn btn-default btn-link"
                                                data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                        </div>
                                        <div class="divider"></div>
                                        <div class="right-side">
                                            <button type="submit" class="btn btn-default btn-link main-color">Add
                                                New</button>
                                        </div>
                                    </div>
                                </form>

                            </div>
                        </div>

                    </div>
                </div>
            </div>


        </div>
        </div>



        <!---------- Lab results --------->
        <div class="col-12 col-lg-4">
            <div class="card shadow mb-4">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold"><?php echo e(__('patientappo.lab result')); ?></h6>
                    <div class="dropdown no-arrow">
                        <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown"
                            aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                            aria-labelledby="dropdownMenuLink">
                            <div class="dropdown-header">Dropdown Header:</div>
                            <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                data-bs-target="#adddxـray"><?php echo e(__('patientappo.new lab')); ?></a>
                        </div>
                    </div>
                </div>

                <!-- Card Body -->
                <?php if(!$lab->isEmpty()): ?>
                    <div class="card-body pb-2">
                        <div class="list-group">
                            <?php $__currentLoopData = $lab; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($loop->index === 3) break; ?>

                            <?php if($item->invoice->status == 0): ?>
                                <div
                                    class="list-group-item li-gr-it-no-space-flx justify-content-between align-items-center mb-3">
                                    <div class="text-truncate">
                                        <p class="text-gray-300 text-xs mb-0">
                                            <?php echo e(date('d M Y', strtotime($item->created_at))); ?></p>
                                        <a href="<?php echo e(route('sett.lab.show', $item->id)); ?>"
                                            class="text-xs link-cust-text text-gray-500 text-truncate"><i
                                                class="fas fa-file-medical-alt text-gray-300 me-1 text-truncate"></i>
                                            <?php echo e($item->service_cat->name); ?></a>
                                    </div>

                                    <div>
                                        <span
                                            class="badge rounded-pill cancel-color-btn badge-padd-l"><?php echo e(__('basic.not paid')); ?></span>
                                    </div>
                                </div>
                            <?php else: ?>

                                <?php if($item->status == 0): ?>
                                    <?php
                                        $lab_status_btn = '<span class="badge rounded-pill active-color-btn badge-padd-l">Sent</span>';
                                        $lab_href = '';
                                    ?>

                                <?php else: ?>
                                    <?php
                                        $lab_status_btn = '<i class="fas fa-arrow-circle-down text-m"></i>';
                                        $lab_href = 'href="' . URL::asset('img/lab/' . $item->xray_file) . '"';
                                    ?>
                                <?php endif; ?>

                                <div
                                    class="list-group-item li-gr-it-no-space-flx justify-content-between align-items-center mb-2">
                                    <div class="text-truncate">
                                        <p class="text-gray-300 text-xs mb-0">
                                            <?php echo e(date('d M Y', strtotime($item->created_at))); ?></p>
                                        <a href="<?php echo e(route('sett.lab.show', $item->id)); ?>"
                                            class="text-xs link-cust-text text-gray-500 text-truncate"><i
                                                class="fas fa-file-medical-alt text-gray-300 me-1 text-truncate"></i>
                                            <?php echo e($item->service_cat->name); ?></a>
                                    </div>

                                    <div>
                                        <a class="text-gray-400" <?php echo $lab_href ?>>
                                            <?php echo $lab_status_btn ?>
                                        </a>
                                    </div>
                                </div>

                            <?php endif; ?>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    <?php else: ?>
        <div class="card-body align-items-center text-center">
            <a class="add-new-iteam stretched-link link-cust-text text-gray-400" href="#" data-bs-toggle="modal"
                data-bs-target="#adddxـray">
                <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                <p class="fw-light mb-0">You can put your notes</p>
            </a>
        </div>
        <?php endif; ?>

        <!-- Card footer -->
        <div class="card-footer text-center ">
            <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal" data-bs-target="#lab_show">
                <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

            </a>
        </div>


        <!-- Modal show all lab -->
        <div class="modal fade" id="lab_show" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
                <div class="modal-content b-r-s-cont border-0">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-capsules me-1"></i>
                            <?php echo e(__('patientappo.lab result')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <!-- Modal content -->
                    <div class="modal-body px-4">

                        <div class="table-responsive">
                            <table class="table display datatable-modal" id="table-lab" width="100%" cellspacing="0">
                                <thead>
                                    <tr>
                                        <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                        <th class="text-xs text-center"><?php echo e(__('basic.code')); ?></th>
                                        <th class="text-xs text-center"><?php echo e(__('patientappo.pay status')); ?></th>
                                        <th class="text-xs text-center"><?php echo e(__('patientappo.pay Code')); ?></th>
                                        <th class="text-xs text-center"><?php echo e(__('basic.status')); ?></th>
                                        <th class="text-xs text-center"><?php echo e(__('basic.note')); ?></th>
                                        <th class="text-xs text-center"><?php echo e(__('basic.created')); ?></th>
                                        <th class="text-xs text-center"><?php echo e(__('basic.handle')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $lab; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($item->status == 0): ?>
                                            <?php
                                                $text_color = 'active-color-btn';
                                                $msg = __('basic.sent');
                                            ?>
                                        <?php elseif($item->status == 1): ?>
                                            <?php
                                                $text_color = 'done-color-btn';
                                                $msg = __('patientappo.done');
                                            ?>
                                        <?php endif; ?>

                                        <?php if($item->invoice->status == 0): ?>
                                            <?php
                                                $text_color_invoice = 'cancel-color-btn';
                                                $msg_invoice = __('basic.not paid');
                                            ?>
                                        <?php elseif($item->invoice->status == 1): ?>
                                            <?php
                                                $text_color_invoice = 'done-color-btn';
                                                $msg_invoice = __('basic.paid');
                                            ?>
                                        <?php endif; ?>

                                        <tr>
                                            <td><a href="<?php echo e(route('sett.lab.show', $item->id)); ?>"
                                                    class="link-cust-text text-gray-500 text-truncate"><i
                                                        class="fas fa-file-medical-alt link-cust-text text-gray-300 me-1 text-truncate"></i>
                                                    <?php echo e($item->service_cat->name); ?></a></td>
                                            <td class="text-center"><?php echo e($item->code); ?></td>
                                            <td class="text-center"> <span
                                                    class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span>
                                            </td>
                                            <td class="text-center"><?php echo e($item->invoice->code); ?></td>
                                            <td class="text-center"> <span
                                                    class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                            </td>
                                            <td><?php echo e($item->note_lab); ?></td>

                                            <td class="text-center"><?php echo e(date('d M Y', strtotime($item->created_at))); ?>

                                            </td>

                                            <td class="text-center">

                                                <?php if(!empty($item->xray_file)): ?>
                                                    <a href="<?php echo e(URL::asset('img/lab/' . $item->xray_file)); ?>"
                                                        class="btn btn-sm modal-effect status-col-link active-color-btn b-r-xs mb-1"
                                                        title="download"><i class="fas fa-trash"></i>
                                                        <?php echo e(__('basic.download')); ?>

                                                    </a>
                                                <?php endif; ?>

                                                <?php if($item->invoice->status == 0): ?>
                                                    <a data-lab_id="<?php echo e($item->id); ?>"
                                                        data-invoice_id="<?php echo e($item->invoice->id); ?>"
                                                        class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 lab_delete_click"
                                                        title="delete" data-effect="effect-scale" data-bs-toggle="modal"
                                                        data-bs-target="#delete1"><i class="fas fa-trash"></i>
                                                        <?php echo e(__('basic.delete')); ?>

                                                    </a>
                                                <?php endif; ?>

                                            </td>

                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link"
                                data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="button"
                                class="btn btn-default btn-link main-color"><?php echo e(__('basic.save changes')); ?></button>
                        </div>
                    </div>

                </div>
            </div>

        </div>

        <!-- Modal lab insert data -->
        <div class="modal fade" id="adddxـray" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                <div class="modal-content b-r-s-cont border-0">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-x-ray me-1"></i>
                            <?php echo e(__('patientappo.new lab')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <form action="<?php echo e(route('sett.lab_patient_add')); ?>" method="post">
                        <?php echo e(method_field('POST')); ?>

                        <?php echo e(csrf_field()); ?>


                        <!-- Modal content -->
                        <div class="modal-body px-5 py-3">

                            <div class="row mb-2">

                                <div class="col-12 mb-2">
                                    <label class="form-label"><?php echo e(__('patientappo.lab catagory')); ?>

                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                    <select
                                        class="myselect2-lab-insert select2-hidden-accessible <?php $__errorArgs = ['lab_cat_serv_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="lab_cat_serv_id" name="lab_cat_serv_id" required>
                                        <?php $__currentLoopData = $service_cat_lab; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>" data-price="<?php echo e($item->price); ?>">
                                                <?php echo e($item->name . ' - ' . $item->price . 'EGP'); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <span id="lab_cat_serv_id_error" class="error-msg-form"></span>

                                    <?php $__errorArgs = ['lab_cat_serv_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>


                                <div class="col-12 mb-2">
                                    <label class="form-label"><?php echo e(__('basic.note')); ?>

                                        <small>(<?php echo e(__('basic.optional')); ?>)</small></label>

                                    <textarea name="note_doctor_lab"
                                        class="form-control <?php $__errorArgs = ['note_doctor_lab'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Write here your notes .." rows="4" spellcheck="false"></textarea>

                                    <span id="note_doctor_lab_error" class="error-msg-form"></span>

                                    <?php $__errorArgs = ['note_doctor_lab'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-msg-form">
                                            <?php echo e($message); ?>

                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>


                            </div>

                            <?php if(isset($appointments[0]->id)): ?>
                                <input name="last_appointment_id" value="<?php echo e($appointments[0]->id); ?>" type="hidden">
                            <?php else: ?>
                                <input name="last_appointment_id" value="null" type="hidden">
                            <?php endif; ?>

                            <?php if(isset($appointments[0]->branch_id)): ?>
                                <input name="last_branch_appoint_id" value="<?php echo e($appointments[0]->branch_id); ?>"
                                    type="hidden">
                            <?php else: ?>
                                <input name="last_branch_appoint_id" value="null" type="hidden">
                            <?php endif; ?>


                            <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link"
                                    data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="submit" class="btn btn-default btn-link main-color">Add
                                    New</button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>

        </div>

        <!-- Modal lab delete -->
        <div class="modal fade" id="lab_delete" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

                <div class="modal-content shadow-lgg b-r-s-cont border-0">

                    <div class="modal-header">
                        <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                            <?php echo e(__('basic.delete')); ?></div>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <form class="mb-0" action="<?php echo e(route('sett.lab.destroy', 'test')); ?>" method="post">
                        <?php echo e(method_field('delete')); ?>

                        <?php echo e(csrf_field()); ?>


                        <!-- Modal content -->
                        <div class="modal-body px-4">

                            <div class="modal-body delete-conf-input text-center py-0">
                                <p class="mb-0">ِAre
                                    you sure you want to delete
                                    this
                                    X-Ray?</p><br>
                                <input type="hidden" name="lab_id_delete" value="">
                                <input type="hidden" name="lab_invoice_id_delete" value="">
                            </div>
                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link"
                                    data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="submit" class="btn btn-default btn-link text-red"><?php echo e(__('basic.delete')); ?>

                                </button>
                            </div>

                        </div>
                    </form>

                </div>
            </div>
        </div>

        </div>

        </div><!-- row end -->

        </div>
    <?php endif; ?>



    <!-- Content Row -->
    <div class="row">

        <!-- Appointments -->
        <div class="<?php if(Auth::user()->hasRole('Call-center')): ?> col <?php else: ?> col-lg-7 <?php endif; ?> page-break ">
            <div class="card shadow mb-4">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold"><?php echo e(__('patientappo.appointment timeline')); ?></h6>
                    <div class="dropdown no-arrow">
                        <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown"
                            aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                            aria-labelledby="dropdownMenuLink">
                            <div class="dropdown-header">Appointment controller:</div>
                            <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#add_past_app">Add
                                past Appointment</a>
                        </div>
                    </div>
                </div>

                <!-- Card Body -->
                <div class="card-body pb-2 overflow-scroll">

                    <?php if(count($appointments) > 0): ?>
                        <ul class="list-group patient-timeline">

                            <?php $__currentLoopData = $appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <?php if($item->status == 0): ?>
                                    <?php
                                        $text_color = 'not_accepted-color';
                                        $msg = __('patientappo.not accepted');
                                    ?>
                                <?php elseif($item->status == 1): ?>
                                    <?php
                                        $text_color = 'main-color';
                                        $msg = __('patientappo.accepted');
                                    ?>
                                <?php elseif($item->status == 2): ?>
                                    <?php
                                        $text_color = 'arrived-color';
                                        $msg = __('patientappo.arrived');
                                    ?>
                                <?php elseif($item->status == 3): ?>
                                    <?php
                                        $text_color = 'inprog-color';
                                        $msg = __('patientappo.with doctor');
                                    ?>
                                <?php elseif($item->status == 4): ?>
                                    <?php
                                        $text_color = 'done-color';
                                        $msg = __('patientappo.done appointment');
                                    ?>
                                <?php elseif($item->status == 5): ?>
                                    <?php
                                        $text_color = 'notresp-color';
                                        $msg = __('patientappo.not respond');
                                    ?>
                                <?php elseif($item->status == 6): ?>
                                    <?php
                                        $text_color = 'cancel-color';
                                        $msg = __('patientappo.canceled');
                                    ?>
                                <?php endif; ?>

                                <?php if($item->invoice): ?>
                                    <?php if($item->invoice->status == 0): ?>
                                        <?php
                                            $msg_invoice = __('basic.not paid');
                                        ?>
                                    <?php elseif($item->invoice->status == 1): ?>
                                        <?php
                                            $msg_invoice = __('basic.paid');
                                        ?>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <?php
                                        $msg_invoice = 'old appointment';
                                    ?>
                                <?php endif; ?>


                            <?php if($loop->index === 3) break; ?>

                            <li class="row flex-nowrap list-group-item d-flex justify-content-between position-relative">

                                <i
                                    class="col patient-timeline-pointer fas fa-circle text-xxs mb-0 <?php echo e($text_color); ?>"></i>

                                <div class="col me-1">
                                    <p class="text-xxs text-gray-200 mb-0">
                                        <?php echo e(date('h:i a', strtotime($item->start_at))); ?></p>
                                    <h6 class="text-s fw-bold <?php echo e($text_color); ?> mb-0">
                                        <?php echo e(date('d M Y', strtotime($item->start_at))); ?></h6>
                                    <p class="text-xs <?php echo e($text_color); ?> fw-bold mb-0">
                                        <?php echo e($msg . ', ' . $msg_invoice); ?>

                                    </p>
                                </div>

                                <div class="col text-center align-self-center me-1">
                                    <p class="text-xs text-gray-200 mb-0"><?php echo e(__('basic.type')); ?></p>
                                    <h6 class="text-s text-gray-400"><?php echo e($item->service_cat->name); ?></h6>
                                </div>

                                <div class="col text-center align-self-center me-1">
                                    <p class="text-xs text-gray-200 mb-0"><?php echo e(__('basic.doctor')); ?></p>
                                    <h6 class="text-s text-gray-400 text-truncate"><?php if(isset($item->doctor->first_name)): ?> <?php echo e($item->doctor->first_name); ?>  <?php else: ?> Not selected <?php endif; ?></h6>
                                </div>

                                <div class="col text-center align-self-center">
                                    <a data-id="<?php echo e($item->id); ?>" data-note_doctor="<?php echo e($item->note_doctor); ?>"
                                        class="text-s text-gray-400 clickable-item-pointer appointment_note_click">
                                        <i class="fas fa-info-circle m-1 fs-5"></i>
                                    </a>
                                </div>

                            </li>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </ul>

                    <!-- doctor note Modal -->
                    <div class="modal fade" id="appointment_note" tabindex="-1" aria-labelledby="exampleModalLabel2"
                        aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                            <div class="modal-content b-r-s-cont border-0">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel2"><i
                                            class="fas fa-quote-left me-1"></i>
                                        Appointment Doctor Note</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>

                                <form class="mb-0" action="<?php echo e(route('sett.app_appointment_note', 'sd')); ?>"
                                    method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>

                                    <!-- Modal content -->
                                    <div class="modal-body px-4">
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(__('basic.note')); ?>

                                                <small></small></label>
                                            <textarea id="appointment_note_input" name="note_appointment"
                                                class="form-control" placeholder="Write here your note .." rows="4"
                                                spellcheck="false" date-text="Write here your note .."></textarea>
                                        </div>
                                        <input type="hidden" name="note_appointment_id">
                                    </div>

                                    <div class="modal-footer">
                                        <div class="left-side">
                                            <button type="button" class="btn btn-default btn-link"
                                                data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                        </div>
                                        <div class="divider"></div>
                                        <div class="right-side">
                                            <button type="submit"
                                                class="btn btn-default btn-link main-color"><?php echo e(__('basic.save changes')); ?></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                    </div>



                <?php else: ?>
                    <div class="text-center">
                        <i class="bi bi-brightness-alt-high-fill fa-sm fa-fw fs-2"></i>
                        <p class="fw-light mb-0"><?php echo e(__('basic.nothing to show')); ?></p>
                    </div>
                    <?php endif; ?>
                </div>

                <!-- Card footer -->
                <div class="card-footer text-center ">
                    <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                        data-bs-target="#appointment_show">
                        <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                    </a>
                </div>


                <!-- Modal show all appointment -->
                <div class="modal fade" id="appointment_show" tabindex="-1" aria-labelledby="exampleModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
                        <div class="modal-content b-r-s-cont border-0">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel"><i
                                        class="fas fas fa-capsules me-1"></i>
                                    <?php echo e(__('basic.appointments')); ?></h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>

                            <!-- Modal content -->
                            <div class="modal-body px-4">

                                <div class="table-responsive">
                                    <table class="table display datatable-modal" id="table-appointment" width="100%"
                                        cellspacing="0">
                                        <thead>
                                            <tr>
                                                <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                                <th class="text-xs text-center"><?php echo e(__('basic.branch')); ?></th>
                                                <th class="text-xs text-center"><?php echo e(__('basic.doctor')); ?></th>
                                                <th class="text-xs text-center"><?php echo e(__('basic.start')); ?></th>
                                                <th class="text-xs text-center"><?php echo e(__('basic.end')); ?></th>
                                                <th class="text-xs text-center"><?php echo e(__('basic.status')); ?></th>
                                                <th class="text-xs text-center"><?php echo e(__('patientappo.pay status')); ?>

                                                </th>
                                                <th class="text-xs text-center"><?php echo e(__('patientappo.pay code')); ?></th>
                                                <th class="text-xs text-center"><?php echo e(__('basic.handle')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($item->status == 0): ?>
                                                    <?php
                                                        $text_color = 'not_accepted-color-btn';
                                                        $msg = __('patientappo.not accepted');
                                                    ?>

                                                <?php elseif($item->status == 1): ?>
                                                    <?php
                                                        $text_color = 'main-color-btn';
                                                        $msg = __('patientappo.accepted');
                                                    ?>
                                                <?php elseif($item->status == 2): ?>
                                                    <?php
                                                        $text_color = 'active-color-btn';
                                                        $msg = __('patientappo.arrived');
                                                    ?>
                                                <?php elseif($item->status == 3): ?>
                                                    <?php
                                                        $text_color = 'prog-color-btn';
                                                        $msg = __('patientappo.with doctor');
                                                    ?>
                                                <?php elseif($item->status == 4): ?>
                                                    <?php
                                                        $text_color = 'done-color-btn';
                                                        $msg = __('patientappo.done appointment');
                                                    ?>
                                                <?php elseif($item->status == 5): ?>
                                                    <?php
                                                        $text_color = 'pend-color-btn';
                                                        $msg = __('patientappo.not respond');
                                                    ?>
                                                <?php elseif($item->status == 6): ?>
                                                    <?php
                                                        $text_color = 'cancel-color-btn';
                                                        $msg = __('patientappo.canceled');
                                                    ?>
                                                <?php endif; ?>

                                                <?php if($item->invoice): ?>
                                                    <?php if($item->invoice->status == 0): ?>
                                                        <?php
                                                            $msg_invoice = __('basic.not paid');
                                                            $text_color_invoice = 'cancel-color-btn';
                                                        ?>
                                                    <?php elseif($item->invoice->status == 1): ?>
                                                        <?php
                                                            $msg_invoice = __('basic.paid');
                                                            $text_color_invoice = 'done-color-btn';
                                                        ?>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <?php
                                                        $msg_invoice = 'Old Appointment';
                                                        $text_color_invoice = 'done-color-btn';
                                                    ?>
                                                <?php endif; ?>

                                                <tr>
                                                    <td><?php echo e($item->service_cat->name); ?></td>
                                                    <td class="text-center"><?php echo e($item->branch->name); ?></td>
                                                    <td class="text-center"><?php if(isset($item->doctor->first_name)): ?>
                                                            <?php echo e($item->doctor->first_name); ?>

                                                        <?php endif; ?></td>
                                                    <td class="text-center">
                                                        <?php echo e(date('Y-m-d', strtotime($item->start_at))); ?> <br>
                                                        <?php echo e(date('h:i a', strtotime($item->start_at))); ?></td>
                                                    <td class="text-center">
                                                        <?php echo e(date('Y-m-d', strtotime($item->end_at))); ?> <br>
                                                        <?php echo e(date('h:i a', strtotime($item->end_at))); ?></td>
                                                    <td class="text-center"> <span
                                                            class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                                    </td>
                                                    <td class="text-center"> <span
                                                            class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span>
                                                    </td>
                                                    <td class="text-center"><?php if($item->invoice): ?><?php echo e($item->invoice->code); ?><?php endif; ?>
                                                    </td>

                                                    <td class="text-center">
                                                        <a data-id="<?php echo e($item->id); ?>"
                                                            data-note_doctor="<?php echo e($item->note_doctor); ?>"
                                                            class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 appointment_note_click"
                                                            title="edit"><i class="fas fa-pencil-alt"></i>
                                                            <?php echo e(__('basic.note')); ?> </a>
                                                    </td>

                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link"
                                        data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="button"
                                        class="btn btn-default btn-link main-color"><?php echo e(__('basic.save changes')); ?></button>
                                </div>
                            </div>

                        </div>
                    </div>

                </div>

                <!-- Modal for inserting the past appointments -->
                <div class="modal fade" id="add_past_app" tabindex="-1" role="dialog"
                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                        <div class="modal-content b-r-s-cont border-0">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                    <?php echo e(__('patientappo.last appointment')); ?></h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>

                            <form class="mb-0" action="<?php echo e(route('sett.app_past_appointment')); ?>"
                                method="post">
                                <?php echo e(method_field('POST')); ?>

                                <?php echo e(csrf_field()); ?>


                                <!-- Modal content -->
                                <div class="modal-body px-5 py-3">

                                    <div class="row mb-2">
                                        <div class="col-12 mb-2">
                                            <label class="form-label"><?php echo e(__('basic.branch')); ?>

                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                            <select
                                                class="myselect2-appo-insert select2-hidden-accessible <?php $__errorArgs = ['branch_appo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="branch_appo" name="branch_appo" required>
                                                <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($item->id); ?>">
                                                        <?php echo e($item->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>

                                            <span id="branch_appo_error" class="error-msg-form"></span>

                                            <?php $__errorArgs = ['branch_appo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                        </div>

                                        <div class="col-12 mb-2">
                                            <label class="form-label"><?php echo e(__('basic.status')); ?>

                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                            <select
                                                class="myselect2-appo-insert select2-hidden-accessible <?php $__errorArgs = ['responsible_doc_app'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="responsible_doc_app" name="responsible_doc_app" required>
                                                <?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($item->id); ?>">
                                                        <?php echo e($item->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>

                                            <span id="responsible_doc_app_error" class="error-msg-form"></span>

                                            <?php $__errorArgs = ['responsible_doc_app'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                        </div>

                                        <div class="col-12 mb-2">
                                            <label class="form-label"><?php echo e(__('basic.start')); ?>

                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text"><i
                                                            class="bi bi-calendar2-week-fill"></i> </div>
                                                </div>
                                                <input name="appo_date" type="text"
                                                    class="form-control datepicker_time bg-white <?php $__errorArgs = ['appo_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                    placeholder="YYYY/MM/DD HM" data-enable-time="true" required>
                                            </div>
                                            <span id="appo_date_error" class="error-msg-form"></span>

                                            <?php $__errorArgs = ['appo_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                    </div>

                                    <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                                </div>

                                <div class="modal-footer">
                                    <div class="left-side">
                                        <button type="button" class="btn btn-default btn-link"
                                            data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                    </div>
                                    <div class="divider"></div>
                                    <div class="right-side">
                                        <button type="submit" class="btn btn-default btn-link main-color">Add
                                            New</button>
                                    </div>
                                </div>
                            </form>

                        </div>
                    </div>

                </div>


            </div>
        </div>

        <?php if(auth()->check() && auth()->user()->hasRole('Super-admin|Doctor|Receptionist')): ?>
            <!-- Payment -->
            <div class="col-lg-5">
                <div class="card shadow mb-4">
                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <h6 class="m-0 fw-bold"><?php echo e(__('basic.payment')); ?></h6>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown"
                                aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <a class="dropdown-item" href="#">Action</a>
                                <a class="dropdown-item" href="#">Another action</a>
                            </div>
                        </div>
                    </div>
                    <!-- Card Body -->
                    <div class="card-body pb-2">

                        <?php if(count($invoices) > 0): ?>
                            <div class="d-flex justify-content-between">
                                <p class="text-xs text-gray-300"><?php echo e(__('patientappo.transaction')); ?></p>
                                <p class="text-xs text-gray-300"><?php echo e(__('basic.amount')); ?></p>
                            </div>


                            <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($loop->index === 3) break; ?>

                            <?php if($item->status == 0): ?>
                                <?php
                                    $text_color = 'cancel-color';
                                    $msg = __('basic.not paid');
                                ?>

                            <?php elseif($item->status == 1): ?>
                                <?php
                                    $text_color = 'main-color';
                                    $msg = __('basic.paid');
                                ?>
                            <?php endif; ?>

                            <div class="d-flex justify-content-between align-items-center mb-3">

                                <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                    <i class="fas fa-circle me-2 text-xxs mb-0 <?php echo e($text_color); ?>"></i>

                                    <div class="text-truncate">
                                        <a href="<?php echo e(route('sett.invoice.show', $item->id)); ?>"
                                            class="text-s text-truncate link-cust-text text-gray-500 mb-0 fw-bold">
                                            <?php echo e($item->categorizable->name); ?></a>
                                        <p class="text-xs text-gray-300 fw-bold mb-0"><?php echo e($msg); ?></p>
                                    </div>
                                </div>

                                <div class="text-s text-gray-600 fw-bold"><?php echo e($item->final_price); ?><small
                                        class="text-gray-300 text-xxxs">
                                        <?php echo e(__('basic.egp')); ?></small>
                                </div>

                            </div>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php else: ?>
                        <div class="text-center">
                            <i class="bi bi-brightness-alt-high-fill fa-sm fa-fw fs-2"></i>
                            <p class="fw-light mb-0"><?php echo e(__('basic.nothing to show')); ?></p>
                        </div>
                        <?php endif; ?>
                    </div>


                    <!-- Card footer -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#payment_show">
                            <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                        </a>
                    </div>


                    <!-- Modal show all invoices -->
                    <div class="modal fade" id="payment_show" tabindex="-1" aria-labelledby="exampleModalLabel"
                        aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
                            <div class="modal-content b-r-s-cont border-0">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel"><i
                                            class="fas fas fa-capsules me-1"></i>
                                        <?php echo e(__('basic.payment')); ?></h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>

                                <!-- Modal content -->
                                <div class="modal-body px-4">

                                    <div class="table-responsive">
                                        <table class="table display datatable-modal" id="table-payment" width="100%"
                                            cellspacing="0">
                                            <thead>
                                                <tr>
                                                    <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                                    <th class="text-xs text-center"><?php echo e(__('basic.code')); ?></th>
                                                    <th class="text-xs text-center"><?php echo e(__('basic.discount')); ?></th>
                                                    <th class="text-xs text-center"><?php echo e(__('patientappo.final price')); ?>

                                                    </th>
                                                    <th class="text-xs text-center"><?php echo e(__('basic.paid')); ?></th>
                                                    <th class="text-xs text-center"><?php echo e(__('basic.status')); ?></th>
                                                    <th class="text-xs text-center"><?php echo e(__('basic.date')); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($item->status == 0): ?>
                                                        <?php
                                                            $text_color_invoice = 'cancel-color-btn';
                                                            $msg_invoice = __('basic.not paid');
                                                        ?>
                                                    <?php elseif($item->status == 1): ?>
                                                        <?php
                                                            $text_color_invoice = 'done-color-btn';
                                                            $msg_invoice = __('basic.paid');
                                                        ?>
                                                    <?php endif; ?>

                                                    <tr>
                                                        <td><a class="link-cust-text text-gray-500"
                                                                href="<?php echo e(route('sett.invoice.show', $item->id)); ?>">
                                                                <?php echo e($item->categorizable->name); ?></a></td>
                                                        <td class="text-center"><?php echo e($item->code); ?></td>
                                                        <td class="text-center">
                                                            <?php if(!empty($item->discount)): ?>
                                                                <?php echo e($item->discount); ?> <small
                                                                    class="text-gray-300 text-xxxs">
                                                                    <?php echo e(__('basic.egp')); ?></small>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td class="text-center"><?php echo e($item->final_price); ?> <small
                                                                class="text-gray-300 text-xxxs">
                                                                <?php echo e(__('basic.egp')); ?></small></td>
                                                        <td class="text-center">
                                                            <?php if(!empty($item->paid)): ?>
                                                                <?php echo e($item->paid); ?> <small class="text-gray-300 text-xxxs">
                                                                    <?php echo e(__('basic.egp')); ?></small>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td class="text-center"> <span
                                                                class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span>
                                                        </td>
                                                        <td class="text-center">
                                                            <?php echo e(date('Y-m-d', strtotime($item->paid_date))); ?> <br>
                                                            <?php echo e(date('h:i a', strtotime($item->paid_date))); ?></td>

                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <div class="modal-footer">
                                    <div class="left-side">
                                        <button type="button" class="btn btn-default btn-link"
                                            data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                    </div>
                                    <div class="divider"></div>
                                    <div class="right-side">
                                        <button type="button"
                                            class="btn btn-default btn-link main-color"><?php echo e(__('basic.save changes')); ?></button>
                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>

                </div>
            </div>
        <?php endif; ?>
    </div>




    </div>


<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>

    <!-- select 2 -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {

            $("#checked00").prop('checked', true);


            $(".myselect2-medicine-insert").select2({
                dropdownParent: $("#addmedic")
            });

            //hide search
            $('.myselect2-medicine-insert-nosearch').select2({
                dropdownParent: $("#addmedic"),
                minimumResultsForSearch: -1
            });

            $(".myselect2-medicine-update").select2({
                dropdownParent: $("#medicine_edit")
            });

            //hide search
            $('.select2-no-search-medicine').select2({
                dropdownParent: $("#medicine_edit"),
                minimumResultsForSearch: -1
            });



            $(".myselect2-disease-insert").select2({
                dropdownParent: $("#adddisease")
            });

            $(".myselect2-disease-update").select2({
                dropdownParent: $("#disease_edit")
            });

            //hide search
            $('.select2-no-search-disease').select2({
                dropdownParent: $("#disease_edit"),
                minimumResultsForSearch: -1
            });


            $(".myselect2-treatment-insert").select2({
                dropdownParent: $("#addtreatment")
            });

            $(".myselect2-treatment-update").select2({
                dropdownParent: $("#treatment_edit")
            });

            //hide search
            $('.select2-no-search-treatment').select2({
                dropdownParent: $("#treatment_edit"),
                minimumResultsForSearch: -1
            });



            $(".myselect2-session-insert").select2({
                dropdownParent: $("#addsession")
            });

            $(".myselect2-session-insert-nosearch").select2({
                dropdownParent: $("#addsession"),
                minimumResultsForSearch: -1
            });

            $(".myselect2-session-update").select2({
                dropdownParent: $("#session_edit")
            });
            //hide search
            $('.select2-no-search-session').select2({
                dropdownParent: $("#session_edit"),
                minimumResultsForSearch: -1
            });



            $(".myselect2-lab-insert").select2({
                dropdownParent: $("#adddxـray")
            });


            $(".myselect2-appo-insert").select2({
                dropdownParent: $("#add_past_app")
            });

            //hide search
            $('.myselect2-appo-insert-nosearch').select2({
                dropdownParent: $("#add_past_app"),
                minimumResultsForSearch: -1
            });


        });
    </script>

    <!-- datapicker date and time -->
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script>
        // without jquery
        //flatpickr('.datepicker', {
        // put options here if your don't want to add them via data- attributes
        //});

        // with jquery
        $('.datepicker_time').flatpickr({
            enableTime: true,
            dateFormat: "Y-m-d H:i",
        });
    </script>

    <!-- jquery ui datepicker -->
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
    <script>
        $(function() {
            $('.hasdatetimepicker').datepicker({
                todayHighlight: true,
                format: "yyyy-mm-dd",
            });
        });
    </script>

    <script>
        // ----------------- mediciens modals -----------------

        //mediciens modals edit
        $(".medicine_edit_click").on('click', function() {

            var medicine_id = $(this).data("medicine_id");

            var medicinescats_id = $(this).data("medicinescats_id");
            var status_medicine = $(this).data("status_medicine");
            var start = $(this).data("start");
            var end = $(this).data("end");

            $("#medicine_pills_update").select2("val", String(medicinescats_id));

            $("#status_medicine_update").select2("val", String(status_medicine));

            $('input[name = "medicine_start_update"]').val(start);
            $('input[name = "medicine_end_update"]').val(end);
            $('input[name = "medicine_id_update"]').val(medicine_id);

            $('.modal').modal('hide');
            $('#medicine_edit').modal('show');

        });

        //mediciens modals delete
        $(".medicine_delete_click").on('click', function() {

            var medicine_id = $(this).data("medicine_id");

            $('input[name = "medicine_id_delete"]').val(medicine_id);

            $('.modal').modal('hide');
            $('#medicine_delete').modal('show');

        });

        // ----------------- diseases modals -----------------

        var patient_id = '<?php echo e($patient->id); ?>';

        $(".exam_appointment").on('click', function() {

            var appointment_id = $(this).data("id");

            $('.modal').modal('hide');
            $('#disease_exam_show').modal('show');

            var url = "<?php echo e(route('sett.pat_show_pati_prof_exam', [':appointment_id', ':patient_id'])); ?>";
            url = url.replace(':appointment_id', appointment_id).replace(':patient_id', patient_id);

            $.ajax({
                url: url,
                type: "GET",
                dataType: "json",
                success: function(data) {
                    $("#exam-front").html('');
                    $("#exam-back").html('');
                    $("#exam-note").html('');
                    $("#exam-date").html('');
                    $("#exam-doctor").html('');

                    if (data.disease_draw) {

                        if (!data.disease_draw.front) {
                            var front =
                                '<div class="ms-4 text-center main-color-bg text-white p-2 b-r-s-cont" style=" solid;position: absolute;top:13rem;left:3rem;"> No Front Draw </div>';
                        } else {
                            draw_front = '<?php echo e(URL::asset('img/diseasedraw/')); ?>';
                            var front = '<img src="' + draw_front + '/' + data.disease_draw.front +
                                '" width="255" height="457" style=" solid;position: absolute;top:0;left:0;">';;
                        }

                        $("#exam-front").html(front);

                        if (!data.disease_draw.front) {
                            var front =
                                '<div class="ms-4 text-center main-color-bg text-white p-2 b-r-s-cont" style=" solid;position: absolute;top:13rem;left:3rem;"> No Back Draw </div>';
                        } else {
                            draw_back = '<?php echo e(URL::asset('img/diseasedraw/')); ?>';
                            var front = '<img src="' + draw_back + '/' + data.disease_draw.back +
                                '" width="255" height="457" style=" solid;position: absolute;top:0;left:0;">';;
                        }

                        $("#exam-back").html(front);

                        if (!data.disease_draw.back) {
                            var note = "Not Selected";
                        } else {
                            var note = data.disease_draw.note;
                        }
                        $("#exam-note").html(note);

                        if (!data.disease_draw.note) {
                            var note = "Not Selected";
                        } else {
                            var note = data.disease_draw.note;
                        }
                        $("#exam-note").html('note');

                        if (!data.disease_draw.appointment.start_at) {
                            var start_at = "Not Selected";
                        } else {
                            var start_at = data.disease_draw.appointment.start_at;
                        }
                        $("#exam-date").html(start_at);

                        if (!data.disease_draw.appointment.doctor.name) {
                            var doctor = "Not Selected";
                        } else {
                            var doctor = data.disease_draw.appointment.doctor.name;
                        }
                        $("#exam-doctor").html(doctor);
                    } else {

                    }

                    if (data.disease) {
                        var html = '';

                        $.each(data.disease, function(key, value) {

                            if (value.status == 0) {
                                text_color = 'active-color-btn';
                                msg = __('patientappo.still');
                            } else if (value.status == 1) {
                                text_color = 'done-color-btn';
                                msg = __('patientappo.healed');
                            }

                            html += '<tr>';
                            html += '<td class="w-25">' + value.diseasecats.name + '</td>';
                            html += '<td>' + value.start + '</td>';
                            html += '<td>' + value.end + '</td>';
                            html += '<td class="text-center"><span class="badge rounded-pill ' +
                                text_color +
                                ' badge-padd-l">' + msg + '</td>';

                            html += '<td class="text-center"><a data-disease_id="' + value.id +
                                '" data-diseasecats_id="' + value.diseasecats.id +
                                '" data-status_disease="' + value.status + '" data-start="' +
                                value.start + '" data-end="' + value.end +
                                '" class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 disease_edit_click" title="edit"><i class="fas fa-pencil-alt"></i> <?php echo e(__('basic.edit')); ?></a> ' +
                                '<a data-disease_id="' + value.id +
                                '" class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 disease_delete_click" title="delete" data-effect="effect-scale"><i class="fas fa-trash"></i> <?php echo e(__('basic.delete')); ?> </a>' +
                                '</td>';

                            html += '</tr>';


                        })

                        $("#exam-table").html(html);
                    }

                }

            })

        });

        //disease modals edit
        $(document).on('click', ".disease_edit_click", function() {

            var disease_id = $(this).data("disease_id");

            var diseasecats_id = $(this).data("diseasecats_id");
            var status_disease = $(this).data("status_disease");
            var start = $(this).data("start");
            var end = $(this).data("end");

            $("#disease_cat_update").select2("val", String(diseasecats_id));

            $("#status_disease_update").select2("val", String(status_disease));

            $('input[name = "disease_start_update"]').val(start);
            $('input[name = "disease_end_update"]').val(end);
            $('input[name = "disease_id_update"]').val(disease_id);

            $('.modal').modal('hide');
            $('#disease_edit').modal('show');

        });

        //disease modals delete
        $(document).on('click', ".disease_delete_click", function() {

            var disease_id = $(this).data("disease_id");

            $('input[name = "disease_id_delete"]').val(disease_id);

            $('.modal').modal('hide');
            $('#disease_delete').modal('show');

        });

        // ----------------- treatment modals -----------------
        //treatment modals edit
        $(".treatment_edit_click").on('click', function() {

            var treatment_id = $(this).data("treatment_id");

            var treatment_cat_id = $(this).data("treatment_cat_id");
            var status_treatment = $(this).data("status_treatment");
            var sessions = $(this).data("sessions");
            var sessions_done = $(this).data("sessions_done");
            var start = $(this).data("start");
            var end = $(this).data("end");

            $("#treatment_cat_update").select2("val", String(treatment_cat_id));

            $("#status_treatment_update").select2("val", String(status_treatment));


            $('input[name = "treatment_session_update"]').val(sessions);
            $('input[name = "treatment_session_done_update"]').val(sessions_done);
            $('input[name = "treatment_start_update"]').val(start);
            $('input[name = "treatment_end_update"]').val(end);
            $('input[name = "treatment_id_update"]').val(treatment_id);

            $('.modal').modal('hide');
            $('#treatment_edit').modal('show');

        });

        $(".treatment_newsession_click").on('click', function() {

            var treatment_id = $(this).data("treatment_id");
            $('#related_treatment_id').select2("val", String(treatment_id));

            $('.modal').modal('hide');
            $('#addsession').modal('show');

        });


        //treatment modals delete
        $(".treatment_delete_click").on('click', function() {

            var treatment_id = $(this).data("treatment_id");

            $('input[name = "treatment_id_delete"]').val(treatment_id);

            $('.modal').modal('hide');
            $('#treatment_delete').modal('show');

        });


        // ----------------- session modals -----------------

        //session modals edit
        $(".session_edit_click").on('click', function() {

            var session_id = $(this).data("session_id");
            var status_session = $(this).data("status_session");
            var treat_id = $(this).data("treat_id");

            $("#status_session_update").select2("val", String(status_session));
            $("#related_treatment_id_update").select2("val", String(treat_id));

            $('input[name = "session_id_update"]').val(session_id);

            $('.modal').modal('hide');
            $('#session_edit').modal('show');
        });

        //session modals delete
        $(".session_delete_click").on('click', function() {

            var session_id = $(this).data("session_id");

            $('input[name = "session_id_delete"]').val(session_id);

            $('.modal').modal('hide');
            $('#session_delete').modal('show');

        });


        // ----------------- Lab modals -----------------

        //lab modals delete
        $(".lab_delete_click").on('click', function() {

            var lab_id = $(this).data("lab_id");
            var invoice_id = $(this).data("invoice_id");

            $('input[name = "lab_id_delete"]').val(lab_id);
            $('input[name = "lab_invoice_id_delete"]').val(invoice_id);

            $('.modal').modal('hide');
            $('#lab_delete').modal('show');

        });


        // ----------------- Lab modals -----------------

        //lab modals delete
        $(".appointment_note_click").on('click', function() {

            var id = $(this).data("id");
            var note = $(this).data("note_doctor");

            $('input[name = "note_appointment_id"]').val(id);
            $('#appointment_note_input').val(note);

            $('.modal').modal('hide');
            $('#appointment_note').modal('show');

        });
    </script>

    <!-- -- datatables plugin -- -->
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.bootstrap5.min.js"></script>

    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>

    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.colVis.min.js"></script>

    <script>
        $(document).ready(function() {

            //------ medicine table
            var table = $('#table-medicine').DataTable({
                    lengthChange: false,

                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: ['copy', 'excel', 'pdf']
                    }
                }

            );
            table.buttons().container()
                .appendTo('#table-medicine_wrapper .col-md-6:eq(0)');

            //------ disease table
            var table = $('#table-disease').DataTable({
                    lengthChange: false,

                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0'
                            }
                        },
                        buttons: ['copy', 'excel', 'pdf']
                    }
                }

            );
            table.buttons().container()
                .appendTo('#table-disease_wrapper .col-md-6:eq(0)');

            var table = $('#table-disease-exam').DataTable({
                    lengthChange: false,

                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0'
                            }
                        },
                        buttons: ['copy', 'excel', 'pdf']
                    }
                }

            );
            table.buttons().container()
                .appendTo('#table-disease-exam_wrapper .col-md-6:eq(0)');

            //------ treatment table
            var table = $('#table-treatment').DataTable({
                    lengthChange: false,

                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0'
                            }
                        },
                        buttons: ['copy', 'excel', 'pdf']
                    }
                }

            );
            table.buttons().container()
                .appendTo('#table-treatment_wrapper .col-md-6:eq(0)');


            //------ session table
            var table = $('#table-session').DataTable({
                    lengthChange: false,

                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0'
                            }
                        },
                        buttons: ['copy', 'excel', 'pdf']
                    }
                }

            );
            table.buttons().container()
                .appendTo('#table-session_wrapper .col-md-6:eq(0)');


            //------ lab table
            var table = $('#table-lab').DataTable({
                    lengthChange: false,
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0'
                            }
                        },
                        buttons: ['copy', 'excel', 'pdf']
                    }
                }

            );
            table.buttons().container()
                .appendTo('#table-lab_wrapper .col-md-6:eq(0)');


            //------ appointment table
            var table = $('#table-appointment').DataTable({
                    lengthChange: false,
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0'
                            }
                        },
                        buttons: ['copy', 'excel', 'pdf']
                    }
                }

            );
            table.buttons().container()
                .appendTo('#table-appointment_wrapper .col-md-6:eq(0)');

            //------ payment table
            var table = $('#table-payment').DataTable({
                    lengthChange: false,
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0'
                            }
                        },
                        buttons: ['copy', 'excel', 'pdf']
                    }
                }

            );
            table.buttons().container()
                .appendTo('#table-payment_wrapper .col-md-6:eq(0)');


        });
    </script>

    <script>
        //patient note
        $(document).ready(function() {

            var id = '<?php echo e($patient->id); ?>';

            //update note
            $(document).on('click', '#note_ajax', function() {

                var query_text = $("textarea[name='note']").val();

                var url = "<?php echo e(route('sett.pat_note_ajax', ':id')); ?>";
                url = url.replace(':id', id);

                $.ajax({
                    url: url,
                    type: "POST",
                    data: {

                        '_token': "<?php echo e(csrf_token()); ?>",
                        '_method': "PATCH",
                        'query': query_text,
                    },
                    success: function(data) {}
                });
            });


        });

        //current Current Medicines
    </script>



    <script>
        // diseases draws
        var $canvas = $('#canvas');
        var $canvas_b = $('#canvas_b');
        var ctx = $canvas[0].getContext('2d');
        var ctx_b = $canvas_b[0].getContext('2d');
        var color = '#000000';
        var color_b = '#000000';

        $('.color-selector-draw').on('click', function(e) {
            color = $(this).data('color');
        });

        $('.color-selector-draw_b').on('click', function(e) {
            color_b = $(this).data('color');
        });

        //---- front draw ----
        $(document).ready(function() {
            var flag, dot_flag = false,
                prevX, prevY, currX, currY = 0,
                thickness = 4;

            $canvas.on('mousemove mousedown mouseup mouseout', function(e) {
                prevX = currX;
                prevY = currY;
                currX = e.clientX - canvas.getBoundingClientRect().left;
                currY = e.clientY - canvas.getBoundingClientRect().top;

                if (e.type == 'mousedown') {
                    flag = true;
                }
                if (e.type == 'mouseup' || e.type == 'mouseout') {
                    flag = false;
                }
                if (e.type == 'mousemove') {
                    if (flag) {
                        ctx.beginPath();
                        ctx.moveTo(prevX, prevY);
                        ctx.lineTo(currX, currY);
                        ctx.strokeStyle = color;
                        ctx.lineWidth = thickness;
                        ctx.stroke();
                        ctx.closePath();
                    }
                }
            });
        });

        // Set up touch events for mobile, etc
        canvas.addEventListener("touchstart", function(e) {
            mousePos = getTouchPos(canvas, e);
            var touch = e.touches[0];
            var mouseEvent = new MouseEvent("mousedown", {
                clientX: touch.clientX,
                clientY: touch.clientY
            });
            canvas.dispatchEvent(mouseEvent);
        }, false);
        canvas.addEventListener("touchend", function(e) {
            var mouseEvent = new MouseEvent("mouseup", {});
            canvas.dispatchEvent(mouseEvent);
        }, false);
        canvas.addEventListener("touchmove", function(e) {
            var touch = e.touches[0];
            var mouseEvent = new MouseEvent("mousemove", {
                clientX: touch.clientX,
                clientY: touch.clientY
            });
            canvas.dispatchEvent(mouseEvent);
        }, false);

        // Get the position of a touch relative to the canvas
        function getTouchPos(canvasDom, touchEvent) {
            var rect = canvasDom.getBoundingClientRect();
            return {
                x: touchEvent.touches[0].clientX - rect.left,
                y: touchEvent.touches[0].clientY - rect.top
            };
        }

        //Prevent scrolling when touching the canvas
        document.body.addEventListener("touchstart", function(e) {
            if (e.target == canvas) {
                e.preventDefault();
            }
        }, false);
        document.body.addEventListener("touchend", function(e) {
            if (e.target == canvas) {
                e.preventDefault();
            }
        }, false);
        document.body.addEventListener("touchmove", function(e) {
            if (e.target == canvas) {
                e.preventDefault();
            }
        }, false);


        //---- back draw ----
        $(document).ready(function() {
            var flag, dot_flag = false,
                prevX, prevY, currX, currY = 0,
                thickness = 4;

            $canvas_b.on('mousemove mousedown mouseup mouseout', function(e) {
                prevX = currX;
                prevY = currY;
                currX = e.clientX - canvas_b.getBoundingClientRect().left;
                currY = e.clientY - canvas_b.getBoundingClientRect().top;

                if (e.type == 'mousedown') {
                    flag = true;
                }
                if (e.type == 'mouseup' || e.type == 'mouseout') {
                    flag = false;
                }
                if (e.type == 'mousemove') {
                    if (flag) {
                        ctx_b.beginPath();
                        ctx_b.moveTo(prevX, prevY);
                        ctx_b.lineTo(currX, currY);
                        ctx_b.strokeStyle = color_b;
                        ctx_b.lineWidth = thickness;
                        ctx_b.stroke();
                        ctx_b.closePath();
                    }
                }
            });

            // Set up touch events for mobile, etc
            canvas_b.addEventListener("touchstart", function(e) {
                mousePos = getTouchPos(canvas_b, e);
                var touch = e.touches[0];
                var mouseEvent = new MouseEvent("mousedown", {
                    clientX: touch.clientX,
                    clientY: touch.clientY
                });
                canvas_b.dispatchEvent(mouseEvent);
            }, false);
            canvas_b.addEventListener("touchend", function(e) {
                var mouseEvent = new MouseEvent("mouseup", {});
                canvas_b.dispatchEvent(mouseEvent);
            }, false);
            canvas_b.addEventListener("touchmove", function(e) {
                var touch = e.touches[0];
                var mouseEvent = new MouseEvent("mousemove", {
                    clientX: touch.clientX,
                    clientY: touch.clientY
                });
                canvas_b.dispatchEvent(mouseEvent);
            }, false);

            // Get the position of a touch relative to the canvas
            function getTouchPos(canvasDom, touchEvent) {
                var rect = canvasDom.getBoundingClientRect();
                return {
                    x: touchEvent.touches[0].clientX - rect.left,
                    y: touchEvent.touches[0].clientY - rect.top
                };
            }

            //Prevent scrolling when touching the canvas
            document.body.addEventListener("touchstart", function(e) {
                if (e.target == canvas_b) {
                    e.preventDefault();
                }
            }, false);
            document.body.addEventListener("touchend", function(e) {
                if (e.target == canvas_b) {
                    e.preventDefault();
                }
            }, false);
            document.body.addEventListener("touchmove", function(e) {
                if (e.target == canvas_b) {
                    e.preventDefault();
                }
            }, false);

        });

        $('#canvas-clear').on('click', function(e) {
            c_width = $canvas.width();
            c_height = $canvas.height();
            ctx.clearRect(0, 0, c_width, c_height);
            $('#canvasimg').hide();
        });


        $('#canvas-clear_b').on('click', function(e) {
            c_width_b = $canvas_b.width();
            c_height_b = $canvas_b.height();
            ctx_b.clearRect(0, 0, c_width_b, c_height_b);
            $('#canvasimg_b').hide();
        });

        //save the canv draw to input
        $('#imgsave').on('click', function(e) {

            //var image = canvas.toDataURL("image/png").replace("image/png",); // here is the most important part because if you dont replace you will get a DOM 18 exception.
            var image = new Image();
            image.src = canvas.toDataURL("image/png");

            //document.getElementById("finalImg").src = image.src;
            document.getElementById("front_input").value = image.src;

            //change the save icon
            $('#icon_save').addClass('fa-check-double').removeClass('fa-check');

        });

        //save the canv draw to input
        $('#imgsave_b').on('click', function(e) {

            var image_b = new Image();
            image_b.src = canvas_b.toDataURL("image/png");
            document.getElementById("back_input").value = image_b.src;

            //change the save icon
            $('#icon_save_b').addClass('fa-check-double').removeClass('fa-check');
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/patient/show2.blade.php ENDPATH**/ ?>