<?php $__env->startSection('title', 'Complaint | Suggestion | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Complaint | Suggestion'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

    <!-- select 2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <!-- boostrap datepicker -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<?php $__env->stopSection(); ?>

<?php $__env->startSection('fixedcontent'); ?>

    <!-- session successful message -->
    <?php if(Session::has('success')): ?>
        <div id="flash-msg" class="shadow pt-3">
            <div class="d-flex justify-content-between mb-2">
                <i class="fas fs-1 fa-check"></i>
                <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
            </div>
            <h3>Sent Successfully</h3>
            <p class="text-blue-300"><?php echo e(Session::get('success')); ?></p>
        </div>
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>

    <div class="container-fluid px-0 px-md-2 mt-3">

        <!-- page title link -->
        <div class="d-flex align-items-center justify-content-between mb-3">
            <span class="mb-0 me-1">
                <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>">Dashboard |</a>
                <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.complaint.index')); ?>">Complaint |
                </a>
                <a class="text-gray-300">Complaint</a>
            </span>

            <?php if(auth()->check() && auth()->user()->hasRole('Super-admin|Hr')): ?>
                <div class="d-flex justify-content-center">

                    <a class=" main-color-bg text-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-1" data-bs-toggle="modal"
                        data-bs-target="#new_record"><i class="fas fa-plus fa-sm me-1"></i> Update</a>
                </div>

                <!-- Modal for paying -->
                <div class="modal fade" id="new_record" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                        <form class="mb-0" action="<?php echo e(route('sett.complaint.update', $complaints->id)); ?>"
                            method="POST">

                            <?php echo method_field('PUT'); ?>
                            <?php echo csrf_field(); ?>

                            <div class="modal-content b-r-s-cont border-0">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-clipboard me-1"></i>
                                        Update Complaint | Suggestion</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>


                                <!-- Modal content -->
                                <div class="modal-body px-5 py-3">

                                    <div class="row">

                                        <div class="col-12 mb-2">
                                            <label class="form-label">Type
                                                <small>(required)</small></label>
                                            <select
                                                class="myselect2-record-insert myselect2-record-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="type" name="type" required>
                                                <option <?php if($complaints->status == 0): ?> selected <?php endif; ?> value="0">Unsolved
                                                </option>
                                                <option <?php if($complaints->status == 1): ?> selected <?php endif; ?> value="1">Solved
                                                </option>
                                            </select>

                                            <span id="type_error" class="error-msg-form"></span>

                                            <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                        </div>

                                        <div class="col-12 mb-2">
                                            <label class="form-label">Answer
                                                <small>(required)</small></label>
                                            <textarea name="answer" class="form-control"
                                                placeholder="Write here your notes .." rows="4"
                                                spellcheck="false"><?php echo e($complaints->answered); ?></textarea>
                                            <span id="answer" class="error-msg-form"></span>

                                            <?php $__errorArgs = ['answer'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                    </div>

                                </div>

                                <div class="modal-footer">
                                    <div class="left-side">
                                        <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">Never
                                            Mind</button>
                                    </div>
                                    <div class="divider"></div>
                                    <div class="right-side">
                                        <button type="submit" class="btn btn-default btn-link main-color">Update</button>
                                    </div>
                                </div>
                            </div>
                        </form>

                    </div>

                </div>
            <?php endif; ?>


        </div>

        <div class="card card-input shadow mb-3 pb-3">
            <!-- Card Header - Dropdown -->
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-box-open me-1"></i> Complaint | Suggestion</h6>
            </div>

            <!-- Card Body -->
            <div class="card-body px-4 px-md-5">

                <div class="row px-0 px-md-3 px-lg-5 pt-3">

                    <div class="col-7 col-md-6 mb-2">
                        <div class="row mb-2 mb-md-0">
                            <div class="d-flex mb-2 align-items-center px-0">
                                <img class="rounded-circle avatar-m me-2"
                                    src="<?php echo e(URL::asset('img/useravatar/' . $complaints->appointment->patient->avatar)); ?>">
                                <div class="">
                                    <p class="mb-0 text-xs text-gray-300"> Appo Date
                                        <?php echo e(date('h:i a d M Y', strtotime($complaints->appointment->start_at))); ?></p>
                                    <a href="<?php echo e(route('sett.complaint.show', $complaints->appointment->patient->id)); ?>"
                                        class="mb-1 fw-bold fs-6 text-gray-600"><?php echo e($complaints->appointment->patient->name); ?></a>
                                    <p class="mb-0 text-xs text-gray-400">Phone <strong>
                                            <?php echo e($complaints->appointment->patient->phone_number); ?></strong>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-5 col-md-2 align-self-center">
                        <div class="">
                            <h6 class="text-gray-300 text-xs mb-1">Doctor</h6>
                            <p id="addre_final_info" class="text-gray-600 text-s fw-bold mb-0">
                                <?php if($complaints->appointment->doctor): ?>
                                    <?php echo e($complaints->appointment->doctor->name); ?>

                                <?php else: ?>
                                    No Doctor
                                <?php endif; ?>
                            </p>
                        </div>
                    </div>

                    <div class="col-6 col-md-2 align-self-center">
                        <div class="">
                            <h6 class="text-gray-300 text-xs mb-1">Creator</h6>
                            <p id="addre_final_info" class="text-gray-600 text-s fw-bold mb-0">
                                <?php echo e($complaints->appointment->creator->name); ?>

                            </p>
                        </div>
                    </div>

                    <div class="col-6 col-md-2 align-self-center">
                        <div class="">
                            <h6 class="text-gray-300 text-xs mb-1">Status</h6>
                            <p id="addre_final_info" class="text-gray-600 fs-6 fw-bold mb-0">
                                <?php if($complaints->status == 0): ?>
                                    <span class="badge rounded-pill cancel-color-btn badge-padd-l">
                                        Unsolved
                                    </span>
                                <?php else: ?>
                                    <span class="badge rounded-pill done-color-btn badge-padd-l">
                                        Solved
                                    </span>
                                <?php endif; ?>
                            </p>
                        </div>
                    </div>


                </div>

                <hr>

                <ul class="list-group patient-timeline">

                    <li class="row flex-nowrap list-group-item d-flex justify-content-between position-relative">
                        <i class="col patient-timeline-pointer fas fa-circle text-xxs mb-0 main-color"
                            style="top: 21px;"></i>

                        <div class="col me-1">
                            <p class="text-xs text-gray-400 mb-0">
                                <?php echo e(date('d M Y', strtotime($complaints->updated_at))); ?></p>
                            <h6 class="text-s fw-bold mb-0">Answer</h6>
                        </div>

                        <div class="col me-1">
                            <h6 class="text-s text-gray-700 mb-0">
                                <?php if(!empty($complaints->answered)): ?>
                                    <?php echo e($complaints->answered); ?>

                                <?php else: ?>
                                    No Answer Yet
                                <?php endif; ?>
                            </h6>
                        </div>
                    </li>

                    <li class="row flex-nowrap list-group-item d-flex justify-content-between position-relative">
                        <i class="col patient-timeline-pointer fas fa-circle text-xxs mb-0 main-color"
                            style="top: 21px;"></i>

                        <div class="col me-1">
                            <p class="text-xs text-gray-400 mb-0">
                                <?php echo e(date('d M Y', strtotime($complaints->created_at))); ?></p>
                            <h6 class="text-s fw-bold mb-0">Complaint | Suggestion</h6>
                        </div>

                        <div class="col me-1">
                            <h6 class="text-s mb-0 text-gray-700"><?php echo e($complaints->body); ?></h6>
                        </div>
                    </li>

                </ul>

            </div>

        </div>

    </div>

<?php $__env->stopSection(); ?>

<!-- js insert -->
<?php $__env->startSection('js'); ?>
    <!-- select 2 -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {

            $(".myselect2-record-insert").select2({
                dropdownParent: $("#new_record")
            });

            //hide search
            $('.myselect2-record-insert-nosearch').select2({
                dropdownParent: $("#new_record"),
                minimumResultsForSearch: -1
            });

        })
    </script>

    <!-- jquery ui datepicker -->
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
    <script>
        $(function() {
            $('.hasdatetimepicker').datepicker({
                todayHighlight: true,
                format: "yyyy-mm-dd",
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/branch/complaint/show.blade.php ENDPATH**/ ?>