<!-- treatments and sessions -->
<div class="col-12 col-lg-4">
    <div class="card shadow mb-4">

        <div id="treat-session" class="carousel slide curr-treament-info-carousel" data-bs-ride="carousel"
            data-bs-interval="false">

            <div class="carousel-indicators dots-radius-carousel" style="bottom: 34px; margin-bottom: 0px;">
                <button type="button" data-bs-target="#treat-session" data-bs-slide-to="0" class="active"
                    aria-current="true" aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#treat-session" data-bs-slide-to="1"
                    aria-label="Slide 2"></button>
                <button type="button" data-bs-target="#treat-session" data-bs-slide-to="2"
                    aria-label="Slide 3"></button>
                <button type="button" data-bs-target="#treat-session" data-bs-slide-to="3"
                    aria-label="Slide 4"></button>
            </div>

            <div class="carousel-inner">

                <!-- Current treatments -->
                <div class="carousel-item active">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span
                                class="m-0 fs-6 me-2 fw-bold clickable-item-pointer"><?php echo e(__('basic.treatments')); ?></span>
                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="1" aria-label="Slide 2">
                                <?php echo e(__('patientappo.sessions')); ?></span>
                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="2" aria-label="Slide 3">
                                <?php echo e(__('basic.laser')); ?></span>
                            <span class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="3" aria-label="Slide 4">
                                <?php echo e(__('basic.package')); ?></span>
                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#addtreatment"><?php echo e(__('patientappo.new treatment')); ?></a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->

                    <?php if(!$patient->treatments->isEmpty()): ?>
                        <div class="card-body pb-4">

                            <?php $__currentLoopData = $patient->treatments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                
                                <?php if($loop->index === 3) break; ?>

                                <?php if($item->status == 0): ?>
                                    <?php
                                        $text_color = 'main-color';
                                        $msg = __('basic.in prog');
                                    ?>
                                <?php elseif($item->status == 1): ?>
                                    <?php
                                        $text_color = 'done-color-btn';
                                        $msg = __('patientappo.done');
                                    ?>
                                <?php endif; ?>

                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                        <i class="fas fa-circle me-2 text-xxs mb-0 <?php echo e($text_color); ?>"></i>

                                        <div class="text-truncate">
                                            <h6 class="text-s fw-bold text-gray-700  mb-0">
                                                <?php echo e($item->treatment_cat->name); ?></h6>
                                            <p class="text-xs text-gray-300 fw-bold mb-0"><?php echo e($msg); ?></p>
                                        </div>
                                    </div>

                                    <div class="text-s text-gray-600 fw-bold"><?php echo e($item->sessions); ?><small
                                            class="text-gray-300 text-xxxs">
                                            Sesi</small>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <div class="card-body align-items-center text-center position-relative">
                            <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                                data-bs-toggle="modal" data-bs-target="#addtreatment">
                                <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                                <p class="fw-light mb-0">You can put your Treatment</p>
                            </a>
                        </div>
                    <?php endif; ?>

                    <!-- Card footer -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300 clickable-item-pointer" data-bs-toggle="modal"
                            data-bs-target="#treatment_show">
                            <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                        </a>
                    </div>

                </div>


                <!----------- sessions start content ----------->
                <div class="carousel-item">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span
                                class="m-0 fs-6 me-2 fw-bold clickable-item-pointer"><?php echo e(__('patientappo.sessions')); ?></span>
                            <span
                                class="m-0 text-x me-2 link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="2" aria-label="Slide 3">
                                <?php echo e(__('basic.laser')); ?></span>
                            <span
                                class="m-0 text-x me-2 link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="3" aria-label="Slide 4">
                                <?php echo e(__('basic.package')); ?></span>
                            <span class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="0" aria-label="Slide 1">
                                <?php echo e(__('basic.treatments')); ?></span>
                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#addsession"><?php echo e(__('patientappo.new session')); ?></a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->
                    <?php if(!$patient->sessions->isEmpty()): ?>
                        <div id="medicine_card_home" class="card-body align-items-center">

                            <?php $__currentLoopData = $patient->sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                
                            <?php if($loop->index === 3) break; ?>

                                <?php if($item->status == 0): ?>
                                    <?php
                                        $text_color = 'main-color';
                                        $msg = __('patientappo.not done');
                                    ?>
                                <?php elseif($item->status == 1): ?>
                                    <?php
                                        $text_color = 'done-color-btn';
                                        $msg = __('patientappo.done');
                                    ?>
                                <?php endif; ?>

                                <?php if($item->invoice_item): ?>
                                <?php if($item->invoice_item->invoice->status == 0): ?>
                                <?php
                                    $text_color_invoice = 'cancel-color-btn';
                                    $msg_invoice = __('basic.not paid');
                                ?>
                            <?php elseif($item->invoice_item->invoice->status == 1): ?>
                                <?php
                                    $text_color_invoice = 'pend-color-btn';
                                    $msg_invoice = __('basic.pending');
                                ?>
                            <?php elseif($item->invoice_item->invoice->status == 2): ?>
                            <?php
                                $text_color_invoice = 'prog-color-btn';
                                $msg_invoice = __('basic.installment');
                            ?>
                            <?php elseif($item->invoice_item->invoice->status == 3): ?>
                                <?php
                                    $text_color_invoice = 'done-color-btn';
                                    $msg_invoice = __('basic.paid');
                                ?>
                            <?php elseif($item->invoice_item->invoice->status == 4): ?>
                                <?php
                                    $text_color_invoice = 'cancel-color-btn';
                                    $msg_invoice = __('basic.refund');
                                ?>
                            <?php endif; ?>
                                <?php else: ?>
                                    <?php
                                        $text_color_invoice = 'done-color-btn';
                                        $msg_invoice = __('patientappo.old record');
                                    ?>
                                <?php endif; ?>
                                <div class="d-flex justify-content-between align-items-center mb-3">

                                    <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                        <i class="fas fa-circle me-2 text-xxs mb-0 <?php echo e($text_color); ?>"></i>

                                        <div class="text-truncate">
                                            <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                                <?php echo e($item->service_item->name); ?></p>
                                            <p class="text-xs text-gray-300 fw-bold mb-0"><?php echo e($msg); ?></p>
                                        </div>
                                    </div>

                                    <span
                                        class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span>

                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <div class="card-body align-items-center text-center position-relative">
                            <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                                data-bs-toggle="modal" data-bs-target="#addsession">
                                <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                                <p class="fw-light mb-0"><?php echo e(__('patientappo.new session')); ?></p>
                            </a>
                        </div>

                    <?php endif; ?>

                    <!-- Card footer session -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#session_show">
                            <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                        </a>
                    </div>

                </div>

                <!----------- pulses start content ----------->
                <div class="carousel-item">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer"><?php echo e(__('basic.laser')); ?></span>
                            <span
                                class="m-0 text-x me-2 link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="3" aria-label="Slide 4">
                                <?php echo e(__('basic.package')); ?></span>
                            <span
                                class="m-0 text-x me-2 link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="1" aria-label="Slide 2">
                                <?php echo e(__('patientappo.session')); ?></span>
                            <span class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="0" aria-label="Slide 1">
                                <?php echo e(__('basic.treatments')); ?></span>
                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#addpulses"><?php echo e(__('basic.new pulses')); ?></a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->
                    <?php if(!$patient->pulses->isEmpty()): ?>
                        <div id="medicine_card_home" class="card-body align-items-center">

                            <?php $__currentLoopData = $patient->pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                
                            <?php if($loop->index === 3) break; ?>

                                <?php if($item->invoice_item): ?>
                                <?php if($item->invoice_item->invoice->status == 0): ?>
                                <?php
                                    $text_color_invoice = 'cancel-color-btn';
                                    $msg_invoice = __('basic.not paid');
                                ?>
                            <?php elseif($item->invoice_item->invoice->status == 1): ?>
                                <?php
                                    $text_color_invoice = 'pend-color-btn';
                                    $msg_invoice = __('basic.pending');
                                ?>
                            <?php elseif($item->invoice_item->invoice->status == 2): ?>
                            <?php
                                $text_color_invoice = 'prog-color-btn';
                                $msg_invoice = __('basic.installment');
                            ?>
                            <?php elseif($item->invoice_item->invoice->status == 3): ?>
                                <?php
                                    $text_color_invoice = 'done-color-btn';
                                    $msg_invoice = __('basic.paid');
                                ?>
                            <?php elseif($item->invoice_item->invoice->status == 4): ?>
                                <?php
                                    $text_color_invoice = 'cancel-color-btn';
                                    $msg_invoice = __('basic.refund');
                                ?>
                            <?php endif; ?>
                                <?php else: ?>
                                    <?php
                                        $text_color_invoice = 'done-color-btn';
                                        $msg_invoice = __('basic.from package');
                                    ?>
                                <?php endif; ?>
                                <div class="d-flex justify-content-between align-items-center mb-3">

                                    <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                        <i class="fas fa-circle me-2 text-xxs mb-0 <?php echo e($text_color_invoice); ?>"></i>

                                        <div class="text-truncate">
                                            <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                                <?php if($item->service_item): ?>
                                                    <?php echo e($item->service_item->name); ?>

                                                <?php else: ?>
                                                    Taken from package
                                                <?php endif; ?>
                                            </p>
                                            <p class="text-xs text-gray-300 fw-bold mb-0">
                                                <?php echo e(date('d M Y', strtotime($item->date))); ?></p>
                                        </div>
                                    </div>

                                    <span
                                        class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span>

                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <div class="card-body align-items-center text-center position-relative">
                            <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                                data-bs-toggle="modal" data-bs-target="#addpulses">
                                <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                                <p class="fw-light mb-0"><?php echo e(__('basic.new pulses')); ?></p>
                            </a>
                        </div>

                    <?php endif; ?>

                    <!-- Card footer session -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#pulses_show">
                            <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                        </a>
                    </div>

                </div>

                <!----------- pulses start content ----------->
                <div class="carousel-item">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span
                                class="m-0 fs-6 me-2 fw-bold clickable-item-pointer"><?php echo e(__('basic.package')); ?></span>
                            <span
                                class="m-0 text-x link-cust-text text-s me-2 fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="2" aria-label="Slide 3">
                                <?php echo e(__('basic.laser')); ?></span>
                            <span
                                class="m-0 text-x me-2 link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="1" aria-label="Slide 2">
                                <?php echo e(__('patientappo.session')); ?></span>
                            <span
                                class="m-0 text-x me-2 link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#treat-session" data-bs-slide-to="0" aria-label="Slide 1">
                                <?php echo e(__('basic.treatments')); ?></span>
                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#addpackage"><?php echo e(__('basic.new package')); ?></a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->
                    <?php if(!$patient->package->isEmpty()): ?>
                        <div id="medicine_card_home" class="card-body align-items-center">

                            <?php $__currentLoopData = $patient->package; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                
                            <?php if($loop->index === 3) break; ?>

                                <?php if($item->invoice_item): ?>
                                <?php if($item->invoice_item->invoice->status == 0): ?>
                                <?php
                                    $text_color_invoice = 'cancel-color-btn';
                                    $msg_invoice = __('basic.not paid');
                                ?>
                            <?php elseif($item->invoice_item->invoice->status == 1): ?>
                                <?php
                                    $text_color_invoice = 'pend-color-btn';
                                    $msg_invoice = __('basic.pending');
                                ?>
                            <?php elseif($item->invoice_item->invoice->status == 2): ?>
                            <?php
                                $text_color_invoice = 'prog-color-btn';
                                $msg_invoice = __('basic.installment');
                            ?>
                            <?php elseif($item->invoice_item->invoice->status == 3): ?>
                                <?php
                                    $text_color_invoice = 'done-color-btn';
                                    $msg_invoice = __('basic.paid');
                                ?>
                            <?php elseif($item->invoice_item->invoice->status == 4): ?>
                                <?php
                                    $text_color_invoice = 'cancel-color-btn';
                                    $msg_invoice = __('basic.refund');
                                ?>
                            <?php endif; ?>
                                <?php else: ?>
                                    <?php
                                        $text_color_invoice = 'done-color-btn';
                                        $msg_invoice = __('patientappo.old record');
                                    ?>
                                <?php endif; ?>
                                <div class="d-flex justify-content-between align-items-center mb-3">

                                    <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                        <i class="fas fa-circle me-2 text-xxs mb-0 <?php echo e($text_color_invoice); ?>"></i>

                                        <div class="text-truncate">
                                            <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                                <?php echo e($item->service_item->name); ?>

                                            </p>
                                            <p class="text-xs text-gray-300 fw-bold mb-0">
                                                <?php echo e(date('d M Y', strtotime($item->date))); ?></p>
                                        </div>
                                    </div>

                                    <span
                                        class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span>

                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <div class="card-body align-items-center text-center position-relative">
                            <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                                data-bs-toggle="modal" data-bs-target="#addpackage">
                                <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                                <p class="fw-light mb-0"><?php echo e(__('basic.new package')); ?></p>
                            </a>
                        </div>

                    <?php endif; ?>

                    <!-- Card footer session -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#package_show">
                            <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                        </a>
                    </div>

                </div>

            </div>


            <!-- Modal show all treatment -->
            <div class="modal fade" id="treatment_show" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-x-ray me-1"></i>
                                Treatment</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-4">

                            <div class="table-responsive">
                                <table class="table display datatable-modal" id="table-treatment" width="100%"
                                    cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs"><?php echo e(__('basic.id')); ?></th>
                                            <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.start')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.end')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('patientappo.sessions')); ?>

                                            </th>
                                            <th class="text-xs text-center">
                                                <?php echo e(__('patientappo.sessions done')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.status')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.handle')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $patient->treatments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($item->status == 0): ?>
                                                <?php
                                                    $text_color = 'active-color-btn';
                                                    $msg = __('basic.in prog');
                                                ?>
                                            <?php elseif($item->status == 1): ?>
                                                <?php
                                                    $text_color = 'done-color-btn';
                                                    $msg = __('patientappo.done');
                                                ?>
                                            <?php endif; ?>

                                            <tr>
                                                <td><?php echo e($item->id); ?></td>
                                                <td class="">
                                                    <?php echo e($item->treatment_cat->name); ?></td>
                                                <td><?php echo e($item->start); ?></td>
                                                <td class="text-center"><?php echo e($item->end); ?></td>
                                                <td class="text-center"><?php echo e($item->sessions); ?></td>
                                                <td class="text-center"><?php echo e($item->sessions_done); ?></td>
                                                <td class="text-center"> <span
                                                        class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                                </td>

                                                <td class="text-center">
                                                    <a data-treatment_id="<?php echo e($item->id); ?>"
                                                        data-treatment_cat_id="<?php echo e($item->treatment_cat->id); ?>"
                                                        data-status_treatment="<?php echo e($item->status); ?>"
                                                        data-sessions="<?php echo e($item->sessions); ?>"
                                                        data-sessions_done="<?php echo e($item->sessions_done); ?>"
                                                        data-start="<?php echo e($item->start); ?>"
                                                        data-end="<?php echo e($item->end); ?>"
                                                        class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 treatment_edit_click"
                                                        title="edit"><i class="fas fa-pencil-alt"></i>
                                                        <?php echo e(__('basic.edit')); ?> </a>

                                                    <a data-treatment_id="<?php echo e($item->id); ?>"
                                                        class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 treatment_newsession_click"
                                                        title="edit"><i class="fas fa-pencil-alt"></i>
                                                        <?php echo e(__('patientappo.new session')); ?> </a>

                                                    <a data-treatment_id="<?php echo e($item->id); ?>"
                                                        class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 treatment_delete_click"
                                                        title="delete" data-effect="effect-scale"><i
                                                            class="fas fa-trash"></i>
                                                        <?php echo e(__('basic.delete')); ?>

                                                    </a>

                                                </td>

                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link"
                                    data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="button"
                                    class="btn btn-default btn-link main-color"><?php echo e(__('basic.save changes')); ?></button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

            <!-- Modal treatment insert data -->
            <div class="modal fade" id="addtreatment" tabindex="-1" role="dialog"
                aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-x-ray me-1"></i>
                                <?php echo e(__('patientappo.new treatment')); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>

                        <form action="<?php echo e(route('sett.treatment.store')); ?>" method="post">
                            <?php echo e(method_field('POST')); ?>

                            <?php echo e(csrf_field()); ?>


                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.treatment')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-treatment-insert select2-hidden-accessible <?php $__errorArgs = ['treatment_cat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="treatment_cat" name="treatment_cat" required>
                                            <?php $__currentLoopData = $treatment_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>">
                                                    <?php echo e($item->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="treatment_cat_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['treatment_cat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"> <?php echo e(__('patientappo.sessions')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                        <input name="treatment_session" type="number"
                                            class="form-control <?php $__errorArgs = ['treatment_session'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="How many session?" required>

                                        <span id="treatment_session_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['treatment_session'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.start')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i
                                                        class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="treatment_start" type="text"
                                                class="form-control hasdatetimepicker <?php $__errorArgs = ['treatment_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="treatment_start_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['treatment_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.end')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i
                                                        class="bi bi-calendar2-week-fill"></i> </div>
                                            </div>
                                            <input name="treatment_end" type="text"
                                                class="form-control hasdatetimepicker <?php $__errorArgs = ['treatment_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="YYYY/MM/DD">
                                        </div>
                                        <span id="treatment_end_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['treatment_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.appointment')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-treatment-insert select2-hidden-accessible <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="last_appointment_id_trea" name="last_appointment_id" required>
                                            <?php $__currentLoopData = $patient->appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>">
                                                    <?php echo e($item->start_at); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="last_appointment_id_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>
                                </div>

                                <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link"
                                        data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">Add
                                        New</button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>

            <!-- Modal treatment update data -->
            <div class="modal fade" id="treatment_edit" tabindex="-1" role="dialog"
                aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                Edit treatment</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="<?php echo e(route('sett.treatment.update', '21')); ?>"
                            method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.treatment')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                        <select
                                            class="myselect2-treatment-update select2-hidden-accessible <?php $__errorArgs = ['treatment_cat_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="treatment_cat_update" name="treatment_cat_update" required>
                                            <?php $__currentLoopData = $treatment_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>">
                                                    <?php echo e($item->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="treatment_cat_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['treatment_cat_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>


                                    <div class="col-12 mb-2">
                                        <label class="form-label"> <?php echo e(__('patientappo.sessions')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                        <input name="treatment_session_update" type="number"
                                            class="form-control <?php $__errorArgs = ['treatment_session_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="How many session?" required>

                                        <span id="treatment_session_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['treatment_session_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Sessions Done
                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                        <input name="treatment_session_done_update" type="number"
                                            class="form-control <?php $__errorArgs = ['treatment_session_done_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="How many session?">

                                        <span id="treatment_session_done_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['treatment_session_done_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.status')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="select2-no-search-treatment select2-hidden-accessible select2-no-search-treatment <?php $__errorArgs = ['status_treatment_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="status_treatment_update" name="status_treatment_update" required>
                                            <option value="0">
                                                <?php echo e(__('basic.in prog')); ?>

                                            </option>
                                            <option value="1">
                                                <?php echo e(__('patientappo.done')); ?>

                                            </option>
                                        </select>

                                        <span id="status_treatment_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['status_treatment_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.start')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i
                                                        class="bi bi-calendar2-week-fill"></i> </div>
                                            </div>
                                            <input name="treatment_start_update" type="text"
                                                class="form-control hasdatetimepicker <?php $__errorArgs = ['treatment_start_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="treatment_start_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['treatment_start_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.end')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i
                                                        class="bi bi-calendar2-week-fill"></i> </div>
                                            </div>
                                            <input name="treatment_end_update" type="text"
                                                class="form-control hasdatetimepicker <?php $__errorArgs = ['treatment_end_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>

                                        <?php $__errorArgs = ['treatment_end_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                        <span id="treatment_end_update_error" class="error-msg-form"></span>
                                    </div>


                                </div>

                                <input name="treatment_id_update" value="" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link"
                                        data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit"
                                        class="btn btn-default btn-link main-color"><?php echo e(__('basic.update')); ?></button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>

            <!-- treatment Modal delete -->
            <div class="modal fade" id="treatment_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

                    <div class="modal-content shadow-lgg b-r-s-cont border-0">

                        <div class="modal-header">
                            <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                                <?php echo e(__('basic.delete')); ?></div>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>

                        <form action="<?php echo e(route('sett.treatment.destroy', 'test')); ?>" method="post">
                            <?php echo e(method_field('delete')); ?>

                            <?php echo e(csrf_field()); ?>


                            <!-- Modal content -->
                            <div class="modal-body px-4">

                                <div class="modal-body delete-conf-input text-center py-0">
                                    <p class="mb-0">ِAre
                                        you sure you want to delete
                                        this
                                        treatment?</p><br>
                                    <input type="hidden" name="treatment_id_delete" value="">
                                </div>
                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link"
                                        data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit"
                                        class="btn btn-default btn-link text-red"><?php echo e(__('basic.delete')); ?>

                                    </button>
                                </div>

                            </div>
                        </form>

                    </div>
                </div>
            </div>

            <!-- Modal show all session -->
            <div class="modal fade" id="session_show" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-capsules me-1"></i>
                                <?php echo e(__('patientappo.session')); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-4">

                            <div class="table-responsive">
                                <table class="table display datatable-modal" id="table-session" width="100%"
                                    cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs"><?php echo e(__('basic.date')); ?></th>
                                            <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                            <th class="text-xs text-center">
                                                <?php echo e(__('patientappo.session status')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('patientappo.pay status')); ?>

                                            </th>
                                            <th class="text-xs text-center"><?php echo e(__('patientappo.pay Code')); ?>

                                            </th>
                                            <th class="text-xs text-center"><?php echo e(__('patientappo.treat id')); ?>

                                            </th>
                                            <th class="text-xs text-center">
                                                <?php echo e(__('patientappo.treat sessions')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.handle')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $patient->sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($item->status == 0): ?>
                                                <?php
                                                    $text_color = 'active-color-btn';
                                                    $msg = __('patientappo.not done');
                                                ?>
                                            <?php elseif($item->status == 1): ?>
                                                <?php
                                                    $text_color = 'done-color-btn';
                                                    $msg = __('basic.done');
                                                ?>
                                            <?php endif; ?>

                                            <?php if($item->invoice_item): ?>
                                            <?php if($item->invoice_item->invoice->status == 0): ?>
                                            <?php
                                                $text_color_invoice = 'cancel-color-btn';
                                                $msg_invoice = __('basic.not paid');
                                            ?>
                                        <?php elseif($item->invoice_item->invoice->status == 1): ?>
                                            <?php
                                                $text_color_invoice = 'pend-color-btn';
                                                $msg_invoice = __('basic.pending');
                                            ?>
                                        <?php elseif($item->invoice_item->invoice->status == 2): ?>
                                        <?php
                                            $text_color_invoice = 'prog-color-btn';
                                            $msg_invoice = __('basic.installment');
                                        ?>
                                        <?php elseif($item->invoice_item->invoice->status == 3): ?>
                                            <?php
                                                $text_color_invoice = 'done-color-btn';
                                                $msg_invoice = __('basic.paid');
                                            ?>
                                        <?php elseif($item->invoice_item->invoice->status == 4): ?>
                                            <?php
                                                $text_color_invoice = 'cancel-color-btn';
                                                $msg_invoice = __('basic.refund');
                                            ?>
                                        <?php endif; ?>
                                                <?php
                                                    $invoice_url = 'href=' . route('sett.invoice.show', $item->invoice_item->invoice->id);
                                                ?>
                                            <?php else: ?>
                                                <?php
                                                    $text_color_invoice = 'done-color-btn';
                                                    $msg_invoice = __('patientappo.old record');
                                                    $invoice_url = '';
                                                ?>
                                            <?php endif; ?>

                                            <tr>
                                                <td><?php echo e(date('d M Y', strtotime($item->date))); ?></td>
                                                <td><?php echo e($item->service_item->name); ?></td>
                                                <td class="text-center"> <span
                                                        class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                                </td>
                                                <td class="text-center">
                                                    <a <?php echo e($invoice_url); ?>><span
                                                            class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span></a>
                                                </td>
                                                <td class="text-center">
                                                    <?php if($item->invoice_item): ?>
                                                        <?php echo e($item->invoice_item->invoice->code); ?>

                                                    <?php else: ?>
                                                        <?php echo e(__('patientappo.old record')); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td class="text-center">
                                                    <?php if(!empty($item->treatment->id)): ?>
                                                        <?php echo e($item->treatment->id); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td class="text-center">
                                                    <?php if(!empty($item->treatment->sessions)): ?>
                                                        <?php echo e($item->treatment->sessions); ?>

                                                    <?php endif; ?>
                                                </td>

                                                <td class="text-center">
                                                    <a data-session_id="<?php echo e($item->id); ?>"
                                                        data-status_session="<?php echo e($item->status); ?>"
                                                        data-treat_id="<?php if(!empty($item->treatment->id)): ?> <?php echo e($item->treatment->id); ?> <?php endif; ?>"
                                                        class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 session_edit_click"
                                                        title="edit"><i class="fas fa-pencil-alt"></i>
                                                        <?php echo e(__('basic.edit')); ?> </a>

                                                    <?php if($item->invoice_item): ?>
                                                        <?php if($item->invoice_item->invoice->status == 0): ?>
                                                            <a data-session_id="<?php echo e($item->id); ?>"
                                                                class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 session_delete_click"
                                                                title="delete" data-effect="effect-scale"
                                                                data-bs-toggle="modal" data-bs-target="#delete1"><i
                                                                    class="fas fa-trash"></i>
                                                                <?php echo e(__('basic.delete')); ?>

                                                            </a>
                                                        <?php endif; ?>
                                                    <?php endif; ?>

                                                </td>

                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">
                                    <?php echo e(__('basic.never mind')); ?></button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="button"
                                    class="btn btn-default btn-link main-color"><?php echo e(__('basic.save changes')); ?></button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

            <!-- Modal session update data -->
            <div class="modal fade" id="session_edit" tabindex="-1" role="dialog"
                aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                Update Session</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="<?php echo e(route('sett.session.update', '21')); ?>"
                            method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">


                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.status')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="select2-no-search-session select2-hidden-accessible select2-no-search-medicine <?php $__errorArgs = ['status_session_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="status_session_update" name="status_session_update" required>
                                            <option value="0">
                                                <?php echo e(__('patientappo.not done')); ?>

                                            </option>
                                            <option value="1">
                                                <?php echo e(__('patientappo.done')); ?>

                                            </option>
                                        </select>

                                        <span id="status_update_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['status_update_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>


                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('patientappo.related to treatment')); ?>

                                            <small>( <?php echo e(__('basic.required')); ?>)</small></label>

                                        <select
                                            class="myselect2-session-update select2-hidden-accessible <?php $__errorArgs = ['related_treatment_id_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="related_treatment_id_update" name="related_treatment_id_update">
                                            <?php $__currentLoopData = $patient->treatments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($item->status == 0): ?>
                                                    <option value="<?php echo e($item->id); ?>">
                                                        <?php echo e($item->treatment_cat->name . ' - ' . $item->start); ?>

                                                    </option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="related_treatment_id_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['related_treatment_id_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>


                                </div>

                                <input name="session_id_update" value="" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link"
                                        data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit"
                                        class="btn btn-default btn-link main-color"><?php echo e(__('basic.update')); ?></button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>

            <!-- session delete -->
            <div class="modal fade" id="session_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

                    <div class="modal-content shadow-lgg b-r-s-cont border-0">

                        <div class="modal-header">
                            <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                                <?php echo e(__('patientappo.session delete')); ?></div>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="<?php echo e(route('sett.session.destroy', 'test')); ?>"
                            method="post">
                            <?php echo e(method_field('delete')); ?>

                            <?php echo e(csrf_field()); ?>


                            <!-- Modal content -->
                            <div class="modal-body px-4">

                                <div class="modal-body delete-conf-input text-center py-0">
                                    <p class="mb-0">ِAre
                                        you sure you want to delete
                                        this
                                        session?</p><br>
                                    <input type="hidden" name="session_id_delete" value="">
                                </div>
                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link"
                                        data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit"
                                        class="btn btn-default btn-link text-red"><?php echo e(__('basic.delete')); ?>

                                    </button>
                                </div>

                            </div>
                        </form>

                    </div>
                </div>
            </div>

            <!-- Modal add new session insert data -->
            <div class="modal fade" id="addsession" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                    <form class="mb-0" action="<?php echo e(route('sett.session.store')); ?>" method="post"
                        style="display: contents">
                        <?php echo e(method_field('POST')); ?>

                        <?php echo e(csrf_field()); ?>


                        <div class="modal-content b-r-s-cont border-0">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                    <?php echo e(__('patientappo.new session')); ?></h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">
                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('patientappo.session')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-session-insert select2-hidden-accessible <?php $__errorArgs = ['session_cat_service'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="session_cat_service_insert" multiple name="session_cat_service[]"
                                            required>
                                            <?php $__currentLoopData = $service_cat_ses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>"
                                                    data-price="<?php echo e($item->price); ?>">
                                                    <?php echo e($item->name . ' - ' . $item->price . 'EGP'); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="session_cat_service_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['session_cat_service'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-3">
                                        <label class="form-label"><?php echo e(__('basic.doctor')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                        <select
                                            class="myselect2-session-insert select2-hidden-accessible <?php $__errorArgs = ['doc_session'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="doc_session" name="doc_session" required>
                                            <?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>">
                                                    <?php echo e($item->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="doc_session_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['doc_session'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.status')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-session-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['session_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="session_status" name="session_status" required>
                                            <option value="0">
                                                <?php echo e(__('patientappo.new record')); ?>

                                            </option>
                                            <option value="1">
                                                <?php echo e(__('patientappo.old record')); ?>

                                            </option>
                                        </select>

                                        <span id="session_status_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['session_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('patientappo.related to treatment')); ?>

                                            <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                        <select
                                            class="myselect2-session-insert select2-hidden-accessible <?php $__errorArgs = ['related_treatment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="related_treatment_id" name="related_treatment_id">
                                            <option disabled selected value> -- select treatment -- </option>
                                            <?php $__currentLoopData = $patient->treatments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($item->status == 0): ?>
                                                    <option value="<?php echo e($item->id); ?>">
                                                        <?php echo e($item->treatment_cat->name . ' - ' . $item->start); ?>

                                                    </option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="related_treatment_id_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['related_treatment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.date')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i
                                                        class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="session_date" type="text"
                                                class="form-control hasdatetimepicker <?php $__errorArgs = ['session_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="YYYY/MM/DD" required>
                                        </div>
                                        <span id="session_date_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['session_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <hr class="my-2">

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.appointment')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-session-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="last_appointment_id_pulses" name="last_appointment_id" required>
                                            <?php $__currentLoopData = $patient->appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>">
                                                    <?php echo e($item->start_at); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="last_appointment_id_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.invoice')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-session-insert-nosearch <?php $__errorArgs = ['session_cat_service'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="session_cat_invoice_insert" name="session_cat_invoice" required>
                                            <option value="new">New Invoice</option>
                                            <option value="wallet">Wallet</option>
                                            <?php $__currentLoopData = $patient->invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($item->status == 0): ?>
                                                    <option value="<?php echo e($item->id); ?>">
                                                        <?php echo e($item->service_inv_cat->name . ' - ' . $item->final_price . 'EGP'); ?>

                                                    </option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="session_cat_invoice_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['session_cat_invoice'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.invoice note')); ?>

                                            <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                        <textarea name="invoice_note" class="form-control" placeholder="Write here your notes .." rows="4"
                                            spellcheck="false"></textarea>

                                        <span id="session_cat_invoice_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['invoice_note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>
                                </div>

                                <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link"
                                        data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">Add
                                        New</button>
                                </div>
                            </div>

                        </div>
                    </form>

                </div>

            </div>

            <!-- Modal add new pulses insert data -->
            <div class="modal fade" id="addpulses" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                    <form class="mb-0" action="<?php echo e(route('sett.pulses.store')); ?>" method="post"
                        style="display: contents">
                        <?php echo e(method_field('POST')); ?>

                        <?php echo e(csrf_field()); ?>


                        <div class="modal-content b-r-s-cont border-0">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                    <?php echo e(__('basic.new pulses')); ?></h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">

                                    <div class="col-12 mb-3">
                                        <label class="form-label"><?php echo e(__('basic.type')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-pulses-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['pulses_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="pulses_type" name="pulses_type" required>
                                            <option value="0">
                                                <?php echo e(__('patientappo.session')); ?>

                                            </option>
                                            <option value="1">
                                                <?php echo e(__('basic.money per pulse')); ?>

                                            </option>
                                            <option value="2">
                                                <?php echo e(__('basic.from session package')); ?>

                                            </option>
                                            <option value="3">
                                                <?php echo e(__('basic.from pulses package')); ?>

                                            </option>
                                            <option value="4">
                                                <?php echo e(__('basic.free session')); ?>

                                            </option>
                                        </select>

                                        <span id="pulses_type_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['pulses_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>


                                    <div class="col-12 mb-2" id="pulses_record_cont">
                                        <label class="form-label"><?php echo e(__('basic.status')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-pulses-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['pulses_record'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="pulses_record" name="pulses_record" required>
                                            <option value="0">
                                                <?php echo e(__('patientappo.new record')); ?>

                                            </option>
                                            <option value="1">
                                                <?php echo e(__('patientappo.old record')); ?>

                                            </option>
                                        </select>

                                        <span id="pulses_record_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['pulses_record'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div id="pulses_serv_item_sess_cont" class="col-12 mb-3">
                                        <label class="form-label"><?php echo e(__('patientappo.session')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-pulses-insert select2-hidden-accessible <?php $__errorArgs = ['pulses_serv_item_sess'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="pulses_serv_item_sess" name="pulses_serv_item_sess" required>
                                            <?php $__currentLoopData = $service_cat_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($item->package == 0 && $item->id != 2 && $item->id != 3): ?>
                                                    <option value="<?php echo e($item->id); ?>"
                                                        data-price="<?php echo e($item->price); ?>">
                                                        <?php echo e($item->name . ' - ' . $item->price . ' EGP ' . $item->pulses . ' ps'); ?>

                                                    </option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="pulses_serv_item_sess_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['pulses_serv_item_sess'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div id="sessions_serv_item_package_cont" class="col-12 mb-3"
                                        style="display: none">

                                        <label class="form-label"><?php echo e(__('basic.package')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-pulses-insert select2-hidden-accessible <?php $__errorArgs = ['session_serv_item_package'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="session_serv_item_package" name="session_serv_item_package" required
                                            disabled>
                                            <?php $__currentLoopData = $patient->package; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($item->type == 1 && $item->items_number_left > 0): ?>
                                                    <option value="<?php echo e($item->id); ?>"
                                                        data-balance="<?php echo e($item->items_number_left); ?>">
                                                        <?php echo e($item->service_item->name . ' - ' . $item->items_number_left . 'left'); ?>

                                                    </option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="session_serv_item_package" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['session_serv_item_package'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-3" id="patient_balance_cont" style="display: none">
                                        <label class="form-label"> <?php echo e(__('basic.balance')); ?></label>

                                        <input type="number" id="pt_puls_balance" class="form-control"
                                            value="<?php echo e($patient->balance); ?>" disabled>
                                    </div>

                                    <div id="pulses_no_balance" class="p-4 text-center" style="display: none">
                                        Sorry, there is no available balance
                                    </div>

                                    <div id="pulses_details_cont">

                                        <div class="col-12 mb-3">
                                            <label class="form-label"><?php echo e(__('basic.doctor')); ?>

                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                            <select
                                                class="myselect2-pulses-insert select2-hidden-accessible <?php $__errorArgs = ['responsible_doc_pulses'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="responsible_doc_pulses" name="responsible_doc_pulses" required>
                                                <?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($item->id); ?>">
                                                        <?php echo e($item->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>

                                            <span id="responsible_doc_pulses_error" class="error-msg-form"></span>

                                            <?php $__errorArgs = ['responsible_doc_pulses'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                        </div>

                                        <div class="col-12 mb-2">
                                            <label class="form-label"><?php echo e(__('basic.branch')); ?>

                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                            <select
                                                class="myselect2-pulses-insert select2-hidden-accessible <?php $__errorArgs = ['branch_id_pulses'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="branch_id_pulses" name="branch_id_pulses" required>
                                                <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($item->id); ?>">
                                                        <?php echo e($item->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>

                                            <span id="branch_id_pulses_error" class="error-msg-form"></span>

                                            <?php $__errorArgs = ['branch_id_pulses'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                        </div>

                                        <div class="col-12 mb-2">
                                            <label class="form-label"><?php echo e(__('basic.machine')); ?>

                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                            <select
                                                class="myselect2-pulses-insert select2-hidden-accessible <?php $__errorArgs = ['responsible_doc_app'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="machine_id" name="machine_id" required>
                                                <option disabled selected>
                                                    Chose Branch first
                                                </option>
                                            </select>

                                            <span id="machine_id_error" class="error-msg-form"></span>

                                            <?php $__errorArgs = ['machine_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                        </div>

                                        <div class="col-12 mb-3">
                                            <label class="form-label"> <?php echo e(__('basic.fluence')); ?>

                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                            <select
                                                class="myselect2-pulses-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['fluence'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                name="fluence" required>
                                                <option value="6">
                                                    6
                                                </option>
                                                <option value="7">
                                                    7
                                                </option>
                                                <option value="8">
                                                    8
                                                </option>
                                                <option value="9">
                                                    9
                                                </option>
                                                <option value="10">
                                                    10
                                                </option>
                                                <option value="12">
                                                    12
                                                </option>
                                                <option value="14">
                                                    14
                                                </option>
                                                <option value="16">
                                                    16
                                                </option>
                                                <option value="18">
                                                    18
                                                </option>
                                                <option value="20">
                                                    20
                                                </option>
                                            </select>

                                            <span id="fluence_error" class="error-msg-form"></span>

                                            <?php $__errorArgs = ['fluence'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="col-12 mb-3">
                                            <label class="form-label"><?php echo e(__('basic.pulse area')); ?>

                                                <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                            <select
                                                class="myselect2-pulses-insert select2-hidden-accessible <?php $__errorArgs = ['pulse_area_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="pulse_area_id" name="pulse_area_id">
                                                <?php $__currentLoopData = $pulses_area; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($item->id); ?>">
                                                        <?php echo e($item->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>

                                            <span id="pulse_area_id_error" class="error-msg-form"></span>

                                            <?php $__errorArgs = ['pulse_area_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="col-12 mb-3">
                                            <label class="form-label"> <?php echo e(__('basic.spot size')); ?>

                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                            <select
                                                class="myselect2-pulses-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['spot_size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="spot_size" name="spot_size" required>
                                                <option value="15">
                                                    15
                                                </option>
                                                <option value="18">
                                                    18
                                                </option>
                                                <option value="20">
                                                    20
                                                </option>
                                                <option value="22">
                                                    22
                                                </option>
                                                <option value="24">
                                                    24
                                                </option>
                                            </select>

                                            <span id="spot_size_error" class="error-msg-form"></span>

                                            <?php $__errorArgs = ['spot_size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="col-12 mb-3">
                                            <label class="form-label"> <?php echo e(__('basic.used pulses')); ?>

                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                            <input name="used_pulses" type="number"
                                                class="form-control <?php $__errorArgs = ['used_pulses'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="used pulses ..." value="0" required>

                                            <span id="used_pulses_error" class="error-msg-form"></span>

                                            <?php $__errorArgs = ['used_pulses'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div id="free_session_price_cont" class="col-12 mb-3" style="display: none">
                                            <label class="form-label"> <?php echo e(__('basic.free session price')); ?>

                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                            <input id="free_session_price" name="free_session_price" type="number"
                                                class="form-control <?php $__errorArgs = ['free_session_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="free session price ..." required disabled>

                                            <span id="free_session_price_error" class="error-msg-form"></span>

                                            <?php $__errorArgs = ['free_session_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                    </div>

                                    <div class="col-12 mb-3">
                                        <label class="form-label"><?php echo e(__('basic.date')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i
                                                        class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="pulses_date" type="text"
                                                class="form-control hasdatetimepicker <?php $__errorArgs = ['pulses_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                placeholder="YYYY/MM/DD" required value="<?php echo e(date('Y-m-d')); ?>">
                                        </div>
                                        <span id="pulses_date_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['pulses_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-3">
                                        <label class="form-label"><?php echo e(__('basic.appointment')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-pulses-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="last_appointment_id_sess" name="last_appointment_id" required>
                                            <?php $__currentLoopData = $patient->appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>">
                                                    <?php echo e($item->start_at); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="last_appointment_id_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div id="invoice_area_pulses">

                                        <hr class="my-2">

                                        <div class="col-12 mb-3">
                                            <label class="form-label"><?php echo e(__('basic.invoice')); ?>

                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                            <select
                                                class="myselect2-pulses-insert-nosearch <?php $__errorArgs = ['pulses_cat_invoice'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="pulses_cat_invoice_insert" name="pulses_cat_invoice" required>
                                                <option value="new">New Invoice</option>
                                                <option value="wallet">Wallet</option>
                                                <?php $__currentLoopData = $patient->invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($item->status == 0): ?>
                                                        <option value="<?php echo e($item->id); ?>">
                                                            <?php echo e($item->service_inv_cat->name . ' - ' . $item->final_price . 'EGP'); ?>

                                                        </option>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>

                                            <span id="pulses_cat_invoice_error" class="error-msg-form"></span>

                                            <?php $__errorArgs = ['pulses_cat_invoice'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="col-12 mb-3">
                                            <label class="form-label"><?php echo e(__('basic.invoice note')); ?>

                                                <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                            <textarea id="invoice_note_pulses" name="invoice_note" class="form-control" placeholder="Write here your notes .."
                                                rows="4" spellcheck="false"></textarea>

                                            <span id="invoice_note_error" class="error-msg-form"></span>

                                            <?php $__errorArgs = ['invoice_note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                        </div>

                                    </div>

                                </div>

                                <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link"
                                        data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">Add
                                        New</button>
                                </div>
                            </div>

                        </div>
                    </form>

                </div>

            </div>

            <!-- Modal show all pulses -->
            <div class="modal fade" id="pulses_show" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-capsules me-1"></i>
                                <?php echo e(__('basic.pulses')); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-4">

                            <div class="table-responsive">
                                <table class="table display datatable-modal" id="table-pulses" width="100%"
                                    cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs"><?php echo e(__('basic.date')); ?></th>
                                            <th class="text-xs text-center">
                                                <?php echo e(__('basic.type')); ?></th>
                                            <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.doctor')); ?>

                                            </th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.machine')); ?>

                                            </th>
                                            <th class="text-xs text-center"><?php echo e(__('patientappo.pay status')); ?>

                                            </th>
                                            <th class="text-xs"><?php echo e(__('basic.fluence')); ?></th>
                                            <th class="text-xs"><?php echo e(__('basic.pulse area')); ?></th>
                                            <th class="text-xs"><?php echo e(__('basic.spot size')); ?></th>
                                            <th class="text-xs"><?php echo e(__('basic.balance before session')); ?>

                                            </th>
                                            <th class="text-xs"><?php echo e(__('basic.used pulses')); ?></th>
                                            <th class="text-xs"><?php echo e(__('basic.package id')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.handle')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $patient->pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($item->type == 0): ?>
                                                <?php
                                                    $text_color = 'active-color-btn';
                                                    $msg = __('patientappo.session');
                                                ?>
                                            <?php elseif($item->type == 1): ?>
                                                <?php
                                                    $text_color = 'done-color-btn';
                                                    $msg = __('basic.money per pulse');
                                                ?>
                                            <?php elseif($item->type == 2): ?>
                                                <?php
                                                    $text_color = 'prog-color-btn';
                                                    $msg = __('basic.session package');
                                                ?>
                                            <?php elseif($item->type == 3): ?>
                                                <?php
                                                    $text_color = 'not_accepted-color-btn';
                                                    $msg = __('basic.pulses package');
                                                ?>
                                            <?php elseif($item->type == 4): ?>
                                                <?php
                                                    $text_color = 'pend-color-btn';
                                                    $msg = __('basic.free session');
                                                ?>
                                            <?php endif; ?>

                                            <?php if($item->invoice_item): ?>
                                                <?php if($item->invoice_item->invoice->status == 0): ?>
                                                    <?php
                                                        $text_color_invoice = 'cancel-color-btn';
                                                        $msg_invoice = __('basic.not paid');
                                                    ?>
                                                <?php elseif($item->invoice_item->invoice->status == 1): ?>
                                                    <?php
                                                        $text_color_invoice = 'pend-color-btn';
                                                        $msg_invoice = __('basic.pending');
                                                    ?>
                                                <?php elseif($item->invoice_item->invoice->status == 2): ?>
                                                <?php
                                                    $text_color_invoice = 'prog-color-btn';
                                                    $msg_invoice = __('basic.installment');
                                                ?>
                                                <?php elseif($item->invoice_item->invoice->status == 3): ?>
                                                    <?php
                                                        $text_color_invoice = 'done-color-btn';
                                                        $msg_invoice = __('basic.paid');
                                                    ?>
                                                <?php elseif($item->invoice_item->invoice->status == 4): ?>
                                                    <?php
                                                        $text_color_invoice = 'cancel-color-btn';
                                                        $msg_invoice = __('basic.refund');
                                                    ?>
                                                <?php endif; ?>
                                                <?php
                                                    $invoice_url = 'href=' . route('sett.invoice.show', $item->invoice_item->invoice->id);
                                                    
                                                ?>
                                            <?php else: ?>
                                                <?php
                                                    $text_color_invoice = 'done-color-btn';
                                                    if ($item->type == 2 || $item->type == 3) {
                                                        $msg_invoice = __('basic.from package');
                                                        $invoice_url = '';
                                                    } else {
                                                        $msg_invoice = __('patientappo.old record');
                                                        $invoice_url = '';
                                                    }
                                                ?>
                                            <?php endif; ?>

                                            <tr>
                                                <td><?php echo e(date('d M Y', strtotime($item->date))); ?></td>
                                                <td class="text-center"> <span
                                                        class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                                </td>
                                                <td>
                                                    <?php if($item->service_item): ?>
                                                        <?php echo e($item->service_item->name); ?>

                                                    <?php else: ?>
                                                        Taken from package
                                                    <?php endif; ?>
                                                </td>
                                                <td class="text-center">
                                                    <?php if($item->doctor): ?>
                                                        <?php echo e($item->doctor->name); ?>

                                                    <?php else: ?>
                                                        No selected
                                                    <?php endif; ?>
                                                </td>
                                                <td class="text-center">
                                                    <?php if($item->machine): ?>
                                                        <?php echo e($item->machine->name); ?>

                                                    <?php else: ?>
                                                        No Machine
                                                    <?php endif; ?>
                                                </td>
                                                <td class="text-center"> <a <?php echo e($invoice_url); ?>><span
                                                            class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span></a>
                                                </td>

                                                <td class="text-center">
                                                    <?php echo e($item->fluence); ?>

                                                </td>
                                                <td class="text-center">
                                                    <?php if($item->pulse_area): ?>
                                                        <?php echo e($item->pulse_area->name); ?>

                                                    <?php else: ?>
                                                    <?php endif; ?>
                                                </td>
                                                <td class="text-center">
                                                    <?php echo e($item->spot_size); ?>

                                                </td>
                                                <td class="text-center">
                                                    <?php echo e($item->balance_before_session); ?>

                                                </td>
                                                <td class="text-center">
                                                    <?php echo e($item->used_pulses); ?>

                                                </td>
                                                <td class="text-center">
                                                    <?php if($item->package): ?>
                                                        <?php echo e($item->package->service_item->name); ?>

                                                        <?php echo e($item->package->date); ?>

                                                    <?php else: ?>
                                                        No package
                                                    <?php endif; ?>

                                                </td>
                                                <td class="text-center">

                                                    <?php if($item->type !== 1): ?>
                                                        <a data-id="<?php echo e($item->id); ?>"
                                                            data-fluence="<?php echo e($item->fluence); ?>"
                                                            data-pulse_area_id="<?php echo e($item->pulse_area_id); ?>"
                                                            data-spot_size="<?php echo e($item->spot_size); ?>"
                                                            data-used_pulses="<?php echo e($item->used_pulses); ?>"
                                                            class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 pulses_edit_click"
                                                            title="edit"><i class="fas fa-pencil-alt"></i>
                                                            <?php echo e(__('basic.edit')); ?> </a>
                                                    <?php endif; ?>

                                                    <?php if(auth()->check() && auth()->user()->hasRole('Super-admin|Branch-manager')): ?>
                                                        <?php if($item->invoice_item): ?>
                                                            <?php if($item->invoice_item->invoice->status == 0): ?>
                                                                <a data-id="<?php echo e($item->id); ?>"
                                                                    class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 pulses_delete_click"
                                                                    title="delete" data-effect="effect-scale"
                                                                    data-bs-toggle="modal" data-bs-target="#delete1"><i
                                                                        class="fas fa-trash"></i>
                                                                    <?php echo e(__('basic.delete')); ?>

                                                                </a>
                                                            <?php endif; ?>
                                                        <?php else: ?>
                                                            <a data-id="<?php echo e($item->id); ?>"
                                                                class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 pulses_delete_click"
                                                                title="delete" data-effect="effect-scale"
                                                                data-bs-toggle="modal" data-bs-target="#delete1"><i
                                                                    class="fas fa-trash"></i>
                                                                <?php echo e(__('basic.delete')); ?>

                                                            </a>
                                                        <?php endif; ?>
                                                    <?php endif; ?>

                                                </td>

                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">
                                    <?php echo e(__('basic.never mind')); ?></button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="button"
                                    class="btn btn-default btn-link main-color"><?php echo e(__('basic.save changes')); ?></button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

            <!-- Modal pulses update data -->
            <div class="modal fade" id="pulses_edit" tabindex="-1" role="dialog"
                aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                Update Pulses</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="<?php echo e(route('sett.pulses.update', '21')); ?>"
                            method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">

                                    <div class="col-12 mb-2">
                                        <label class="form-label"> <?php echo e(__('basic.fluence')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select id="fluence_update_id"
                                            class="myselect2-pulses-update-nosearch select2-hidden-accessible <?php $__errorArgs = ['fluence_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            name="fluence_update" required>
                                            <option value="6">
                                                6
                                            </option>
                                            <option value="7">
                                                7
                                            </option>
                                            <option value="8">
                                                8
                                            </option>
                                            <option value="9">
                                                9
                                            </option>
                                            <option value="10">
                                                10
                                            </option>
                                            <option value="12">
                                                12
                                            </option>
                                            <option value="14">
                                                14
                                            </option>
                                            <option value="16">
                                                16
                                            </option>
                                            <option value="18">
                                                18
                                            </option>
                                            <option value="20">
                                                20
                                            </option>
                                        </select>

                                        <span id="fluence_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['fluence_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>


                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.pulse area')); ?>

                                            <small>( <?php echo e(__('basic.required')); ?>)</small></label>

                                        <select
                                            class="myselect2-pulses-update select2-hidden-accessible <?php $__errorArgs = ['related_treatment_id_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="pulse_area_id_update" name="pulse_area_id_update">
                                            <?php $__currentLoopData = $pulses_area; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>">
                                                    <?php echo e($item->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="pulse_area_id_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['pulse_area_id_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"> <?php echo e(__('basic.spot size')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                        <select
                                            class="myselect2-pulses-update-nosearch select2-hidden-accessible <?php $__errorArgs = ['spot_size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="spot_size_update_id" name="spot_size_update" required>
                                            <option value="15">
                                                15
                                            </option>
                                            <option value="18">
                                                18
                                            </option>
                                            <option value="20">
                                                20
                                            </option>
                                            <option value="22">
                                                22
                                            </option>
                                            <option value="24">
                                                24
                                            </option>
                                        </select>

                                        <span id="spot_size_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['spot_size_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"> <?php echo e(__('basic.used pulses')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                        <input name="used_pulses_update" type="number"
                                            class="form-control <?php $__errorArgs = ['used_pulses_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="used pulses ..." required>

                                        <span id="used_pulses_update_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['used_pulses_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <input name="pulses_id_update" value="" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link"
                                        data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit"
                                        class="btn btn-default btn-link main-color"><?php echo e(__('basic.update')); ?></button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>

            </div>

            <!-- pulses delete -->
            <div class="modal fade" id="pulses_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

                    <div class="modal-content shadow-lgg b-r-s-cont border-0">

                        <div class="modal-header">
                            <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                                <?php echo e(__('basic.pulses delete')); ?></div>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="<?php echo e(route('sett.pulses.destroy', 'test')); ?>"
                            method="post">
                            <?php echo e(method_field('delete')); ?>

                            <?php echo e(csrf_field()); ?>


                            <!-- Modal content -->
                            <div class="modal-body px-4">

                                <div class="modal-body delete-conf-input text-center py-0">
                                    <p class="mb-0">ِAre
                                        you sure you want to delete
                                        this
                                        session?</p><br>
                                    <input type="hidden" name="pulses_id_delete" value="">
                                </div>
                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link"
                                        data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit"
                                        class="btn btn-default btn-link text-red"><?php echo e(__('basic.delete')); ?>

                                    </button>
                                </div>

                            </div>
                        </form>

                    </div>
                </div>
            </div>

            <!-- Modal add new package insert data -->
            <div class="modal fade" id="addpackage" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                    <form class="mb-0" action="<?php echo e(route('sett.service_package.store')); ?>" method="post"
                        style="display: contents">
                        <?php echo e(method_field('POST')); ?>

                        <?php echo e(csrf_field()); ?>


                        <div class="modal-content b-r-s-cont border-0">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                    <?php echo e(__('basic.new package')); ?></h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">

                                    <div class="col-12 mb-3">
                                        <label class="form-label"><?php echo e(__('basic.status')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-package-insert select2-hidden-accessible <?php $__errorArgs = ['old_new_package'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="old_new_package" name="old_new_package" required>
                                            <option value="1">
                                                <?php echo e(__('patientappo.new record')); ?>

                                            </option>
                                            <option value="2">
                                                <?php echo e(__('patientappo.old record')); ?>

                                            </option>
                                        </select>

                                        <span id="old_new_package_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['old_new_package'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-3">
                                        <label class="form-label"><?php echo e(__('basic.package')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-package-insert select2-hidden-accessible <?php $__errorArgs = ['package_service_item_cat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="package_service_item_cat" name="package_service_item_cat" required>
                                            <?php $__currentLoopData = $service_cat_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($item->package > 0): ?>
                                                    <option value="<?php echo e($item->id); ?>"
                                                        data-price="<?php echo e($item->price); ?>">
                                                        <?php echo e($item->name . ' - ' . $item->price . ' EGP ' . $item->package_items_number . ' ps'); ?>

                                                    </option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="package_service_item_cat_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['package_service_item_cat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-12 mb-3">
                                        <label class="form-label"><?php echo e(__('basic.appointment')); ?>

                                            <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                        <select
                                            class="myselect2-package-insert select2-hidden-accessible <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            id="last_appointment_id_package" name="last_appointment_id" required>
                                            <?php $__currentLoopData = $patient->appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>">
                                                    <?php echo e($item->start_at); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                        <span id="last_appointment_id_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <hr>

                                    <div class="col-12 mb-2">
                                        <label class="form-label"><?php echo e(__('basic.invoice note')); ?>

                                            <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                        <textarea name="invoice_note" class="form-control" placeholder="Write here your notes .." rows="4"
                                            spellcheck="false"></textarea>

                                        <span id="session_cat_invoice_error" class="error-msg-form"></span>

                                        <?php $__errorArgs = ['invoice_note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                    </div>
                                </div>

                                <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link"
                                        data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">Add
                                        New</button>
                                </div>
                            </div>

                        </div>
                    </form>

                </div>

            </div>

            <!-- Modal show all package -->
            <div class="modal fade" id="package_show" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-capsules me-1"></i>
                                <?php echo e(__('basic.package')); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <!-- Modal content -->
                        <div class="modal-body px-4">

                            <div class="table-responsive">
                                <table class="table display datatable-modal" id="table-package" width="100%"
                                    cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs"><?php echo e(__('basic.id')); ?></th>
                                            <th class="text-xs"><?php echo e(__('basic.status')); ?></th>
                                            <th class="text-xs"><?php echo e(__('basic.date')); ?></th>
                                            <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                            <th class="text-xs text-center">
                                                <?php echo e(__('basic.type')); ?></th>
                                            <th class="text-xs text-center"><?php echo e(__('patientappo.pay status')); ?>

                                            </th>
                                            <th class="text-xs text-center"><?php echo e(__('basic.session|pulses number')); ?>

                                            </th>
                                            <th class="text-xs text-center">
                                                <?php echo e(__('basic.session|pulses number left')); ?>

                                            </th>

                                            <th class="text-xs text-center"><?php echo e(__('basic.handle')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <?php $__currentLoopData = $patient->package; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($item->invoice_item): ?>
                                                <?php
                                                    $text_color_status = 'active-color-btn';
                                                    $msg_status = __('patientappo.new record');
                                                ?>
                                            <?php else: ?>
                                                <?php
                                                    $text_color_status = 'done-color-btn';
                                                    $msg_status = __('patientappo.old record');
                                                ?>
                                            <?php endif; ?>

                                            <?php if($item->type == 1): ?>
                                                <?php
                                                    $text_color = 'active-color-btn';
                                                    $msg = __('basic.session');
                                                ?>
                                            <?php elseif($item->type == 2): ?>
                                                <?php
                                                    $text_color = 'done-color-btn';
                                                    $msg = __('basic.pulses');
                                                ?>
                                            <?php endif; ?>

                                            <?php if($item->invoice_item): ?>
                                                <?php if($item->invoice_item->invoice->status == 0): ?>
                                                    <?php
                                                        $text_color_invoice = 'cancel-color-btn';
                                                        $msg_invoice = __('basic.not paid');
                                                    ?>
                                                <?php elseif($item->invoice_item->invoice->status == 1): ?>
                                                    <?php
                                                        $text_color_invoice = 'pend-color-btn';
                                                        $msg_invoice = __('basic.pending');
                                                    ?>
                                                <?php elseif($item->invoice_item->invoice->status == 2): ?>
                                                <?php
                                                    $text_color_invoice = 'prog-color-btn';
                                                    $msg_invoice = __('basic.installment');
                                                ?>
                                                <?php elseif($item->invoice_item->invoice->status == 3): ?>
                                                    <?php
                                                        $text_color_invoice = 'done-color-btn';
                                                        $msg_invoice = __('basic.paid');
                                                    ?>
                                                <?php elseif($item->invoice_item->invoice->status == 4): ?>
                                                    <?php
                                                        $text_color_invoice = 'cancel-color-btn';
                                                        $msg_invoice = __('basic.refund');
                                                    ?>
                                                <?php endif; ?>
                                                <?php
                                                    $invoice_url = 'href=' . route('sett.invoice.show', $item->invoice_item->invoice->id);
                                                ?>
                                            <?php else: ?>
                                                <?php
                                                    $text_color_invoice = 'done-color-btn';
                                                    $msg_invoice = __('patientappo.old record');
                                                    $invoice_url = '';
                                                ?>
                                            <?php endif; ?>

                                            <tr>
                                                <td><?php echo e($item->id); ?></td>
                                                <td><span
                                                        class="badge rounded-pill <?php echo e($text_color_status); ?> badge-padd-l"><?php echo e($msg_status); ?></span>
                                                </td>
                                                <td><?php echo e(date('d M Y', strtotime($item->date))); ?></td>
                                                <td><?php echo e($item->service_item->name); ?></td>
                                                <td class="text-center"> <span
                                                        class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                                </td>
                                                <td class="text-center">
                                                    <a <?php echo e($invoice_url); ?>><span
                                                            class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span></a>
                                                </td>

                                                <td class="text-center">
                                                    <?php echo e($item->items_number); ?>

                                                </td>
                                                <td class="text-center">
                                                    <?php echo e($item->items_number_left); ?>

                                                </td>

                                                <td class="text-center">
                                                    <?php if($item->invoice_item): ?>
                                                        <?php if($item->invoice_item->invoice->status == 0): ?>
                                                            <a data-id="<?php echo e($item->id); ?>"
                                                                class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 package_delete_click"
                                                                title="delete" data-effect="effect-scale"
                                                                data-bs-toggle="modal" data-bs-target="#delete1"><i
                                                                    class="fas fa-trash"></i>
                                                                <?php echo e(__('basic.delete')); ?>

                                                            </a>
                                                        <?php endif; ?>
                                                    <?php endif; ?>

                                                </td>

                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">
                                    <?php echo e(__('basic.never mind')); ?></button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="button"
                                    class="btn btn-default btn-link main-color"><?php echo e(__('basic.save changes')); ?></button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

            <!-- pulses delete -->
            <div class="modal fade" id="package_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

                    <div class="modal-content shadow-lgg b-r-s-cont border-0">

                        <div class="modal-header">
                            <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                                <?php echo e(__('basic.package delete')); ?></div>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>

                        <form class="mb-0" action="<?php echo e(route('sett.service_package.destroy', 'test')); ?>"
                            method="post">
                            <?php echo e(method_field('delete')); ?>

                            <?php echo e(csrf_field()); ?>


                            <!-- Modal content -->
                            <div class="modal-body px-4">

                                <div class="modal-body delete-conf-input text-center py-0">
                                    <p class="mb-0">ِAre
                                        you sure you want to delete
                                        this
                                        package?</p><br>
                                    <input type="hidden" name="package_id_delete" value="">
                                </div>
                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link"
                                        data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit"
                                        class="btn btn-default btn-link text-red"><?php echo e(__('basic.delete')); ?>

                                    </button>
                                </div>

                            </div>
                        </form>

                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<?php /**PATH /home/drsamirghoraba/public_html/prox/proxima/resources/views/patient/component/treat_sess.blade.php ENDPATH**/ ?>