<!---------- Lab results --------->
<div class="col-12 col-lg-4">
    <div class="card shadow mb-4">

        <div id="lab-operation" class="carousel slide curr-treament-info-carousel" data-bs-ride="carousel"
            data-bs-interval="false">

            <div class="carousel-indicators dots-radius-carousel" style="bottom: 34px; margin-bottom: 0px;">
                <button type="button" data-bs-target="#lab-operation" data-bs-slide-to=" 0" class="active"
                    aria-current="true" aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#lab-operation" data-bs-slide-to=" 1"
                    aria-label="Slide 2"></button>
                <button type="button" data-bs-target="#lab-operation" data-bs-slide-to="2"
                    aria-label="Slide 3"></button>
            </div>

            <div class="carousel-inner">

                <!-- Current treatments -->
                <div class="carousel-item active">
                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer"><?php echo e(__('patientappo.lab results')); ?></span>
                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#lab-operation" data-bs-slide-to="1" aria-label="Slide 2">
                                <?php echo e(__('basic.operations')); ?></span>
                            <span class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#lab-operation" data-bs-slide-to="2" aria-label="Slide 3">
                                <?php echo e(__('basic.attachments')); ?></span>
                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#adddxـray"><?php echo e(__('patientappo.new lab')); ?></a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->
                    <?php if(!$patient->labs->isEmpty()): ?>
                    <div class="card-body pb-2">
                        <div class="list-group">
                            <?php $__currentLoopData = $patient->labs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            
                            <?php if($loop->index === 3) break; ?>
                            <?php if($item->invoice_item): ?>
                            <?php if($item->invoice_item->invoice->status == 0): ?>
                            <div
                                class="list-group-item li-gr-it-no-space-flx justify-content-between align-items-center mb-3">
                                <div class="text-truncate">
                                    <p class="text-gray-300 text-xs mb-0">
                                        <?php echo e(date('d M Y', strtotime($item->created_at))); ?></p>
                                    <a href="<?php echo e(route('sett.lab.show', $item->id)); ?>"
                                        class="text-xs link-cust-text text-gray-500 text-truncate"><i
                                            class="fas fa-file-medical-alt text-gray-300 me-1 text-truncate"></i>
                                        <?php echo e($item->service_item->name); ?></a>
                                </div>

                                <div>
                                    <span class="badge rounded-pill cancel-color-btn badge-padd-l"><?php echo e(__('basic.not
                                        paid')); ?></span>
                                </div>
                            </div>
                            <?php else: ?>
                            <?php if($item->status == 0): ?>
                            <?php
                            $lab_status_btn = '<span
                                class="badge rounded-pill active-color-btn badge-padd-l">Sent</span>';
                            $lab_href = '';
                            ?>
                            <?php else: ?>
                            <?php
                            $lab_status_btn = '<i class="fas fa-arrow-circle-down text-m"></i>';
                            $lab_href = 'href="' . URL::asset('img/lab/' . $item->xray_file) . '"';
                            ?>
                            <?php endif; ?>

                            <div
                                class="list-group-item li-gr-it-no-space-flx justify-content-between align-items-center mb-2">
                                <div class="text-truncate">
                                    <p class="text-gray-300 text-xs mb-0">
                                        <?php echo e(date('d M Y', strtotime($item->created_at))); ?></p>
                                    <a href="<?php echo e(route('sett.lab.show', $item->id)); ?>"
                                        class="text-xs link-cust-text text-gray-500 text-truncate"><i
                                            class="fas fa-file-medical-alt text-gray-300 me-1 text-truncate"></i>
                                        <?php echo e($item->service_item->name); ?></a>
                                </div>

                                <div>
                                    <a class="text-gray-400" <?php echo $lab_href ?>>
                                        <?php echo $lab_status_btn ?>
                                    </a>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="card-body align-items-center text-center position-relative">
                        <a class="add-new-iteam stretched-link link-cust-text text-gray-400" href="#"
                            data-bs-toggle="modal" data-bs-target="#adddxـray">
                            <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                            <p class="fw-light mb-0">You can put your notes</p>
                        </a>
                    </div>
                    <?php endif; ?>

                    <!-- Card footer -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#lab_show">
                            <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                        </a>
                    </div>
                </div>

                <!----------- operation comperation start content ----------->
                <div class="carousel-item">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer"><?php echo e(__('basic.operations')); ?></span>
                            <span
                                class="m-0 text-x link-cust-text me-2 text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#lab-operation" data-bs-slide-to="2" aria-label="Slide 3">
                                <?php echo e(__('basic.attachments')); ?></span>
                            <span class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#lab-operation" data-bs-slide-to="0" aria-label="Slide 1">
                                <?php echo e(__('patientappo.lab results')); ?></span>
                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#add_operation"><?php echo e(__('patientappo.new operation')); ?></a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->
                    <?php if(!$patient->operations->isEmpty()): ?>
                    <div id="medicine_card_home" class="card-body align-items-center">

                        <?php $__currentLoopData = $patient->operations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        
                        <?php if($loop->index === 3) break; ?>

                        <?php if($item->status == 0): ?>
                        <?php
                        $text_color = 'not_accepted-color';
                        $msg = __('patientappo.not scheduled');
                        ?>
                        <?php elseif($item->status == 1): ?>
                        <?php
                        $text_color = 'main-color';
                        $msg = __('patientappo.scheduled');
                        ?>
                        <?php elseif($item->status == 2): ?>
                        <?php
                        $text_color = 'arrived-color';
                        $msg = __('patientappo.accepted');
                        ?>
                        <?php elseif($item->status == 3): ?>
                        <?php
                        $text_color = 'done-color';
                        $msg = __('patientappo.done');
                        ?>
                        <?php elseif($item->status == 4): ?>
                        <?php
                        $text_color = 'notresp-color';
                        $msg = __('patientappo.not respond');
                        ?>
                        <?php elseif($item->status == 5): ?>
                        <?php
                        $text_color = 'inprog-color';
                        $msg = __('patientappo.postponed');
                        ?>
                        <?php elseif($item->status == 6): ?>
                        <?php
                        $text_color = 'cancel-color';
                        $msg = __('patientappo.canceled');
                        ?>
                        <?php endif; ?>

                        <?php if($item->invoice_item): ?>
                        <?php if($item->invoice_item->invoice->status == 0): ?>
                        <?php
                        $text_color_invoice = 'cancel-color-btn';
                        $msg_invoice = __('basic.not paid');
                        ?>
                        <?php elseif($item->invoice_item->invoice->status == 1): ?>
                        <?php
                        $text_color_invoice = 'pend-color-btn';
                        $msg_invoice = __('basic.pending');
                        ?>
                        <?php elseif($item->invoice_item->invoice->status == 2): ?>
                        <?php
                        $text_color_invoice = 'prog-color-btn';
                        $msg_invoice = __('basic.installment');
                        ?>
                        <?php elseif($item->invoice_item->invoice->status == 3): ?>
                        <?php
                        $text_color_invoice = 'done-color-btn';
                        $msg_invoice = __('basic.paid');
                        ?>
                        <?php elseif($item->invoice_item->invoice->status == 4): ?>
                        <?php
                        $text_color_invoice = 'cancel-color-btn';
                        $msg_invoice = __('basic.refund');
                        ?>
                        <?php endif; ?>
                        <?php else: ?>
                        <?php
                        $text_color_invoice = 'done-color-btn';
                        $msg_invoice = __('patientappo.old record');
                        ?>
                        <?php endif; ?>
                        <div class="d-flex justify-content-between align-items-center mb-3">

                            <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                <i class="fas fa-circle me-2 text-xxs mb-0 <?php echo e($text_color); ?>"></i>

                                <div class="text-truncate">
                                    <p class="text-gray-300 text-xxs mb-0">
                                        <?php echo e(date('h:i a d M Y', strtotime($item->start_at))); ?></p>
                                    <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                        <?php if($item->service_item): ?>
                                        <?php echo e($item->service_item->name); ?>

                                        <?php else: ?>
                                        Deleted Service
                                        <?php endif; ?>
                                    </p>
                                    <p class="text-xs text-gray-300 fw-bold mb-0"><?php echo e($msg); ?></p>
                                </div>
                            </div>

                            <span class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span>

                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php else: ?>
                    <div class="card-body align-items-center text-center position-relative">
                        <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                            data-bs-toggle="modal" data-bs-target="#add_operation">
                            <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                            <p class="fw-light mb-0"><?php echo e(__('patientappo.new operation')); ?></p>
                        </a>
                    </div>

                    <?php endif; ?>

                    <!-- Card footer session -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#operations_show">
                            <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                        </a>
                    </div>
                </div>

                <!----------- attatchment comperation start content ----------->
                <div class="carousel-item">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer"><?php echo e(__('basic.attachments')); ?></span>
                            <span
                                class="m-0 me-2 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#lab-operation" data-bs-slide-to="1" aria-label="Slide 1">
                                <?php echo e(__('basic.operations')); ?></span>
                            <span class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#lab-operation" data-bs-slide-to="0" aria-label="Slide 0">
                                <?php echo e(__('patientappo.lab results')); ?></span>

                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#add_attachment"><?php echo e(__('basic.new attachment')); ?></a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->
                    <?php if(!$patient->attachments->isEmpty()): ?>
                    <div id="medicine_card_home" class="card-body align-items-center">

                        <?php $__currentLoopData = $patient->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        
                        <?php if($loop->index === 3) break; ?>

                        <div class="d-flex justify-content-between align-items-center mb-3">

                            <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                <i class="fas fa-image me-2 fs-4 mb-0 <?php echo e($item->name); ?>"></i>

                                <div class="text-truncate">
                                    <p class="text-gray-300 text-xxs mb-0">
                                        <?php echo e($item->date); ?></p>
                                    <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                        <?php echo e($item->name); ?>

                                    </p>
                                </div>
                            </div>

                            <a href="<?php echo e(URL::asset('img/pat_attachments/' . $item->img)); ?>" target="_blank">
                                <span class="badge rounded-pill main-color-btn badge-padd-l"><?php echo e(__('basic.download')); ?></span>
                            </a>

                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php else: ?>
                    <div class="card-body align-items-center text-center position-relative">
                        <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                            data-bs-toggle="modal" data-bs-target="#add_attachment">
                            <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                            <p class="fw-light mb-0"><?php echo e(__('basic.new attachment')); ?></p>
                        </a>
                    </div>

                    <?php endif; ?>

                    <!-- Card footer session -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#attachment_show">
                            <i class="fas fa-chevron-down"></i> <?php echo e(__('basic.more')); ?>

                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal show all lab -->
    <div class="modal fade" id="lab_show" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-x-ray me-1"></i>
                        <?php echo e(__('patientappo.lab results')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-4">

                    <div class="table-responsive">
                        <table class="table display datatable-modal" id="table-lab" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                    <th class="text-xs text-center"><?php echo e(__('basic.code')); ?></th>
                                    <th class="text-xs text-center"><?php echo e(__('patientappo.pay status')); ?></th>
                                    <th class="text-xs text-center"><?php echo e(__('patientappo.pay Code')); ?></th>
                                    <th class="text-xs text-center"><?php echo e(__('basic.status')); ?></th>
                                    <th class="text-xs text-center"><?php echo e(__('basic.note')); ?></th>
                                    <th class="text-xs text-center"><?php echo e(__('basic.created')); ?></th>
                                    <th class="text-xs text-center"><?php echo e(__('basic.handle')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $patient->labs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($item->status == 0): ?>
                                <?php
                                $text_color = 'active-color-btn';
                                $msg = __('basic.sent');
                                ?>
                                <?php elseif($item->status == 1): ?>
                                <?php
                                $text_color = 'done-color-btn';
                                $msg = __('patientappo.done');
                                ?>
                                <?php endif; ?>
                                <?php if($item->invoice_item): ?>
                                <?php if($item->invoice_item->invoice->status == 0): ?>
                                <?php
                                $text_color_invoice = 'cancel-color-btn';
                                $msg_invoice = __('basic.not paid');
                                ?>
                                <?php elseif($item->invoice_item->invoice->status == 1): ?>
                                <?php
                                $text_color_invoice = 'pend-color-btn';
                                $msg_invoice = __('basic.pending');
                                ?>
                                <?php elseif($item->invoice_item->invoice->status == 2): ?>
                                <?php
                                $text_color_invoice = 'prog-color-btn';
                                $msg_invoice = __('basic.installment');
                                ?>
                                <?php elseif($item->invoice_item->invoice->status == 3): ?>
                                <?php
                                $text_color_invoice = 'done-color-btn';
                                $msg_invoice = __('basic.paid');
                                ?>
                                <?php elseif($item->invoice_item->invoice->status == 4): ?>
                                <?php
                                $text_color_invoice = 'cancel-color-btn';
                                $msg_invoice = __('basic.refund');
                                ?>
                                <?php endif; ?>
                                <?php else: ?>
                                <?php
                                $text_color_invoice = 'done-color-btn';
                                $msg_invoice = __('patientappo.old lab');
                                ?>
                                <?php endif; ?>

                                <tr>
                                    <td><a href="<?php echo e(route('sett.lab.show', $item->id)); ?>"
                                            class="link-cust-text text-gray-500 text-truncate"><i
                                                class="fas fa-file-medical-alt link-cust-text text-gray-300 me-1 text-truncate"></i>
                                            <?php echo e($item->service_item->name); ?>

                                        </a></td>
                                    <td class="text-center"><?php echo e($item->code); ?></td>
                                    <td class="text-center"> <span
                                            class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span>
                                    </td>
                                    <td class="text-center">
                                        <?php if($item->invoice_item): ?>
                                        <?php echo e(@$item->invoice_item->invoice->code); ?>

                                        <?php else: ?>
                                        No Payment
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center"> <span
                                            class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                    </td>
                                    <td><?php echo e($item->note_lab); ?></td>

                                    <td class="text-center">
                                        <?php echo e(date('d M Y', strtotime($item->created_at))); ?>

                                    </td>

                                    <td class="text-center">

                                        <?php if(!empty($item->xray_file)): ?>
                                        <a href="<?php echo e(URL::asset('img/lab/' . $item->xray_file)); ?>" target="_blank"
                                            class="btn btn-sm modal-effect status-col-link active-color-btn b-r-xs mb-1"
                                            title="download"><i class="fas fa-arrow-circle-down"></i>
                                            <?php echo e(__('basic.download')); ?>

                                        </a>
                                        <?php endif; ?>
                                        <?php if($item->invoice_item): ?>
                                        <?php if($item->invoice_item->invoice->status == 0): ?>
                                        <a data-lab_id="<?php echo e($item->id); ?>"
                                            data-invoice_id="<?php echo e($item->invoice_item->invoice->id); ?>"
                                            class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 lab_delete_click"
                                            title="delete" data-effect="effect-scale" data-bs-toggle="modal"
                                            data-bs-target="#delete1"><i class="fas fa-trash"></i>
                                            <?php echo e(__('basic.delete')); ?>

                                        </a>
                                        <?php endif; ?>
                                        <?php endif; ?>

                                    </td>

                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="modal-footer">
                    <div class="left-side">
                        <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                    </div>
                    <div class="divider"></div>
                    <div class="right-side">
                        <button type="button" class="btn btn-default btn-link main-color"><?php echo e(__('basic.save changes')); ?></button>
                    </div>
                </div>

            </div>
        </div>

    </div>

    <!-- Modal lab insert data -->
    <div class="modal fade" id="adddxـray" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

            <form action="<?php echo e(route('sett.lab_patient_add')); ?>" method="post" style="display: contents">
                <?php echo e(method_field('POST')); ?>

                <?php echo e(csrf_field()); ?>


                <div class="modal-content b-r-s-cont border-0">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-x-ray me-1"></i>
                            <?php echo e(__('patientappo.new lab')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="row mb-2">

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('patientappo.lab catagory')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <select
                                    class="myselect2-lab-insert select2-hidden-accessible <?php $__errorArgs = ['lab_cat_serv_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="lab_cat_serv_id" name="lab_cat_serv_id" required>
                                    <?php $__currentLoopData = $service_cat_lab; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>" data-price="<?php echo e($item->price); ?>">
                                        <?php echo e($item->name . ' - ' . $item->price . 'EGP'); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <span id="lab_cat_serv_id_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['lab_cat_serv_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>


                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.note')); ?>

                                    <small>(<?php echo e(__('basic.optional')); ?>)</small></label>

                                <textarea name="note_doctor_lab"
                                    class="form-control <?php $__errorArgs = ['note_doctor_lab'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write here your notes .." rows="4" spellcheck="false"></textarea>

                                <span id="note_doctor_lab_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['note_doctor_lab'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>

                            <hr class="my-2">

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.appointment')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <select
                                    class="myselect2-lab-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="last_appointment_id_lab" name="last_appointment_id" required>
                                    <?php $__currentLoopData = $patient->appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>">
                                        <?php echo e($item->start_at); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <span id="last_appointment_id_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.invoice')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <select
                                    class="myselect2-lab-insert-nosearch <?php $__errorArgs = ['lab_cat_invoice'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="lab_cat_invoice_insert" name="lab_cat_invoice" required>
                                    <option value="new">New Invoice</option>
                                    <?php $__currentLoopData = $patient->invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($item->status == 0): ?>
                                    <option value="<?php echo e($item->id); ?>">
                                        <?php echo e($item->service_inv_cat->name . ' - ' . $item->final_price . 'EGP'); ?>

                                    </option>
                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <span id="lab_cat_invoice_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['lab_cat_invoice'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.invoice note')); ?>

                                    <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                <textarea name="invoice_note_lab" class="form-control"
                                    placeholder="Write here your notes .." rows="4" spellcheck="false"></textarea>

                                <span id="session_cat_invoice_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['invoice_note_lab'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>

                        </div>

                        <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">Add
                                New</button>
                        </div>
                    </div>
                </div>
            </form>

        </div>

    </div>

    <!-- Modal lab delete -->
    <div class="modal fade" id="lab_delete" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

            <div class="modal-content shadow-lgg b-r-s-cont border-0">

                <div class="modal-header">
                    <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                        <?php echo e(__('basic.delete')); ?></div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form class="mb-0" action="<?php echo e(route('sett.lab.destroy', 'test')); ?>" method="post">
                    <?php echo e(method_field('delete')); ?>

                    <?php echo e(csrf_field()); ?>


                    <!-- Modal content -->
                    <div class="modal-body px-4">

                        <div class="modal-body delete-conf-input text-center py-0">
                            <p class="mb-0">ِAre
                                you sure you want to delete
                                this
                                X-Ray?</p><br>
                            <input type="hidden" name="lab_id_delete" value="">
                            <input type="hidden" name="lab_invoice_id_delete" value="">
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link text-red"><?php echo e(__('basic.delete')); ?>

                            </button>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>

    <!-- Modal show all operations -->
    <div class="modal fade" id="operations_show" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-procedures me-1"></i>
                        <?php echo e(__('basic.operations')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-4">

                    <?php $__currentLoopData = $patient->operations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($item->status == 0): ?>
                    <?php
                    $text_color = 'not_accepted-color-btn';
                    $msg = __('patientappo.not scheduled');
                    ?>
                    <?php elseif($item->status == 1): ?>
                    <?php
                    $text_color = 'main-color-btn';
                    $msg = __('patientappo.scheduled');
                    ?>
                    <?php elseif($item->status == 2): ?>
                    <?php
                    $text_color = 'active-color-btn';
                    $msg = __('patientappo.accepted');
                    ?>
                    <?php elseif($item->status == 3): ?>
                    <?php
                    $text_color = 'done-color-btn';
                    $msg = __('patientappo.with doctor');
                    $msg = __('patientappo.done');
                    ?>
                    <?php elseif($item->status == 4): ?>
                    <?php
                    $text_color = 'pend-color-btn';
                    $msg = __('patientappo.not respond');
                    ?>
                    <?php elseif($item->status == 5): ?>
                    <?php
                    $text_color = 'prog-color-btn';
                    $msg = __('patientappo.postponed');
                    ?>
                    <?php elseif($item->status == 6): ?>
                    <?php
                    $text_color = 'cancel-color-btn';
                    $msg = __('patientappo.canceled');
                    ?>
                    <?php endif; ?>

                    <?php if($item->invoice_item): ?>
                    <?php if($item->invoice_item->invoice->status == 0): ?>
                    <?php
                    $text_color_invoice = 'cancel-color-btn';
                    $msg_invoice = __('basic.not paid');
                    ?>
                    <?php elseif($item->invoice_item->invoice->status == 1): ?>
                    <?php
                    $text_color_invoice = 'pend-color-btn';
                    $msg_invoice = __('basic.pending');
                    ?>
                    <?php elseif($item->invoice_item->invoice->status == 2): ?>
                    <?php
                    $text_color_invoice = 'prog-color-btn';
                    $msg_invoice = __('basic.installment');
                    ?>
                    <?php elseif($item->invoice_item->invoice->status == 3): ?>
                    <?php
                    $text_color_invoice = 'done-color-btn';
                    $msg_invoice = __('basic.paid');
                    ?>
                    <?php elseif($item->invoice_item->invoice->status == 4): ?>
                    <?php
                    $text_color_invoice = 'cancel-color-btn';
                    $msg_invoice = __('basic.refund');
                    ?>
                    <?php endif; ?>
                    <?php
                    $invoice_id_operation = route('sett.invoice.show', $item->invoice_item->invoice->id);
                    ?>
                    <?php else: ?>
                    <?php
                    $msg_invoice = 'Old Appointment';
                    $text_color_invoice = 'done-color-btn';
                    $invoice_id_operation = '';
                    ?>
                    <?php endif; ?>

                    <div class="p-2">

                        <div class="row mb-2">
                            <div class="col-6 col-md-3">
                                <div class="d-flex">
                                    <i class="fas fs-1 fa-procedures me-2 align-self-center text-gray-400"></i>
                                    <div>
                                        <p class="text-xxs mb-0 text-gray-300">
                                            <?php echo e(date('h:i a Y-m-d', strtotime($item->start_at))); ?></p>
                                        <h6 class="mb-0 fw-bold">
                                            <?php if($item->service_item): ?>
                                            <?php echo e($item->service_item->name); ?>

                                            <?php else: ?>
                                            Deleted Service
                                            <?php endif; ?>
                                        </h6>
                                        <p class="text-xxs mb-0 text-gray-300">Op place: <?php echo e($item->place->name); ?>

                                            <?php if(isset($item->doctor->first_name)): ?>
                                            with
                                            docotr <span class="fw-bold"><?php echo e($item->doctor->first_name); ?></span>
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6 col-md-3 text-center align-self-center">
                                <p class="text-xs text-gray-200 mb-1">Status</p>
                                <h6 class="text-s text-gray-400 text-truncate">
                                    <span class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                </h6>
                            </div>
                            <div class="col-4 col-md-2 text-center align-self-center">
                                <p class="text-xs text-gray-200 mb-1">Payment</p>
                                <h6 class="text-s text-gray-400 text-truncate">
                                    <a href="<?php echo e($invoice_id_operation); ?>"><span
                                            class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span></a>
                                </h6>
                            </div>
                            <div class="col-4 col-md-2 text-center align-self-center">
                                <p class="text-xs text-gray-200 mb-0">Improvment Rate</p>
                                <?php if($item->improvement_rate): ?>
                                <span class="text-gray-400"><?php echo e($item->improvement_rate); ?></span>
                                <?php else: ?>
                                <span class="text-gray-400">Not selected</span>
                                <?php endif; ?>
                            </div>

                            <div class="col-4 col-md-2 text-center align-self-center">
                                <a data-operation_id="<?php echo e($item->id); ?>" data-status_operation="<?php echo e($item->status); ?>"
                                    data-note_operation="<?php echo e($item->note); ?>"
                                    data-improvement_rate="<?php echo e($item->improvement_rate); ?>"
                                    class="btn rounded-pill btn-sm status-col-link active-color-btn b-r-xs operation_edit_click px-4"
                                    title="edit"><i class="fas fa-pencil-alt"></i>
                                    <?php echo e(__('basic.edit')); ?> </a>

                                <?php if($item->invoice_item): ?>
                                <?php if($item->invoice_item->invoice->status == 0): ?>
                                <a data-operation_id="<?php echo e($item->id); ?>"
                                    class="btn rounded-pill btn-sm status-col-link active-color-btn b-r-xs cancel-color-btn b-r-xs mt-1 px-4 operation_delete_click"
                                    title="delete" data-effect="effect-scale" data-bs-toggle="modal"
                                    data-bs-target="#delete1"><i class="fas fa-trash"></i>
                                    <?php echo e(__('basic.delete')); ?>

                                </a>
                                <?php endif; ?>
                                <?php endif; ?>

                            </div>
                        </div>

                        <div class="accordion accordion-100" id="accordionExample">
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingSpec">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseStat" aria-expanded="true"
                                        aria-controls="collapseStat">
                                        <i class="fas fa-x-ray me-1"></i> <?php echo e(__('patientappo.pre op')); ?>

                                    </button>
                                </h2>
                                <div id="collapseStat" class="accordion-collapse collapse show"
                                    aria-labelledby="headingSpec" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <div class="d-flex justify-content-between add_exam_modal" data-type="op"
                                            data-id="<?php echo e($item->id); ?>">
                                            <p class="text-gray-300">Here is all info before the operation</p>
                                            <div class="clickable-item-pointer">
                                                <p><i class="fas fa-plus"></i>
                                                    <?php if($item->pre_op_draw): ?>
                                                    Update
                                                    <?php else: ?>
                                                    Add New
                                                    <?php endif; ?>
                                                </p>
                                            </div>
                                        </div>

                                        <div class="d-flex flex-wrap justify-content-center">
                                            <div class="mb-3 mb-md-0"
                                                style="background-image: url('<?php echo e(asset('img/dashboard/system/human_front.jpg')); ?>'); width:255px; height:457px; position: relative;">
                                                <?php if(!empty($item->pre_op_draw->front)): ?>
                                                <img src="<?php echo e(URL::asset('img/diseasedraw/' . $item->pre_op_draw->front)); ?>"
                                                    width="255" height="457"
                                                    style=" solid;position: absolute;top:0;left:0;">
                                                <?php else: ?>
                                                <div class="ms-4 text-center main-color-bg text-white p-2 b-r-s-cont"
                                                    style=" solid;position: absolute;top:13rem;left:3rem;">
                                                    <?php echo e(__('patientappo.no back draw')); ?>

                                                </div>
                                                <?php endif; ?>
                                            </div>
                                            <div class="mb-3 mb-md-0"
                                                style="background-image: url('<?php echo e(asset('img/dashboard/system/human_back.jpg')); ?>'); width:255px; height:457px; position: relative;">

                                                <?php if(!empty($item->pre_op_draw->back)): ?>
                                                <img src="<?php echo e(URL::asset('img/diseasedraw/' . $item->pre_op_draw->back)); ?>"
                                                    width="255" height="457"
                                                    style=" solid;position: absolute;top:0;left:0;">
                                                <?php else: ?>
                                                <div class="ms-4 text-center main-color-bg text-white p-2 b-r-s-cont"
                                                    style=" solid;position: absolute;top:13rem;left:3rem;">
                                                    <?php echo e(__('patientappo.no front draw')); ?>

                                                </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="mb-2">
                                            <label class="form-label mb-1"><?php echo e(__('patientappo.examination note')); ?>:</label>
                                            <div class="form-control-textarea overflow-auto"
                                                style="border-radius: 13px !important; border: 1px solid #d5d5d5;">
                                                <?php if(!empty($item->pre_op_draw->note)): ?>
                                                <?php echo e($item->pre_op_draw->note); ?>

                                                <?php else: ?>
                                                No Note
                                                <?php endif; ?>
                                            </div>
                                        </div>

                                        <div class="table-responsive">
                                            <table class="table display datatable-modal" id="table-disease" width="100%"
                                                cellspacing="0">
                                                <thead>
                                                    <tr>
                                                        <th class="text-xs w-25"><?php echo e(__('basic.name')); ?>

                                                        </th>
                                                        <th class="text-xs text-center">
                                                            <?php echo e(__('basic.start')); ?></th>
                                                        <th class="text-xs text-center">
                                                            <?php echo e(__('basic.end')); ?></th>
                                                        <th class="text-xs text-center">
                                                            <?php echo e(__('basic.status')); ?></th>
                                                        <th class="text-xs text-center">
                                                            <?php echo e(__('basic.handle')); ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__currentLoopData = $item->diseases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item_des): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($item_des->status == 0): ?>
                                                    <?php
                                                    $text_color = 'active-color-btn';
                                                    $msg = __('patientappo.still');
                                                    ?>
                                                    <?php elseif($item_des->status == 1): ?>
                                                    <?php
                                                    $text_color = 'done-color-btn';
                                                    $msg = __('patientappo.healed');
                                                    ?>
                                                    <?php endif; ?>

                                                    <tr>
                                                        <td class="w-25">
                                                            <?php echo e($item_des->diseasecats->name); ?></td>
                                                        <td><?php echo e($item_des->start); ?></td>
                                                        <td class="text-center"><?php echo e($item_des->end); ?>

                                                        </td>
                                                        <td class="text-center"> <span
                                                                class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                                        </td>

                                                        <td class="text-center">
                                                            <a data-disease_id="<?php echo e($item_des->id); ?>"
                                                                data-diseasecats_id="<?php echo e($item_des->diseasecats->id); ?>"
                                                                data-status_disease="<?php echo e($item_des->status); ?>"
                                                                data-start="<?php echo e($item_des->start); ?>"
                                                                data-end="<?php echo e($item_des->end); ?>"
                                                                class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 disease_edit_click"
                                                                title="edit"><i class="fas fa-pencil-alt"></i>
                                                                <?php echo e(__('basic.edit')); ?> </a>

                                                            <a data-disease_id="<?php echo e($item_des->id); ?>"
                                                                class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 disease_delete_click"
                                                                title="delete" data-effect="effect-scale"><i
                                                                    class="fas fa-trash"></i>
                                                                <?php echo e(__('basic.delete')); ?>

                                                            </a>

                                                        </td>

                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="duringop-accor">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseReco" aria-expanded="true"
                                        aria-controls="collapseReco">
                                        <i class="fas fa-pager me-1"></i> <?php echo e(__('patientappo.during op')); ?>

                                    </button>
                                </h2>
                                <div id="collapseReco" class="accordion-collapse collapse"
                                    aria-labelledby="duringop-accor" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">

                                        <?php if($item->during_op): ?>
                                        <form class="mb-0" action="<?php echo e(route('sett.operation_patient_during_op_upd')); ?>"
                                            method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PUT'); ?>

                                            <div class="row mb-2 text-gray-700">

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Dorsum (Hump
                                                            Reduction Bony)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                <?php if($item->during_op->dorsum_hump_reduction_bony): ?>
                                                            checked <?php endif; ?> name="dorsum_hump_reduction_bony"
                                                            type="checkbox" value="1"
                                                            id="dorsum_hump_reduction_bony_up"><label
                                                                for="dorsum_hump_reduction_bony_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['dorsum_hump_reduction_bony'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Dorsum
                                                            (Hump
                                                            Reduction Septal)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                <?php if($item->during_op->dorsum_hump_reduction_septal): ?>
                                                            checked <?php endif; ?>
                                                            name="dorsum_hump_reduction_septal"
                                                            type="checkbox" value="1"
                                                            id="dorsum_hump_reduction_septal_up"><label
                                                                for="dorsum_hump_reduction_septal_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['dorsum_hump_reduction_septal'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Dorsum (Hump
                                                            Reduction Cartilaginous)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                <?php if($item->during_op->dorsum_hump_reduction_cartilaginous): ?>
                                                            checked <?php endif; ?>
                                                            name="dorsum_hump_reduction_cartilaginous"
                                                            type="checkbox" value="1"
                                                            id="dorsum_hump_reduction_cartilaginous_up"><label
                                                                for="dorsum_hump_reduction_cartilaginous_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['dorsum_hump_reduction_cartilaginous'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Dorsum
                                                            (Augmentation)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="dorsum_augmentation"
                                                                <?php if($item->during_op->dorsum_augmentation): ?> checked
                                                            <?php endif; ?> type="checkbox" value="1"
                                                            id="dorsum_augmentation_up"><label
                                                                for="dorsum_augmentation_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['dorsum_augmentation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Septum (Caudal
                                                            Resection)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="dorsum_caudal_resection"
                                                                type="checkbox"
                                                                <?php if($item->during_op->dorsum_caudal_resection): ?> checked
                                                            <?php endif; ?>
                                                            value="1"
                                                            id="dorsum_caudal_resection_up"><label
                                                                for="dorsum_caudal_resection_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['dorsum_caudal_resection'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Septum (Excision
                                                            Except Lat. Strut)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                <?php if($item->during_op->septum_excision_except): ?> checked
                                                            <?php endif; ?>
                                                            name="septum_excision_except" type="checkbox"
                                                            value="1"
                                                            id="septum_excision_except_up"><label
                                                                for="septum_excision_except_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['septum_excision_except'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Septum (Total
                                                            Excision & Reconstruction)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                <?php if($item->during_op->septum_total_excision_reconstruction): ?>
                                                            checked <?php endif; ?>
                                                            name="septum_total_excision_reconstruction"
                                                            type="checkbox" value="1"
                                                            id="septum_total_excision_reconstruction_up"><label
                                                                for="septum_total_excision_reconstruction_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['septum_total_excision_reconstruction'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Septum
                                                            (Reconstruction)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                <?php if($item->during_op->septum_reconstruction): ?> checked
                                                            <?php endif; ?>
                                                            name="septum_reconstruction" type="checkbox"
                                                            value="1"
                                                            id="septum_reconstruction_up"><label
                                                                for="septum_reconstruction_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['septum_reconstruction'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Septum (Fixation
                                                            to
                                                            the spine)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                <?php if($item->during_op->septum_fixation_spine): ?> checked
                                                            <?php endif; ?>
                                                            name="septum_fixation_spine" type="checkbox"
                                                            value="1"
                                                            id="septum_fixation_spine_up"><label
                                                                for="septum_fixation_spine_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['septum_fixation_spine'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Septum (Fixation
                                                            to
                                                            the Nasal Bones)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                <?php if($item->during_op->septum_fixation_nasal_bones): ?>
                                                            checked
                                                            <?php endif; ?>
                                                            name="septum_fixation_nasal_bones"
                                                            type="checkbox" value="1"
                                                            id="septum_fixation_nasal_bones_up"><label
                                                                for="septum_fixation_nasal_bones_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['septum_fixation_nasal_bones'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Septum
                                                            (Scoring)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="septum_scoring"
                                                                <?php if($item->during_op->septum_scoring): ?> checked <?php endif; ?>
                                                            type="checkbox" value="1"
                                                            id="septum_scoring_up"><label for="septum_scoring_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['septum_scoring'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Osteotomies (Med.
                                                            Oblique)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="osteotomies_med_oblique"
                                                                type="checkbox"
                                                                <?php if($item->during_op->osteotomies_med_oblique): ?> checked
                                                            <?php endif; ?>
                                                            value="1"
                                                            id="osteotomies_med_oblique_up"><label
                                                                for="osteotomies_med_oblique_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['osteotomies_med_oblique'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Osteotomies
                                                            (Lateral)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="osteotomies_lateral"
                                                                <?php if($item->during_op->osteotomies_lateral): ?> checked
                                                            <?php endif; ?>
                                                            type="checkbox" value="1"
                                                            id="osteotomies_lateral_up"><label
                                                                for="osteotomies_lateral_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['osteotomies_lateral'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Osteotomies
                                                            (Multiple)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="osteotomies_multiple"
                                                                type="checkbox"
                                                                <?php if($item->during_op->osteotomies_multiple): ?> checked
                                                            <?php endif; ?>
                                                            value="1"
                                                            id="osteotomies_multiple_up"><label
                                                                for="osteotomies_multiple_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['osteotomies_multiple'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Osteotomies (Bone
                                                            carving)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="osteotomies_bone_carving"
                                                                <?php if($item->during_op->osteotomies_bone_carving): ?> checked
                                                            <?php endif; ?>
                                                            type="checkbox" value="1"
                                                            id="osteotomies_bone_carving_up"><label
                                                                for="osteotomies_bone_carving_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['osteotomies_bone_carving'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Upper Lats
                                                            (On-lay
                                                            Grafts)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="upper_lats_on_lay_grafts"
                                                                <?php if($item->during_op->upper_lats_on_lay_grafts): ?> checked
                                                            <?php endif; ?>
                                                            type="checkbox" value="1"
                                                            id="upper_lats_on_lay_grafts_up"><label
                                                                for="upper_lats_on_lay_grafts_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['upper_lats_on_lay_grafts'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Upper Lats (
                                                            Total
                                                            Reconstruction )</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                name="upper_lats_total_reconstruction" type="checkbox"
                                                                value="1"
                                                                <?php if($item->during_op->upper_lats_total_reconstruction): ?>
                                                            checked <?php endif; ?>
                                                            id="upper_lats_total_reconstruction_up"><label
                                                                for="upper_lats_total_reconstruction_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['upper_lats_total_reconstruction'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Upper Lats
                                                            (Spreader Grafts)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="upper_lats_spreader_grafts"
                                                                <?php if($item->during_op->upper_lats_spreader_grafts): ?>
                                                            checked <?php endif; ?>
                                                            type="checkbox" value="1"
                                                            id="upper_lats_spreader_grafts_up"><label
                                                                for="upper_lats_spreader_grafts_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['upper_lats_spreader_grafts'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Upper Lats
                                                            (Spreader Flaps)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="upper_lats_spreader_flaps"
                                                                <?php if($item->during_op->upper_lats_spreader_flaps): ?> checked
                                                            <?php endif; ?>
                                                            type="checkbox" value="1"
                                                            id="upper_lats_spreader_flaps_up"><label
                                                                for="upper_lats_spreader_flaps_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['upper_lats_spreader_flaps'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Tip
                                                            Plasty
                                                            (Hemidomal Suture)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="tip_plasty_hemidomal_suture"
                                                                <?php if($item->during_op->tip_plasty_hemidomal_suture): ?>
                                                            checked <?php endif; ?>
                                                            type="checkbox" value="1"
                                                            id="tip_plasty_hemidomal_suture_up"><label
                                                                for="tip_plasty_hemidomal_suture_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['tip_plasty_hemidomal_suture'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Tip
                                                            Plasty (Tip
                                                            Defining Suture)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                name="tip_plasty_tip_defining_suture"
                                                                <?php if($item->during_op->tip_plasty_tip_defining_suture): ?>
                                                            checked <?php endif; ?>
                                                            type="checkbox" value="1"
                                                            id="tip_plasty_tip_defining_suture_up"><label
                                                                for="tip_plasty_tip_defining_suture_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['tip_plasty_tip_defining_suture'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Tip
                                                            Plasty (Tip
                                                            Equalizing Suture)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                name="tip_plasty_tip_equalizing_suture"
                                                                <?php if($item->during_op->tip_plasty_tip_equalizing_suture): ?>
                                                            checked <?php endif; ?>
                                                            type="checkbox" value="1"
                                                            id="tip_plasty_tip_equalizing_suture_up"><label
                                                                for="tip_plasty_tip_equalizing_suture_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['tip_plasty_tip_equalizing_suture'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Tip Plasty
                                                            (Other
                                                            Sutures)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="tip_plasty_other_sutures"
                                                                <?php if($item->during_op->tip_plasty_other_sutures): ?> checked
                                                            <?php endif; ?>
                                                            type="checkbox" value="1"
                                                            id="tip_plasty_other_sutures_up"><label
                                                                for="tip_plasty_other_sutures_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['tip_plasty_other_sutures'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Cap
                                                            Graft
                                                            (Non-Crushed Cartilage)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                name="cap_graft_non_crushed_cartilage"
                                                                <?php if($item->during_op->cap_graft_non_crushed_cartilage): ?>
                                                            checked <?php endif; ?>
                                                            type="checkbox" value="1"
                                                            id="cap_graft_non_crushed_cartilage_up"><label
                                                                for="cap_graft_non_crushed_cartilage_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['cap_graft_non_crushed_cartilage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Cap Graft
                                                            (Crushed
                                                            Cartilage)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="cap_graft_crushed_cartilage"
                                                                <?php if($item->during_op->cap_graft_crushed_cartilage): ?>
                                                            checked <?php endif; ?>
                                                            type="checkbox" value="1"
                                                            id="cap_graft_crushed_cartilage_up"><label
                                                                for="cap_graft_crushed_cartilage_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['cap_graft_crushed_cartilage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Cap
                                                            Graft (Soft
                                                            Tissue Cartilage)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                name="cap_graft_soft_tissue_cartilage"
                                                                <?php if($item->during_op->cap_graft_soft_tissue_cartilage): ?>
                                                            checked <?php endif; ?>
                                                            type="checkbox" value="1"
                                                            id="cap_graft_soft_tissue_cartilage_up"><label
                                                                for="cap_graft_soft_tissue_cartilage_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['cap_graft_soft_tissue_cartilage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal"
                                                            id="tip_plasty_shield_graft">Tip-Plasty
                                                            (Shield
                                                            Graft)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="tip_plasty_shield_graft"
                                                                type="checkbox"
                                                                <?php if($item->during_op->tip_plasty_shield_graft): ?> checked
                                                            <?php endif; ?>
                                                            value="1"
                                                            id="tip_plasty_shield_graft_up"><label
                                                                for="tip_plasty_shield_graft_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['tip_plasty_shield_graft'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Tip-Plasty
                                                            (Columellar Strut)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="tip_plasty_columellar_strut"
                                                                <?php if($item->during_op->tip_plasty_columellar_strut): ?>
                                                            checked <?php endif; ?>
                                                            type="checkbox" value="1"
                                                            id="tip_plasty_columellar_strut_up"><label
                                                                for="tip_plasty_columellar_strut_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['tip_plasty_columellar_strut'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Tools (Rose
                                                            head
                                                            Drill)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="tools_rose_head_drill"
                                                                type="checkbox"
                                                                <?php if($item->during_op->tools_rose_head_drill): ?> checked
                                                            <?php endif; ?>
                                                            value="1"
                                                            id="tools_rose_head_drill_up"><label
                                                                for="tools_rose_head_drill_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['tools_rose_head_drill'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Tools (Burr
                                                            head
                                                            Drill)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="tools_burr_head_drill"
                                                                type="checkbox"
                                                                <?php if($item->during_op->tools_burr_head_drill): ?> checked
                                                            <?php endif; ?>
                                                            value="1"
                                                            id="tools_burr_head_drill_up"><label
                                                                for="tools_burr_head_drill_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['tools_burr_head_drill'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal"
                                                            id="service_final_info">Tools (Piezotome
                                                            )</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="tools_piezotome"
                                                                <?php if($item->during_op->tools_piezotome): ?> checked <?php endif; ?>
                                                            type="checkbox" value="1"
                                                            id="tools_piezotome_up"><label for="tools_piezotome_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['tools_piezotome'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal"
                                                            id="service_final_info">Tools (Hammer &
                                                            Chisel)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="tools_hammer_chisel"
                                                                <?php if($item->during_op->tools_hammer_chisel): ?> checked
                                                            <?php endif; ?>
                                                            type="checkbox" value="1"
                                                            id="tools_hammer_chisel_up"><label
                                                                for="tools_hammer_chisel_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['tools_hammer_chisel'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Dorsal
                                                            Graft</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="dorsal_graft"
                                                                <?php if($item->during_op->dorsal_graft): ?> checked <?php endif; ?>
                                                            type="checkbox" value="1"
                                                            id="dorsal_graft_up"><label for="dorsal_graft_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['dorsal_graft'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Conceal Cartilage
                                                            Graft</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="conceal_cartilage_graft"
                                                                type="checkbox"
                                                                <?php if($item->during_op->conceal_cartilage_graft): ?> checked
                                                            <?php endif; ?>
                                                            value="1"
                                                            id="conceal_cartilage_graft_up"><label
                                                                for="conceal_cartilage_graft_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['conceal_cartilage_graft'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal"
                                                            id="service_final_info">Costal Cartilage
                                                            Graft</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="costal_cartilage_graft"
                                                                type="checkbox"
                                                                <?php if($item->during_op->costal_cartilage_graft): ?> checked
                                                            <?php endif; ?>
                                                            value="1"
                                                            id="costal_cartilage_graft_up"><label
                                                                for="costal_cartilage_graft_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['costal_cartilage_graft'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal"
                                                            id="service_final_info">Temporal Fascial
                                                            Graft</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="temporal_fascial_graft"
                                                                type="checkbox"
                                                                <?php if($item->during_op->temporal_fascial_graft): ?> checked
                                                            <?php endif; ?>
                                                            value="1"
                                                            id="temporal_fascial_graft_up"><label
                                                                for="temporal_fascial_graft_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['temporal_fascial_graft'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Op. type <small>
                                                            (<?php echo e(__('basic.optional')); ?>)</small></label>

                                                    <input name="op_type" type="text"
                                                        class="form-control <?php $__errorArgs = ['op_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="Write here.."
                                                        value="<?php echo e($item->during_op->other_steps); ?>">

                                                    <span id="op_type_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['op_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Tools
                                                            (Raspier)</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="tools_raspier"
                                                                <?php if($item->during_op->tools_raspier): ?> checked <?php endif; ?>
                                                            type="checkbox" value="1"
                                                            id="tools_raspier_up"><label for="tools_raspier_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['tools_raspier'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal"
                                                            id="service_final_info">Nostril
                                                            Reduction</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn" name="nostril_reduction"
                                                                <?php if($item->during_op->nostril_reduction): ?> checked <?php endif; ?>
                                                            type="checkbox" value="1"
                                                            id="nostril_reduction_up"><label for="nostril_reduction_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['nostril_reduction'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Other steps <small>
                                                            (<?php echo e(__('basic.optional')); ?>)</small></label>

                                                    <input name="other_steps" type="text"
                                                        class="form-control <?php $__errorArgs = ['other_steps'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="Write here.."
                                                        value="<?php echo e($item->during_op->other_steps); ?>">

                                                    <span id="other_steps_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['other_steps'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Other Operations <small>
                                                            (<?php echo e(__('basic.optional')); ?>)</small></label>

                                                    <input name="other_operations" type="text"
                                                        class="form-control <?php $__errorArgs = ['other_operations'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="Write here.."
                                                        value="<?php echo e($item->during_op->other_operations); ?>">

                                                    <span id="other_operations_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['other_operations'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="row mb-0 mx-0">
                                                    <div class="col-9 fw-bold text-truncate">
                                                        <span class="text-truncate fw-normal">Cephalic
                                                            Resection of
                                                            Lat. Crus
                                                            Cartilage</span>
                                                    </div>
                                                    <div class="col-3 col-md-3 text-center">
                                                        <div class="switch-checkbox">
                                                            <input class="done_btn"
                                                                name="cephalic_resection_lat_crus_cartilage"
                                                                type="checkbox" value="1"
                                                                <?php if($item->during_op->cephalic_resection_lat_crus_cartilage): ?>
                                                            checked <?php endif; ?>
                                                            id="cephalic_resection_lat_crus_cartilage_up"><label
                                                                for="cephalic_resection_lat_crus_cartilage_up"
                                                                class="ms-auto me-auto">Toggle</label>
                                                        </div>
                                                    </div>
                                                    <?php $__errorArgs = ['cephalic_resection_lat_crus_cartilage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Op. Duration <small>
                                                            (<?php echo e(__('basic.op_duration')); ?>)</small></label>

                                                    <input name="op_duration" type="text"
                                                        class="form-control <?php $__errorArgs = ['op_duration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="Write here.."
                                                        value="<?php echo e($item->during_op->op_duration); ?>">

                                                    <span id="op_duration_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['op_duration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Skin Type <small>
                                                            (<?php echo e(__('basic.optional')); ?>)</small></label>

                                                    <input name="skin_type" type="text"
                                                        class="form-control <?php $__errorArgs = ['skin_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="Write here.."
                                                        value="<?php echo e($item->during_op->skin_type); ?>">

                                                    <span id="skin_type_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['skin_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Other Facial Problems <small>
                                                            (<?php echo e(__('basic.optional')); ?>)</small></label>

                                                    <input name="other_facial_problems" type="text"
                                                        class="form-control <?php $__errorArgs = ['other_facial_problems'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="Write here.."
                                                        value="<?php echo e($item->during_op->other_facial_problems); ?>">

                                                    <span id="other_facial_problems_error"
                                                        class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['other_facial_problems'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Length <small>
                                                            (<?php echo e(__('basic.optional')); ?>)</small></label>

                                                    <input name="length" type="text"
                                                        class="form-control <?php $__errorArgs = ['length'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="Write here.."
                                                        value="<?php echo e($item->during_op->length); ?>">

                                                    <span id="length_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['length'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Dorsal Width <small>
                                                            (<?php echo e(__('basic.optional')); ?>)</small></label>

                                                    <input name="dorsal_width" type="text"
                                                        class="form-control <?php $__errorArgs = ['dorsal_width'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="Write here.."
                                                        value="<?php echo e($item->during_op->dorsal_width); ?>">

                                                    <span id="dorsal_width_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['dorsal_width'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Rotation <small>
                                                            (<?php echo e(__('basic.optional')); ?>)</small></label>

                                                    <input name="rotation" type="text"
                                                        class="form-control <?php $__errorArgs = ['rotation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="Write here.."
                                                        value="<?php echo e($item->during_op->rotation); ?>">

                                                    <span id="rotation_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['rotation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Tip Projection <small>
                                                            (<?php echo e(__('basic.optional')); ?>)</small></label>

                                                    <input name="tip_projection" type="text"
                                                        class="form-control <?php $__errorArgs = ['tip_projection'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="Write here.."
                                                        value="<?php echo e($item->during_op->tip_projection); ?>">

                                                    <span id="tip_projection_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['tip_projection'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Alar Base <small>
                                                            (<?php echo e(__('basic.optional')); ?>)</small></label>

                                                    <input name="alar_base" type="text"
                                                        class="form-control <?php $__errorArgs = ['alar_base'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="Write here.."
                                                        value="<?php echo e($item->during_op->alar_base); ?>">

                                                    <span id="alar_base_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['alar_base'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-12 mb-3">
                                                    <label class="form-label">Other Note <small>
                                                            (<?php echo e(__('basic.optional')); ?>)</small></label>

                                                    <textarea name="other_note" class="form-control "
                                                        placeholder="Write here your note .." rows="4"
                                                        spellcheck="false"><?php echo e($item->during_op->other_note); ?></textarea>

                                                    <span id="other_note_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['other_note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <input type="hidden" name="op_during_id"
                                                    value="<?php echo e($item->during_op->id); ?>">

                                                <div class="text-center "><input
                                                        class="main-color-bg btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-blue-200"
                                                        type="submit" value="Update">
                                                </div>
                                            </div>
                                        </form>
                                        <?php else: ?>
                                        <div class="d-flex justify-content-between add_op_during_modal"
                                            data-id="<?php echo e($item->id); ?>">
                                            <p class="text-gray-300">Here is all info during the operation</p>
                                            <div class="clickable-item-pointer">
                                                <p><i class="fas fa-plus"></i> Add New</p>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="after_op_accor">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseAfterOp" aria-expanded="true"
                                        aria-controls="collapseAfterOp">
                                        <i class="fas fa-comment-alt me-1"></i> <?php echo e(__('patientappo.after op')); ?>

                                    </button>
                                </h2>
                                <div id="collapseAfterOp" class="accordion-collapse collapse"
                                    aria-labelledby="after_op_accor" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">

                                        <form class="mb-0" action="<?php echo e(route('sett.operation_patient_past_note')); ?>"
                                            method="POST">

                                            <?php echo e(method_field('PUT')); ?>

                                            <?php echo e(csrf_field()); ?>


                                            <div class="col-12 mb-3">
                                                <label class="form-label">Past Op Note<small>
                                                        (<?php echo e(__('basic.optional')); ?>)</small></label>

                                                <textarea name="note_after_op" class="form-control "
                                                    placeholder="Write here your note after the operation .." rows="4"
                                                    spellcheck="false"><?php echo e($item->note_after_op); ?></textarea>

                                                <span id="note_after_op_error" class="error-msg-form"></span>

                                                <?php $__errorArgs = ['note_after_op'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <input type="hidden" name="op_id" value="<?php echo e($item->id); ?>">

                                            <div class="text-center "><input
                                                    class="main-color-bg btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-blue-200"
                                                    type="submit" value="Update">
                                            </div>
                                        </form>

                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <h2 class="accordion-header" id="gallery_op_accor">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseGallery" aria-expanded="true"
                                        aria-controls="collapseGallery">
                                        <i class="fas fa-images me-1"></i> <?php echo e(__('basic.gallery')); ?>

                                    </button>
                                </h2>
                                <div id="collapseGallery" class="accordion-collapse collapse"
                                    aria-labelledby="gallery_op_accor" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <div class="d-flex justify-content-between add_op_gallery_modal"
                                            data-id="<?php echo e($item->id); ?>">
                                            <p class="text-gray-300">Here is the
                                                op gallery <a class="main-color"
                                                    href="<?php echo e(route('sett.operation_gallery', $item->id)); ?>">CLICK
                                                    HERE FOR LIVE IMAGES</a></p>
                                            <div class="clickable-item-pointer">
                                                <p><i class="fas fa-plus"></i> Add New</p>
                                            </div>
                                        </div>

                                        <p class="text-gray-500 mb-2">Before Op Gallery</p>

                                        <?php $__currentLoopData = $item->gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $g_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($g_item->type == 1): ?>
                                        <div class="d-flex ps-2 justify-content-between align-items-center mb-2">
                                            <div class="d-flex align-items-center">
                                                <i class="fas fa-image fs-3 me-2"></i>
                                                <a href="<?php echo e(URL::asset('img/opgallery/' . $g_item->img)); ?>"
                                                    target="_blank" class="fs-6 text-gray-500" title="download">
                                                    Pre Image
                                                    <?php echo e($key); ?>

                                                </a>
                                            </div>
                                            <div>
                                                <a data-img_id="<?php echo e($g_item->id); ?>"
                                                    class="btn rounded-pill btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 op_img_delete_click"
                                                    title="delete"><i class="fas fa-trash"></i>
                                                    <?php echo e(__('basic.delete')); ?>

                                                </a>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        <hr>

                                        <p class="text-gray-500 mb-2">During Op Gallery</p>

                                        <?php $__currentLoopData = $item->gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $g_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($g_item->type == 2): ?>
                                        <div class="d-flex ps-2 justify-content-between align-items-center mb-2">
                                            <div class="d-flex align-items-center">
                                                <i class="fas fa-image fs-3 me-2"></i>
                                                <a href="<?php echo e(URL::asset('img/opgallery/' . $g_item->img)); ?>"
                                                    target="_blank" class="fs-6 text-gray-500" title="download">
                                                    Pre Image
                                                    <?php echo e($key); ?>

                                                </a>
                                            </div>
                                            <div>
                                                <a data-img_id="<?php echo e($g_item->id); ?>"
                                                    class="btn rounded-pill btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 op_img_delete_click"
                                                    title="delete"><i class="fas fa-trash"></i>
                                                    <?php echo e(__('basic.delete')); ?>

                                                </a>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        <hr>

                                        <p class="text-gray-500 mb-2">After Op Gallery</p>

                                        <?php $__currentLoopData = $item->gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $g_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($g_item->type == 3): ?>
                                        <div class="d-flex ps-2 justify-content-between align-items-center mb-2">
                                            <div class="d-flex align-items-center">
                                                <i class="fas fa-image fs-3 me-2"></i>
                                                <a href="<?php echo e(URL::asset('img/opgallery/' . $g_item->img)); ?>"
                                                    target="_blank" class="fs-6 text-gray-500" title="download">
                                                    Pre Image
                                                    <?php echo e($key); ?>

                                                </a>
                                            </div>
                                            <div>
                                                <a data-img_id="<?php echo e($g_item->id); ?>"
                                                    class="btn rounded-pill btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 op_img_delete_click"
                                                    title="delete"><i class="fas fa-trash"></i>
                                                    <?php echo e(__('basic.delete')); ?>

                                                </a>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>

                <div class="modal-footer">

                </div>

            </div>
        </div>

    </div>

    <!-- Modal operation insert data -->
    <div class="modal fade" id="add_operation" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

            <form action="<?php echo e(route('sett.app_operation_patient_add')); ?>" method="post" enctype="multipart/form-data"
                style="display: contents">
                <?php echo e(method_field('POST')); ?>

                <?php echo e(csrf_field()); ?>


                <div class="modal-content b-r-s-cont border-0">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-procedures me-1"></i>
                            <?php echo e(__('patientappo.new operation')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="row mb-2">

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('patientappo.operation catagory')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <select
                                    class="myselect2-operation-insert select2-hidden-accessible <?php $__errorArgs = ['oper_cat_serv_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="oper_cat_serv_id" name="oper_cat_serv_id" required>
                                    <?php $__currentLoopData = $service_cat_oper; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>" data-price="<?php echo e($item->price); ?>">
                                        <?php echo e($item->name . ' - ' . $item->price . 'EGP'); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <span id="oper_cat_serv_id_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['oper_cat_serv_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('patientappo.operation place')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <select
                                    class="myselect2-operation-insert select2-hidden-accessible <?php $__errorArgs = ['oper_place_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="oper_place_id" name="oper_place_id" required>
                                    <?php $__currentLoopData = $operation_place; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>">
                                        <?php echo e($item->name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <span id="oper_place_id_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['oper_place_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.date')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                        </div>
                                    </div>
                                    <input name="operation_start" value="<?php echo e(date('Y-m-d')); ?>" type="text"
                                        class="form-control hasdatetimepicker <?php $__errorArgs = ['operation_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="YYYY/MM/DD" required>
                                </div>
                                <span id="operation_start_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['operation_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.note')); ?>

                                    <small>(<?php echo e(__('basic.optional')); ?>)</small></label>

                                <textarea name="note_operation"
                                    class="form-control <?php $__errorArgs = ['note_operation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write here your notes .." rows="4" spellcheck="false"></textarea>

                                <span id="note_operation_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['note_operation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.appointment')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <select
                                    class="myselect2-oper-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="last_appointment_id_operation" name="last_appointment_id" required>
                                    <?php $__currentLoopData = $patient->appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>">
                                        <?php echo e($item->start_at); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <span id="last_appointment_id_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['last_appointment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <hr class="my-2">

                            <div class="col-12 mb-2">
                                <label class="form-label"> <?php echo e(__('basic.price')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                <input name="price_invoice_operation" type="number"
                                    class="form-control <?php $__errorArgs = ['price_invoice_operation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write here the price?" required>

                                <span id="price_invoice_update_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['price_invoice_operation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.invoice note')); ?>

                                    <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                                <textarea name="invoice_note_operation" class="form-control"
                                    placeholder="Write here your notes .." rows="4" spellcheck="false"></textarea>

                                <span id="invoice_note_operation_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['invoice_note_operation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>

                        </div>

                        <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">Add
                                New</button>
                        </div>
                    </div>
                </div>
            </form>

        </div>

    </div>

    <!-- Modal operation delete -->
    <div class="modal fade" id="operation_delete" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

            <div class="modal-content shadow-lgg b-r-s-cont border-0">

                <div class="modal-header">
                    <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                        <?php echo e(__('basic.delete')); ?></div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form class="mb-0" action="<?php echo e(route('sett.operation.destroy', 'test')); ?>" method="post">
                    <?php echo e(method_field('delete')); ?>

                    <?php echo e(csrf_field()); ?>


                    <!-- Modal content -->
                    <div class="modal-body px-4">

                        <div class="modal-body delete-conf-input text-center py-0">
                            <p class="mb-0">ِAre you sure you want to delete this Operation?</p><br>
                            <input type="hidden" name="opertion_id_delete" value="">
                            <input type="hidden" name="operation_invoice_id_delete" value="">
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link text-red"><?php echo e(__('basic.delete')); ?>

                            </button>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>

    <!-- Modal operation edit -->
    <div class="modal fade" id="edit_operation" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

            <form class="mb-0" action="<?php echo e(route('sett.app_operation_patient_edit')); ?>" style="display: contents"
                enctype="multipart/form-data" method="POST"> <?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>

                <div class="modal-content b-r-s-cont border-0">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-x-ray me-1"></i>
                            <?php echo e(__('patientappo.edit operation')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="row mb-2">

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('patientappo.operation catagory')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <select
                                    class="myselect2-operation-insert-nosearch select2-hidden-accessible <?php $__errorArgs = ['oper_cat_serv_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="oper_status_up" name="oper_status_up" required>
                                    <option value="0">Not scheduled</option>
                                    <option value="1">Scheduled</option>
                                    <option value="2">accepted</option>
                                    <option value="3">Done</option>
                                    <option value="4">Not respond</option>
                                    <option value="5">postponed</option>
                                    <option value="6">Canceled</option>
                                </select>

                                <span id="oper_status_up_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['oper_status_up'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.note')); ?>

                                    <small>(<?php echo e(__('basic.optional')); ?>)</small></label>

                                <textarea name="note_operation_up"
                                    class="form-control <?php $__errorArgs = ['note_operation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write here your notes .." rows="4" spellcheck="false"></textarea>

                                <span id="note_operation_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['note_operation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label"> <?php echo e(__('patientappo.improvment rate')); ?>

                                    <small>(<?php echo e(__('basic.optional')); ?>)</small></label>

                                <input name="operation_improvment_up" type="number"
                                    class="form-control <?php $__errorArgs = ['operation_improvment_up'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write here the improvment rate from 0-5?">

                                <div class="form-text text-gray-200">The improvment rate from 0 to 5
                                </div>

                                <span id="operation_improvment_up_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['operation_improvment_up'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                        </div>

                        <input name="operation_id_update" value="" type="hidden">

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">Update</button>
                        </div>
                    </div>
                </div>
            </form>

        </div>

    </div>

    <!-------------- Gallery -------------->
    <!-- Modal operation insert data -->
    <div class="modal fade" id="add_gallery" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

            <form action="<?php echo e(route('sett.operation_patient_add_gallery')); ?>" method="post" enctype="multipart/form-data"
                style="display: contents">
                <?php echo e(method_field('POST')); ?>

                <?php echo e(csrf_field()); ?>


                <div class="modal-content b-r-s-cont border-0">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-procedures me-1"></i>
                            <?php echo e(__('patientappo.new op images')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="row mb-2">

                            <div class="col-12 mb-2">
                                <label class="form-label"><?php echo e(__('basic.type')); ?>

                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                <select
                                    class="myselect2-operation-img-insert select2-hidden-accessible <?php $__errorArgs = ['op_ga_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="op_ga_type" name="op_ga_type" required>
                                    <option value="1">
                                        Pre
                                    </option>
                                    <option value="2">
                                        During
                                    </option>
                                    <option value="3">
                                        After
                                    </option>
                                </select>

                                <span id="op_ga_type_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['op_ga_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-2 ">
                                <label class="form-label">Images
                                    <small>(<?php echo e(__('basic.requried')); ?>)</small></label>
                                <input class="form-control file_dropzone_cuts" name='op_imgs[]' accept="image/*"
                                    type="file" id="formFile" multiple required>

                                <div class="form-text text-gray-200">Insert here all picture and every image must
                                    be less than 15MB.
                                </div>

                                <span id="op_imgs_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['op_imgs'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                        </div>

                        <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">
                        <input name="gallery-op-id" value="" type="hidden">

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">Add
                                New</button>
                        </div>
                    </div>
                </div>
            </form>

        </div>

    </div>

    <!-- Modal operation delete -->
    <div class="modal fade" id="op_gallery_img_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

            <div class="modal-content shadow-lgg b-r-s-cont border-0">

                <div class="modal-header">
                    <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                        <?php echo e(__('basic.delete')); ?></div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form class="mb-0" action="<?php echo e(route('sett.operation_patient_delete_gallery')); ?>" method="post">
                    <?php echo e(method_field('delete')); ?>

                    <?php echo e(csrf_field()); ?>


                    <!-- Modal content -->
                    <div class="modal-body px-4">

                        <div class="modal-body delete-conf-input text-center py-0">
                            <p class="mb-0">ِAre you sure you want to delete this Op Img?</p><br>
                            <input type="hidden" name="opertion_id_op_delete" value="">
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link text-red"><?php echo e(__('basic.delete')); ?>

                            </button>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>

    <!-- Modal operation insert during -->
    <div class="modal fade" id="add_during_op" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

            <form action="<?php echo e(route('sett.operation_patient_during_op')); ?>" method="post" style="display: contents">
                <?php echo e(method_field('POST')); ?>

                <?php echo e(csrf_field()); ?>


                <div class="modal-content b-r-s-cont border-0">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-procedures me-1"></i>
                            <?php echo e(__('patientappo.new op images')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="row mb-2 text-gray-700">

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Dorsum (Hump
                                        Reduction Bony)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="dorsum_hump_reduction_bony" type="checkbox"
                                            value="1" id="dorsum_hump_reduction_bony"><label
                                            for="dorsum_hump_reduction_bony" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Dorsum
                                        (Hump
                                        Reduction Septal)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="dorsum_hump_reduction_septal" type="checkbox"
                                            value="1" id="dorsum_hump_reduction_septal"><label
                                            for="dorsum_hump_reduction_septal" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Dorsum (Hump
                                        Reduction Cartilaginous)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="dorsum_hump_reduction_cartilaginous"
                                            type="checkbox" value="1" id="dorsum_hump_reduction_cartilaginous"><label
                                            for="dorsum_hump_reduction_cartilaginous"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Dorsum
                                        (Augmentation)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="dorsum_augmentation" type="checkbox" value="1"
                                            id="dorsum_augmentation"><label for="dorsum_augmentation"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Septum (Caudal
                                        Resection)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="dorsum_caudal_resection" type="checkbox" value="1"
                                            id="dorsum_caudal_resection"><label for="dorsum_caudal_resection"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Septum (Excision
                                        Except Lat. Strut)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="septum_excision_except" type="checkbox" value="1"
                                            id="septum_excision_except"><label for="septum_excision_except"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Septum (Total
                                        Excision & Reconstruction)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="septum_total_excision_reconstruction"
                                            type="checkbox" value="1" id="septum_total_excision_reconstruction"><label
                                            for="septum_total_excision_reconstruction"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Septum
                                        (Reconstruction)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="septum_reconstruction" type="checkbox" value="1"
                                            id="septum_reconstruction"><label for="septum_reconstruction"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Septum (Fixation to
                                        the spine)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="septum_fixation_spine" type="checkbox" value="1"
                                            id="septum_fixation_spine"><label for="septum_fixation_spine"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Septum (Fixation to
                                        the Nasal Bones)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="septum_fixation_nasal_bones" type="checkbox"
                                            value="1" id="septum_fixation_nasal_bones"><label
                                            for="septum_fixation_nasal_bones" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Septum
                                        (Scoring)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="septum_scoring" type="checkbox" value="1"
                                            id="septum_scoring"><label for="septum_scoring"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Osteotomies (Med.
                                        Oblique)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="osteotomies_med_oblique" type="checkbox" value="1"
                                            id="osteotomies_med_oblique"><label for="osteotomies_med_oblique"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Osteotomies
                                        (Lateral)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="osteotomies_lateral" type="checkbox" value="1"
                                            id="osteotomies_lateral"><label for="osteotomies_lateral"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Osteotomies
                                        (Multiple)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="osteotomies_multiple" type="checkbox" value="1"
                                            id="osteotomies_multiple"><label for="osteotomies_multiple"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Osteotomies (Bone
                                        carving)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="osteotomies_bone_carving" type="checkbox"
                                            value="1" id="osteotomies_bone_carving"><label
                                            for="osteotomies_bone_carving" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Upper Lats (On-lay
                                        Grafts)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="upper_lats_on_lay_grafts" type="checkbox"
                                            value="1" id="upper_lats_on_lay_grafts"><label
                                            for="upper_lats_on_lay_grafts" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Upper Lats ( Total
                                        Reconstruction )</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="upper_lats_total_reconstruction" type="checkbox"
                                            value="1" id="upper_lats_total_reconstruction"><label
                                            for="upper_lats_total_reconstruction" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Upper Lats
                                        (Spreader Grafts)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="upper_lats_spreader_grafts" type="checkbox"
                                            value="1" id="upper_lats_spreader_grafts"><label
                                            for="upper_lats_spreader_grafts" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Upper Lats
                                        (Spreader Flaps)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="upper_lats_spreader_flaps" type="checkbox"
                                            value="1" id="upper_lats_spreader_flaps"><label
                                            for="upper_lats_spreader_flaps" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Tip
                                        Plasty
                                        (Hemidomal Suture)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tip_plasty_hemidomal_suture" type="checkbox"
                                            value="1" id="tip_plasty_hemidomal_suture"><label
                                            for="tip_plasty_hemidomal_suture" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Tip
                                        Plasty (Tip
                                        Defining Suture)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tip_plasty_tip_defining_suture" type="checkbox"
                                            value="1" id="tip_plasty_tip_defining_suture"><label
                                            for="tip_plasty_tip_defining_suture" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Tip
                                        Plasty (Tip
                                        Equalizing Suture)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tip_plasty_tip_equalizing_suture" type="checkbox"
                                            value="1" id="tip_plasty_tip_equalizing_suture"><label
                                            for="tip_plasty_tip_equalizing_suture"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Tip Plasty
                                        (Other
                                        Sutures)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tip_plasty_other_sutures" type="checkbox"
                                            value="1" id="tip_plasty_other_sutures"><label
                                            for="tip_plasty_other_sutures" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Cap
                                        Graft
                                        (Non-Crushed Cartilage)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="cap_graft_non_crushed_cartilage" type="checkbox"
                                            value="1" id="cap_graft_non_crushed_cartilage"><label
                                            for="cap_graft_non_crushed_cartilage" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Cap Graft
                                        (Crushed
                                        Cartilage)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="cap_graft_crushed_cartilage" type="checkbox"
                                            value="1" id="cap_graft_crushed_cartilage"><label
                                            for="cap_graft_crushed_cartilage" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Cap
                                        Graft (Soft
                                        Tissue Cartilage)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="cap_graft_soft_tissue_cartilage" type="checkbox"
                                            value="1" id="cap_graft_soft_tissue_cartilage"><label
                                            for="cap_graft_soft_tissue_cartilage" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal" id="tip_plasty_shield_graft">Tip-Plasty
                                        (Shield
                                        Graft)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tip_plasty_shield_graft" type="checkbox" value="1"
                                            id="tip_plasty_shield_graft"><label for="tip_plasty_shield_graft"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Tip-Plasty
                                        (Columellar Strut)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tip_plasty_columellar_strut" type="checkbox"
                                            value="1" id="tip_plasty_columellar_strut"><label
                                            for="tip_plasty_columellar_strut" class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Tools (Rose
                                        head
                                        Drill)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tools_rose_head_drill" type="checkbox" value="1"
                                            id="tools_rose_head_drill"><label for="tools_rose_head_drill"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Tools (Burr
                                        head
                                        Drill)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tools_burr_head_drill" type="checkbox" value="1"
                                            id="tools_burr_head_drill"><label for="tools_burr_head_drill"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal" id="service_final_info">Tools (Piezotome
                                        )</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tools_piezotome" type="checkbox" value="1"
                                            id="tools_piezotome"><label for="tools_piezotome"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal" id="service_final_info">Tools (Hammer &
                                        Chisel)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tools_hammer_chisel" type="checkbox" value="1"
                                            id="tools_hammer_chisel"><label for="tools_hammer_chisel"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Dorsal Graft</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="dorsal_graft" type="checkbox" value="1"
                                            id="dorsal_graft"><label for="dorsal_graft"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Conceal Cartilage Graft</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="conceal_cartilage_graft" type="checkbox" value="1"
                                            id="conceal_cartilage_graft"><label for="conceal_cartilage_graft"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal" id="service_final_info">Costal Cartilage
                                        Graft</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="costal_cartilage_graft" type="checkbox" value="1"
                                            id="costal_cartilage_graft"><label for="costal_cartilage_graft"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['costal_cartilage_graft'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal" id="service_final_info">Temporal Fascial
                                        Graft</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="temporal_fascial_graft" type="checkbox" value="1"
                                            id="temporal_fascial_graft"><label for="temporal_fascial_graft"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['temporal_fascial_graft'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Op. type <small>
                                        (<?php echo e(__('basic.optional')); ?>)</small></label>

                                <input name="op_type" type="text"
                                    class="form-control <?php $__errorArgs = ['op_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write here..">

                                <span id="op_type_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['op_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Tools (Raspier)</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="tools_raspier" type="checkbox" value="1"
                                            id="tools_raspier"><label for="tools_raspier"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['tools_raspier'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal" id="service_final_info">Nostril
                                        Reduction</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="nostril_reduction" type="checkbox" value="1"
                                            id="nostril_reduction"><label for="nostril_reduction"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['nostril_reduction'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Other steps <small>
                                        (<?php echo e(__('basic.optional')); ?>)</small></label>

                                <input name="other_steps" type="text"
                                    class="form-control <?php $__errorArgs = ['other_steps'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write here..">

                                <span id="other_steps_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['other_steps'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Other Operations <small>
                                        (<?php echo e(__('basic.optional')); ?>)</small></label>

                                <input name="other_operations" type="text"
                                    class="form-control <?php $__errorArgs = ['other_operations'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write here..">

                                <span id="other_operations_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['other_operations'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-0 mx-0">
                                <div class="col-9 fw-bold text-truncate">
                                    <span class="text-truncate fw-normal">Cephalic Resection of Lat. Crus
                                        Cartilage</span>
                                </div>
                                <div class="col-3 col-md-3 text-center">
                                    <div class="switch-checkbox">
                                        <input class="done_btn" name="cephalic_resection_lat_crus_cartilage"
                                            type="checkbox" value="1" id="cephalic_resection_lat_crus_cartilage"><label
                                            for="cephalic_resection_lat_crus_cartilage"
                                            class="ms-auto me-auto">Toggle</label>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['cephalic_resection_lat_crus_cartilage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Op. Duration <small>
                                        (<?php echo e(__('basic.op_duration')); ?>)</small></label>

                                <input name="op_duration" type="text"
                                    class="form-control <?php $__errorArgs = ['op_duration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write here..">

                                <span id="op_duration_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['op_duration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Skin Type <small>
                                        (<?php echo e(__('basic.optional')); ?>)</small></label>

                                <input name="skin_type" type="text"
                                    class="form-control <?php $__errorArgs = ['skin_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write here..">

                                <span id="skin_type_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['skin_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Other Facial Problems <small>
                                        (<?php echo e(__('basic.optional')); ?>)</small></label>

                                <input name="other_facial_problems" type="text"
                                    class="form-control <?php $__errorArgs = ['other_facial_problems'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write here..">

                                <span id="other_facial_problems_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['other_facial_problems'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Length <small>
                                        (<?php echo e(__('basic.optional')); ?>)</small></label>

                                <input name="length" type="text"
                                    class="form-control <?php $__errorArgs = ['length'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write here..">

                                <span id="length_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['length'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Dorsal Width <small>
                                        (<?php echo e(__('basic.optional')); ?>)</small></label>

                                <input name="dorsal_width" type="text"
                                    class="form-control <?php $__errorArgs = ['dorsal_width'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write here..">

                                <span id="dorsal_width_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['dorsal_width'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Rotation <small>
                                        (<?php echo e(__('basic.optional')); ?>)</small></label>

                                <input name="rotation" type="text"
                                    class="form-control <?php $__errorArgs = ['rotation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write here..">

                                <span id="rotation_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['rotation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Tip Projection <small>
                                        (<?php echo e(__('basic.optional')); ?>)</small></label>

                                <input name="tip_projection" type="text"
                                    class="form-control <?php $__errorArgs = ['tip_projection'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write here..">

                                <span id="tip_projection_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['tip_projection'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Alar Base <small>
                                        (<?php echo e(__('basic.optional')); ?>)</small></label>

                                <input name="alar_base" type="text"
                                    class="form-control <?php $__errorArgs = ['alar_base'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Write here..">

                                <span id="alar_base_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['alar_base'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"> Other Note <small>
                                        (<?php echo e(__('basic.optional')); ?>)</small></label>

                                <textarea name="other_note" class="form-control " placeholder="Write here your note .."
                                    rows="4" spellcheck="false"></textarea>

                                <span id="other_note_error" class="error-msg-form"></span>

                                <?php $__errorArgs = ['other_note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">
                        <input name="during-op-id" value="" type="hidden">

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">Add
                                New</button>
                        </div>
                    </div>
                </div>
            </form>

        </div>

    </div>





    <!-- Modal new attachment insert data -->
    <div class="modal fade" id="add_attachment" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

            <form action="<?php echo e(route('sett.pat_add_new_attachment')); ?>" method="post" enctype="multipart/form-data"
                style="display: contents">
                <?php echo e(method_field('POST')); ?>

                <?php echo e(csrf_field()); ?>


                <div class="modal-content b-r-s-cont border-0">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-image me-1"></i>
                            <?php echo e(__('basic.new attachment')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="col-12 mb-3">
                            <label class="form-label"><?php echo e(__('basic.name')); ?> <small>
                                    (<?php echo e(__('basic.optional')); ?>)</small></label>
                            <input name="attachments_name" type="text"
                                class="form-control <?php $__errorArgs = ['attachments_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                placeholder="Write here the attachment name .." maxlength="35">

                            <span id="attachments_name" class="error-msg-form"></span>

                            <?php $__errorArgs = ['attachments_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error-msg-form">
                                <?php echo e($message); ?>

                            </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-12 mb-2 ">
                            <label class="form-label"><?php echo e(__('basic.attachments')); ?>

                                <small>(<?php echo e(__('basic.requried')); ?>)</small></label>
                            <input class="form-control file_dropzone_cuts" name='attachments_imgs[]' accept="image/*"
                                type="file" id="formFile" multiple required>

                            <div class="form-text text-gray-200">Insert here all picture and every image must
                                be less than 2MB.
                            </div>

                            <span id="op_imgs_error" class="error-msg-form"></span>

                            <?php $__errorArgs = ['attachments_imgs'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error-msg-form">
                                <?php echo e($message); ?>

                            </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <input name="patient_id" value="<?php echo e($patient->id); ?>" type="hidden">

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">Add
                                New</button>
                        </div>
                    </div>
                </div>
            </form>

        </div>

    </div>




    <!-- Modal show all lab -->
    <div class="modal fade" id="attachment_show" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-image me-1"></i>
                        <?php echo e(__('basic.attachments')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-4">

                    <?php $__currentLoopData = $patient->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="d-flex justify-content-between align-items-center mb-3">

                        <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                            <i class="fas fa-image me-2 fs-4 mb-0 <?php echo e($item->name); ?>"></i>

                            <div class="text-truncate">
                                <p class="text-gray-300 text-xxs mb-0">
                                    <?php echo e($item->date); ?></p>
                                <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                    <?php echo e($item->name); ?>

                                </p>
                            </div>
                        </div>
                        <div>
                            <a data-img_id="<?php echo e($item->id); ?>"
                                class="btn rounded-pill btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 attachment_img_delete_click"
                                title="delete"><i class="fas fa-trash"></i>
                            </a>
                            <a href="<?php echo e(URL::asset('img/pat_attachments/' . $item->img)); ?>" target="_blank">
                                <span class="badge rounded-pill status-col-link main-color-btn badge-padd-l"><?php echo e(__('basic.download')); ?></span>
                            </a>
                        </div>

                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>

                <div class="modal-footer">
                    <div class="left-side">
                        <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                    </div>
                    <div class="divider"></div>
                    <div class="right-side">
                        <button id="new_attachment_modal" type="button" class="btn btn-default btn-link main-color"><?php echo e(__('basic.new attachment')); ?></button>
                    </div>
                </div>

            </div>
        </div>

    </div>


    <!-- Modal operation delete -->
    <div class="modal fade" id="attachment_gallery_img_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

            <div class="modal-content shadow-lgg b-r-s-cont border-0">

                <div class="modal-header">
                    <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                        <?php echo e(__('basic.delete')); ?></div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form class="mb-0" action="<?php echo e(route('sett.pat_delete_new_attachment')); ?>" method="post">
                    <?php echo e(method_field('delete')); ?>

                    <?php echo e(csrf_field()); ?>


                    <!-- Modal content -->
                    <div class="modal-body px-4">

                        <div class="modal-body delete-conf-input text-center py-0">
                            <p class="mb-0">ِAre you sure you want to delete this Op Img?</p><br>
                            <input type="hidden" name="attachment_id_op_delete" value="">
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link text-red"><?php echo e(__('basic.delete')); ?>

                            </button>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/patient/component/clients/ramad/lab.blade.php ENDPATH**/ ?>