<?php $__env->startSection('title', 'Statistics | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Statistics'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-flex align-items-center justify-content-between mb-3">

        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>">Dashboard |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.invoice.index')); ?>">Invoice | </a>
            <a class="text-gray-300">Invoice statistics</a>
        </span>

        <div class="d-flex justify-content-center mt-2 mt-md-0">

            <a class="main-color-bg text-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-1" data-bs-toggle="modal"
                data-bs-target="#new_record"><i class="fas fa-filter fa-sm me-1"></i> Filter</a>

            <!-- Modal for search filtering -->
            <div class="modal fade" id="new_record" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                    <form class="mb-0" action="<?php echo e(route('sett.invo_allstatcs')); ?>" method="GET"
                        style="display: contents">

                        <div class="modal-content b-r-s-cont border-0">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-clipboard me-1"></i>
                                    Search Filter</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row">

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Specialty
                                            <small>(optional)</small></label>
                                        <select
                                            class="myselect2-record-insert myselect2-record-insert-nosearch select2-hidden-accessible"
                                            id="specialty" name="specialty">
                                            <option value="all">
                                                All
                                            </option>
                                            <?php $__currentLoopData = $specialty_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>" <?php if($specialty==$item->id): ?> selected <?php endif; ?>
                                                <?php if($specialty == $item->id): ?> selected <?php endif; ?>>
                                                <?php echo e($item->name); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Branch
                                            <small>(optional)</small></label>
                                        <select
                                            class="myselect2-record-insert myselect2-record-insert-nosearch select2-hidden-accessible"
                                            id="branch" name="branch">
                                            <option value="all">
                                                All
                                            </option>
                                            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>" <?php if($branch==$item->id): ?> selected <?php endif; ?>
                                                <?php if($branch == $item->id): ?> selected <?php endif; ?>>
                                                <?php echo e($item->name); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">From
                                            <small>(optional)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="from" type="text" class="form-control hasdatetimepicker"
                                                value="<?php echo e($from); ?>" placeholder="YYYY/MM">
                                        </div>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">To
                                            <small>(optional)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="to" type="text" class="form-control hasdatetimepicker"
                                                value="<?php echo e($to); ?>" placeholder="YYYY/MM">
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">Never
                                        Mind</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">Search</button>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>

            </div>
        </div>

    </div>


    <div class="row mb-0">
        <ul class="nav nav-tabs nav-tabs-nobg nav-tabs-cat justify-content-center pe-0" id="myTab" role="tablist">
            <li class="nav-item" role="presentation">
                <a href="<?php echo e(route('sett.invo_day_search')); ?>" class="nav-link" id="year_invoice-tab">
                    <?php echo e(__('basic.daily st')); ?></a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="<?php echo e(route('sett.invo_month_search')); ?>" class="nav-link" id="specialty-tab">
                    <?php echo e(__('basic.monthly st')); ?></a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="<?php echo e(route('sett.invo_year_search')); ?>" class="nav-link" id="specialty-tab">
                    <?php echo e(__('basic.yearly st')); ?></a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="<?php echo e(route('sett.invo_allstatcs')); ?>" class="nav-link active" id="specialty-tab">
                    <?php echo e(__('basic.statistics')); ?></a>
            </li>
        </ul>
    </div>

    <div class="row mb-2">
        <ul class="nav nav-tabs nav-tabs-nobg mb-3 justify-content-center border-bottom-0 pe-0" id="myTab"
            role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="year_invoice-tab" data-bs-toggle="tab"
                    data-bs-target="#year_invoice" type="button" role="tab" aria-controls="year_invoice"
                    aria-selected="true" class="text-gray-500"><i class="fas fa-money-check me-1"></i>
                    Total monthly</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="specialty-tab" data-bs-toggle="tab" data-bs-target="#specialty_stat"
                    type="button" role="tab" aria-controls="home" aria-selected="true" class="text-gray-500"><i
                        class="fas fa-funnel-dollar me-1"></i>
                    Specialty</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="branches-tab" data-bs-toggle="tab" data-bs-target="#branches" type="button"
                    role="tab" aria-controls="operation_tab" aria-selected="true" class="text-gray-500"><i
                        class="fas fa-stethoscope me-1"></i>
                    Branches</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button"
                    role="tab" aria-controls="home" aria-selected="true" class="text-gray-500"><i
                        class="fas fa-stethoscope me-1"></i>
                    Income | Expenses</button>
            </li>
            <li class="nav-item" role="presentation">
                <a class="text-gray-300" href="<?php echo e(route('sett.inv_show_all_invoices')); ?>">
                    <button class="nav-link" id="examinations-tab" type="button" role="tab"
                        aria-controls="examinations-treatment" aria-selected="false" class="main-color"><i
                            class="fas fa-search me-1"></i>
                        Smart Search</button></a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="text-gray-300" href="<?php echo e(route('sett.invo_other_search')); ?>">
                    <button class="nav-link" id="examinations-tab" type="button" role="tab"
                        aria-controls="examinations-treatment" aria-selected="false" class="main-color"><i
                            class="fas fa-receipt me-1"></i>
                        Other Search</button></a>
            </li>
        </ul>
    </div>

    <div class="row">

        <div class="col-12">
            <div class="card card-input shadow mb-3 pb-3">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-chart-bar me-1"></i> Invoice Statistics</h6>
                </div>

                <!-- Card Body -->
                <div class="card-body">

                    <div class="tab-content" id="myTabContent">

                        <div class="tab-pane fade show active" id="year_invoice" role="tabpanel"
                            aria-labelledby="year_invoice">

                            <div class="row mb-1 justify-content-center">

                                <div class="col-12 mb-5">
                                    <div>
                                        <div class="mt-4 text-center small">
                                            <span class="me-2">
                                                <i class="fas fa-circle text-success"></i> Profits
                                            </span>
                                            <span class="me-2">
                                                <i class="fas fa-circle text-primary"></i> Expense
                                            </span>
                                        </div>

                                        <canvas id="profit_expense">
                                            <!-- the code and its style is printed from js -->

                                        </canvas>
                                    </div>
                                </div>

                                <div class="col-12 my-2">
                                    <div class="row">

                                        <div
                                            class="col-12 col-md-6 border-flex pb-2 pb-md-0 mb-2 mb-md-0 align-self-center">
                                            <div class="row">
                                                <div class="col-12 col-md-6 text-center align-self-center mb-2 mb-md-0">
                                                    <h6 class="text-s text-gray-400">Total Profit
                                                        <?php if($from !== 'all'): ?>
                                                        in the given date
                                                        <?php endif; ?>
                                                    </h6>
                                                    <span class="fs-4"><?php echo e($total_credit); ?><small
                                                            class="text-gray-300 text-xxxs">
                                                            EGP</small></span>
                                                </div>
                                                <div class="col-12 col-md-6 text-center align-self-center">
                                                    <h6 class="text-s text-gray-400">Total Expenses
                                                        <?php if($from !== 'all'): ?>
                                                        in the given date
                                                        <?php endif; ?>
                                                    </h6>
                                                    <span class="fs-4"><?php echo e($total_debit); ?><small
                                                            class="text-gray-300 text-xxxs">
                                                            EGP</small></span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-6 text-center align-self-center">
                                            <h6 class="text-gray-400">Net Profit
                                                <?php if($from !== 'all'): ?>
                                                in the given date
                                                <?php endif; ?>
                                            </h6>
                                            <span class="fs-1"><?php echo e($total_credit - $total_debit); ?><small
                                                    class="text-gray-300 text-xxxs">
                                                    EGP</small></span>
                                        </div>

                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="tab-pane fade" id="specialty_stat" role="tabpanel" aria-labelledby="specialty-tab">

                            <div class="row">
                                <div class="col-12 col-md-6 border-flex mb-3">
                                    <h5 class="text-center text-gray-300">Most Specialty Income this year</h5>
                                    <div class="chart-pie px-1 pb-3">
                                        <canvas id="myChart-specialty">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 border-flex mb-3">
                                    <h5 class="text-center text-gray-300">
                                        <?php if($from !== 'all'): ?>
                                        Most Specialty Income in the given date
                                        <?php else: ?>
                                        Most Specialty Income this month
                                        <?php endif; ?>
                                    </h5>
                                    <div class="chart-pie px-1 pb-3">
                                        <canvas id="myChart-specialty_month">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12 col-md-6 border-flex mb-3">
                                    <h5 class="text-center text-gray-300">Most Specialty Expenses this year</h5>
                                    <div class="chart-pie px-1 pb-3">
                                        <canvas id="myChart-specialty_expenses">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 border-flex mb-3">
                                    <h5 class="text-center text-gray-300">
                                        <?php if($from !== 'all'): ?>
                                        Most Specialty Expenses in the given date
                                        <?php else: ?>
                                        Most Specialty Expenses this month
                                        <?php endif; ?>
                                    </h5>
                                    <div class="chart-pie px-1 pb-3">
                                        <canvas id="myChart-specialty_month_expenses">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="tab-pane fade" id="branches" role="tabpanel" aria-labelledby="branches-tab">

                            <div class="row">
                                <div class="col-12 col-md-6 border-flex mb-3">
                                    <h5 class="text-center text-gray-300">Most Brances Income this year</h5>
                                    <div class="chart-pie px-1 pb-3">
                                        <canvas id="myChart-branch">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 border-flex mb-3">
                                    <h5 class="text-center text-gray-300">
                                        <?php if($from !== 'all'): ?>
                                        Most Brances Income in the given date
                                        <?php else: ?>
                                        Most Brances Income this month
                                        <?php endif; ?>
                                    </h5>
                                    <div class="chart-pie px-1 pb-3">
                                        <canvas id="myChart-branch_month">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12 col-md-6 border-flex mb-3">
                                    <h5 class="text-center text-gray-300">Most Brances Expenses this year</h5>
                                    <div class="chart-pie px-1 pb-3">
                                        <canvas id="myChart-branch_expenses">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 border-flex mb-3">
                                    <h5 class="text-center text-gray-300">
                                        <?php if($from !== 'all'): ?>
                                        Most Brances Expenses in the given date
                                        <?php else: ?>
                                        Most Brances Expenses this month
                                        <?php endif; ?>
                                    </h5>
                                    <div class="chart-pie px-1 pb-3">
                                        <canvas id="myChart-branch_month_expenses">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="tab-pane fade" id="home" role="tabpanel" aria-labelledby="home-tab">

                            <div class="row">
                                <div class="col-12 col-md-6 border-flex mb-3">
                                    <h5 class="text-center text-gray-300">Most profitable services
                                    </h5>
                                    <div class="chart-pie px-1 pb-3">
                                        <canvas id="myChart-credit">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6">
                                    <h5 class="text-center text-gray-300">Most expenses</h5>
                                    <div class="chart-pie px-1">
                                        <canvas id="myChart-debit">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>

                </div>
            </div>
        </div>


    </div>



    <?php $__env->stopSection(); ?>

    <!-- js insert -->
    <?php $__env->startSection('js'); ?>

    <!-- select 2 -->
    <script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {

                $(".myselect2-record-insert").select2({
                    dropdownParent: $("#new_record")
                });

                //hide search
                $('.myselect2-record-insert-nosearch').select2({
                    dropdownParent: $("#new_record"),
                    minimumResultsForSearch: -1
                });

            })
    </script>

    <!-- jquery ui datepicker -->
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
    <script>
        $(function() {
                $('.hasdatetimepicker').datepicker({
                    todayHighlight: true,
                    format: "mm-yyyy",
                    viewMode: "months",
                    minViewMode: "months"
                });
            });
    </script>

    <!-- -- Chart.js plugin -- -->
    <script src="https://fastly.jsdelivr.net/npm/chart.js"></script>
    <?php
    $chart_color = ['#1a78f1', '#38dfa8', '#d13c62', '#12c7d9', '#03c2c3', '#5035df', '#17a673', '#2e59d9', '#9aeded',
    '#f3d56a', '#7c859d', '#a4adc5', '#80142f', '#33d293', '#bed233', '#3958e9', '#10c86f', '#654fb6', '#a44fb6',
    '#89728e', '#c85110', '#6d769d', '#1b6954', '#204494', '#94206b', '#948320', '#209493', '#292094', '#203a65',
    '#4e6fa5', '#e29031', '#e23168', '#31e0e2', '#e29131', '#319fe2', '#8131e2', '#31a8e2', '#31e2c0', '#31c3e2',
    '#e2a931', '#3157e2', '#dc3545', '#51b24b', '#a94bb2', '#4b8bb2', '#57b24b', '#a5b24b', '#b2804b', '#b24b4b',
    '#834bb2', '#b24b6a', '#574bb2', '#236368', '#232c68', '#682345', '#4b2368', '#234b68', '#306823', '#a39f39',
    '#a239a3', '#a33963', '#a33951', '#a33939', '#c73737', '#6837c7'];
    ?>

    <script>
        function number_format(number, decimals, dec_point, thousands_sep) {
                // *     example: number_format(1234.56, 2, ',', ' ');
                // *     return: '1 234,56'
                number = (number + '').replace(',', '').replace(' ', '');
                var n = !isFinite(+number) ? 0 : +number,
                    prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
                    sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
                    dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
                    s = '',
                    toFixedFix = function(n, prec) {
                        var k = Math.pow(10, prec);
                        return '' + Math.round(n * k) / k;
                    };
                // Fix for IE parseFloat(0.55).toFixed(0) = 0;
                s = (prec ? toFixedFix(n, prec) : '' + Math.round(n)).split('.');
                if (s[0].length > 3) {
                    s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
                }
                if ((s[1] || '').length < prec) {
                    s[1] = s[1] || '';
                    s[1] += new Array(prec - s[1].length + 1).join('0');
                }
                return s.join(dec);
            }

            // Area Chart Example
            var ctx = document.getElementById("profit_expense");
            var myLineChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
                    datasets: [{
                        label: "Profits",
                        lineTension: 0.5,
                        backgroundColor: "#1cc88a",
                        borderColor: "#1cc88a",
                        pointRadius: 3,
                        pointBackgroundColor: "#1cc88a",
                        pointBorderColor: "#1cc88a",
                        pointHoverRadius: 3,
                        pointHoverBackgroundColor: "rgba(78, 115, 223, 1)",
                        pointHoverBorderColor: "rgba(78, 115, 223, 1)",
                        pointHitRadius: 10,
                        pointBorderWidth: 2,
                        data: [
                            <?php $__currentLoopData = $data_credit; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }, {
                        label: "Expenses",
                        lineTension: 0.5,
                        backgroundColor: "#4e73df",
                        borderColor: "#4e73df",
                        pointRadius: 3,
                        pointBackgroundColor: "#4e73df",
                        pointBorderColor: "#4e73df",
                        pointHoverRadius: 3,
                        pointHoverBackgroundColor: "#4e73df",
                        pointHoverBorderColor: "#4e73df",
                        pointHitRadius: 10,
                        pointBorderWidth: 2,
                        data: [
                            <?php $__currentLoopData = $data_debit; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: true,
                    layout: {
                        padding: {
                            left: 10,
                            right: 25,
                            top: 25,
                            bottom: 0
                        }
                    },
                    scales: {
                        xAxes: [{
                            time: {
                                unit: 'date'
                            },
                            gridLines: {
                                display: false,
                                drawBorder: false
                            },
                            ticks: {
                                maxTicksLimit: 7
                            }
                        }],
                        yAxes: [{
                            ticks: {
                                maxTicksLimit: 5,
                                padding: 10,
                                // Include a dollar sign in the ticks
                                callback: function(value, index, values) {
                                    return '$' + number_format(value);
                                }
                            },
                            gridLines: {
                                color: "rgb(234, 236, 244)",
                                zeroLineColor: "rgb(234, 236, 244)",
                                drawBorder: false,
                                borderDash: [2],
                                zeroLineBorderDash: [2]
                            }
                        }],
                    },
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        titleMarginBottom: 10,
                        titleFontColor: '#6e707e',
                        titleFontSize: 14,
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        intersect: false,
                        mode: 'index',
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem, chart) {
                                var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                return datasetLabel + ': $' + number_format(tooltipItem.yLabel);
                            }
                        }
                    }
                }
            });
    </script>

    <script>
        // --------- credit chart ---------
            var ctx_recourse = document.getElementById("myChart-credit");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        <?php $__currentLoopData = $profit; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($item->categorizable): ?>
                                "<?php echo e($item->categorizable->name); ?>",
                            <?php else: ?>
                                "No name",
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $profit; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->sums . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $profit; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
            // --------- debit chart ---------
            var ctx_recourse = document.getElementById("myChart-debit");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        <?php $__currentLoopData = $expense; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($item->categorizable): ?>
                                "<?php echo e($item->categorizable->name); ?>",
                            <?php else: ?>
                                "No name",
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $expense; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->sums . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $expense; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });

            // --------- specialty income chart year ---------
            var ctx_recourse = document.getElementById("myChart-specialty");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'polarArea',
                data: {
                    labels: [
                        <?php $__currentLoopData = $specialty_income; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->specialty->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $specialty_income; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $specialty_income; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
            // --------- specialty income chart month ---------
            var ctx_recourse = document.getElementById("myChart-specialty_month");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'polarArea',
                data: {
                    labels: [
                        <?php $__currentLoopData = $specialty_income_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->specialty->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $specialty_income_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $specialty_income_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });

            // --------- specialty expenses chart year ---------
            var ctx_recourse = document.getElementById("myChart-specialty_expenses");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'polarArea',
                data: {
                    labels: [
                        <?php $__currentLoopData = $specialty_expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->specialty->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $specialty_expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $specialty_expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
            // --------- specialty expenses chart month ---------
            var ctx_recourse = document.getElementById("myChart-specialty_month_expenses");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'polarArea',
                data: {
                    labels: [
                        <?php $__currentLoopData = $specialty_expenses_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->specialty->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $specialty_expenses_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $specialty_expenses_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });

            // --------- branch income chart year ---------
            var ctx_recourse = document.getElementById("myChart-branch");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'polarArea',
                data: {
                    labels: [
                        <?php $__currentLoopData = $branch_income; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->branch->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $branch_income; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $branch_income; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
            // --------- branch income chart month ---------
            var ctx_recourse = document.getElementById("myChart-branch_month");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'polarArea',
                data: {
                    labels: [
                        <?php $__currentLoopData = $branch_income_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->branch->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $branch_income_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $branch_income_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });


            // --------- branch expenses chart year ---------
            var ctx_recourse = document.getElementById("myChart-branch_expenses");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'polarArea',
                data: {
                    labels: [
                        <?php $__currentLoopData = $branch_expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->branch->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $branch_expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $branch_expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
            // --------- branch expenses chart month ---------
            var ctx_recourse = document.getElementById("myChart-branch_month_expenses");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'polarArea',
                data: {
                    labels: [
                        <?php $__currentLoopData = $branch_expenses_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            "<?php echo e($item->branch->name); ?>",
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ],
                    datasets: [{
                        data: [
                            <?php $__currentLoopData = $branch_expenses_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($item->total . ','); ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        <?php
                            $i = 0;
                        ?>
                        backgroundColor: [
                            <?php $__currentLoopData = $branch_expenses_month; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
    </script>


    <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/invoice/allstatcs.blade.php ENDPATH**/ ?>