<?php $__env->startSection('title', prox_sett('clinicname') . " تقييم زيارة في"); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- animate.css -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />

<link rel="stylesheet" href="<?php echo e(URL::asset('plugins/owl/owl.carousel.min.css')); ?>">

<?php $__env->stopSection(); ?>


<!-- session successful message -->
<?php if(Session::has('success')): ?>
<div id="flash-msg" class="shadow pt-3">
    <div class="d-flex justify-content-between mb-2">
        <i class="fas fs-1 fa-check"></i>
        <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
    </div>
    <h3>Sent Successfully</h3>
    <p class="text-blue-300"><?php echo e(Session::get('success')); ?></p>
</div>
<?php endif; ?>


<!-- content insert -->
<?php $__env->startSection('content'); ?>
<div class="bradcam_area breadcam_bg bradcam_overlay"
    style="background-image: url('<?php echo e(asset('img/dashboard/system/landing/bradcam_empty.jpg')); ?>'); padding:87px;">
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="text-white text-end">
                    <h1>يرجي تقييم اخر زيارة لك في عيادات <?php echo e(prox_sett('clinicname')); ?></h1>
                    <p>لاننا نريد الافضل لك ولتحسين مستوي
                        العيادات في الزيارة القادمة</p>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="container bg-white position-relative b-r-s-cont p-3 shadow" style="margin-top: -84px; z-index:9;">

    <?php if($status == 1): ?>
    <div class="row d-flex justify-content-around align-items-center my-2 px-1 px-md-5">

        <div class="col-8 col-md-4 d-flex align-items-center mb-3 mb-md-0">
            <img id="avatar_final_info" class="rounded-circle avatar-m me-3"
                src="<?php echo e(URL::asset('img/useravatar/' . $appointment->patient->avatar)); ?>">
            <div class="">
                <p class=" mb-0 text-xs text-gray-300">
                    <?php echo e(date('d M Y', strtotime($appointment->start_at))); ?></p>
                <a href="<?php echo e(route('sett.patient.show', $appointment->id)); ?>" id="name_final_info"
                    class="mb-1 fw-bold text-gray-600 fs-6">
                    <?php echo e($appointment->patient->name); ?>

                </a>
                <p id="number_final_info" class="mb-0 text-xs text-gray-400">
                    <?php echo e($appointment->patient->phone_number); ?></p>
            </div>
        </div>

        <div class="col-4 col-md-2">
            <h6 class="text-gray-300 text-xs mb-1">الفرع</h6>
            <p id="branch_final_info" class="text-gray-600 text-s fw-bold">
                <?php echo e($appointment->branch->name); ?></p>
        </div>

        <div class="col-4 col-md-2">
            <h6 class="text-gray-300 text-xs mb-1">الطبيب</h6>
            <p id="addre_final_info" class="text-gray-600 text-s fw-bold">
                <?php if($appointment->doctor): ?>
                <?php echo e($appointment->doctor->name); ?>

                <?php else: ?>
                طبيب
                <?php endif; ?>
            </p>
        </div>

        <div class="col-4 col-md-2">
            <h6 class="text-gray-300 text-xs mb-1">موظف الاستقبال</h6>
            <p id="addre_final_info" class="text-gray-600 text-s fw-bold">
                <?php echo e($appointment->creator->name); ?></p>
        </div>

        <div class="col-4 col-md-2">
            <div class="visible-print text-center">
                <?php echo QrCode::color(68, 95, 129)->size(60)->style('round')->eye('circle')->generate($appointment->code); ?>

                <p class="mt-1 mb-0 text-xs fw-bold text-gray-300"><?php echo e($appointment->code); ?></p>
            </div>
        </div>
    </div>

    <hr>

    <div class="px-2 px-lg-5 mt-4">

        <?php if(in_array($appointment->status, [2, 3, 4])): ?>
        <form class="mb-0" action="<?php echo e(route('patient_auth.land_rate_appo_public_store')); ?>" method="POST"
            style="display: contents">

            <?php echo csrf_field(); ?>
            <?php echo method_field('POST'); ?>

            <input id="appointment_code_input" name="appointment_code_input" type="hidden"
                value="<?php echo e(request()->code); ?>">
            <input name="rate_type" type="hidden" value="1">

            <div class="row mb-2">

                <div class="col-6 mb-2 text-center">
                    <label class="form-label">الخدمة
                        <small>(اختياري)</small></label>

                    <div class="rating">
                        <input id="rate-service-5" type="radio" name="rate_service" value="5" /><label
                            for="rate-service-5"><i class="fas fa-star"></i></label>
                        <input id="rate-service-4" type="radio" name="rate_service" value="4" /><label
                            for="rate-service-4"><i class="fas fa-star"></i></label>
                        <input id="rate-service-3" type="radio" name="rate_service" value="3" /><label
                            for="rate-service-3"><i class="fas fa-star"></i></label>
                        <input id="rate-service-2" type="radio" name="rate_service" value="2" /><label
                            for="rate-service-2"><i class="fas fa-star"></i></label>
                        <input id="rate-service-1" type="radio" name="rate_service" value="1" /><label
                            for="rate-service-1"><i class="fas fa-star"></i></label>
                    </div>
                    <span id="rate_service" class="error-msg-form"></span>

                    <?php $__errorArgs = ['rate_service'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="error-msg-form">
                        <?php echo e($message); ?>

                    </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="col-6 mb-2 text-center">
                    <label class="form-label">الطبيب
                        <small>(اختياري)</small></label>

                    <div class="rating text-center">
                        <input id="rate-doctor-5" type="radio" name="rate_doctor" value="5" /><label
                            for="rate-doctor-5"><i class="fas fa-star"></i></label>
                        <input id="rate-doctor-4" type="radio" name="rate_doctor" value="4" /><label
                            for="rate-doctor-4"><i class="fas fa-star"></i></label>
                        <input id="rate-doctor-3" type="radio" name="rate_doctor" value="3" /><label
                            for="rate-doctor-3"><i class="fas fa-star"></i></label>
                        <input id="rate-doctor-2" type="radio" name="rate_doctor" value="2" /><label
                            for="rate-doctor-2"><i class="fas fa-star"></i></label>
                        <input id="rate-doctor-1" type="radio" name="rate_doctor" value="1" /><label
                            for="rate-doctor-1"><i class="fas fa-star"></i></label>
                    </div>
                    <span id="rate_doctor" class="error-msg-form"></span>

                    <?php $__errorArgs = ['rate_doctor'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="error-msg-form">
                        <?php echo e($message); ?>

                    </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="col-6 mb-2 text-center">
                    <label class="form-label">موظف الاستقبال
                        <small>(اختياري)</small></label>

                    <div class="rating text-center">
                        <input id="rate-reception-5" type="radio" name="rate_reception" value="5" /><label
                            for="rate-reception-5"><i class="fas fa-star"></i></label>
                        <input id="rate-reception-4" type="radio" name="rate_reception" value="4" /><label
                            for="rate-reception-4"><i class="fas fa-star"></i></label>
                        <input id="rate-reception-3" type="radio" name="rate_reception" value="3" /><label
                            for="rate-reception-3"><i class="fas fa-star"></i></label>
                        <input id="rate-reception-2" type="radio" name="rate_reception" value="2" /><label
                            for="rate-reception-2"><i class="fas fa-star"></i></label>
                        <input id="rate-reception-1" type="radio" name="rate_reception" value="1" /><label
                            for="rate-reception-1"><i class="fas fa-star"></i></label>
                    </div>

                    <span id="rate_reception" class="error-msg-form"></span>

                    <?php $__errorArgs = ['rate_reception'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="error-msg-form">
                        <?php echo e($message); ?>

                    </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="col-6 mb-2 text-center">
                    <label class="form-label">الوقت
                        <small>(اختياري)</small></label>

                    <div class="rating text-center">
                        <input id="rate-time-5" type="radio" name="rate_time" value="5" /><label for="rate-time-5"><i
                                class="fas fa-star"></i></label>
                        <input id="rate-time-4" type="radio" name="rate_time" value="4" /><label for="rate-time-4"><i
                                class="fas fa-star"></i></label>
                        <input id="rate-time-3" type="radio" name="rate_time" value="3" /><label for="rate-time-3"><i
                                class="fas fa-star"></i></label>
                        <input id="rate-time-2" type="radio" name="rate_time" value="2" /><label for="rate-time-2"><i
                                class="fas fa-star"></i></label>
                        <input id="rate-time-1" type="radio" name="rate_time" value="1" /><label for="rate-time-1"><i
                                class="fas fa-star"></i></label>
                    </div>

                    <span id="rate_time" class="error-msg-form"></span>

                    <?php $__errorArgs = ['rate_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="error-msg-form">
                        <?php echo e($message); ?>

                    </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="col-6 mb-2 text-center">
                    <label class="form-label">النظافة
                        <small>(اختياري)</small></label>

                    <div class="rating text-center">
                        <input id="rate-clean-5" type="radio" name="rate_cleanliness" value="5" /><label
                            for="rate-clean-5"><i class="fas fa-star"></i></label>
                        <input id="rate-clean-4" type="radio" name="rate_cleanliness" value="4" /><label
                            for="rate-clean-4"><i class="fas fa-star"></i></label>
                        <input id="rate-clean-3" type="radio" name="rate_cleanliness" value="3" /><label
                            for="rate-clean-3"><i class="fas fa-star"></i></label>
                        <input id="rate-clean-2" type="radio" name="rate_cleanliness" value="2" /><label
                            for="rate-clean-2"><i class="fas fa-star"></i></label>
                        <input id="rate-clean-1" type="radio" name="rate_cleanliness" value="1" /><label
                            for="rate-clean-1"><i class="fas fa-star"></i></label>
                    </div>

                    <span id="rate_cleanliness" class="error-msg-form"></span>

                    <?php $__errorArgs = ['rate_cleanliness'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="error-msg-form">
                        <?php echo e($message); ?>

                    </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="col-6 mb-2">
                    <label class="form-label">هل لديك اي ملاحظة اخري؟
                        <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                    <textarea name="rate_note" class="form-control"
                        placeholder="اكتب هنا اي ملاحظة تريد ارساله الينا .." rows="4" spellcheck="false"></textarea>

                    <?php $__errorArgs = ['rate_note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="error-msg-form">
                        <?php echo e($message); ?>

                    </span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

            </div>

            <div class="d-flex justify-content-center mt-3">
                <input type="submit" name="submit" class="next-form-steps btn btn-primary px-5" value="ارسال التقييم">
            </div>
        </form>
        <?php elseif($appointment->status == 6): ?>
        <form class="mb-0" action="<?php echo e(route('patient_auth.land_rate_appo_public_store')); ?>" method="POST"
            style="display: contents">

            <?php echo csrf_field(); ?>
            <?php echo method_field('POST'); ?>

            <input id="appointment_code_input" name="appointment_code_input" type="hidden"
                value="<?php echo e(request()->code); ?>">

            <input name="rate_type" type="hidden" value="2">

            <div class="row justify-content-center">
                <div class="col-12 col-md-6">
                    <div class="row mb-2">

                        <div class="col-12 mb-2">
                            <label class="form-label">لماذا قمت بالغاء حجزك
                                <small>(مطلوب)</small></label>
                            <select class="myselect2-insert-nosearch select2-hidden-accessible" name="reason" required>
                                <?php $__currentLoopData = $cancel_reasons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->id); ?>">
                                    <?php echo e($item->name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-12">
                            <label class="form-label">ارسال ملاحظة
                                <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                            <textarea name="rate_note" class="form-control" placeholder="يمكنك ارسال اي ملاحظة الينا .."
                                rows="4" spellcheck="false"></textarea>

                            <?php $__errorArgs = ['rate_note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error-msg-form">
                                <?php echo e($message); ?>

                            </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                    </div>
                </div>
            </div>

            <div class="d-flex justify-content-center mt-3">
                <input type="submit" name="submit" class="next-form-steps btn btn-primary px-5" value="Send">
            </div>
    </div>

    </form>
    <?php else: ?>
    <div class="p-5 text-center text-gray-400">
        <i class="bi bi-brightness-alt-high-fill fs-1"></i>
        <h3>ناسف. لا يمكنك تقييم هذا الحجز</h3>
    </div>
    <?php endif; ?>

</div>
<?php else: ?>
<div class="p-5 text-center text-gray-400">
    <i class="bi bi-brightness-alt-high-fill fs-1"></i>
    <h3>شكرا لمساعدتنا لنكون افضل</h3>
</div>
<?php endif; ?>


</div>

<?php $__env->stopSection(); ?>

<!-- js insert -->
<?php $__env->startSection('js'); ?>
<!-- select 2 -->
<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
            $('.myselect2-insert-nosearch').select2({
                minimumResultsForSearch: -1
            });
        });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.land.master_top_empty', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/landing/empty/rate_appo_public.blade.php ENDPATH**/ ?>