<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($patient->first_name); ?> Profile</title>
    <link rel="stylesheet" href="<?php echo e(public_path('css/kv-mpdf-bootstrap.css')); ?>">

</head>

<body>

    <!-- Patient Info -->
    <div class="card-body px-4">

        <div class="row mb-3 b-r-s-cont border2 py-3 px-2">

            <div class="col-xs-5 text-truncate p-0" style="">
                <div class="w-10">
                    <div class="p-0" style="width: 25%;float: left;">
                        <div class="rounded-circle avatar-m2 profile_img"
                            style="background-image: url(<?php echo e(public_path('img/useravatar/' . $patient->avatar)); ?>)">
                        </div>
                    </div>

                    <div class="text-truncate p-0" style="width: 75%;float: left;">
                        <p class="m-0 p-0 text-s">
                            Patient</p>
                        <p class="m-0 p-0 text-s fw-bold2 text-truncate">
                            <?php echo e($patient->first_name . ' ' . $patient->second_name); ?></p>
                        <p class="m-0 p-0 text-s"><?php echo e($patient->city->name); ?> <?php echo e($patient->country->name); ?></p>
                    </div>
                </div>
            </div>

            <div class="col-xs-2 px-0" style="display: inline;">
                <p class="text-s mb-0">Age</p>
                <p class="fw-bold2">
                    <?php echo e(\Carbon\Carbon::parse($patient->birthday)->diff(\Carbon\Carbon::now())->format('%y')); ?>

                </p>
            </div>

            <div class="col-xs-2 px-0 text-truncate">
                <p class="text-s mb-0 text-truncate">Insurance</p>
                <p class="fw-bold2"><?php echo e($patient->insurance); ?></p>
            </div>
            <div class="col-xs-2">
                <p class="text-s mb-0">Phone Number</p>
                <p class="fw-bold2"><?php echo e($patient->phone_number); ?></p>
            </div>
        </div>


        <!-- Examination -->
        <div class="row justify-content-center mb-2">
            <span class="text-s2">Last Examination:</span>
            <div class="col-xs-6 p-0"
                style="background-image: url('<?php echo e(public_path('img/dashboard/system/human_front2.jpg')); ?>'); width:181px; height:325px; position: relative; background-repeat: no-repeat; margin-left: 25%;">
                <?php if(!empty($patient->disease_draws[0]->front)): ?>
                <img src="<?php echo e(public_path('img/diseasedraw/' . $patient->disease_draws[0]->front)); ?>" width="181"
                    height="325" style=" solid;position: absolute;top:0;left:0;">
                <?php else: ?>
                <div class="ms-4 text-center main-color-bg text-white p-2 b-r-s-cont"
                    style=" solid;position: absolute;top:13rem;left:3rem;">
                    No Back Draw
                </div>
                <?php endif; ?>
            </div>

            <div class="col-xs-6 p-0"
                style="background-image: url('<?php echo e(public_path('img/dashboard/system/human_back2.jpg')); ?>'); width:181px; height:325px; position: relative; background-repeat: no-repeat;">

                <?php if(!empty($patient->disease_draws[0]->back)): ?>
                <img src="<?php echo e(public_path('img/diseasedraw/' . $patient->disease_draws[0]->back)); ?>" width="181"
                    height="325" style=" solid;position: absolute;top:0;left:0;">
                <?php else: ?>
                <div class="ms-4 text-center main-color-bg text-white p-2 b-r-s-cont"
                    style=" solid;position: absolute;top:13rem;left:3rem;">
                    No Back Draw
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- All exminations -->
        <div class="row mb-3">
            <div class="col-xs-12">
                <div class="table-responsive">
                    <table class="table-responsive text-s table-bordered2 bordered w-100 b-r-s-cont">
                        <thead>
                            <tr class="b-r-s-cont" style="background-color: #f7fbff;">
                                <th>Name</th>
                                <th>OD</th>
                                <th>OS</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php if(count($patient->examinations) > 0): ?>

                            <?php if($patient->examinations[0]->type == 3): ?>
                            <tr>
                                <td class="w-25 fw-bold2">LID</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->lid_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->lid_os); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Surface</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->surface_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->surface_os); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">A.C.</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->ac_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->ac_os); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Pupil</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->pupil_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->pupil_os); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Lens</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->lens_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->lens_os); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Iris</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->iris_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->iris_os); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Angle</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->angle_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->angle_os); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Fundus</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->fundus_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->fundus_os); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">Motility</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->motility_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->motility_os); ?></td>
                            </tr>
                            <tr>
                                <td class="w-25 fw-bold2">IOP</td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->iop_od); ?></td>
                                <td class="fw-bold text-uppercase fw-bold2"><?php echo e($patient->examinations[0]->iop_os); ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php endif; ?>
                        </tbody>

                    </table>
                </div>
            </div>
        </div>

        <?php if(count($patient->examinations) > 0): ?>
        <?php if($patient->examinations[0]->appointment): ?>
        <?php if($patient->examinations[0]->appointment->doctor): ?>
        <h4 class="text-s">Responsible Doctor: <?php echo e($patient->examinations[0]->appointment->doctor->first_name); ?></h4>

        <?php endif; ?>
        <?php endif; ?>

        <?php endif; ?>
    </div>


</body>

</html><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/patient/print_ramad_examination.blade.php ENDPATH**/ ?>