<?php $__env->startSection('title', 'Follow up | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', __('basic.follow up')); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-flex align-items-center justify-content-center">

        <div class="d-flex justify-content-center mt-2 mt-md-0 ms-auto">

            <a class="main-color-bg text-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-1" data-bs-toggle="modal"
                data-bs-target="#new_record"><i class="fas fa-filter fa-sm me-1"></i> Filter</a>

            <!-- Modal for search filtering -->
            <div class="modal fade" id="new_record" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                    <form class="mb-0" action="<?php echo e(route('sett.rate_appo.index')); ?>" method="GET"
                        style="display: contents">

                        <div class="modal-content b-r-s-cont border-0">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-clipboard me-1"></i>
                                    Search Filter</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row">

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Specialty
                                            <small>(optional)</small></label>
                                        <select
                                            class="myselect2-record-insert myselect2-record-insert-nosearch select2-hidden-accessible"
                                            id="specialty" name="specialty">
                                            <option value="">
                                                All
                                            </option>
                                            <?php $__currentLoopData = $specialty_cat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>" <?php if($specialty==$item->id): ?> selected <?php endif; ?>
                                                <?php if($specialty == $item->id): ?> selected <?php endif; ?>>
                                                <?php echo e($item->name); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Branch
                                            <small>(optional)</small></label>
                                        <select
                                            class="myselect2-record-insert myselect2-record-insert-nosearch select2-hidden-accessible"
                                            id="branch" name="branch">
                                            <option value="">
                                                All
                                            </option>
                                            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>" <?php if($branch==$item->id): ?> selected <?php endif; ?>
                                                <?php if($branch == $item->id): ?> selected <?php endif; ?>>
                                                <?php echo e($item->name); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">From
                                            <small>(optional)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="from" type="text" class="form-control hasdatetimepicker"
                                                value="<?php echo e($from); ?>" placeholder="YYYY/MM">
                                        </div>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">To
                                            <small>(optional)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="to" type="text" class="form-control hasdatetimepicker"
                                                value="<?php echo e($to); ?>" placeholder="YYYY/MM">
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">Never
                                        Mind</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">Search</button>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>

            </div>
        </div>
    </div>

    <div class="row mb-3">

        <ul class="nav nav-tabs nav-tabs-nobg mb-3 justify-content-center" id="myTab" role="tablist">
            <li class="nav-item" role="presentation">
                <a href="<?php echo e(route('sett.rate_appo.index')); ?>" class="nav-link active" id="year_invoice-tab"><i
                        class="fas fa-headset me-1"></i>
                    <?php echo e(__('basic.follow up calls')); ?></a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="<?php echo e(route('sett.index_cancel_rate')); ?>" class="nav-link" id="specialty-tab"><i
                        class="fas fa-ban me-1"></i>
                    <?php echo e(__('basic.cancellation')); ?></a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="<?php echo e(route('sett.index_inactive_patient')); ?>" class="nav-link" id="specialty-tab"><i
                        class="fas fa-bullhorn me-1"></i>
                    <?php echo e(__('basic.leads')); ?></a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="<?php echo e(route('sett.op_follow_up')); ?>" class="nav-link" id="specialty-tab"><i
                        class="fas fa-user-md me-1"></i>
                    <?php echo e(__('basic.op follow up')); ?></a>
            </li>
        </ul>
    </div>

    <div class="row">

        <!-- total doctors -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card shadow h-100 p-1 ">
                <div class="card-body p-2 px-5 px-md-4">
                    <p class="text-center text-s fw-bold text-gray-400"><?php echo e(__('basic.service')); ?></p>
                    <div class="row no-gutters align-items-center">
                        <div class="col-9 p-0">
                            <?php if($rate_total[0]->service < 3): ?> <?php $rate_color='text-red' ; ?>
                                <?php elseif($rate_total[0]->service == 3): ?>
                                <?php
                                $rate_color = 'text-gray-700';
                                ?>
                                <?php elseif($rate_total[0]->service > 3): ?>
                                <?php
                                $rate_color = 'main-color-500';
                                ?>
                                <?php endif; ?>
                                <a href="<?php echo e(route('sett.bad_rate', 'service')); ?>">
                                    <div class="h1 mb-0 fw-bold <?php echo e($rate_color); ?>">
                                        <?php echo e($rate_total[0]->service); ?></div>

                                    <div class="text-xxs text-gray-400 text-uppercase">
                                        out of 5</div>
                                </a>
                        </div>
                        <div class="col-3 text-center p-0 text-white">
                            <i class="fas fa-syringe h1 text-gray-400"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- total doctors -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card shadow h-100 p-1 ">
                <div class="card-body p-2 px-5 px-md-4">
                    <p class="text-center text-s fw-bold text-gray-400"><?php echo e(__('basic.doctors')); ?></p>
                    <div class="row no-gutters align-items-center">
                        <div class="col-9 p-0">
                            <?php if($rate_total[0]->doctor < 3): ?> <?php $rate_color='text-red' ; ?>
                                <?php elseif($rate_total[0]->doctor == 3): ?>
                                <?php
                                $rate_color = 'text-gray-700';
                                ?>
                                <?php elseif($rate_total[0]->doctor > 3): ?>
                                <?php
                                $rate_color = 'main-color-500';
                                ?>
                                <?php endif; ?>
                                <a href="<?php echo e(route('sett.bad_rate', 'doctor')); ?>">
                                    <div class="h1 mb-0 fw-bold <?php echo e($rate_color); ?>">
                                        <?php echo e($rate_total[0]->doctor); ?></div>
                                    <div class="text-xxs text-gray-400 text-uppercase">
                                        out of 5</div>
                                </a>
                        </div>
                        <div class="col-3 text-center p-0 text-white">
                            <i class="fas fa-user-md h1 text-gray-400"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- total doctors -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card shadow h-100 p-1 ">
                <div class="card-body p-2 px-5 px-md-4">
                    <p class="text-center text-s fw-bold text-gray-400"><?php echo e(__('basic.reception')); ?></p>
                    <div class="row no-gutters align-items-center">
                        <div class="col-9 p-0">
                            <?php if($rate_total[0]->reception < 3): ?> <?php $rate_color='text-red' ; ?>
                                <?php elseif($rate_total[0]->reception == 3): ?>
                                <?php
                                $rate_color = 'text-gray-700';
                                ?>
                                <?php elseif($rate_total[0]->reception > 3): ?>
                                <?php
                                $rate_color = 'main-color-500';
                                ?>
                                <?php endif; ?>
                                <a href="<?php echo e(route('sett.bad_rate', 'reception')); ?>">
                                    <div class="h1 mb-0 fw-bold <?php echo e($rate_color); ?>">
                                        <?php echo e($rate_total[0]->reception); ?></div>
                                    <div class="text-xxs text-gray-400 text-uppercase">
                                        out of 5</div>
                                </a>
                        </div>
                        <div class="col-3 text-center p-0 text-white">
                            <i class="fas fa-headset h1 text-gray-400"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- total doctors -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card shadow h-100 p-1 ">
                <div class="card-body p-2 px-5 px-md-4">
                    <p class="text-center text-s fw-bold text-gray-400"><?php echo e(__('basic.time')); ?></p>
                    <div class="row no-gutters align-items-center">
                        <div class="col-9 p-0">
                            <?php if($rate_total[0]->time < 3): ?> <?php $rate_color='text-red' ; ?>
                                <?php elseif($rate_total[0]->time == 3): ?>
                                <?php
                                $rate_color = 'text-gray-800';
                                ?>
                                <?php elseif($rate_total[0]->time > 3): ?>
                                <?php
                                $rate_color = 'main-color-500';
                                ?>
                                <?php endif; ?>
                                <a href="<?php echo e(route('sett.bad_rate', 'time')); ?>">
                                    <div class="h1 mb-0 fw-bold <?php echo e($rate_color); ?>">
                                        <?php echo e($rate_total[0]->time); ?></div>
                                    <div class="text-xxs text-gray-400 text-uppercase">
                                        out of 5</div>
                                </a>
                        </div>
                        <div class="col-3 text-center p-0 text-white">
                            <i class="fas fa-hourglass-end h1 text-gray-400"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- total doctors -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card shadow h-100 p-1 ">
                <div class="card-body p-2 px-5 px-md-4">
                    <p class="text-center text-s fw-bold text-gray-400"><?php echo e(__('basic.cleanliness')); ?></p>
                    <div class="row no-gutters align-items-center">
                        <div class="col-9 p-0">
                            <?php if($rate_total[0]->cleanliness < 3): ?> <?php $rate_color='text-red' ; ?>
                                <?php elseif($rate_total[0]->cleanliness == 3): ?>
                                <?php
                                $rate_color = 'text-gray-800';
                                ?>
                                <?php elseif($rate_total[0]->cleanliness > 3): ?>
                                <?php
                                $rate_color = 'main-color-500';
                                ?>
                                <?php endif; ?>
                                <a href="<?php echo e(route('sett.bad_rate', 'cleanliness')); ?>">
                                    <div class="h1 mb-0 fw-bold <?php echo e($rate_color); ?>"> <?php echo e($rate_total[0]->cleanliness); ?>

                                    </div>
                                    <div class="text-xxs text-gray-400 text-uppercase">
                                        out of 5</div>
                                </a>
                        </div>
                        <div class="col-3 text-center p-0 text-white">
                            <i class="fas fa-broom h1 text-gray-400"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- links -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card shadow h-100 main-color-bg p-1">
                <div class="card-body d-flex align-self-center p-2 px-2 px-md-3">
                    <div class="row no-gutters align-items-center">
                        <div class="col-5 d-flex align-items-center h-100 p-2 border-right-blue">
                            <a class="text-white" href="<?php echo e(route('sett.ready_rate', 'last15')); ?>">
                                <div class="text-xs fw-bold text-uppercase mb-0">
                                </div>
                                <div> <span class="h2"><?php echo e($not_rated_appo_number); ?></span>
                                    <small>appointments</small>
                                </div>
                                <small>not rated</small>
                            </a>
                        </div>
                        <div class="col-4 p-2 h-100 d-flex align-items-center border-right-blue">
                            <a class="text-white" href="<?php echo e(route('sett.ready_rate')); ?>">
                                <div class="h6 text-uppercase mb-0">
                                    <?php echo e(__('basic.ready to rate')); ?></div>
                            </a>
                        </div>
                        <div class="col-3 text-center p-2 text-white">
                            <a class="text-white" href="<?php echo e(route('sett.index_rate_note')); ?>">
                                <div class="h6 text-uppercase mb-0 border-bottom-blue py-2 mb-2">
                                    <?php echo e(__('basic.notes')); ?></div>
                            </a>

                            <a class="text-white" href="<?php echo e(route('sett.index_rate_note', 'saved')); ?>">
                                <div class="h6 text-uppercase mb-0">
                                    <?php echo e(__('basic.saved notes')); ?></div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>


    </div>

    <div class="row">

        <div class="col-12">
            <div class="card card-input shadow mb-3 pb-3">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-chart-bar me-1"></i>
                        <?php echo e(__('basic.rates statistics')); ?>

                    </h6>
                </div>

                <!-- Card Body -->
                <div class="card-body">

                    <div class="row mb-2">

                        <div class="col-12">
                            <div>
                                <canvas id="branches_line">
                                    <!-- the code and its style is printed from js -->
                                </canvas>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>


    </div>



    <?php $__env->stopSection(); ?>

    <!-- js insert -->
    <?php $__env->startSection('js'); ?>

    <!-- select 2 -->
    <script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {

                $(".myselect2-record-insert").select2({
                    dropdownParent: $("#new_record")
                });

                //hide search
                $('.myselect2-record-insert-nosearch').select2({
                    dropdownParent: $("#new_record"),
                    minimumResultsForSearch: -1
                });

            })
    </script>

    <!-- jquery ui datepicker -->
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
    <script>
        $(function() {
                $('.hasdatetimepicker').datepicker({
                    todayHighlight: true,
                    format: "mm-yyyy",
                    viewMode: "months",
                    minViewMode: "months"
                });
            });
    </script>

    <!-- -- Chart.js plugin -- -->
    <script src="https://fastly.jsdelivr.net/npm/chart.js"></script>
    <?php
    $chart_color = ['#1a78f1', '#38dfa8', '#d13c62', '#12c7d9', '#03c2c3', '#5035df', '#17a673', '#2e59d9', '#9aeded',
    '#f3d56a', '#7c859d', '#a4adc5', '#80142f', '#33d293', '#bed233', '#3958e9', '#10c86f', '#654fb6', '#a44fb6',
    '#89728e', '#c85110', '#6d769d', '#1b6954', '#204494', '#94206b', '#948320', '#209493', '#292094', '#203a65',
    '#4e6fa5', '#e29031', '#e23168', '#31e0e2', '#e29131', '#319fe2', '#8131e2', '#31a8e2', '#31e2c0', '#31c3e2',
    '#e2a931', '#3157e2'];
    ?>


    <script>
        // Area Chart for each branch
            var ctx = document.getElementById("branches_line");
            var myLineChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
                    datasets: [
                        <?php
                            $i = 0;
                        ?>
                        <?php $__currentLoopData = $rate_year; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            {
                                label: "<?php echo e($item->name); ?>",
                                lineTension: 0.5,
                                backgroundColor: '<?php echo e($chart_color[$i]); ?>',
                                borderColor: '<?php echo e($chart_color[$i]); ?>',
                                pointRadius: 3,
                                pointBackgroundColor: '<?php echo e($chart_color[$i]); ?>',
                                pointBorderColor: '<?php echo e($chart_color[$i]); ?>',
                                <?php
                                    $i++;
                                ?>
                                pointHoverRadius: 3,
                                pointHoverBackgroundColor: "rgba(78, 115, 223, 1)",
                                pointHoverBorderColor: "rgba(78, 115, 223, 1)",
                                pointHitRadius: 10,
                                pointBorderWidth: 2,
                                data: [
                                    <?php $__currentLoopData = $item->avg; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item4): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($item4 . ','); ?>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                ],
                            },
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    ],
                },

                options: {
                    maintainAspectRatio: true,
                    layout: {
                        padding: {
                            left: 10,
                            right: 25,
                            top: 25,
                            bottom: 0
                        }
                    },
                    scales: {
                        xAxes: [{
                            time: {
                                unit: 'date'
                            },
                            gridLines: {
                                display: false,
                                drawBorder: false
                            },
                            ticks: {
                                maxTicksLimit: 7
                            }
                        }],
                        yAxes: [{
                            ticks: {
                                maxTicksLimit: 5,
                                padding: 10,
                                // Include a dollar sign in the ticks
                                callback: function(value, index, values) {
                                    return '$' + number_format(value);
                                }
                            },
                            gridLines: {
                                color: "rgb(234, 236, 244)",
                                zeroLineColor: "rgb(234, 236, 244)",
                                drawBorder: false,
                                borderDash: [2],
                                zeroLineBorderDash: [2]
                            }
                        }],
                    },
                    plugins: {
                        legend: {
                            display: true
                        }
                    },
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        titleMarginBottom: 10,
                        titleFontColor: '#6e707e',
                        titleFontSize: 14,
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        intersect: false,
                        mode: 'index',
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem, chart) {
                                var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                return datasetLabel + ': $' + number_format(tooltipItem.yLabel);
                            }
                        }
                    }
                }
            });
    </script>


    <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/proxima/resources/views/branch/rate_appointment/index.blade.php ENDPATH**/ ?>