<?php $__env->startSection('title', 'Invoice | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Invoice'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<style>
    .select2-container {
        z-index: 99999;
    }
</style>

<!-- datepicker time and date -->
<link rel="stylesheet" href="https://fastly.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('fixedcontent'); ?>

<!-- session successful message -->
<?php if(Session::has('success')): ?>
<div id="flash-msg" class="shadow pt-3">
    <div class="d-flex justify-content-between mb-2">
        <i class="fas fs-1 fa-check"></i>
        <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
    </div>
    <h3>Sent Successfully</h3>
    <p class="text-blue-300"><?php echo e(Session::get('success')); ?></p>
</div>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>

<div class="container-fluid px-0 px-md-2 mt-3">

    <!-- page title link -->
    <div class="d-flex flex-wrap align-items-center justify-content-between mb-3">
        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>"><?php echo e(__('basic.dashboard')); ?>

                |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.invoice.index')); ?>"><?php echo e(__('basic.invoices')); ?> | </a>
            <a class="text-gray-300"><?php echo e(__('patientappo.invoice show')); ?></a>
        </span>
        <div class="d-flex flex-wrap">

            <?php if(in_array($invoice->status, [1, 2, 3]) && $invoice->refund_id == null && $invoice->type == 0): ?>
            <a data-bs-toggle="modal" data-bs-target="#refund"
                class="pend-color-btn btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-1 mb-2 mb-md-0"><i
                    class="fas fa-table fa-sm me-1"></i> <?php echo e(__('basic.refund')); ?></a>
            <?php endif; ?>
            <?php if($invoice->status == 0): ?>
            <a data-bs-toggle="modal" data-bs-target="#add_items"
                class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 me-2 mb-2 mb-md-0"><i
                    class="fas fa-plus fa-sm me-1"></i> <?php echo e(__('patientappo.new items invoice')); ?></a>
            <a data-bs-toggle="modal" data-bs-target="#add_material"
                class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 me-2 mb-2 mb-md-0"><i
                    class="fas fa-plus fa-sm me-1"></i> <?php echo e(__('basic.new material')); ?></a>
            <?php endif; ?>
            <?php if($invoice->status == 0): ?>
            <a data-bs-toggle="modal" data-bs-target="#installment"
                class="pend-color-btn btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-2 mb-2 mb-md-0"><i
                    class="fas fa-table fa-sm me-1"></i> <?php echo e(__('basic.installment')); ?></a>
            <a data-bs-toggle="modal" data-bs-target="#pay_invoice"
                class="active-color-btn btn btn-sm shadow-sm b-r-l-cont p-2 px-4 mb-2 mb-md-0"><i
                    class="fas fa-dollar-sign fa-sm me-1"></i> <?php echo e(__('basic.pay')); ?></a>
            <?php endif; ?>
            <?php if($invoice->status == 1): ?>
            <a data-bs-toggle="modal" data-bs-target="#pay_installment"
                class="active-color-btn btn btn-sm shadow-sm b-r-l-cont p-2 px-4 mb-2 mb-md-0"><i
                    class="fas fa-dollar-sign fa-sm me-1"></i> <?php echo e(__('basic.add payment')); ?></a>

            <?php endif; ?>
            <?php if($invoice->status !== 0): ?>
            <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Branch-manager')): ?>
            <a data-bs-toggle="modal" data-bs-target="#edit_invoice"
                class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 ms-2"><i
                    class="fas fa-dollar-sign fa-sm me-1"></i> <?php echo e(__('basic.edit')); ?></a>
            <?php endif; ?>
            <?php endif; ?>
            <?php if($invoice->status !== 0): ?>
            <a href="<?php echo e(route('sett.invo_invoice_print', $invoice->id)); ?>"
                class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 ms-2"><i
                    class="fas fa-download fa-sm text-gray-300 me-2"></i> <?php echo e(__('basic.print')); ?></a>
            <?php endif; ?>
        </div>
    </div>

</div>

<!-- Modal for paying -->
<div class="modal fade" id="pay_invoice" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

        <form class="mb-0" action="<?php echo e(route('sett.invo_invoice_pay', $invoice->id)); ?>" method="POST"
            style="display: contents">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PATCH'); ?>

            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-wallet me-1"></i>
                        <?php echo e(__('patientappo.pay invoice')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-5 py-3">

                    <div class="row my-3">
                        <div class="col-7 col-md-7">
                            <i class="fas fa-tag me-2 text-gray-400"></i>
                            <span id="service_final_info"><?php echo e(__('basic.coupon')); ?></span>
                        </div>
                        <div class="col-5 col-md-5 text-center">
                            <div class="input-group">
                                <input type="text" name="coupon_input" class="form-control custom-select"
                                    id="coupon_input" style="border-radius: 5px 0px 0px 5px !important;"
                                    placeholder="Discount code here .." <?php if(!empty($invoice->coupon->code)): ?> value="<?php echo e($invoice->coupon->code); ?>" <?php endif; ?>>

                                <input type="hidden" name="coupon_id" id="coupon_id">
                                <input type="hidden" name="invoice_id" value="<?php echo e($invoice->id); ?>">

                                <div class="input-group-append">
                                    <button id="coupon-buttn" class="btn btn-outline-secondary" class="form-control "
                                        type="button"><?php echo e(__('basic.end')); ?></button>
                                </div>
                            </div>

                            <?php $__errorArgs = ['coupon_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error-msg-form">
                                <?php echo e($message); ?>

                            </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            <?php $__errorArgs = ['invoice_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error-msg-form">
                                <?php echo e($message); ?>

                            </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            <div id="search-result-input"></div>

                        </div>
                    </div>

                    <div class="row">
                        <div class="col-7 col-md-7">
                            <i class="fas fa-tag me-2 text-gray-400"></i>
                            <span id="service_final_info"><?php echo e(__('patientappo.discount percentage')); ?></span>
                        </div>

                        <div class="col-5 col-md-5 text-center">
                            <input id="doctor_discount" name="doctor_discount" type="number"
                                class="form-control text-center <?php $__errorArgs = ['doctor_discount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                placeholder="Discount Percentage without %" value="">
                        </div>
                        <span id="doctor_discount-error" class="error-msg-form"></span>

                        <?php $__errorArgs = ['doctor_discount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="error-msg-form">
                            <?php echo e($message); ?>

                        </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    </div>

                    <div class="row">
                        <div class="col-7 col-md-7">
                            <i class="fas fa-tag me-2 text-gray-400"></i>
                            <span><?php echo e(__('patientappo.discount value')); ?></span>
                        </div>

                        <div class="col-5 col-md-5 text-center">
                            <input id="doctor_discount_value" name="doctor_discount_value" type="number"
                                class="form-control text-center <?php $__errorArgs = ['doctor_discount_value'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                placeholder="Discount Amount" value="">
                        </div>
                        <span id="doctor_discount_value-error" class="error-msg-form"></span>

                        <?php $__errorArgs = ['doctor_discount_value'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="error-msg-form">
                            <?php echo e($message); ?>

                        </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    </div>

                    <hr>

                    <div class="row mt-3">
                        <div class="col-7">
                            <i class="fas fa-stethoscope me-2 text-gray-400"></i>
                            <span id="service_final_info"><?php echo e(__('patientappo.total services price')); ?></span>
                        </div>
                        <div class="col-5 text-center">
                            <div id="service_price" data-service_price="<?php echo e($invoice->items_price); ?>"
                                class="text-s2 text-gray-600"><?php echo e($invoice->items_price); ?><small
                                    class="text-gray-300 text-xxxs">
                                    <?php echo e(__('basic.egp')); ?></small>
                            </div>
                        </div>
                    </div>


                    <div class="row my-3" id="discount_amount_div">
                        <div class="col-7">
                            <i class="fas fa-percent me-2 text-gray-400"></i>
                            <span id="service_final_info"><?php echo e(__('patientappo.coupon discount')); ?></span>
                        </div>
                        <div class="col-5 text-center">
                            <div class="text-s2 text-gray-600 text-decoration-line-through" id="discount_amount_place">
                                0
                            </div>
                        </div>
                    </div>

                    <div class="row my-3" id="discount_amount_div">
                        <div class="col-7">
                            <i class="fas fa-percent me-2 text-gray-400"></i>
                            <span id="service_final_info"><?php echo e(__('basic.discount')); ?></span>
                        </div>
                        <div class="col-5 text-center">
                            <div class="text-s2 text-gray-600 text-decoration-line-through" id="doctor_discount_place">
                                <?php if(!empty($invoice->discount)): ?>
                                <?php echo e($invoice->discount); ?>

                                <small class="text-gray-300 text-xxxs"> <?php echo e(__('basic.egp')); ?></small>
                                <?php else: ?>
                                0 <small class="text-gray-300 text-xxxs"> <?php echo e(__('basic.egp')); ?></small>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-7 fw-bold">
                            <i class="fas fa-dollar-sign me-2"></i>
                            <span id="service_final_info"><?php echo e(__('patientappo.final price')); ?></span>
                        </div>
                        <div class="col-5 text-center d-flex justify-content-center align-items-center">
                            <div class="text-s2 text-gray-600 fw-bold me-1" id="price_total_final_info">
                                <?php echo e($invoice->final_price); ?>

                            </div>
                            <small class="text-gray-300 text-xxxs">
                                <?php echo e(__('basic.egp')); ?></small>
                        </div>
                    </div>

                    

                    <?php if(in_array($invoice->status, [0, 1])): ?>


                    <div class="row">
                        <div class="col-7 col-md-7">
                            <i class="fas fa-cash-register me-2 text-gray-400"></i>
                            <span id="service_final_info"><?php echo e(__('basic.target')); ?></span>
                        </div>
                        <div class="col-5 col-md-5 text-center">
                            <select
                                class="js-example-basic-single select2-hidden-accessible <?php $__errorArgs = ['target'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                id="target_input" data-current_number="0" name="target">
                                <option value="1">Old</option>
                                <option value="2">New page</option>
                                <option value="3">New friend</option>
                                <option value="4">Offer</option>
                                <option value="5">Upgrade</option>
                                <option value="6">other</option>
                                <option value="7">other 2</option>
                            </select>
                        </div>
                        <span id="target_error" class="error-msg-form"></span>
                        <?php $__errorArgs = ['target'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="error-msg-form">
                            <?php echo e($message); ?>

                        </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <hr>

                    <div class="row">
                        <div class="col-7 col-md-7">
                            <i class="fas fa-cash-register me-2 text-gray-400"></i>
                            <span id="service_final_info"><?php echo e(__('basic.cash')); ?></span>
                        </div>

                        <?php if($invoice->status == 1): ?>
                        <?php
                        $deposit = $invoice->total_paid;
                        ?>
                        <?php else: ?>
                        <?php
                        $deposit = '';
                        ?>
                        <?php endif; ?>

                        <div class="col-5 col-md-5 text-center">
                            <input name="cash_pay" type="number" id="cash_pay"
                                class="form-control text-center <?php $__errorArgs = ['cash_pay'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                placeholder="Amount" value="">
                        </div>
                        <span id="cash_pay_error" class="error-msg-form"></span>

                        <?php $__errorArgs = ['cash_pay'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="error-msg-form">
                            <?php echo e($message); ?>

                        </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    </div>

                    <div class="row">
                        <div class="col-7 col-md-7">
                            <i class="fab fa-cc-visa me-2 text-gray-400"></i>
                            <span id="service_final_info"><?php echo e(__('basic.visa')); ?></span>
                        </div>

                        <?php if($invoice->status == 1): ?>
                        <?php
                        $deposit = $invoice->total_paid;
                        ?>
                        <?php else: ?>
                        <?php
                        $deposit = '';
                        ?>
                        <?php endif; ?>

                        <div class="col-5 col-md-5 text-center">
                            <input id="visa_pay" name="visa_pay" type="number"
                                class="form-control text-center <?php $__errorArgs = ['visa_pay'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                placeholder="Amount" value="">
                        </div>
                        <span id="visa_pay_error" class="error-msg-form"></span>

                        <?php $__errorArgs = ['visa_pay'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="error-msg-form">
                            <?php echo e($message); ?>

                        </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    </div>

                    <div class="row mb-4">
                        <div class="col-7 fw-bold">
                            <i class="fas fa-dollar-sign me-2"></i>
                            <span id="service_final_info"><?php echo e(__('basic.remaining amount')); ?></span>
                        </div>
                        <div class="col-5 text-center d-flex justify-content-center align-items-center">
                            <div class="text-s2 text-gray-600 fw-bold me-1" id="remaining_cash_id">
                                Not Paid Yet
                            </div>
                            <small class="text-gray-300 text-xxxs">
                                <?php echo e(__('basic.egp')); ?></small>
                        </div>
                    </div>

                    <?php endif; ?>
                </div>

                <div class="modal-footer">
                    <div class="left-side">
                        <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                    </div>
                    <div class="divider"></div>
                    <div class="right-side">
                        <button type="submit" class="btn btn-default btn-link main-color"><?php echo e(__('basic.pay')); ?></button>
                    </div>
                </div>

            </div>

        </form>

    </div>

</div>

<!-- Modal for making installment -->
<div class="modal fade" id="installment" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

        <form class="mb-0" action="<?php echo e(route('sett.insert_installment', $invoice->id)); ?>" method="POST"
            style="display: contents">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PATCH'); ?>

            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-wallet me-1"></i>
                        <?php echo e(__('basic.installment')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-5 py-3">

                    <div class="row">
                        <div class="col-7 col-md-7">
                            <i class="fas fa-cash-register me-2 text-gray-400"></i>
                            <span><?php echo e(__('basic.number of installment')); ?></span>
                        </div>

                        <div class="col-5 col-md-5 text-center">
                            <select
                                class="js-example-basic-single select2-hidden-accessible <?php $__errorArgs = ['installment_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                id="installment_number" data-current_number="0" name="installment_number">
                                <option disabled selected>
                                    - Select number -
                                </option>
                                <option value="1">
                                    1
                                </option>
                                <option value="2">
                                    2
                                </option>
                                <option value="3">
                                    3
                                </option>
                                <option value="4">
                                    4
                                </option>
                                <option value="5">
                                    5
                                </option>
                                <option value="6">
                                    6
                                </option>
                                <option value="7">
                                    7
                                </option>
                                <option value="8">
                                    8
                                </option>
                                <option value="9">
                                    9
                                </option>
                                <option value="10">
                                    10
                                </option>
                                <option value="11">
                                    11
                                </option>
                                <option value="12">
                                    12
                                </option>
                                <option value="13">
                                    13
                                </option>
                            </select>
                        </div>
                        <span id="installment_number_error" class="error-msg-form"></span>

                        <?php $__errorArgs = ['installment_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="error-msg-form">
                            <?php echo e($message); ?>

                        </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="row">
                        <div class="col-7 col-md-7">
                            <i class="fab fa-cc-visa me-2 text-gray-400"></i>
                            <span><?php echo e(__('basic.amount of each installment')); ?></span>
                        </div>

                        <div class="col-5 text-center d-flex justify-content-center align-items-center">
                            <div class="text-s2 text-gray-600 fw-bold me-1" id="each_installment_amount">
                                0
                            </div>
                            <small class="text-gray-300 text-xxxs">
                                <?php echo e(__('basic.egp')); ?></small>
                        </div>
                    </div>

                    <hr>

                    <div id="installment_number_cont">

                    </div>

                </div>

                <div class="modal-footer">
                    <div class="left-side">
                        <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                    </div>
                    <div class="divider"></div>
                    <div class="right-side">
                        <button type="submit" class="btn btn-default btn-link main-color"><?php echo e(__('basic.pay')); ?></button>
                    </div>
                </div>

            </div>

        </form>

    </div>

</div>

<!-- Modal for add payment -->
<div class="modal fade" id="pay_installment" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

        <form class="mb-0" action="<?php echo e(route('sett.invoice_pay_installment', $invoice->id)); ?>" method="POST"
            style="display: contents">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PATCH'); ?>

            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-wallet me-1"></i>
                        <?php echo e(__('patientappo.pay invoice')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-5 py-3">

                    <div class="row mb-4">
                        <div class="col-7 fw-bold">
                            <i class="fas fa-dollar-sign me-2"></i>
                            <span id="service_final_info"><?php echo e(__('patientappo.final price')); ?></span>
                        </div>
                        <div class="col-5 text-center d-flex justify-content-center align-items-center">
                            <div class="text-s2 text-gray-600 fw-bold me-1" id="remaining_amount_installment">
                                <?php echo e($invoice->final_price - $invoice->payment->sum('amount')); ?>

                            </div>
                            <small class="text-gray-300 text-xxxs">
                                <?php echo e(__('basic.egp')); ?></small>
                        </div>
                    </div>

                    <hr>

                    <div class="row">
                        <div class="col-7 col-md-7">
                            <i class="fas fa-cash-register me-2 text-gray-400"></i>
                            <span id="service_final_info"><?php echo e(__('basic.cash')); ?></span>
                        </div>

                        <div class="col-5 col-md-5 text-center">
                            <input id="cash_pay_insta" name="cash_pay_insta" type="number"
                                class="form-control text-center <?php $__errorArgs = ['cash_pay_insta'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                placeholder="Amount" value="">
                        </div>
                        <span id="cash_pay_insta_error" class="error-msg-form"></span>

                        <?php $__errorArgs = ['cash_pay_insta'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="error-msg-form">
                            <?php echo e($message); ?>

                        </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    </div>

                    <div class="row">
                        <div class="col-7 col-md-7">
                            <i class="fab fa-cc-visa me-2 text-gray-400"></i>
                            <span id="service_final_info"><?php echo e(__('basic.visa')); ?></span>
                        </div>

                        <?php if($invoice->status == 1): ?>
                        <?php
                        $deposit = $invoice->total_paid;
                        ?>
                        <?php else: ?>
                        <?php
                        $deposit = '';
                        ?>
                        <?php endif; ?>

                        <div class="col-5 col-md-5 text-center">
                            <input id="visa_pay_insta" name="visa_pay_insta" type="number"
                                class="form-control text-center <?php $__errorArgs = ['visa_pay_insta'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                placeholder="Amount" value="">
                        </div>
                        <span id="visa_pay_insta_error" class="error-msg-form"></span>

                        <?php $__errorArgs = ['visa_pay_insta'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="error-msg-form">
                            <?php echo e($message); ?>

                        </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    </div>
                    <div class="row mb-4">
                        <div class="col-7 fw-bold">
                            <i class="fas fa-dollar-sign me-2"></i>
                            <span id="service_final_info"><?php echo e(__('basic.remaining amount')); ?></span>
                        </div>
                        <div class="col-5 text-center d-flex justify-content-center align-items-center">
                            <div class="text-s2 text-gray-600 fw-bold me-1" id="remaining_cash_installment">
                                Not Paid Yet
                            </div>
                            <small class="text-gray-300 text-xxxs">
                                <?php echo e(__('basic.egp')); ?></small>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <div class="left-side">
                        <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                    </div>
                    <div class="divider"></div>
                    <div class="right-side">
                        <button type="submit" class="btn btn-default btn-link main-color"><?php echo e(__('basic.pay')); ?></button>
                    </div>
                </div>

            </div>

        </form>

    </div>

</div>

<!-- Modal for refund -->
<div class="modal fade" id="refund" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

        <form class="mb-0" action="<?php echo e(route('sett.refund_inv', $invoice->id)); ?>" method="POST"
            style="display: contents">
            <?php echo csrf_field(); ?>
            <?php echo method_field('post'); ?>

            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-wallet me-1"></i>
                        Refund Invoice</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-5 py-3">

                    <p class="mb-0">ِAre
                        you sure you want to refund
                        this
                        Invoice?</p><br>

                </div>

                <div class="modal-footer">
                    <div class="left-side">
                        <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                    </div>
                    <div class="divider"></div>
                    <div class="right-side">
                        <button type="submit" class="btn btn-default btn-link text-red"><?php echo e(__('basic.refund')); ?>

                        </button>
                    </div>
                </div>

            </div>
        </form>

    </div>

</div>

<?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Branch-manager')): ?>
<!-- Modal for editing -->
<div class="modal fade" id="edit_invoice" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

        <form class="mb-0" action="<?php echo e(route('sett.invoice.update', $invoice->id)); ?>" method="POST"
            style="display: contents">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-wallet me-1"></i>
                        <?php echo e(__('patientappo.edit invoice')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-5 py-3">

                    <div class="row mt-3">
                        <div class="col-7">
                            <i class="fas fa-stethoscope me-2 text-gray-400"></i>
                            <span id="service_final_info"><?php echo e(__('patientappo.total services price')); ?></span>
                        </div>
                        <div class="col-5 text-center">
                            <div id="service_price" data-service_price="<?php echo e($invoice->items_price); ?>"
                                class="text-s2 text-gray-600"><?php echo e($invoice->items_price); ?><small
                                    class="text-gray-300 text-xxxs">
                                    <?php echo e(__('basic.egp')); ?></small>
                            </div>
                        </div>
                    </div>

                    <div class="row my-3" id="discount_amount_div">
                        <div class="col-7">
                            <i class="fas fa-percent me-2 text-gray-400"></i>
                            <span><?php echo e(__('basic.discount')); ?></span>
                        </div>
                        <div class="col-5 text-center">
                            <div class="text-s2 text-gray-600 text-decoration-line-through"
                                id="doctor_discount_place_edit">
                                <?php if($invoice->discount): ?>
                                <?php echo e($invoice->discount); ?> <small class="text-gray-300 text-xxxs">
                                    <?php echo e(__('basic.egp')); ?></small>
                                <?php else: ?>
                                0
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-7 fw-bold">
                            <i class="fas fa-dollar-sign me-2"></i>
                            <span id="service_final_info"><?php echo e(__('patientappo.final price')); ?></span>
                        </div>
                        <div class="col-5 text-center">
                            <div class="text-s2 text-gray-600 fw-bold" id="price_total_final_info_edit">
                                <?php echo e($invoice->final_price); ?><small class="text-gray-300 text-xxxs">
                                    <?php echo e(__('basic.egp')); ?></small>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-7 col-md-7">
                            <i class="fas fa-cash-register me-2 text-gray-400"></i>
                            <span id="service_final_info"><?php echo e(__('basic.target')); ?></span>
                        </div>
                        <div class="col-5 col-md-5 text-center">
                            <select
                                class="js-example-basic-single select2-hidden-accessible <?php $__errorArgs = ['target'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                id="target_input" data-current_number="0" name="target_update">
                                <option <?php if($invoice->target == 1): ?> selected <?php endif; ?> value="1">Old</option>
                                <option <?php if($invoice->target == 2): ?> selected <?php endif; ?> value="2">New page</option>
                                <option <?php if($invoice->target == 3): ?> selected <?php endif; ?> value="3">New friend</option>
                                <option <?php if($invoice->target == 4): ?> selected <?php endif; ?> value="4">Offer</option>
                                <option <?php if($invoice->target == 5): ?> selected <?php endif; ?> value="5">Upgrade</option>
                                <option <?php if($invoice->target == 6): ?> selected <?php endif; ?> value="6">other</option>
                                <option <?php if($invoice->target == 7): ?> selected <?php endif; ?> value="7">other 2</option>
                            </select>
                        </div>
                        <span id="target_error" class="error-msg-form"></span>
                        <?php $__errorArgs = ['target'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="error-msg-form">
                            <?php echo e($message); ?>

                        </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <hr>

                    <?php if($invoice->paid_date): ?>
                    <div class="row mb-4">
                        <div class="col-6 fw-bold">
                            <i class="bi bi-calendar2-week-fill me-2"></i>
                            <span id="service_final_info"><?php echo e(__('basic.paid')); ?></span>
                        </div>
                        <div class="col-6 text-center">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                    </div>
                                </div>
                                <input name="pay_date" type="text"
                                    class="form-control hasdatetimepicker <?php $__errorArgs = ['pay_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="YYYY/MM/DD" value="<?php echo e(date('Y-m-d', strtotime($invoice->paid_date))); ?>"
                                    required>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <div class="row mb-0">
                        <div class="col-7 col-md-7 fw-bold">
                            <i class="fas fa-cash-register me-2"></i>
                            <span id="service_final_info"><?php echo e(__('basic.status')); ?></span>
                        </div>

                        <div class="col-5 col-md-5 text-center">
                            <div class="switch-checkbox">
                                <input class="done_btn" name="status" type="checkbox" <?php if($invoice->status == 3): ?>
                                checked <?php endif; ?> value="3"
                                id="status_check"><label for="status_check" class="ms-auto me-auto">Toggle</label>
                            </div>
                        </div>
                        <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="error-msg-form">
                            <?php echo e($message); ?>

                        </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="modal-footer">
                    <div class="left-side">
                        <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                    </div>
                    <div class="divider"></div>
                    <div class="right-side">
                        <button type="submit" class="btn btn-default btn-link main-color"><?php echo e(__('basic.pay')); ?></button>
                    </div>
                </div>

            </div>
        </form>

    </div>

</div>
<?php endif; ?>

<!-- Modal for note -->
<div class="modal fade" id="edit_note" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

        <form class="mb-0" action="<?php echo e(route('sett.inv_edit_note', $invoice->id)); ?>" method="POST"
            style="display: contents">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-wallet me-1"></i>
                        <?php echo e(__('basic.note')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-5 py-3">

                    <div class="row mb-2">
                        <div class="col-12 mb-2">
                            <label class="form-label"><?php echo e(__('basic.note')); ?>

                                <small>(<?php echo e(__('basic.optional')); ?>)</small></label>
                            <textarea name="note" class="form-control" placeholder="Write here your notes .." rows="4"
                                spellcheck="false"><?php echo e($invoice->note); ?></textarea>

                            <?php $__errorArgs = ['note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error-msg-form">
                                <?php echo e($message); ?>

                            </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                    </div>

                </div>

                <div class="modal-footer">
                    <div class="left-side">
                        <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                    </div>
                    <div class="divider"></div>
                    <div class="right-side">
                        <button type="submit" class="btn btn-default btn-link main-color"><?php echo e(__('basic.edit')); ?></button>
                    </div>
                </div>

            </div>
        </form>

    </div>

</div>

<!-- Modal for add new items to invoice -->
<div class="modal fade" id="add_items" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content b-r-s-cont border-0">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-wallet me-1"></i>
                    <?php echo e(__('patientappo.new items invoice title')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <form class="mb-0" action="<?php echo e(route('sett.invo_add_items', $invoice->id)); ?>" method="post">
                <?php echo csrf_field(); ?>
                <?php echo method_field('POST'); ?>

                <!-- Modal content -->
                <div class="modal-body px-5 py-3 mb-2">

                    <div class="row mt-3">

                        <div class="col-12 mb-2">
                            <label class="form-label"><?php echo e(__('basic.services')); ?>

                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                            <select
                                class="myselect2-additem-insert select2-hidden-accessible <?php $__errorArgs = ['item_add'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                id="item_add_input" multiple="" name="item_add[]">
                                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->id); ?>">
                                    <?php echo e($item->name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <span id="item_add_error" class="error-msg-form"></span>
                            <?php $__errorArgs = ['item_add'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error-msg-form">
                                <?php echo e($message); ?>

                            </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-12 mb-2">
                            <label class="form-label">Products
                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                            <select
                                class="myselect2-additem-insert select2-hidden-accessible <?php $__errorArgs = ['item_add_product'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                id="item_add_products_input" multiple="" name="item_add_product[]">
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->id); ?>">
                                    <?php echo e($item->name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <span id="item_add_product_error" class="error-msg-form"></span>
                            <?php $__errorArgs = ['item_add_product'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error-msg-form">
                                <?php echo e($message); ?>

                            </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <div class="left-side">
                        <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                    </div>
                    <div class="divider"></div>
                    <div class="right-side">
                        <input type="hidden" name="branch_id" value="<?php echo e($invoice->branch_id); ?>">
                        <input type="hidden" name="type_id" value="<?php echo e($invoice->type); ?>">
                        <button type="submit" class="btn btn-default btn-link main-color"><?php echo e(__('basic.send')); ?></button>
                    </div>
                </div>
            </form>

        </div>
    </div>

</div>

<!-- Modal for add new items to invoice -->
<div class="modal fade" id="add_material" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content b-r-s-cont border-0">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-wallet me-1"></i>
                    <?php echo e(__('basic.new material')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <form class="mb-0" action="<?php echo e(route('sett.invo_add_material', $invoice->id)); ?>" method="post">
                <?php echo csrf_field(); ?>
                <?php echo method_field('POST'); ?>

                <!-- Modal content -->
                <div class="modal-body px-5 py-3 mb-2">

                    <div class="row mt-3">

                        <div class="col-12 mb-2">
                            <label class="form-label"><?php echo e(__('basic.item')); ?>

                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                            <select
                                class="js-example-basic-single select2-hidden-accessible <?php $__errorArgs = ['invoice_item_material'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                id="invoice_item_material" name="invoice_item_material">
                                <?php $__currentLoopData = $invoice->invoice_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->id); ?>">
                                    <?php echo e($item->categorizable->name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <span id="invoice_item_material_error" class="error-msg-form"></span>
                            <?php $__errorArgs = ['invoice_item_material'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error-msg-form">
                                <?php echo e($message); ?>

                            </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-12 mb-2">
                            <label class="form-label">Inventory
                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                            <select
                                class="js-example-basic-single select2-hidden-accessible <?php $__errorArgs = ['inventory_add_material'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                name="inventory_add_material">
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->id); ?>">
                                    <?php echo e($item->name); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <span id="inventory_add_material_error" class="error-msg-form"></span>
                            <?php $__errorArgs = ['inventory_add_material'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error-msg-form">
                                <?php echo e($message); ?>

                            </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-7 col-md-7">
                            <span id="service_final_info">Quantity</span>
                        </div>
                        <div class="col-5 col-md-5 text-center">
                            <input name="material_qty" type="number"
                                class="form-control text-center serivce_price_change <?php $__errorArgs = ['material_qty'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                placeholder="Material quantity.." value="1" required>
                        </div>
                        <span id="material_qty_error" class="error-msg-form"></span>
                        <?php $__errorArgs = ['material_qty'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="error-msg-form">
                            <?php echo e($message); ?>

                        </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                </div>

                <div class="modal-footer">
                    <div class="left-side">
                        <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                    </div>
                    <div class="divider"></div>
                    <div class="right-side">
                        <input type="hidden" name="branch_id" value="<?php echo e($invoice->branch_id); ?>">
                        <input type="hidden" name="type_id" value="<?php echo e($invoice->type); ?>">
                        <button type="submit" class="btn btn-default btn-link main-color"><?php echo e(__('basic.send')); ?></button>
                    </div>
                </div>
            </form>

        </div>
    </div>

</div>

<div class="card card-input shadow mb-3 pb-3">
    <!-- Card Header - Dropdown -->
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-wallet me-1"></i> <?php echo e(__('basic.invoice')); ?></h6>
    </div>


    <!-- Card Body -->
    <div class="card-body px-4 px-md-5">

        <div class="row px-0 px-md-3 px-lg-5 pt-3">

            <div class="col-9 mb-2">
                <div class="row mb-2">

                    <?php if($invoice->receivable): ?>
                    <div class="d-flex mb-2 align-items-center">

                        <img class="rounded-circle avatar-lg me-3"
                            src="<?php echo e(URL::asset('img/useravatar/' . $invoice->receivable->avatar)); ?>">
                        <div class="">
                            <p class=" mb-0 text-xs text-gray-300">
                                <?php echo e(__('basic.patient')); ?></p>
                            <a class="mb-1 fw-bold fs-5 text-gray-600" <?php if($invoice->type == 0): ?> href="<?php echo e(route('sett.patient.show', $invoice->receivable->id)); ?>"
                                <?php else: ?>

                                <?php if($invoice->receivable_type === 'App\Models\Invoice\Debtor'): ?>
                                href="<?php echo e(route('sett.invo_debtor', $invoice->receivable->id)); ?>"
                                <?php else: ?>
                                href=" <?php echo e(route('sett.patient.show', $invoice->receivable->id)); ?>" <?php endif; ?>
                                <?php endif; ?>

                                ><?php echo e($invoice->receivable->name); ?>

                            </a>
                            <p class="mb-0 text-xs text-gray-400"><?php echo e(__('basic.id')); ?> <strong>
                                    <?php echo e($invoice->receivable->id); ?></strong>
                            </p>
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="text-center text-gray-300">
                        <i class="fas fa-id-card-alt fs-2 mb-2"></i>
                        <h4><?php echo e(__('patientappo.invoice no receiver')); ?></h4>
                    </div>
                    <?php endif; ?>
                </div>

            </div>

            <div class="col-3 align-self-center">
                <div class="">
                    <div class="visible-print text-center">
                        <?php echo QrCode::color(68, 95,
                        129)->size(75)->style('round')->eye('circle')->generate($invoice->code); ?>

                        <p id="addre_final_info" class="text-gray-300 fs-6 fw-bold mt-1 mb-0 text-gray-300">
                            <?php echo e($invoice->code); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <hr>

        <div class="row px-0 justify-content-center my-4">

            <div class="col-3 col-md-2">
                <h6 class="text-gray-300 text-xs mb-1 text-center"><?php echo e(__('basic.type')); ?></h6>
                <p id="branch_final_info" class="text-gray-600 text-s fw-bold text-center">
                    <?php if($invoice->type == 0): ?>
                    <?php echo e(__('patientappo.income')); ?>

                    <?php else: ?>
                    <?php echo e(__('patientappo.expenses')); ?>

                    <?php endif; ?>
                </p>
            </div>

            <div class="col-3 col-md-2">
                <h6 class="text-gray-300 text-xs mb-1 text-center"><?php echo e(__('basic.specialty')); ?></h6>
                <p id="branch_final_info" class="text-gray-600 text-s fw-bold text-center text-truncate">
                    <?php echo e($invoice->specialty->name); ?></p>
            </div>

            <div class="col-3 col-md-2">
                <h6 class="text-gray-300 text-xs mb-1 text-center"><?php echo e(__('basic.branch')); ?></h6>
                <p id="branch_final_info" class="text-gray-600 text-s fw-bold text-center text-truncate">
                    <?php echo e($invoice->branch->name); ?> <?php if($invoice->worker): ?>
                    | <?php echo e($invoice->worker->name); ?>

                    <?php endif; ?>
                </p>
            </div>

            <div class="col-3 col-md-2">
                <h6 class="text-gray-300 text-xs mb-1 text-center"><?php echo e(__('basic.created')); ?></h6>
                <p id="branch_final_info" class="text-gray-600 text-s fw-bold text-center text-truncate">
                    <?php echo e(date('d M Y', strtotime($invoice->created_at))); ?></p>
            </div>

            <div class="col-3 col-md-2 text-center">

                <h6 class="text-gray-300 text-xs mb-1 text-center">
                    <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Branch-manager')): ?>
                    <i class="fas fa-pen me-1 link-cust-text text-gray-400 clickable-item-pointer"
                        data-bs-toggle="modal" data-bs-target="#edit_attached"></i>
                    <?php endif; ?> <?php echo e(__('basic.attached')); ?>

                </h6>

                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Branch-manager')): ?>
                <!-- Modal for editing -->
                <div class="modal fade" id="edit_attached" tabindex="-1" role="dialog"
                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                        <form class="mb-0" action="<?php echo e(route('sett.invoice_edit_attched', $invoice->id)); ?>" method="POST"
                            enctype="multipart/form-data" style="display: contents">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PATCH'); ?>

                            <div class="modal-content b-r-s-cont border-0">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-link me-1"></i>
                                        Edit attched</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>

                                <!-- Modal content -->
                                <div class="modal-body px-5 py-3">

                                    <div class="row">

                                        <div class="col-12 mb-2 text-start">
                                            <label class="form-label">Attached img
                                                <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                            <input class="form-control" name='attached_pic_edit' accept="image/*"
                                                type="file" id="formFile">

                                            <div class="form-text text-gray-200">Attach an invoice img.
                                            </div>

                                            <span id="attached_pic_edit_error" class="error-msg-form"></span>

                                            <?php $__errorArgs = ['attached_pic_edit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="error-msg-form">
                                                <?php echo e($message); ?>

                                            </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                    </div>

                                </div>

                                <div class="modal-footer">
                                    <div class="left-side">
                                        <button type="button" class="btn btn-default btn-link"
                                            data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                    </div>
                                    <div class="divider"></div>
                                    <div class="right-side">
                                        <button type="submit" class="btn btn-default btn-link main-color"><?php echo e(__('basic.edit')); ?></button>
                                    </div>
                                </div>

                            </div>
                        </form>

                    </div>

                </div>
                <?php endif; ?>

                <?php if(!empty($invoice->attached_pic)): ?>
                <a href="<?php echo e(URL::asset('img/inv_attached/' . $invoice->attached_pic)); ?>" target="_blank"
                    class="btn btn-sm modal-effect status-col-link active-color-btn b-r-l-cont px-2" title="download"><i
                        class="fas fa-arrow-circle-down"></i>
                    <?php echo e(__('basic.download')); ?>

                </a>
                <?php else: ?>
                <p id="branch_final_info" class="text-gray-600 text-s fw-bold text-center text-truncate">
                    No attached
                </p>
                <?php endif; ?>
            </div>

            <?php if($invoice->payment_method == 1): ?>
            <?php
            $payment_method_txt = __('basic.cash');
            ?>
            <?php elseif($invoice->payment_method == 2): ?>
            <?php
            $payment_method_txt = __('basic.visa');
            ?>
            <?php elseif($invoice->payment_method == 3): ?>
            <?php
            $payment_method_txt = __('basic.online');
            ?>
            <?php elseif($invoice->payment_method == 4): ?>
            <?php
            $payment_method_txt = __('basic.bank transfer');
            ?>
            <?php elseif($invoice->payment_method == 5): ?>
            <?php
            $payment_method_txt = __('basic.mobile transfer');
            ?>
            <?php else: ?>
            <?php
            $payment_method_txt = '';
            ?>
            <?php endif; ?>

            <?php if($invoice->status == 0): ?>
            <div class="col-3 col-md-2 text-center">
                <h6 class="text-gray-300 text-xs mb-1 text-center"><?php echo e(__('basic.status')); ?></h6>
                <span class="badge rounded-pill badge-padd-l cancel-color-btn text-truncate"><?php echo e(__('basic.not paid')); ?></span>
            </div>
            <?php elseif($invoice->status == 1): ?>
            <div class="col-3 col-md-2 text-center">
                <h6 class="text-gray-300 text-xs mb-1 text-center"><?php echo e(__('basic.status')); ?></h6>
                <span class="badge rounded-pill badge-padd-l pend-color-btn text-truncate"><?php echo e(__('basic.pending')); ?></span>
            </div>
            <?php elseif($invoice->status == 2): ?>
            <div class="col-3 col-md-2 text-center">
                <h6 class="text-gray-300 text-xs mb-1 text-center"><?php echo e(__('basic.status')); ?></h6>
                <span class="badge rounded-pill badge-padd-l pend-color-btn text-truncate"><?php echo e(__('basic.installment')); ?></span>
            </div>
            <?php elseif($invoice->status == 3): ?>
            <div class="col-3 col-md-2 text-center">
                <h6 class="text-gray-300 text-xs mb-1 text-center"><?php echo e(__('basic.paid')); ?></h6>
                <p id="branch_final_info" class="text-gray-600 text-s fw-bold text-center text-truncate">
                    <?php echo e(date('d M Y', strtotime($invoice->paid_date))); ?> | <?php echo e($payment_method_txt); ?>

                </p>
            </div>
            <?php else: ?>
            <div class="col-3 col-md-2 text-center">
                <a href="<?php echo e(route('sett.invoice.show', $invoice->refund_id)); ?>">
                    <h6 class="text-gray-300 text-xs mb-1 text-center"><?php echo e(__('basic.status')); ?></h6>
                    <span class="badge rounded-pill badge-padd-l pend-color-btn text-truncate"><?php echo e(__('basic.refund')); ?></span>
                </a>
            </div>
            <?php endif; ?>
        </div>

        <hr>

        <?php $__currentLoopData = $invoice->invoice_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="row px-0 px-md-3 px-lg-5 mt-3">
            <div class="col-9 ps-3 ps-md-5">
                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Branch-manager')): ?>
                <i class="fas fa-pen me-2 link-cust-text text-gray-400 clickable-item-pointer" data-bs-toggle="modal"
                    data-bs-target="#edit_item_invoice_<?php echo e($item->id); ?>"></i>
                <?php endif; ?>
                <i class="fas fa-stethoscope me-2 text-gray-400"></i>
                <span id="service_final_info"><?php echo e($item->categorizable->name); ?></span>
            </div>
            <div class="col-3 text-center pe-0 pe-md-5">
                <div class="text-s2 text-gray-600"><?php echo e($item->price); ?><small class="text-gray-300 text-xxxs">
                        <?php echo e(__('basic.egp')); ?></small>
                </div>
            </div>
        </div>

        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Branch-manager')): ?>
        <!-- Modal for editing -->
        <div class="modal fade" id="edit_item_invoice_<?php echo e($item->id); ?>" tabindex="-1" role="dialog"
            aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                <form class="mb-0" action="<?php echo e(route('sett.inv_edit_item', $item->id)); ?>" method="POST"
                    style="display: contents">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PATCH'); ?>

                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-wallet me-1"></i>
                                <?php echo e($item->categorizable->name); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-5 py-3">

                            <div class="row">
                                <div class="col-7 col-md-7">
                                    <i class="fas fa-stethoscope me-2 text-gray-400"></i>
                                    <span id="service_final_info">Original price
                                    </span>
                                </div>

                                <div class="col-5 col-md-5 text-center">
                                    <input id="original_price" name="original_price" type="number" step=".01"
                                        class="form-control text-center serivce_price_change <?php $__errorArgs = ['original_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Item Amount" value="<?php echo e($item->price); ?>">
                                </div>
                                <span id="original_price" class="error-msg-form"></span>

                                <?php $__errorArgs = ['original_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="row mb-1">
                                <div class="col-7 col-md-7 fw-bold">
                                    <i class="fas fa-cash-register me-2"></i>
                                    <span id="service_final_info">Sold Price</span>
                                </div>
                                <div class="col-5 col-md-5 text-center">
                                    <input disabled type="number" class="form-control text-center" placeholder="Amount"
                                        value="<?php echo e($item->sold_price); ?>">
                                </div>
                            </div>

                            <div class="row mb-1">
                                <div class="col-7 col-md-7 fw-bold">
                                    <i class="fas fa-cash-register me-2"></i>
                                    <span id="service_final_info">Paid</span>
                                </div>
                                <div class="col-5 col-md-5 text-center">
                                    <input disabled type="number" class="form-control text-center" placeholder="Amount"
                                        value="<?php echo e($item->paid); ?>">
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-7 col-md-7">
                                    <i class="fas fa-stethoscope me-2 text-gray-400"></i>
                                    <span id="service_final_info">Doctor Commission
                                    </span>
                                </div>

                                <div class="col-5 col-md-5 text-center">
                                    <input id="doctor_comm" name="doctor_comm" type="number" step=".01"
                                        class="form-control text-center serivce_price_change <?php $__errorArgs = ['original_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="Doctor Commission.." value="<?php echo e($item->doctor_comm); ?>">
                                </div>
                                <span id="doctor_comm" class="error-msg-form"></span>

                                <?php $__errorArgs = ['doctor_comm'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="submit" class="btn btn-default btn-link main-color"><?php echo e(__('basic.edit')); ?></button>
                            </div>
                        </div>

                    </div>
                </form>

            </div>

        </div>
        <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <hr>

        <div class="row px-0 px-md-3 px-lg-5 my-2">
            <div class="col-9 ps-3 ps-md-5">
                <i class="fas fa-coins me-2 text-gray-400"></i><span id="service_final_info"><?php echo e(__('basic.subtotal')); ?></span>
            </div>
            <div class="col-3 text-center pe-0 pe-md-5">
                <div class="text-s2 text-gray-500"><?php echo e($invoice->invoice_items->sum('price')); ?><small
                        class="text-gray-300 text-xxxs"> <?php echo e(__('basic.egp')); ?></small>
                </div>
            </div>
        </div>

        <div class="row px-0 px-md-3 px-lg-5 my-2">
            <div class="col-9 ps-3 ps-md-5">
                <i class="fas fa-percent me-2 text-gray-400"></i><span id="service_final_info"><?php echo e(__('basic.discount')); ?></span>
            </div>
            <div class="col-3 text-center pe-0 pe-md-5">
                <div class="text-s2 text-gray-600 text-decoration-line-through">
                    <?php if(!empty($invoice->discount)): ?>
                    <?php echo e($invoice->discount); ?>

                    <small class="text-gray-300 text-xxxs"> <?php echo e(__('basic.egp')); ?></small>
                    <?php else: ?>
                    0 <small class="text-gray-300 text-xxxs"> <?php echo e(__('basic.egp')); ?></small>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="row px-0 px-md-3 px-lg-5 my-2 mb-4">
            <div class="col-9 ps-3 ps-md-5 fw-bold">
                <i class="fas fa-dollar-sign me-2"></i>
                <span id="service_final_info"><?php echo e(__('basic.total price')); ?></span>
            </div>
            <div class="col-3 text-center pe-0 pe-md-5">
                <div class="text-s2 text-gray-600 fw-bold"><?php echo e($invoice->final_price); ?><small
                        class="text-gray-300 text-xxxs"> <?php echo e(__('basic.egp')); ?></small>
                </div>
            </div>
        </div>

        <hr>

        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Accountant')): ?>

        <div class="px-0 px-md-3 px-lg-5">
            <p class="px-0 px-md-3 px-lg-5 text-gray-300">All Costs</p>
        </div>
        <div class="row px-0 px-md-3 px-lg-5 mt-3">
            <div class="col-9 ps-3 ps-md-5">
                <i class="fas fa-user-md me-2 text-gray-400"></i>
                <span id="service_final_info">Doctors commission</span>
            </div>

            <div class="col-3 text-center pe-0 pe-md-5">
                <div class="text-s2 text-gray-600"><?php echo e($invoice->invoice_items->sum('doctor_comm')); ?><small
                        class="text-gray-300 text-xxxs">
                        <?php echo e(__('basic.egp')); ?></small>
                </div>
            </div>
        </div>

        <?php if(count($invoice->costs) > 0): ?>
        <hr>

        <div class="px-0 px-md-3 px-lg-5">
            <p class="px-0 px-md-3 px-lg-5 text-gray-300">Basic Costs</p>
        </div>

        <?php $__currentLoopData = $invoice->costs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="row px-0 px-md-3 px-lg-5 mt-3">
            <div class="col-9 ps-3 ps-md-5">
                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Branch-manager')): ?>
                <i class="fas fa-times me-2 link-cust-text text-gray-400 clickable-item-pointer" data-bs-toggle="modal"
                    data-bs-target="#delete_material_<?php echo e($item->id); ?>"></i>
                <?php endif; ?>
                <i class="fas fa-receipt me-2 text-gray-400"></i>
                <span id="service_final_info"><?php echo e($item->cost_cat->name); ?></span>
            </div>

            <div class="col-3 text-center pe-0 pe-md-5">
                <div class="text-s2 text-gray-600"><?php echo e($item->price); ?><small class="text-gray-300 text-xxxs">
                        <?php echo e(__('basic.egp')); ?></small>
                </div>
            </div>
        </div>


        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Branch-manager')): ?>
        <!-- Modal for editing -->
        <div class="modal fade" id="delete_material_<?php echo e($item->id); ?>" tabindex="-1" role="dialog"
            aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                <form class="mb-0" action="<?php echo e(route('sett.delete_inv_material', $item->id)); ?>" method="POST"
                    style="display: contents">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('delete'); ?>

                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-wallet me-1"></i>
                                Delete Material</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-5 py-3">

                            <p class="mb-0">ِAre
                                you sure you want to delete
                                this
                                Payment?</p><br>

                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="submit" class="btn btn-default btn-link text-red"><?php echo e(__('basic.delete')); ?>

                                </button>
                            </div>
                        </div>

                    </div>
                </form>

            </div>

        </div>
        <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

        <?php if(count($invoice->materials) > 0): ?>

        <hr>

        <div class="px-0 px-md-3 px-lg-5">
            <p class="px-0 px-md-3 px-lg-5 text-gray-300">Materials</p>
        </div>

        <?php $__currentLoopData = $invoice->materials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="row px-0 px-md-3 px-lg-5 mt-3">
            <div class="col-9 ps-3 ps-md-5">
                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Branch-manager')): ?>
                <i class="fas fa-times me-2 link-cust-text text-gray-400 clickable-item-pointer" data-bs-toggle="modal"
                    data-bs-target="#delete_material_<?php echo e($item->id); ?>"></i>
                <?php endif; ?>
                <i class="fas fa-receipt me-2 text-gray-400"></i>
                <span id="service_final_info"><?php echo e($item->inventory->name); ?> <small class="text-gray-300 text-xxs">(Qty:
                        <?php echo e($item->qty); ?>)</small></span>
            </div>

            <div class="col-3 text-center pe-0 pe-md-5">
                <?php
                $material_item_cost = $item->qty * $item->price;
                ?>
                <div class="text-s2 text-gray-600"><?php echo e($material_item_cost); ?><small class="text-gray-300 text-xxxs">
                        <?php echo e(__('basic.egp')); ?></small>
                </div>
            </div>
        </div>


        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Branch-manager')): ?>
        <!-- Modal for editing -->
        <div class="modal fade" id="delete_material_<?php echo e($item->id); ?>" tabindex="-1" role="dialog"
            aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                <form class="mb-0" action="<?php echo e(route('sett.delete_inv_material', $item->id)); ?>" method="POST"
                    style="display: contents">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('delete'); ?>

                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-wallet me-1"></i>
                                Delete Material</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-5 py-3">

                            <p class="mb-0">ِAre
                                you sure you want to delete
                                this
                                Payment?</p><br>

                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="submit" class="btn btn-default btn-link text-red"><?php echo e(__('basic.delete')); ?>

                                </button>
                            </div>
                        </div>

                    </div>
                </form>

            </div>

        </div>
        <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

        <div class="row px-0 px-md-3 px-lg-5 mt-3">
            <div class="col-9 ps-3 ps-md-5">
                <i class="fas fa-box-open me-2"></i>
                <span id="service_final_info"><?php echo e(__('basic.total cost')); ?></span>
            </div>
            <div class="col-3 text-center pe-0 pe-md-5">
                <div class="text-s2 text-gray-600 fw-bold me-1" id="price_total_final_info">
                    <?php echo e($invoice->total_cost); ?>

                </div>
                <small class="text-gray-300 text-xxxs">
                    <?php echo e(__('basic.egp')); ?></small>
            </div>
        </div>
        <?php endif; ?>

        
        <?php if(count($invoice->payment) > 0): ?>

        <hr>

        <div class="px-0 px-md-3 px-lg-5">
            <p class="px-0 px-md-3 px-lg-5 text-gray-300">Payments</p>
        </div>

        <?php $__currentLoopData = $invoice->payment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item_p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
        if ($item_p->method == 1) {
        $method_payment = 'Cash';
        } else {
        $method_payment = 'Visa';
        }
        ?>
        <div class="row px-0 px-md-3 px-lg-5 mt-3">
            <div class="col-9 ps-3 ps-md-5">
                <?php if($invoice->status == 1): ?>
                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Branch-manager')): ?>
                <i class="fas fa-times me-2 link-cust-text text-gray-400 clickable-item-pointer" data-bs-toggle="modal"
                    data-bs-target="#delete_inv_payment_<?php echo e($item_p->id); ?>"></i>
                <?php endif; ?>
                <?php endif; ?>
                <i class="fas fa-pen me-2 link-cust-text text-gray-400 clickable-item-pointer" data-bs-toggle="modal"
                    data-bs-target="#edit_inv_payment_<?php echo e($item_p->id); ?>"></i>

                <!-- paying installment -->
                <?php if($item_p->type == 2): ?>
                <i class="fas fa-cash-register me-2 link-cust-text text-gray-400 clickable-item-pointer"
                    data-bs-toggle="modal" data-bs-target="#pay_installment_payment_<?php echo e($item_p->id); ?>"></i>

                <!-- Modal for paying installment -->
                <div class="modal fade" id="pay_installment_payment_<?php echo e($item_p->id); ?>" tabindex="-1" role="dialog"
                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                        <form class="mb-0" action="<?php echo e(route('sett.pay_installment', $item_p->id)); ?>" method="POST"
                            style="display: contents">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PATCH'); ?>

                            <div class="modal-content b-r-s-cont border-0">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-wallet me-1"></i>
                                        Pay Installment</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>

                                <!-- Modal content -->
                                <div class="modal-body px-5 py-3">

                                    <p class="mb-0">ِAre
                                        you sure you want to pay
                                        this
                                        installment?</p><br>

                                </div>

                                <div class="modal-footer">
                                    <div class="left-side">
                                        <button type="button" class="btn btn-default btn-link"
                                            data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                    </div>
                                    <div class="divider"></div>
                                    <div class="right-side">
                                        <button type="submit" class="btn btn-default btn-link main-color"><?php echo e(__('basic.pay')); ?></button>
                                    </div>
                                </div>

                            </div>
                        </form>

                    </div>

                </div>
                <?php endif; ?>

                <i class="fas fa-dollar-sign me-1 text-gray-400"></i>
                <?php if($item_p->type == 2): ?>
                <span id="service_final_info" class="pend-color"><?php echo e(date('d M Y', strtotime($item_p->installment_date))); ?>

                    Installment
                </span>
                <?php else: ?>
                <span id="service_final_info"><?php echo e(date('d M Y', strtotime($item_p->paid_date))); ?>

                    via
                    <?php echo e($method_payment); ?>

                </span>
                <?php endif; ?>
                <?php if($item_p->installment_date): ?>
                <p class="text-gray-300 mb-0">Installment:
                    <?php echo e(date('d M Y', strtotime($item_p->installment_date))); ?>

                </p>
                <?php endif; ?>
                <?php if($item_p->worker): ?>
                <p class="text-gray-400 mb-0">Shift:
                    <?php echo e($item_p->worker->name); ?>

                </p>
                <?php endif; ?>
            </div>
            <div class="col-3 text-center pe-0 pe-md-5">
                <div class="text-s2 text-gray-600"><?php echo e($item_p->amount); ?><small class="text-gray-300 text-xxxs">
                        <?php echo e(__('basic.egp')); ?></small>
                </div>
            </div>
        </div>

        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Branch-manager')): ?>
        <!-- Modal for editing -->
        <div class="modal fade" id="edit_inv_payment_<?php echo e($item_p->id); ?>" role="dialog"
            aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                <form class="mb-0" action="<?php echo e(route('sett.edit_inv_payment', $item_p->id)); ?>" method="POST"
                    style="display: contents">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PATCH'); ?>

                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-wallet me-1"></i>
                                Edit Payment</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-5 py-3">

                            <?php if($item_p->paid_date): ?>
                            <div class="row">
                                <div class="col-7 col-md-7">
                                    <i class="fas fa-calendar me-2 text-gray-400"></i>
                                    <span>Payment Date</span>
                                </div>
                                <div class="col-5 col-md-5 text-center">
                                    <input name="payment_date" type="text"
                                        class="form-control datepicker_time bg-white <?php $__errorArgs = ['payment_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="YYYY/MM/DD HM" value="<?php echo e($item_p->paid_date); ?>"
                                        data-enable-time="true" required>
                                </div>
                                <span id="original_price" class="error-msg-form"></span>

                                <?php $__errorArgs = ['payment_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <?php endif; ?>

                            <?php if($item_p->installment_date): ?>
                            <div class="row">
                                <div class="col-7 col-md-7">
                                    <i class="fas fa-table me-2 text-gray-400"></i>
                                    <span>installment Date</span>
                                </div>
                                <div class="col-5 col-md-5 text-center">
                                    <input name="installment_date" type="text"
                                        class="form-control datepicker_time bg-white <?php $__errorArgs = ['installment_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        placeholder="YYYY/MM/DD HM" value="<?php echo e($item_p->installment_date); ?>">
                                </div>
                                <span id="original_price" class="error-msg-form"></span>

                                <?php $__errorArgs = ['installment_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <?php endif; ?>

                            <div class="row">
                                <div class="col-7 col-md-7">
                                    <i class="fas fa-credit-card me-2 text-gray-400"></i><span>Payment
                                        Method</span>
                                </div>
                                <div class="col-5 col-md-5 text-center">
                                    <select
                                        class="js-example-basic-single select2-hidden-accessible <?php $__errorArgs = ['payment_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="payment_method">
                                        <option <?php if($item_p->method == 1): ?> selected <?php endif; ?>
                                            value="1">
                                            <?php echo e(__('basic.cash')); ?>

                                        </option>
                                        <option <?php if($item_p->method == 2): ?> selected <?php endif; ?>
                                            value="2">
                                            <?php echo e(__('basic.visa')); ?>

                                        </option>

                                    </select>
                                </div>
                                <span id="original_price" class="error-msg-form"></span>

                                <?php $__errorArgs = ['payment_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-msg-form">
                                    <?php echo e($message); ?>

                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="submit" class="btn btn-default btn-link main-color"><?php echo e(__('basic.edit')); ?></button>
                            </div>
                        </div>

                    </div>
                </form>

            </div>

        </div>
        <?php endif; ?>


        <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Branch-manager')): ?>
        <!-- Modal for editing -->
        <div class="modal fade" id="delete_inv_payment_<?php echo e($item_p->id); ?>" tabindex="-1" role="dialog"
            aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                <form class="mb-0" action="<?php echo e(route('sett.delete_inv_payment', $item_p->id)); ?>" method="POST"
                    style="display: contents">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('delete'); ?>

                    <div class="modal-content b-r-s-cont border-0">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-wallet me-1"></i>
                                Delete Payment</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-5 py-3">

                            <p class="mb-0">ِAre
                                you sure you want to delete
                                this
                                Payment?</p><br>

                        </div>

                        <div class="modal-footer">
                            <div class="left-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                            </div>
                            <div class="divider"></div>
                            <div class="right-side">
                                <button type="submit" class="btn btn-default btn-link text-red"><?php echo e(__('basic.delete')); ?>

                                </button>
                            </div>
                        </div>

                    </div>
                </form>

            </div>

        </div>
        <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <div class="row px-0 px-md-3 px-lg-5 my-2">
            <div class="col-9 ps-3 ps-md-5 fw-bold">
                <i class="fas fa-dollar-sign me-2"></i>
                <span id="service_final_info"><?php echo e(__('basic.total payments')); ?></span>
            </div>
            <div class="col-3 text-center pe-0 pe-md-5">
                <div class="text-s2 text-gray-600 fw-bold">
                    <?php if($invoice->sum_payment): ?>
                    <?php echo e($invoice->sum_payment); ?>

                    <?php else: ?>
                    0
                    <?php endif; ?>
                    <small class="text-gray-300 text-xxxs"> <?php echo e(__('basic.egp')); ?></small>
                </div>
            </div>
        </div>
        <?php if($invoice->status !== 3): ?>
        <hr>
        <div class="row px-0 px-md-3 px-lg-5 my-3">
            <div class="col-9 ps-3 ps-md-5 fw-bold">
                <i class="fas fa-money-check me-2 text-gray-400"></i>
                <span id="service_final_info"><?php echo e(__('basic.remaining amount')); ?></span>
            </div>
            <div class="col-3 text-center pe-0 pe-md-5">
                <div class="text-s2 text-gray-600 fw-bold">
                    <?php echo e($invoice->final_price - $invoice->sum_payment); ?><small class="text-gray-300 text-xxxs">
                        <?php echo e(__('basic.egp')); ?></small>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <?php endif; ?>


        <div class="row px-0 px-md-3 px-lg-5 my-3">
            <div class="col-12 mb-2">
                <label class="form-label text-gray-300"> <i
                        class="fas fa-pen me-1 link-cust-text text-gray-400 clickable-item-pointer"
                        data-bs-toggle="modal" data-bs-target="#edit_note"></i> <?php echo e(__('basic.note')); ?></label>
                <div class="form-control-textarea overflow-auto">
                    <?php echo e($invoice->note); ?></div>
            </div>
        </div>

        <div class="row align-items-center main-color-bg text-white px-lg-5 b-r-s-cont px-4 py-4">
            <div class="col-12 col-md-7 text-blue-300 mb-2 mb-md-0">
                <?php echo e(__('patientappo.invoice final msg')); ?>

            </div>

            <div class="col-12 col-md-5 text-center">

                <?php if($invoice->status == 0): ?>
                <p id="date_final_info" class="fs-2 fw-bold mb-0">
                    <?php echo e(__('basic.not paid')); ?>

                </p>
                <?php elseif(in_array($invoice->status, [1, 2])): ?>
                <h6 class="text-xs mb-2 text-blue-300"><?php echo e(__('basic.remaining amount')); ?></h6>
                <p id="date_final_info" class="fs-2 fw-bold mb-0">
                    <?php echo e($invoice->final_price - $invoice->sum_payment); ?> <small class="text-blue-300 text-xxxs">
                        <?php echo e(__('basic.egp')); ?></small>
                </p>
                <?php else: ?>
                <h6 class="text-xs mb-0 text-blue-300"><?php echo e(__('patientappo.amount to pay')); ?></h6>
                <p id="date_final_info" class="fs-2 fw-bold mb-0">
                    <?php echo e($invoice->final_price); ?> <small class="text-blue-300 text-xxxs">
                        <?php echo e(__('basic.egp')); ?></small>
                </p>
                <?php endif; ?>
            </div>
        </div>
    </div>

</div>

<?php $__env->stopSection(); ?>



<!-- js insert -->
<?php $__env->startSection('js'); ?>


<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
    $('.js-example-basic-single').select2({
            minimumResultsForSearch: -1
        });
        $(".myselect2-additem-insert").select2({
            dropdownParent: $("#add_items")
        });
        //hide search
        $('.select2-no-search-additem').select2({
            dropdownParent: $("#add_items"),
            minimumResultsForSearch: -1
        });
</script>

<!-- jquery ui datepicker -->
<script type="text/javascript"
    src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
<script>
    $(function() {
            $('.hasdatetimepicker').datepicker({
                todayHighlight: true,
                format: "yyyy-mm-dd",
            });
        });
</script>

<script>
    //--------------------- coupons -------------------
        $(document).on('click', '#coupon-buttn', function() {

            var search_query = $('#coupon_input').val();
            var patient_check = <?php echo e($invoice->receivable_id); ?>;

            //service price
            var total_price = $('#service_price').data('service_price');;

            if (!patient_check) {
                var patient_id = 'null';
            } else {
                var patient_id = patient_check;
            }

            var url =
                "<?php echo e(route('sett.invo_coupon_search', [':search_query', ':patient_id', ':total_price'])); ?>";
            url = url.replace(':search_query', search_query).replace(':patient_id', patient_id).replace(
                ':total_price', total_price);

            $.ajax({
                url: url,
                type: "GET",
                dataType: "json",
                success: function(data) {
                    //if the coupon is not valid or used before
                    if (!data.discount_amount) {
                        $('#coupon_input').val("")
                        $("#discount_amount_div").addClass('d-none');
                        $("#search-result-input").html('<p class="text-red-error">' + data.msg +
                            '</p>');
                        $("#price_total_final_info").html(total_price);

                        //if the coupon is valid
                    } else {
                        $("#discount_amount_div").removeClass('d-none');

                        $("#search-result-input").html('<p class="me-2 text-green">' + data.msg +
                            '<small id="delete_coupon" class="text-red clickable-item-pointer"> DELETE</small><p>'
                        );
                        $("#discount_amount_place").html('$' + data.discount_amount);

                        //insert the coupon id to the hidden input
                        $("#coupon_id").val(data.id);

                        var after_discount = total_price - data.discount_amount;
                        $("#price_total_final_info").html(after_discount);
                        //disabled the doctor discount
                        $("#doctor_discount").prop('disabled', true);
                    }
                }

            });
        });

        //in case the user want to delete the coupon
        $(document).on('click', '#delete_coupon', function() {
            var total_price = $('#service_price').data('service_price');;
            $("#discount_amount_div").addClass('d-none');
            $('#coupon_input').val('');
            $("#search-result-input").html('');
            $("#price_total_final_info").html(total_price);
            //set null to coupon id hidden input
            $("#coupon_id").val("");
            $("#doctor_discount").prop('disabled', false);
        })

        $(document).ready(function() {

            //for doctor discount pernctae
            $(document).on('keyup', '#doctor_discount', function() {

                var amount = $(this).val();
                var total_price = $('#service_price').data('service_price');

                //to get percentage Math.round(((amount / total_price) * 100));
                var discount = Math.round(((amount * total_price) / 100));

                var amount_after_discount = total_price - discount;

                $("#doctor_discount_place").html(discount + ' egp');

                $("#price_total_final_info").html(amount_after_discount);

                $("#doctor_discount_place_edit").html(discount + ' egp');

                $("#price_total_final_info_edit").html(amount_after_discount);

                if (amount) {
                    $("#coupon_input").prop('disabled', true);
                    $("#doctor_discount_value").prop('disabled', true);
                } else {
                    $("#coupon_input").prop('disabled', false);
                    $("#doctor_discount_value").prop('disabled', false);
                }
            })

            //for doctor discount value
            $(document).on('keyup', '#doctor_discount_value', function() {

                var amount = $(this).val();
                var total_price = $('#service_price').data('service_price');

                //to get percentage Math.round(((amount / total_price) * 100));
                var amount_after_discount = (total_price - amount);

                $("#doctor_discount_place").html(amount + ' egp');

                $("#price_total_final_info").html(amount_after_discount);

                $("#doctor_discount_place_edit").html(amount + ' egp');

                $("#price_total_final_info_edit").html(amount_after_discount);

                if (amount) {
                    $("#coupon_input").prop('disabled', true);
                    $("#doctor_discount").prop('disabled', true);
                } else {
                    $("#coupon_input").prop('disabled', false);
                    $("#doctor_discount").prop('disabled', false);
                }

            })

            //search patients Text to the server
            $(".serivce_price_change").keyup(function() {

                var amount = $('.serivce_price_change').val();

                var total_price = 0;

                for (var i = 0; i < amount.length; i++) {
                    total_price += $(amount[i]).val();
                }

                var total_price = $('#final_price_edit').val();
                console.log(total_price);
                var amount_after_new_price = amount + total_price;

                //$("#final_price_edit").val(amount_after_new_price);

            })

            //for giving the final price after paying via cash or visa
            $(document).on('keyup', ('#cash_pay, #visa_pay'), function() {
                var amount_cash = parseInt($('#cash_pay').val());
                var amount_visa = parseInt($('#visa_pay').val());
                var final_price = parseInt($('#price_total_final_info').html());
                if (amount_cash) {
                    var amount_cash = parseInt($('#cash_pay').val());
                } else {
                    var amount_cash = 0;
                }
                if (amount_visa) {
                    var amount_visa = parseInt($('#visa_pay').val());
                } else {
                    var amount_visa = 0;
                }
                var amount_after_discount = final_price - (amount_cash + amount_visa);
                $('#remaining_cash_id').html(amount_after_discount);
            })

            //for giving the final price after paying via cash or visa
            $(document).on('keyup', ('#cash_pay_insta, #visa_pay_insta'), function() {
                var amount_cash = parseInt($('#cash_pay_insta').val());
                var amount_visa = parseInt($('#visa_pay_insta').val());
                var final_price = parseInt($('#remaining_amount_installment').html());
                if (amount_cash) {
                    var amount_cash = parseInt($('#cash_pay_insta').val());
                } else {
                    var amount_cash = 0;
                }
                if (amount_visa) {
                    var amount_visa = parseInt($('#visa_pay_insta').val());
                } else {
                    var amount_visa = 0;
                }
                var amount_after_discount = final_price - (amount_cash + amount_visa);
                $('#remaining_cash_installment').html(amount_after_discount);
            })

        });
</script>

<script>
    //for gettomg machines depnds on branch ajax
        $(document).on('change', '#installment_number', function(e) {
            e.preventDefault();

            var number = $(this).val();

            var total_price = <?php echo e($invoice->final_price); ?>;

            var intallment_amount = total_price / number;

            $("#each_installment_amount").html(parseFloat(intallment_amount).toFixed(2));

            $("#installment_number_cont").html('');

            for (var i = 0; i < number; i++) {

                $("#installment_number_cont").append('<div class="row mb-3">' +
                    '<div class="col-7 col-md-7">' +
                    '<i class="fas fa-cash-register me-2 text-gray-400"></i>' +
                    '<span><?php echo e(__('basic.installment date')); ?></span>' +
                    '</div>' +
                    '<div class="col-5 col-md-5 text-center">' +
                    '<input name="installment_date[]" type="text" class="form-control datepicker_time_inst bg-white" placeholder="YYYY/MM/DD HM" readonly="false" required>' +
                    '</div>' +
                    '</div>');
            }

            $('.datepicker_time_inst').flatpickr({
                allowInput: true,
                altInput: true,
                dateFormat: "Y-m-d",
            });
        });
</script>

<!-- datapicker date and time -->
<script src="https://fastly.jsdelivr.net/npm/flatpickr"></script>

<script>
    //-------- datepicker time --------
        $('.datepicker_time').flatpickr({
            enableTime: true,
            dateFormat: "Y-m-d H:i",
        });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/medix/public_html/samirghoraba/med/resources/views/invoice/show.blade.php ENDPATH**/ ?>