<?php

use App\Http\Controllers\admins\RoleController;
use App\Http\Controllers\admins\UsersController;
use App\Http\Controllers\Branch\Appointment\Rate_appointment;
use App\Http\Controllers\Branch\AppointmentController;
use App\Http\Controllers\Branch\Cats\Branch_cat;
use App\Http\Controllers\Branch\Cats\Cost_cats;
use App\Http\Controllers\Branch\Cats\Coupon_cat;
use App\Http\Controllers\Branch\Cats\Debtor_cat;
use App\Http\Controllers\Branch\Cats\Expenses_item;
use App\Http\Controllers\Branch\Cats\Oper_placecat;
use App\Http\Controllers\Branch\Cats\Specialty_cat;
use App\Http\Controllers\Branch\Cats\Unit_cat;
use App\Http\Controllers\Branch\ComplaintController;
use App\Http\Controllers\Branch\Inventory\Inventory_item;
use App\Http\Controllers\Branch\Inventory\InventoryController;
use App\Http\Controllers\Branch\InvoiceController;
use App\Http\Controllers\Branch\LabController;
use App\Http\Controllers\Branch\OperationController;
use App\Http\Controllers\Branch\RateController;
use App\Http\Controllers\Controller;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\LandController;
use App\Http\Controllers\OutsideReports\SocialReports;
use App\Http\Controllers\Patient\Cats\Ask_for_cat;
use App\Http\Controllers\Patient\Cats\Ask_for_main_cat;
use App\Http\Controllers\Patient\Cats\Cancel_reason;
use App\Http\Controllers\Patient\Cats\Dent_main_cat;
use App\Http\Controllers\Patient\Cats\Examination_cat;
use App\Http\Controllers\Patient\Cats\Med_doseCont;
use App\Http\Controllers\Patient\Cats\Med_durationCont;
use App\Http\Controllers\Patient\Cats\Medicine_cat;
use App\Http\Controllers\Patient\Cats\Medicine_typeCont;
use App\Http\Controllers\Patient\Cats\Pulse_area_cat;
use App\Http\Controllers\Patient\Cats\Pulses_machine;
use App\Http\Controllers\Patient\Cats\Resource_cat;
use App\Http\Controllers\Patient\Cats\Service_inv_cat;
use App\Http\Controllers\Patient\Cats\Service_item;
use App\Http\Controllers\Patient\Cats\Treatment_cat;
use App\Http\Controllers\Patient\Disease_drawsController;
use App\Http\Controllers\Patient\DiseaseController;
use App\Http\Controllers\Patient\Eyeglasses_prescriptionsCont;
use App\Http\Controllers\Patient\MedicineController;
use App\Http\Controllers\Patient\Patient_dentalController;
use App\Http\Controllers\Patient\PatientController;
use App\Http\Controllers\Patient\PulseController;
use App\Http\Controllers\Patient\Service_package;
use App\Http\Controllers\Patient\SessionController;
use App\Http\Controllers\Patient\TreatmentController;
use App\Http\Controllers\Prox_option;
use App\Http\Controllers\Prox_setting;
use App\Models\Branch\Appointment_operation;
use App\Http\Controllers\Patient\Pat_investigationCont;
use App\Http\Controllers\PublicController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


//----- important if we want to show the webview -----
// Route::get('/', [LandController::class, 'index'])->name('landing');


 Route::get('/', function () {
     return view('auth.login');
 })->name('landing'); 


Route::get('/test', [Controller::class, 'test']);

/*
|--------------------------------------------------------------------------
| User interface (landing, login, register, profile)
|--------------------------------------------------------------------------
*/


Route::prefix('land')->name('patient_auth.')->group(function () {

     Route::middleware(['guest:patient'])->group(function () {
          Route::get('/login', [LandController::class, 'login'])->name('login')->middleware("throttle:10,2"); //it will send 10 request per 2 minute
          Route::post('/login_sub', [LandController::class, 'login_sub'])->name('login_sub');
          Route::get('/register', [LandController::class, 'register'])->name('register')->middleware("throttle:10,2");;
          Route::post('/store', [LandController::class, 'store'])->name('store');
          Route::get('/createcityajax/{id}', [LandController::class, 'createcityajax'])->name('createcityajax');
     });

     Route::middleware(['auth:patient'])->group(function () {
          Route::get('/profile', [LandController::class, 'profile'])->name('profile');
          Route::get('/appointment', [LandController::class, 'appointment'])->name('appointment')->middleware("throttle:10,2");;
          Route::get('/coupon_search/{search_query}/{patient_id}/{total_price}', [LandController::class, 'coupon_search']);
          Route::get('/calander_appointment_ajax/{month}/{year}/{specialty_id}/{branch_id}/{unit_id}', [LandController::class, 'calander_appointment_ajax'])->name('land_calander_appointment_ajax');
          //ajax for calander
          Route::get('/calander_show_slots_ajax/{datetoday}/{specialty_id}/{branch_id}/{unit_id}', [LandController::class, 'calander_show_slots_ajax'])->name('land_calander_show_slots_ajax');

          //get the services for appointment 
          Route::get('/fetch_servicecat_ajax/{specialty_id}/{branch_id}', [LandController::class, 'fetch_servicecat_ajax'])->name('land_fetch_servicecat_ajax');

          //get the services for appointment 
          Route::get('/land_fetch_unit_ajax/{branch_id}', [LandController::class, 'land_fetch_unit_ajax'])->name('land_fetch_unit_ajax');
          Route::post('/store_appointment', [LandController::class, 'store_appointment'])->name('store_appointment');
          Route::post('logout', [LandController::class, 'logout'])->name('logout');
     });

     //--- other non authictaction pages ---
     Route::get('contact', [LandController::class, 'contact'])->name('contact');
     Route::get('about', [LandController::class, 'about'])->name('about');
     Route::get('blogs', [LandController::class, 'blogs'])->name('blogs');
     Route::get('/appointment_public/{code}', [LandController::class, 'show_pat_appointment_public'])->name('land_show_pat_appointment_public');
     Route::get('/rate_appo_public/{code}', [LandController::class, 'rate_appo_public'])->name('land_rate_appo_public');
     Route::post('/rate_appo_public_store', [LandController::class, 'rate_appo_public_store'])->name('land_rate_appo_public_store');
});


// -----------------------------------------
//for Proxima system 

//multi languages
Route::group(
     [
          'prefix' => LaravelLocalization::setLocale(),
          'middleware' => ['localeSessionRedirect', 'localizationRedirect', 'localeViewPath']
     ],
     function () {

          // prescription print
          Route::get('/patient/prescription/{id}/{prescription_id?}', [PublicController::class, 'patient_print_pre'])->name('pat_patient_print_pre');
          Route::get('/patient/prescription315/{id}/{prescription_id?}', [PublicController::class, 'patient_print_pre_no_frame'])->name('pat_patient_print_pre_no_frame');

          //eyeglasses prescription print
          Route::get('/patient/eyeglass_presc_print/{id}/{eye_glass_id?}', [PublicController::class, 'eyeglasses_prescription_print'])->name('eyeglasses_prescription_print');

          Route::get('/patient/eyeglasses_presc_print487/{id}/{eye_glass_id?}', [PublicController::class, 'eyeglasses_presc_print_no_frame'])->name('eyeglasses_presc_print_no_frame');

          Route::get('/patient/eyeglasses_presc_print9410/{id}/{eye_glass_id?}', [PublicController::class, 'eyeglasses_presc_print_no_frame_a5'])->name('eyeglasses_presc_print_no_frame_a5');

          Route::prefix('prox')->name('sett.')->group(function () {

               //for the guest
               Route::get('/', function () {
                    return view('auth.login');
               })->middleware('guest');

               Auth::routes();

               //for the auth user
               Route::middleware('auth', 'activeuser', 'ValidWebUrl')->group(function () {

                    Route::get('/dashboard', [HomeController::class, 'index'])->name('home');

                    Route::resource('/admin', UsersController::class);
                    Route::get('/edit_profile_user', [UsersController::class, 'edit_profile_user'])->name('edit_profile_user');
                    Route::PUT('/edit_profile_user_store', [UsersController::class, 'edit_profile_user_store'])->name('edit_profile_user_store');

                    //note for the user in the dashboard
                    Route::PATCH('/note_ajax', [UsersController::class, 'note_ajax'])->name('ad_note_ajax');

                    Route::get('/createcityajax/{id}', [UsersController::class, 'createcityajax'])->name('createcityajax');

                    /*
          |--------------------------------------------------------------------------
          | settings (users, roles, perimsstion) {{ route('sett.createcityajax') }}
          |--------------------------------------------------------------------------
          */
                    Route::group(['prefix' => 'hr', 'middleware' => ['role:Super-admin|Hr']], function () {
                         Route::POST('/create_doctor_record', [UsersController::class, 'create_doctor_record'])->name('hr_create_doctor_record');
                         Route::resource('/admin', UsersController::class);
                         Route::get('/allstatcs', [UsersController::class, 'allstatcs'])->name('user_allstatcs');
                         Route::resource('/role', RoleController::class);
                         Route::get('/attendance/{worker_id}/{date?}', [UsersController::class, 'attendance'])->name('hr_attendance');
                         Route::get('/edit_attendance/{id}', [UsersController::class, 'edit_attendance'])->name('hr_edit_attendance');
                         Route::PUT('/edit_attendance_insert/{id}', [UsersController::class, 'edit_attendance_insert'])->name('hr_edit_attendance_insert');
                    });

                    Route::get('/worker_attendance', [UsersController::class, 'worker_attendance'])->name('hr_worker_attendance');
                    Route::POST('/worker_attendance_insert', [UsersController::class, 'worker_attendance_insert'])->name('hr_worker_attendance_insert');
                    Route::get('/my_attendance/{date?}', [UsersController::class, 'my_attendance'])->name('hr_my_attendance');
                    Route::get('/create_attendance_admin', [UsersController::class, 'create_attendance_admin'])->name('hr_create_attendance_admin');
                    Route::POST('/insert_attendance_admin', [UsersController::class, 'insert_attendance_admin'])->name('hr_insert_attendance_admin');

                    /*
          |--------------------------------------------------------------------------
          | settings (users, roles, perimsstion) {{ route('sett.createcityajax') }}
          |--------------------------------------------------------------------------
          */

                    Route::group(['prefix' => 'ad', 'middleware' => ['role:Super-admin']], function () {
                         Route::resource('/options', Prox_setting::class);
                         Route::resource('/specialtycat', Specialty_cat::class);
                         Route::resource('/branchcat', Branch_cat::class);
                         Route::resource('/unitcat', Unit_cat::class);
                         Route::resource('/oper_placecat', Oper_placecat::class);
                         Route::resource('/dentmaincat', Dent_main_cat::class);
                         Route::resource('/treatmentcat', Treatment_cat::class);
                         Route::resource('/medicinecat', Medicine_cat::class);
                         Route::resource('/medicine_type', Medicine_typeCont::class);
                         Route::resource('/med_duration', Med_durationCont::class);
                         Route::resource('/med_dose', Med_doseCont::class);
                         Route::resource('/pulse_area_cat', Pulse_area_cat::class);
                         Route::resource('/pulses_machine', Pulses_machine::class);
                         Route::resource('/examinationcat', Examination_cat::class);
                         Route::resource('/eyeglasses_prescription', Eyeglasses_prescriptionsCont::class);
                         Route::resource('/pat_investigation', Pat_investigationCont::class);
                         Route::resource('/expenses_item', Expenses_item::class);
                         Route::resource('/debtorcat', Debtor_cat::class);
                         Route::resource('/service_inv_cat', Service_inv_cat::class);
                         Route::resource('/service_item', Service_item::class);
                         Route::resource('/cost_cats', Cost_cats::class);
                         Route::resource('/resourcecat', Resource_cat::class);
                         Route::resource('/askformaincat', Ask_for_main_cat::class);
                         Route::resource('/askforcat', Ask_for_cat::class);
                         Route::resource('/cancelreasoncat', Cancel_reason::class);
                         Route::resource('/couponcat', Coupon_cat::class);
                         Route::get('/google', [SocialReports::class, 'google'])->name('google');
                         Route::get('/livereport', [Prox_setting::class, 'livereport'])->name('livereport');
                         Route::get('/service_report', [Prox_setting::class, 'service_report'])->name('service_report');
                    });

                    /*
          |--------------------------------------------------------------------------
          | Appointment Operations
          |--------------------------------------------------------------------------
          */

                    Route::group(['prefix' => 'appo', 'middleware' => ['role:Super-admin|Branch-manager|Receptionist|Call-center|Doctor|Operation|Operation_doctor']], function () {

                         //ajax for calander
                         Route::get('/calander_appointment_ajax/{month}/{year}/{specialty_id}/{branch_id}/{unit_id}', [AppointmentController::class, 'calander_appointment_ajax'])->name('appcalander_appointment_ajax');

                         //ajax for calander
                         Route::get('/calander_show_slots_ajax/{datetoday}/{specialty_id}/{branch_id}/{unit_id}', [AppointmentController::class, 'calander_show_slots_ajax'])->name('appcalander_show_slots_ajax');

                         //get the services for appointment 
                         Route::get('/fetch_unit_ajax/{branch_id}', [AppointmentController::class, 'fetch_unit_ajax'])->name('app_fetch_unit_ajax');

                         //get the services for appointment 
                         Route::get('/fetch_servicecat_ajax/{specialty_id}/{branch_id}', [AppointmentController::class, 'fetch_servicecat_ajax'])->name('app_fetch_servicecat_ajax');

                         //search engine in creating appointment
                         Route::get('/calander_patient_search/{search_query}', [AppointmentController::class, 'calander_patient_search'])->name('app_calander_patient_search');

                         //get the appointment info from the timeslot
                         Route::get('/appointment_info_ajax/{id}', [AppointmentController::class, 'appointment_info_ajax'])->name('app_appointment_info_ajax');

                         //weekly calander
                         Route::get('/weekly_calender/{yearin}/{weekin}', [AppointmentController::class, 'weekly_calender'])->name('app_weekly_calender');


                         //update calendar sortable drag and drop
                         Route::post('/sortable_calendar_update/{id}', [AppointmentController::class, 'sortable_calendar_update'])->name('sortable_calendar_update');


                         //weekly calander timeslots
                         Route::get('/weekly_calender_date/{year}/{month}/{day}/{specialty}/{branch}/{unit}/{order}/{search}', [AppointmentController::class, 'weekly_calender_date'])->name('app_weekly_calender_date');

                         //weekly calander timeslots get total services in the day
                         Route::get('/weekly_calender_date_total_services/{year}/{month}/{day}/{specialty}/{branch}', [AppointmentController::class, 'weekly_calender_date_total_services'])->name('app_weekly_calender_date_total_services');

                         //update appointment note
                         Route::put('/appointment_note/{id}', [AppointmentController::class, 'appointment_note'])->name('app_appointment_note');

                         //update appointment status
                         Route::PATCH('/update_status_doctor/{id}', [AppointmentController::class, 'update_status_doctor'])->name('app_update_status_doctor');

                         //waiting in branch view
                         Route::get('/witing_branch', [AppointmentController::class, 'witing_branch'])->name('app_witing_branch');
                         //waiting in branch data
                         Route::get('/witing_branch_data', [AppointmentController::class, 'witing_branch_data'])->name('app_witing_branch_data');
                         //to queue_show update to be shown
                         Route::PATCH('/queue_show_update/{id}', [AppointmentController::class, 'queue_show_update'])->name('app_queue_show_update');

                         //rate appointment
                         Route::resource('/rate', RateController::class);

                         //stat for appointments
                         Route::get('/allstatcs/{specialty?}/{branch?}/{from?}/{to?}', [AppointmentController::class, 'allstatcs'])->name('app_allstatcs')->middleware(['role:Super-admin']);

                         //stat for appointments
                         Route::get('/all_appointments/{specialty?}/{branch?}/{from?}/{to?}', [AppointmentController::class, 'all_appointments'])->name('all_appointments');

                         //update the appointment status to 2 (arrived) using qr reader in the clinc
                         Route::get('/arrived_patient_qr', [AppointmentController::class, 'arrived_patient_qr'])->name('app_arrived_patient_qr');
                         Route::PATCH('/arrived_patient_qr_update/{patient_username}', [AppointmentController::class, 'arrived_patient_qr_update'])->name('app_arrived_patient_qr_update');

                         //patients waiting to enter the doctors page
                         Route::get('/withdoctor', [AppointmentController::class, 'withdoctor'])->name('app_withdoctor');
                         //patients waiting to enter the doctors page
                         Route::get('/withdoctor_data', [AppointmentController::class, 'withdoctor_data'])->name('app_withdoctor_data');
                         //patients waiting to enter the doctors page
                         Route::get('/withdoctor_service', [AppointmentController::class, 'withdoctor_service'])->name('app_withdoctor_service');
                         Route::PUT('/withdoctor_service_save', [AppointmentController::class, 'withdoctor_service_save'])->name('app_withdoctor_service_save');
                         Route::PUT('/withdoctor_service_save_session', [AppointmentController::class, 'withdoctor_service_save_session'])->name('app_withdoctor_service_save_session');


                         //update status to 4 in patients waiting to enter the doctors page
                         Route::PATCH('/withdoctor_update/{id}', [AppointmentController::class, 'withdoctor_update'])->name('app_withdoctor_update');

                         //rate system
                         Route::get('/rate', [AppointmentController::class, 'rate_index'])->name('app_rate');
                         //patients waiting to enter the doctors page
                         Route::get('/rate_show', [AppointmentController::class, 'rate_show'])->name('app_rate_show');
                         //update status to 4 in patients waiting to enter the doctors page
                         Route::PATCH('/rate_update/{appointment_id}', [AppointmentController::class, 'rate_update'])->name('app_rate_update');

                         //complaints
                         Route::resource('/complaint', ComplaintController::class);
                         Route::get('/complaint_show_ajax', [ComplaintController::class, 'complaint_show_ajax'])->name('comp_complaint_show_ajax');
                         Route::post('/complaint_save_ajax', [ComplaintController::class, 'complaint_save_ajax'])->name('comp_complaint_save_ajax');

                         //weekly calander timeslots
                         Route::get('/monthly_calendar_show', [AppointmentController::class, 'monthly_calendar_show'])->name('app_monthly_calendar_show');

                         //fetch the monthly calendar
                         Route::get('/monthly_calendar_data/{year}/{month}/{specialty}/{branch}/{unit}', [AppointmentController::class, 'monthly_calendar_data'])->name('app_monthly_calendar_data');

                         //store past appointment
                         Route::post('/past_appointment', [AppointmentController::class, 'past_appointment'])->name('app_past_appointment');

                         //----------- operation

                         //update past operation note
                         Route::put('/operation_patient_past_note', [OperationController::class, 'operation_patient_past_note'])->name('operation_patient_past_note')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                         //update info during operation
                         Route::put('/operation_patient_during_op_upd', [OperationController::class, 'operation_patient_during_op_upd'])->name('operation_patient_during_op_upd')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);


                         //----------- Operation follow up

                         Route::put('/op_follow_up_file_update/{id}', [OperationController::class, 'op_follow_up_file_update'])->name('op_follow_up_file_update')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                         Route::get('/op_follow_up_show/{id}', [OperationController::class, 'op_follow_up_show'])->name('op_follow_up_show')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);

                         Route::post('/op_follow_up_file_store/{id}', [OperationController::class, 'op_follow_up_file_store'])->name('op_follow_up_file_store')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                         Route::get('/op_follow_up_file_insert/{id}', [OperationController::class, 'op_follow_up_file_insert'])->name('op_follow_up_file_insert')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                         Route::get('/op_follow_up_inprog', [OperationController::class, 'op_follow_up_inprog'])->name('op_follow_up_inprog')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;
                         Route::get('/op_follow_up_done', [OperationController::class, 'op_follow_up_done'])->name('op_follow_up_done')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;
                         Route::get('/op_follow_up_today', [OperationController::class, 'op_follow_up_today'])->name('op_follow_up_today')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;
                         Route::get('/op_follow_up', [OperationController::class, 'op_follow_up'])->name('op_follow_up')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;


                         //add info during operation
                         Route::post('/operation_patient_during_op', [OperationController::class, 'operation_patient_during_op'])->name('operation_patient_during_op')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                         //delete gallery img
                         Route::delete('/operation_patient_delete_gallery', [OperationController::class, 'operation_patient_delete_gallery'])->name('operation_patient_delete_gallery')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                         //show gallery op in different page
                         Route::get('/operation_gallery/{id}', [OperationController::class, 'operation_gallery'])->name('operation_gallery')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                         //add gallery to operation
                         Route::post('/operation_patient_add_gallery', [OperationController::class, 'operation_patient_add_gallery'])->name('operation_patient_add_gallery')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                         //edit operation from patient profile 
                         Route::PUT('/operation_patient_edit', [OperationController::class, 'operation_patient_edit'])->name('app_operation_patient_edit')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);

                         //store operation from patient profile 
                         Route::post('/operation_patient_add', [OperationController::class, 'operation_patient_add'])->name('app_operation_patient_add')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                         //get the services for appointment 
                         Route::get('/fetch_servicecat_ajax_operation/{search_query}', [OperationController::class, 'fetch_servicecat_ajax_operation'])->name('app_fetch_servicecat_ajax_operation')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                         //ajax for calander
                         Route::get('/calander_show_slots_ajax_op/{datetoday}/{specialty_id}/{branch_id}', [OperationController::class, 'calander_show_slots_ajax_op'])->name('calander_show_slots_ajax_op');

                         //ajax for operation calander
                         Route::get('/calander_appointment_ajax_operation/{month}/{year}/{specialty_id}/{oper_place_id}', [OperationController::class, 'calander_appointment_ajax_operation'])->name('app_calander_appointment_ajax_operation')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                         //update appointment status
                         Route::PATCH('/update_status_doctor_operation/{id}', [OperationController::class, 'update_status_doctor_operation'])->name('app_update_status_doctor_operation')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                         //fetch the monthly calendar
                         Route::get('/monthly_calendar_data_operation/{year}/{month}/{specialty}/{branch}', [OperationController::class, 'monthly_calendar_data_operation'])->name('app_monthly_calendar_data_operation')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                         //get the operation info from the timeslot
                         Route::get('/appointment_info_ajax_operation/{id}', [OperationController::class, 'appointment_info_ajax_operation'])->name('app_appointment_info_ajax_operation')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                         //weekly calander timeslots for operation
                         Route::get('/weekly_calender_date_operation/{year}/{month}/{day}/{specialty}/{branch}/{order}', [OperationController::class, 'weekly_calender_date_operation'])->name('app_weekly_calender_date_operation')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                         //second appointments for operation
                         Route::resource('/operation', OperationController::class)->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;


                         //--------
                         Route::post('/follow_up_app_index', [AppointmentController::class, 'follow_up_app_index'])->name('follow_up_app_index')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor|Receptionist']);;

                         //main appointments controller
                         Route::resource('/appointment', AppointmentController::class);
                    });

                    /*
          |--------------------------------------------------------------------------
          | Invoice operations
          |--------------------------------------------------------------------------
          */

                    Route::prefix('invo')->group(function () {

                         //today installment
                         Route::get('/today_installment/{date?}', [InvoiceController::class, 'today_installment'])->name('today_installment')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                         //doctor comm profile monthly
                         Route::get('/doctor_profile_comm_service_month/{id}/{date?}', [InvoiceController::class, 'doctor_profile_comm_service_month'])->name('doctor_profile_comm_service_month')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                         //doctor comm monthly
                         Route::get('/doctor_comm_service_month/{date?}', [InvoiceController::class, 'doctor_comm_service_month'])->name('doctor_comm_service_month')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                         //doctor comm daily
                         Route::get('/doctor_comm_service/{date?}', [InvoiceController::class, 'doctor_comm_service'])->name('doctor_comm_service')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                         //doctor comm daily
                         Route::get('/all_doctor_comm_day/{date?}', [InvoiceController::class, 'all_doctor_comm_day'])->name('all_doctor_comm_day')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                         //doctor comm
                         Route::get('/all_doctor_comm/{date?}', [InvoiceController::class, 'all_doctor_comm'])->name('all_doctor_comm')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                         //fetch inventory in service item creation and update
                         Route::get('/fetch_inventory/{branch_id}', [Service_item::class, 'fetch_inventory'])->name('fetch_inventory')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                         //show debtor profile
                         Route::get('/debtor/{id?}', [InvoiceController::class, 'debtor_show'])->name('invo_debtor')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);
                         Route::get('/debtor_doctor/{id?}', [InvoiceController::class, 'doctor_show'])->name('invo_debtor_doctor')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist|Hr']);

                         //total invoices statistics
                         Route::get('/allstatcs/{specialty?}/{branch?}/{from?}/{to?}', [InvoiceController::class, 'allstatcs'])->name('invo_allstatcs')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                         //get the day invoice for debit and credit
                         Route::get('/day_search/{date?}/{specialty?}/{branch?}', [InvoiceController::class, 'day_search'])->name('invo_day_search')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist|Operation_accountant']);
                         //get the month invoice for debit and credit
                         Route::get('/month_search/{date?}/{specialty?}/{branch?}', [InvoiceController::class, 'month_search'])->name('invo_month_search')->middleware(['role:Super-admin|Accountant|Branch-manager']);
                         //get the year invoice for debit and credit
                         Route::get('/year_search/{date?}/{specialty?}/{branch?}', [InvoiceController::class, 'year_search'])->name('invo_year_search')->middleware(['role:Super-admin|Accountant|Branch-manager']);


                         //for other invoice search such as doctor, services, and workers
                         Route::get('/invo_other_search', [InvoiceController::class, 'invo_other_search'])->name('invo_other_search')->middleware(['role:Super-admin|Accountant|Branch-manager']);
                         Route::get('/invo_other_search_store/{date?}/{service?}/{doctor?}/{worker?}/{branch?}', [InvoiceController::class, 'invo_other_search_store'])->name('invo_other_search_store')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);


                         //get the latsest results
                         Route::get('/invoice_result_index/{branch}', [InvoiceController::class, 'invoice_result_index'])->name('invo_invoice_result_index')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);
                         //get the latsest results for no pay
                         Route::get('/invoice_result_nopay_index/{branch}', [InvoiceController::class, 'invoice_result_nopay_index'])->name('invo_invoice_result_nopay_index')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                         //search engine for invoice
                         Route::get('/invoice_search/{search_query}', [InvoiceController::class, 'invoice_search'])->name('invo_invoice_search')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist|Operation_accountant']);

                         //Coupon search
                         Route::get('/coupon_search/{search_query}/{patient_id}/{total_price}', [InvoiceController::class, 'coupon_search'])->name('invo_coupon_search')->middleware(['role:Super-admin|Accountant|Doctor|Branch-manager|Receptionist|Call-center']);

                         //invoice print
                         Route::get('/invoice_print/{id}', [InvoiceController::class, 'invoice_print'])->name('invo_invoice_print')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                         //search engine for debtors
                         Route::get('/debtor_search/{search_query}', [InvoiceController::class, 'debtor_search'])->name('invo_debtor_search')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                         //search engine for doctors
                         Route::get('/doctor_search/{search_query}', [InvoiceController::class, 'doctor_search'])->name('invo_doctor_search')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                         //store income
                         Route::post('/store_income', [InvoiceController::class, 'store_income'])->name('invo_store_income')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                         //delete material in invoice
                         Route::delete('/delete_inv_material/{id}', [InvoiceController::class, 'delete_inv_material'])->name('delete_inv_material');

                         //refund invoice
                         Route::post('/refund_inv/{id}', [InvoiceController::class, 'refund_inv'])->name('refund_inv')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                         //pay installments
                         Route::PATCH('/pay_installment/{id}', [InvoiceController::class, 'pay_installment'])->name('pay_installment');

                         //insert installments
                         Route::PATCH('/insert_installment/{id}', [InvoiceController::class, 'insert_installment'])->name('insert_installment');

                         //delete payment
                         Route::delete('/delete_inv_payment/{id}', [InvoiceController::class, 'delete_inv_payment'])->name('delete_inv_payment');

                         //edit payment
                         Route::PATCH('/edit_inv_payment/{id}', [InvoiceController::class, 'edit_inv_payment'])->name('edit_inv_payment');

                         //to pay installemnt 
                         Route::PATCH('/invoice_pay_installment/{id}', [InvoiceController::class, 'invoice_pay_installment'])->name('invoice_pay_installment');

                         //to pay for first time
                         Route::PATCH('/invoice_pay/{id}', [InvoiceController::class, 'invoice_pay'])->name('invo_invoice_pay');

                         //add new items to the invoice
                         Route::post('/add_items/{invoice_id}', [InvoiceController::class, 'add_items'])->name('invo_add_items')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                         //add new material to the invoice
                         Route::post('/invo_add_material/{invoice_id}', [InvoiceController::class, 'invo_add_material'])->name('invo_add_material')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                         //get all invoices search 
                         Route::get('/show_all_invoice', [InvoiceController::class, 'show_all_invoices'])->name('inv_show_all_invoices')->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist']);

                         //main invoice
                         Route::resource('/invoice', InvoiceController::class)->middleware(['role:Super-admin|Accountant|Branch-manager|Receptionist|Operation_accountant']);

                         Route::PATCH('/inv_edit_item/{id}', [InvoiceController::class, 'inv_edit_item'])->name('inv_edit_item');
                         Route::PUT('/inv_edit_note/{id}', [InvoiceController::class, 'inv_edit_note'])->name('inv_edit_note');
                         //update attched img
                         Route::PATCH('/invoice_edit_attched/{id}', [InvoiceController::class, 'invoice_edit_attched'])->name('invoice_edit_attched');
                    });

                    /*
          |--------------------------------------------------------------------------
          | inventory operations
          |--------------------------------------------------------------------------
          */

                    Route::group(['prefix' => 'inven', 'middleware' => ['role:Super-admin|Branch-manager|Stocker']], function () {

                         //get the latsest results
                         Route::get('/inventory_finished/{branch}', [InventoryController::class, 'inventory_finished'])->name('inven_inventory_finished');
                         //get the latsest results for no pay
                         Route::get('/inventory_close_finish/{branch}', [InventoryController::class, 'inventory_close_finish'])->name('inven_inventory_close_finish');

                         //search engine for inventory
                         Route::get('/inventory_search/{search_query}', [InventoryController::class, 'inventory_search'])->name('inven_inventory_search');

                         //catagory
                         Route::resource('/inventory_item', Inventory_item::class);

                         //to add new lab from the patient account
                         Route::post('/store_inventory_rec/{item_id}', [InventoryController::class, 'store_inventory_rec'])->name('inven_store_inventory_rec');

                         //search engine for inventory
                         Route::get('/fetch_inven_items_ajax', [InventoryController::class, 'fetch_inven_items_ajax'])->name('inven_fetch_items_ajax');

                         //main inventory
                         Route::resource('/inventory', InventoryController::class);
                    });


                    /*
          |--------------------------------------------------------------------------
          | Lab operations
          |--------------------------------------------------------------------------
          */

                    Route::prefix('lab')->group(function () {

                         //to add new lab from the patient account
                         Route::post('/lab/patient_add', [LabController::class, 'patient_add'])->name('lab_patient_add')->middleware(['role:Super-admin|Doctor']);

                         //search engine for lab
                         Route::get('/lab/lab_search/{search_query}', [LabController::class, 'lab_search'])->name('lab_lab_search')->middleware(['role:Super-admin|Lab']);

                         //get the latsest results
                         Route::get('/lab/lab_result_index/{branch}', [LabController::class, 'lab_result_index'])->name('lab_lab_result_index')->middleware(['role:Super-admin|Lab']);

                         //get the latsest results for no pay
                         Route::get('/lab/lab_result_nopay_index/{branch}', [LabController::class, 'lab_result_nopay_index'])->name('lab_lab_result_nopay_index')->middleware(['role:Super-admin|Lab']);

                         //lab print
                         Route::get('/lab/lab_print/{id}', [LabController::class, 'lab_print'])->name('lab_lab_print')->middleware(['role:Super-admin|Lab']);

                         //main lab controller
                         Route::resource('/lab', LabController::class)->middleware(['role:Super-admin|Lab']);
                    });

                    /*
          |--------------------------------------------------------------------------
          | Patient operations
          |--------------------------------------------------------------------------
          */

                    Route::prefix('pat')->group(function () {

                         //fetch city depends on country
                         Route::get('/patient/createcityajax/{id}', [PatientController::class, 'createcityajax'])->name('pat_createcityajax')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center']);

                         //search engine for patients
                         Route::get('/patient/patient_search/{search_query}', [PatientController::class, 'patient_search'])->name('pat_patient_search')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center|Operation|Operation_doctor']);

                         //update note ajax
                         Route::PATCH('/patient/note_ajax/{id}', [PatientController::class, 'note_ajax'])->name('pat_note_ajax')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center']);

                         //total patient statistics
                         Route::get('/patient/allstatcs/{branch?}/{from?}/{to?}', [PatientController::class, 'allstatcs'])->name('pat_allstatcs')->middleware(['role:Super-admin']);

                         //patient print
                         Route::get('/patient/patient_print/{id}', [PatientController::class, 'patient_print'])->name('pat_patient_print')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Operation']);
                         //ramad examination print
                         Route::get('/patient/ramad_examination_print/{id}', [PatientController::class, 'ramad_examination_print'])->name('ramad_examination_print')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Operation']);

                         Route::get('/patient/investigation_print/{id}/{cat}/{pat_investigation_id?}', [Pat_investigationCont::class, 'investigation_print'])->name('investigation_print')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Operation']);

                         Route::get('/patient/investigation_print5915/{id}/{cat}/{pat_investigation_id?}', [Pat_investigationCont::class, 'investigation_print_no_frame_a5'])->name('investigation_print_no_frame_a5')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Operation']);


                         //add new exmination, treatment, session, and etc from old and exsit appointment
                         Route::post('/add_all_pt_info_appo/{id}', [PatientController::class, 'add_all_pt_info_appo'])->name('pat_add_all_pt_info_appo');

                         //fetch new patients in index
                         Route::get('/new_patients_index/{branch}', [PatientController::class, 'new_patients_index'])->name('pat_inven_new_patients_index');

                         //get all appointment info in patient profile in appointments
                         Route::get('/get_all_info_pat_appo/{id}', [PatientController::class, 'get_all_info_pat_appo'])->name('pat_get_all_info_pat_appo');


                         //---- access via ajax ----
                         Route::get('/create_askfor_ajax/{id}', [PatientController::class, 'create_askfor_ajax'])->name('pat_create_askfor_ajax');
                         Route::get('/fetch_dental_service/{name}', [Patient_dentalController::class, 'fetch_dental_service'])->name('pat_fetch_dental_service');
                         Route::post('/store_basic_dental', [Patient_dentalController::class, 'store_basic_dental'])->name('pat_store_basic_dental');
                         Route::post('/delete_basic_dental', [Patient_dentalController::class, 'delete_basic_dental'])->name('pat_delete_basic_dental');

                         Route::post('/store_action_dental', [Patient_dentalController::class, 'store_action_dental'])->name('pat_store_action_dental');
                         Route::post('/delete_action_dental', [Patient_dentalController::class, 'delete_action_dental'])->name('pat_delete_action_dental');
                         Route::post('/status_action_dental', [Patient_dentalController::class, 'status_action_dental'])->name('pat_status_action_dental');


                         //send sms to the pattient
                         Route::get('/sms_form_profile/{id}', [PatientController::class, 'sms_form_profile'])->name('pat_sms_form_profile')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center']);

                         //Patient
                         //show for dental patients
                         Route::resource('/patient_dental', Patient_dentalController::class);
                         Route::resource('/patient', PatientController::class);


                         //print sticker 
                         Route::post('/patient_print_sticker', [PatientController::class, 'patient_print_sticker'])->name('patient_print_sticker');


                         //slight edit
                         Route::PATCH('/pat_slight_edit', [PatientController::class, 'pat_slight_edit'])->name('pat_slight_edit')->middleware(['role:Super-admin|Branch-manager|Doctor']);

                         //medicine
                         Route::resource('/medicine', MedicineController::class)->middleware(['role:Super-admin|Branch-manager|Doctor']);

                         //disease
                         Route::resource('/disease', DiseaseController::class)->middleware(['role:Super-admin|Branch-manager|Doctor']);

                         //get all patients by filters
                         Route::get('/my_patients', [PatientController::class, 'my_patients'])->name('pat_my_patients')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center']);

                         //get all patients by filters
                         Route::get('/show_all', [PatientController::class, 'show_all_patients'])->name('pat_show_all_patients')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center']);
                         Route::get('/sms_done', [PatientController::class, 'sms_done'])->name('pat_sms_done')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist|Call-center']);

                         //get all vip patients by filters
                         Route::get('/vip_patients', [PatientController::class, 'vip_patients'])->name('pat_vip_patients')->middleware(['role:Super-admin|Branch-manager|Receptionist|Call-center']);


                         //disease draws
                         Route::resource('/disease_draws', Disease_drawsController::class)->middleware(['role:Super-admin|Doctor']);

                         //treatment
                         Route::resource('/treatment', TreatmentController::class)->middleware(['role:Super-admin|Doctor']);

                         //session
                         Route::resource('/session', SessionController::class)->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist']);

                         //pulses
                         Route::resource('/pulses', PulseController::class)->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist']);
                         Route::get('/pulses_day_st/{date?}/{branch?}', [PulseController::class, 'pulses_day_st'])->name('pulses_day_st')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist']);
                         Route::get('/pulses_month_st/{date?}/{branch?}', [PulseController::class, 'pulses_month_st'])->name('pulses_month_st')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist']);
                         //packages
                         Route::resource('/service_package', Service_package::class)->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist']);
                         Route::get('/get_packgae_ajax/{patient_id}', [Service_package::class, 'get_packgae_ajax'])->name('get_packgae_ajax')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist']);

                         Route::post('/machine_rec_insert', [PulseController::class, 'machine_rec_insert'])->name('pul_machine_rec_insert');

                         //slight edit
                         Route::PATCH('/machine_rec_edit/{id}', [PulseController::class, 'machine_rec_edit'])->name('pul_machine_rec_edit')->middleware(['role:Super-admin|Branch-manager|Doctor']);
                         Route::get('/pulses_machines_ajax/{branch_id?}', [PulseController::class, 'pulses_machines_ajax'])->name('pulses_machines_ajax')->middleware(['role:Super-admin|Doctor|Branch-manager|Receptionist']);

                         //session
                         Route::post('/add_wallet_balance/{id}', [PatientController::class, 'add_wallet_balance'])->name('pat_add_wallet_balance');

                         // newattachments
                         Route::post('/add_new_attachment', [PatientController::class, 'add_new_attachment'])->name('pat_add_new_attachment');
                         Route::delete('/delete_new_attachment', [PatientController::class, 'delete_new_attachment'])->name('pat_delete_new_attachment')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;
                    });

                    Route::prefix('rate')->group(function () {
                         Route::resource('/rate_appo', Rate_appointment::class);
                         Route::get('/index_cancel_rate', [Rate_appointment::class, 'index_cancel_rate'])->name('index_cancel_rate');
                         Route::get('/index_inactive_patient', [Rate_appointment::class, 'index_inactive_patient'])->name('index_inactive_patient');

                         Route::get('/ready_rate/{date?}', [Rate_appointment::class, 'ready_rate'])->name('ready_rate');
                         Route::get('/cancellation_appointments/{date?}', [Rate_appointment::class, 'cancellation_appointments'])->name('cancellation_appointments');

                         Route::get('/index_rate_note/{type_saved?}', [Rate_appointment::class, 'index_rate_note'])->name('index_rate_note');
                         Route::PATCH('/save_rate_note/{id}', [Rate_appointment::class, 'save_rate_note'])->name('save_rate_note');
                         Route::get('/bad_rate/{type}', [Rate_appointment::class, 'bad_rate'])->name('bad_rate');


                         Route::post('/store_patient_call_center', [PatientController::class, 'store_patient_call_center'])->name('store_patient_call_center');
                         Route::get('/create_patient_call_center', [PatientController::class, 'create_patient_call_center'])->name('create_patient_call_center');

                         Route::post('/add_lead_note/{patient_id}', [Rate_appointment::class, 'add_lead_note'])->name('add_lead_note');
                    });
               });
          });
     }
);