@extends('layouts.master')

@section('title', 'Statistics | Proxima - Medical Management app')

@section('title-topbar', 'Statistics')

<!-- css insert -->
@section('css')
<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<!-- tables -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.0.1/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.2/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/autofill/2.3.9/css/autoFill.bootstrap5.min.css">
<link rel="stylesheet"
    href="https://nightly.datatables.net/fixedheader/css/fixedHeader.dataTables.css?_=f0de745b101295e88f1504c17177ff49.css"
    type="text/css" />
@endsection


@section('fixedcontent')

<!-- session successful message -->
@if (Session::has('success'))
<div id="flash-msg" class="shadow pt-3">
    <div class="d-flex justify-content-between mb-2">
        <i class="fas fs-1 fa-check"></i>
        <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
    </div>
    <h3>Sent Successfully</h3>
    <p class="text-blue-300">{{ Session::get('success') }}</p>
</div>
@endif

<!-- session successful message -->
@if (Session::has('error_delete'))
<div id="flash-msg" class="shadow pt-3" style="background-color:#ff4152;">
    <div class="d-flex justify-content-between mb-2">
        <i class="fas fs-1 fa-times"></i>
        <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"
                style="color:#ffb4bc"></i></a>
    </div>
    <h3>Can not be deleted</h3>
    <p style="color:#ffb4bc">{{ Session::get('error_delete') }}</p>
</div>
@endif

@endsection


<!-- content insert -->
@section('content')

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-3">

        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">Dashboard | </a>
            <a class="text-gray-300">Day pulses</a>
        </span>

        <div class="d-flex justify-content-center mt-2 mt-md-0">

            @if (Auth::user()->branch_id == 0)
            <div class="cont-branch-calendar me-2">
                <select id="select-branch-calendar"
                    class="js-example-basic-single select2-no-search select2-hidden-accessible">
                    @if (Auth::user()->branch_id == 0)
                    <option value="all">
                        All
                    </option>
                    @foreach ($branches as $item)
                    <option value="{{ $item->id }}" @if ($branch==$item->id) selected @endif>
                        {{ $item->name }}
                    </option>
                    @endforeach
                    @else
                    <option value="{{ Auth::user()->branch_id }}">
                        {{ Auth::user()->branch->name }}
                    </option>
                    @endif
                </select>
            </div>
            @endif

            <div class="calendar-datepicker">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text ps-3"><i class="bi bi-calendar2-week-fill"></i> </div>
                    </div>
                    <input id="calendar-date-input" type="text" value="{{ $date }}"
                        class="form-control hasdatetimepicker " placeholder="YYYY/MM/DD">
                </div>
            </div>
        </div>

    </div>

    <div class="row mb-3">
        @if (request()->live_report)
        <ul class="nav nav-tabs nav-tabs-nobg mb-3 justify-content-center border-bottom-0 pe-0" id="myTab"
            role="tablist">
            <li class="nav-item" role="presentation">
                <a href="{{ route('sett.livereport') }}">
                    <button class="nav-link" id="year_invoice-tab" data-bs-toggle="tab" data-bs-target="#year_invoice"
                        type="button" role="tab" aria-controls="year_invoice" aria-selected="true"
                        class="text-gray-500"><i class="fas fa-cog me-1"></i>
                        Operations</button>
                </a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="{{ route('sett.livereport') }}">
                    <button class="nav-link" id="specialty-tab" data-bs-toggle="tab" data-bs-target="#specialty_stat"
                        type="button" role="tab" aria-controls="home" aria-selected="true" class="text-gray-500"><i
                            class="fas fa-users me-1"></i>
                        Workers</button>
                </a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="{{ route('sett.invo_day_search', '?live_report=true') }}">
                    <button class="nav-link" id="branches-tab" data-bs-toggle="tab" data-bs-target="#branches"
                        type="button" role="tab" aria-controls="operation_tab" aria-selected="true"
                        class="text-gray-500"><i class="fas fa-money-check me-1"></i>
                        Accounting</button>
                </a>
            </li>
            <li class="nav-item active" role="presentation">
                <a href="{{ route('sett.pulses_day_st', '?live_report=true') }}">
                    <button class="nav-link" id="branches-tab" data-bs-toggle="tab" data-bs-target="#branches"
                        type="button" role="tab" aria-controls="operation_tab" aria-selected="true"
                        class="text-gray-500"><i class="fas fa-thermometer me-1"></i>
                        Pulses</button>
                </a>
            </li>
        </ul>
        @else
        <ul class="nav nav-tabs nav-tabs-nobg nav-tabs-cat justify-content-center pe-0" id="myTab" role="tablist">
            <li class="nav-item" role="presentation">
                <a href="{{ route('sett.pulses_day_st') }}" class="nav-link active" id="year_invoice-tab">
                    {{ __('basic.daily st') }}</a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="{{ route('sett.pulses_month_st') }}" class="nav-link" id="specialty-tab">
                    {{ __('basic.monthly st') }}</a>
            </li>
        </ul>
        @endif
    </div>

    <div class="row">

        <div class="col-12 px-0 px-md-2">
            <div class="card card-input shadow mb-4">
                <!-- Card Body -->
                <div class="card-body">
                    <div class="row">

                        <div class="col-12 col-md-6 mb-3 mb-md-0 border-flex">
                            <div class="chart-pie pt-4 pb-2">
                                <canvas id="myChart">
                                    <!-- the code and its style is printed from js -->
                                </canvas>
                            </div>
                        </div>

                        <div class="col-12 col-md-6 text-center align-self-center">
                            <h6 class="text-gray-400">{{ __('basic.total pulses') }}</h6>
                            @php
                            //$profit = $all_pulses->sum('total_paid') - $all_pulses->sum('total_paid');
                            @endphp
                            <span class="fs-1">{{ $all_pulses->sum('used_pulses') }}<small
                                    class="text-gray-300 text-xxxs">
                                    ps</small></span>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12 px-0 px-md-2 mb-4">
            <div class="card card-input shadow h-100">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold"><i class="fas fa-layer-group"></i> Machine records</h6>
                    <h6 data-bs-toggle="modal" data-bs-target="#new_machine_reco"
                        class="m-0 fw-bold main-color clickable-item-pointer"><i class="fas fa-plus"></i> New Record
                    </h6>

                    <!-- Modal for inserting the machines reco -->
                    <div class="modal fade" id="new_machine_reco" tabindex="-1" role="dialog"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                            <div class="modal-content b-r-s-cont border-0">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                        {{ __('basic.add new') }}</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>

                                <form class="mb-0" action="{{ route('sett.pul_machine_rec_insert') }}" method="post">
                                    {{ method_field('POST') }}
                                    {{ csrf_field() }}

                                    <!-- Modal content -->
                                    <div class="modal-body px-5 py-3">

                                        <div class="row mb-2">
                                            <div class="col-12 mb-2">
                                                <label class="form-label">{{ __('basic.branch') }}
                                                    <small>({{ __('basic.required') }})</small></label>
                                                <select
                                                    class="myselect2-machine-insert select2-hidden-accessible @error('branch_id') is-invalid @enderror"
                                                    id="branch_id" name="branch_id" required>

                                                    @if (Auth::user()->branch_id == 0)
                                                    @foreach ($branches as $item)
                                                    <option value="{{ $item->id }}">
                                                        {{ $item->name }}
                                                    </option>
                                                    @endforeach
                                                    @else
                                                    <option value="{{ Auth::user()->branch_id }}">
                                                        {{ Auth::user()->branch->name }}
                                                    </option>
                                                    @endif

                                                </select>

                                                <span id="branch_appo_error" class="error-msg-form"></span>

                                                @error('branch_id')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror

                                            </div>

                                            <div class="col-12 mb-2">
                                                <label class="form-label">{{ __('basic.machine') }}
                                                    <small>({{ __('basic.required') }})</small></label>

                                                <select
                                                    class="myselect2-machine-insert select2-hidden-accessible @error('responsible_doc_app') is-invalid @enderror"
                                                    id="machine_id" name="machine_id" required>
                                                    <option disabled selected>
                                                        Chose Branch first
                                                    </option>
                                                </select>

                                                <span id="machine_id_error" class="error-msg-form"></span>

                                                @error('machine_id')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror

                                            </div>

                                            <div class="col-12 mb-2">
                                                <label class="form-label"> {{ __('basic.beginning') }}
                                                    <small>({{ __('basic.required') }})</small></label>

                                                <input name="beginning" type="number"
                                                    class="form-control @error('beginning') is-invalid @enderror"
                                                    placeholder="Machine beginning number.." required>

                                                <span id="beginning_error" class="error-msg-form"></span>

                                                @error('beginning')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror
                                            </div>

                                            <div class="col-12 mb-2">
                                                <label class="form-label"> {{ __('basic.ending') }}
                                                    <small>({{ __('basic.optional') }})</small></label>

                                                <input name="ending" type="number"
                                                    class="form-control @error('ending') is-invalid @enderror"
                                                    placeholder="Machine ending number.." required>

                                                <span id="ending_error" class="error-msg-form"></span>

                                                @error('ending')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror
                                            </div>
                                        </div>

                                    </div>

                                    <div class="modal-footer">
                                        <div class="left-side">
                                            <button type="button" class="btn btn-default btn-link"
                                                data-bs-dismiss="modal">{{ __('basic.never mind') }}</button>
                                        </div>
                                        <div class="divider"></div>
                                        <div class="right-side">
                                            <button type="submit" class="btn btn-default btn-link main-color">Add
                                                New</button>
                                        </div>
                                    </div>
                                </form>

                            </div>
                        </div>

                    </div>

                </div>

                <!-- Card Body -->
                <div class="card-body overflow-scroll">
                    @if (count($machine_recs_total_pulses) > 0)
                    @foreach ($machine_recs_total_pulses as $item)
                    <div class="row px-0 justify-content-center my-4 border-bottom-gray pb-3">
                        <div class="col-12">
                            <h6 class="text-gray-500 fw-bold text-s2 mb-3 text-center"><i
                                    class="fas fa-pen me-1 link-cust-text text-gray-400 clickable-item-pointer"
                                    data-bs-toggle="modal"
                                    data-bs-target="#edit_machine_reco{{ $item->record->id }}"></i>
                                {{ $item->record->machine->name }}</h6>
                        </div>

                        <!-- Modal for edting the machines reco -->
                        <div class="modal fade" id="edit_machine_reco{{ $item->record->id }}" tabindex="-1"
                            role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                                <div class="modal-content b-r-s-cont border-0">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel"><i
                                                class="fas fa-capsules me-1"></i>
                                            {{ __('basic.edit record') }}</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>

                                    <form class="mb-0"
                                        action="{{ route('sett.pul_machine_rec_edit', $item->record->id) }}"
                                        method="post">
                                        {{ method_field('PATCH') }}
                                        {{ csrf_field() }}

                                        <!-- Modal content -->
                                        <div class="modal-body px-5 py-3">

                                            <div class="row mb-2">

                                                <div class="col-12 mb-2">
                                                    <label class="form-label">
                                                        {{ __('basic.beginning') }}
                                                        <small>({{ __('basic.required') }})</small></label>

                                                    <input name="beginning" type="number"
                                                        class="form-control @error('beginning') is-invalid @enderror"
                                                        placeholder="Machine beginning number.."
                                                        value="{{ $item->record->beginning }}" required>

                                                    <span id="beginning_error" class="error-msg-form"></span>

                                                    @error('beginning')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="col-12 mb-2">
                                                    <label class="form-label"> {{ __('basic.ending') }}
                                                        <small>({{ __('basic.optional') }})</small></label>

                                                    <input name="ending" type="number"
                                                        class="form-control @error('ending') is-invalid @enderror"
                                                        placeholder="Machine ending number.."
                                                        value="{{ $item->record->ending }}" required>

                                                    <span id="ending_error" class="error-msg-form"></span>

                                                    @error('ending')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>
                                            </div>

                                        </div>

                                        <div class="modal-footer">
                                            <div class="left-side">
                                                <button type="button" class="btn btn-default btn-link"
                                                    data-bs-dismiss="modal">{{ __('basic.never mind') }}</button>
                                            </div>
                                            <div class="divider"></div>
                                            <div class="right-side">
                                                <button type="submit" class="btn btn-default btn-link main-color">Add
                                                    New</button>
                                            </div>
                                        </div>
                                    </form>

                                </div>
                            </div>

                        </div>

                        <div class="col-4 col-md-2 align-self-center">
                            <h6 class="text-gray-300 text-xs mb-1 text-center">branch</h6>
                            <p id="branch_final_info" class="text-gray-600 text-s text-center">
                                {{ $item->record->machine->branch->name }}
                            </p>
                        </div>

                        <div class="col-4 col-md-2 align-self-center">
                            <h6 class="text-gray-300 text-xs mb-1 text-center">Doctor</h6>
                            <p id="branch_final_info" class="text-gray-600 text-s text-center text-truncate">
                                {{ $item->record->doctor->name }}</p>
                        </div>

                        <div class="col-4 col-md-1 align-self-center">
                            <h6 class="text-gray-300 text-xs mb-1 text-center">Beginning</h6>
                            <p id="branch_final_info" class="text-gray-600 text-s text-center text-truncate">
                                {{ $item->record->beginning }} <small class="text-gray-300 text-xxxs">ps</small>
                            </p>
                        </div>

                        <div class="col-4 col-md-1 text-center align-self-center">
                            <h6 class="text-gray-300 text-xs mb-1 text-center">Ending</h6>
                            <p id="branch_final_info" class="text-gray-600 text-s text-center text-truncate">
                                {{ $item->record->ending }} <small class="text-gray-300 text-xxxs">ps</small>
                            </p>
                            </a>
                        </div>

                        <div class="col-4 col-md-2 text-center align-self-center">
                            <div class="main-color-bg text-center text-white b-r-s-cont p-2"> Total</h6>
                                <p id="addre_final_info" class="text-white fs-5 fw-bold mb-0">
                                    @php
                                    $total_machin = $item->record->ending - $item->record->beginning;
                                    @endphp
                                    {{ $total_machin }} <small class="text-xxxs text-blue-300"> ps</small>
                                </p>
                            </div>
                        </div>

                        <div class="col-4 col-md-2 text-center align-self-center">
                            <div class="main-color-bg text-center text-white b-r-s-cont p-2"> Used</h6>
                                <p id="addre_final_info" class="text-white fs-5 fw-bold mb-0">
                                    {{ $item->used }} <small class="text-xxxs text-blue-300"> ps</small>
                                </p>
                            </div>
                        </div>

                        @if ($item->used == $total_machin)
                        @php
                        $total_machin_color = 'done-color-btn';
                        @endphp
                        @else
                        @php
                        $total_machin_color = 'cancel-color-btn';
                        @endphp
                        @endif

                        <div class="col-4 col-md-2 text-center align-self-center">
                            <div class="{{ $total_machin_color }} text-center b-r-s-cont p-2"> Difference
                                </h6>
                                <p id="addre_final_info" class="fs-5 fw-bold mb-0">
                                    {{ $item->used - $total_machin }} <small class="text-xxxs">
                                        ps</small>
                                </p>
                            </div>
                        </div>

                    </div>
                    @endforeach
                    @else
                    <div class="text-center">
                        <i class="bi bi-brightness-alt-high-fill fa-sm fa-fw fs-2"></i>
                        <p class="fw-light mb-0">Nothing to show</p>
                    </div>
                    @endif

                </div>
            </div>
        </div>
    </div>


    <div class="row mb-4">

        <div class="col-12 col-md-6 mb-4 mb-md-0">
            <div class="card card-input shadow h-100">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> All machine pulses today
                    </h6>
                </div>

                <!-- Card Body -->
                <div class="card-body overflow-scroll">

                    <div class="table-responsive">
                        <table class="table display datatable-modal" id="table-machine-totals-cat" width="100%"
                            cellspacing="0">
                            <thead>
                                <tr>
                                    <th class="text-xs text-center">Name</th>
                                    <th class="text-xs text-center">Total</th>
                                </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                    <th width="50%" class="text-center fw-bold text-s">TOTAL</th>
                                    <th width="50%" class="text-center fw-bold text-s2">
                                        {{ $all_pulses->sum('used_pulses') }} <small class="text-gray-300 text-xxxs">
                                            ps</small>
                                    </th>
                                </tr>
                            </tfoot>

                            <tbody>
                                @foreach ($machine_pulses as $item)
                                <tr>
                                    <td class="text-center text-truncate">
                                        {{ $item->machine->name }}
                                    </td>

                                    <td class="text-center">
                                        {{ $item->total }} <small class="text-gray-300 text-xxxs">
                                            ps</small>
                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>

        <div class="col-12 col-md-6">
            <div class="card card-input shadow h-100">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> All Machine pulses today
                        chart
                    </h6>
                </div>

                <!-- Card Body -->
                <div class="card-body overflow-scroll">
                    <h5 class="text-center text-gray-300"> Machine pulses chart</h5>
                    <div class="chart-pie px-1">
                        <canvas id="myChart-machine">
                            <!-- the code and its style is printed from js -->
                        </canvas>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <div class="row">
        <div class="col-12 px-0 px-md-2 mb-4">
            <div class="card card-input shadow h-100">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> All Pulses</h6>
                </div>

                <!-- Card Body -->
                <div class="card-body overflow-scroll">

                    <div class="table-responsive">
                        <table class="table display datatable-modal" id="table-income-all" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th class="text-xs">{{ __('basic.date') }}</th>
                                    <th class="text-xs text-center">
                                        {{ __('basic.type') }}</th>
                                    <th class="text-xs">{{ __('basic.name') }}</th>
                                    <th class="text-xs">{{ __('basic.patient') }}</th>
                                    <th class="text-xs text-center">{{ __('basic.machine') }}
                                    </th>
                                    <th class="text-xs text-center">{{ __('basic.doctor') }}
                                    </th>
                                    <th class="text-xs text-center">{{ __('patientappo.pay status') }}
                                    </th>
                                    <th class="text-xs">{{ __('basic.fluence') }}</th>
                                    <th class="text-xs">{{ __('basic.pulse area') }}</th>
                                    <th class="text-xs">{{ __('basic.spot size') }}</th>
                                    <th class="text-xs">{{ __('basic.balance before session') }}
                                    </th>
                                    <th class="text-xs">{{ __('basic.used pulses') }}</th>
                                    <th class="text-xs">{{ __('basic.package') }}</th>
                                </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                    <th class="text-center fw-bold text-s">TOTAL</th>
                                    <th class="text-center fw-bold text-s2">
                                        {{ $all_pulses->sum('used_pulses') }} <small
                                            class="text-gray-300 text-xxxs">ps</small>
                                    </th>
                                </tr>
                            </tfoot>

                            <tbody>
                                @foreach ($all_pulses as $item)
                                @if ($item->type == 0)
                                @php
                                $text_color = 'active-color-btn';
                                $msg = __('patientappo.session');
                                @endphp
                                @elseif ($item->type == 1)
                                @php
                                $text_color = 'done-color-btn';
                                $msg = __('basic.money per pulse');
                                @endphp
                                @elseif ($item->type == 2)
                                @php
                                $text_color = 'prog-color-btn';
                                $msg = __('basic.session package');
                                @endphp
                                @elseif ($item->type == 3)
                                @php
                                $text_color = 'not_accepted-color-btn';
                                $msg = __('basic.pulses package');
                                @endphp
                                @elseif ($item->type == 4)
                                @php
                                $text_color = 'pend-color-btn';
                                $msg = __('basic.free session');
                                @endphp
                                @endif

                                @if ($item->invoice_item)
                                @if ($item->invoice_item->invoice->status == 0)
                                @php
                                $text_color_invoice = 'cancel-color-btn';
                                $msg_invoice = __('basic.not paid');
                                @endphp
                                @elseif ($item->invoice_item->invoice->status == 1)
                                @php
                                $text_color_invoice = 'pend-color-btn';
                                $msg_invoice = __('basic.pending');
                                @endphp
                                @elseif ($item->invoice_item->invoice->status == 2)
                                @php
                                $text_color_invoice = 'prog-color-btn';
                                $msg_invoice = __('basic.installment');
                                @endphp
                                @elseif ($item->invoice_item->invoice->status == 3)
                                @php
                                $text_color_invoice = 'done-color-btn';
                                $msg_invoice = __('basic.paid');
                                @endphp
                                @elseif ($item->invoice_item->invoice->status == 4)
                                @php
                                $text_color_invoice = 'cancel-color-btn';
                                $msg_invoice = __('basic.refund');
                                @endphp
                                @endif
                                @php
                                $invoice_url = 'href=' . route("sett.invoice.show", $item->invoice_item->invoice->id);
                                @endphp
                                @else
                                @php
                                $text_color_invoice = 'done-color-btn';
                                $msg_invoice = __('basic.from package');
                                $invoice_url = '';
                                @endphp
                                @endif

                                <tr>
                                    <td>{{ date('d M Y', strtotime($item->date)) }}</td>
                                    <td class="text-center"> <span
                                            class="badge rounded-pill {{ $text_color }} badge-padd-l">{{ $msg }}</span>
                                    </td>
                                    <td>
                                        @if ($item->service_item)
                                        {{ $item->service_item->name }}
                                        @else
                                        Taken from package
                                        @endif
                                    </td>

                                    <td><a class="text-center text-gray-500"
                                            href="{{ route('sett.patient.show', $item->patient->id) }}">
                                            {{ $item->patient->name }}</a></td>

                                    <td class="text-center">
                                        {{ $item->machine->name }}
                                    </td>


                                    <td class="text-center">
                                        {{ $item->doctor->name }}
                                    </td>

                                    <td class="text-center"> <a {{ $invoice_url }}><span
                                                class="badge rounded-pill {{ $text_color_invoice }} badge-padd-l">{{
                                                $msg_invoice }}</span></a>
                                    </td>

                                    <td class="text-center">
                                        {{ $item->fluence }}
                                    </td>
                                    <td class="text-center">
                                        @if ($item->pulse_area)
                                        {{ $item->pulse_area->name }}
                                        @else
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        {{ $item->spot_size }}
                                    </td>
                                    <td class="text-center">
                                        {{ $item->balance_before_session }}
                                    </td>
                                    <td class="text-center">
                                        {{ $item->used_pulses }}
                                    </td>
                                    <td class="text-center">
                                        @if ($item->package)
                                        {{ $item->package->service_item->name }}
                                        {{ $item->package->date }}
                                        @else
                                        No package
                                        @endif
                                    </td>
                                    @endforeach
                            </tbody>
                        </table>
                    </div>


                </div>
            </div>
        </div>
    </div>

    <div class="row mb-4">

        <div class="col-12 col-md-6 mb-4 mb-md-0">
            <div class="card card-input shadow h-100">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> All doctor pulses today
                    </h6>
                </div>

                <!-- Card Body -->
                <div class="card-body overflow-scroll">

                    <div class="table-responsive">
                        <table class="table display datatable-modal" id="table-income-totals-cat" width="100%"
                            cellspacing="0">
                            <thead>
                                <tr>
                                    <th class="text-xs text-center">Name</th>
                                    <th class="text-xs text-center">Total</th>
                                </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                    <th width="50%" class="text-center fw-bold text-s">TOTAL</th>
                                    <th width="50%" class="text-center fw-bold text-s2">
                                        {{ $all_pulses->sum('used_pulses') }} <small class="text-gray-300 text-xxxs">
                                            ps</small>
                                    </th>
                                </tr>
                            </tfoot>

                            <tbody>
                                @foreach ($doctor_pulses as $item)
                                <tr>
                                    <td class="text-center text-truncate">
                                        {{ $item->doctor->name }}
                                    </td>

                                    <td class="text-center">
                                        {{ $item->total }} <small class="text-gray-300 text-xxxs">
                                            ps</small>
                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>

        <div class="col-12 col-md-6">
            <div class="card card-input shadow h-100">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> All doctor pulses today
                        chart
                    </h6>
                </div>

                <!-- Card Body -->
                <div class="card-body overflow-scroll">
                    <h5 class="text-center text-gray-300"> Doctor pulses chart</h5>
                    <div class="chart-pie px-1">
                        <canvas id="myChart-doctor">
                            <!-- the code and its style is printed from js -->
                        </canvas>
                    </div>
                </div>
            </div>

        </div>
    </div>

    @endsection

    <!-- js insert -->
    @section('js')


    <!-- select 2 -->
    <script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(document).ready(function() {
            $('.js-example-basic-single').select2();
            //hide search
            $('.select2-no-search').select2({
                minimumResultsForSearch: -1
            });
        });
        $(".myselect2-machine-insert").select2({
            dropdownParent: $("#new_machine_reco")
        });

        //hide search
        $('.myselect2-machine-insert-nosearch').select2({
            dropdownParent: $("#new_machine_reco")
            , minimumResultsForSearch: -1
        });

    </script>

    <script>
        $(document).ready(function() {

            fetchMachine();

            function fetchMachine(branch_id = $('select[name="branch_id"]').val()) {
                var url = "{{ route('sett.pulses_machines_ajax', ':id') }}";
                url = url.replace(':id', branch_id);

                $.ajax({
                    url: url
                    , type: "GET"
                    , dataType: "json"
                    , success: function(data) {
                        $('select[name="machine_id"]').empty();
                        $.each(data, function(key, value) {
                            $('select[name="machine_id"]').append(
                                '<option value="' +
                                value.id + '">' + value.name + '</option>');
                        });
                    }
                });
            }

            //for gettomg machines depnds on branch ajax
            $('select[name="branch_id"]').on('change', function(e) {
                e.preventDefault();
                var branch_id = $(this).val();

                fetchMachine(branch_id)
            });

            //--------------------- selectors -------------------
            $(document).on('change', '#select-specialty-calendar, #select-branch-calendar', function() {
                var date_input = $('#calendar-date-input').val();
                var date = $('#select-branch-calendar').val();

                var url = "{{ route('sett.pulses_day_st', [':date_input', ':date']) }}";

                url = url.replace(':date_input', date_input).replace(':date', date);

                var url = url;
                window.location.href = url;
            });
            $(document).on('change', '#calendar-date-input', function() {
                var date_input = $('#calendar-date-input').val();
                var date = $('#select-branch-calendar').val();

                var url = "{{ route('sett.pulses_day_st', [':date_input', ':date']) }}";

                url = url.replace(':date_input', date_input).replace(':date', date)

                window.location.href = url;
            });
        });

    </script>

    <!-- jquery ui datepicker -->
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>

    <script>
        $(function() {
            $('.hasdatetimepicker').datepicker({
                todayHighlight: true
                , format: "yyyy-mm-dd"
            , });
        });

    </script>

    <!-- -- Chart.js plugin -- -->
    <script src="https://fastly.jsdelivr.net/npm/chart.js"></script>

    @php
    $chart_color = ['#1a78f1', '#38dfa8', '#d13c62', '#12c7d9', '#03c2c3', '#5035df', '#17a673', '#2e59d9', '#9aeded',
    '#f3d56a', '#7c859d', '#a4adc5', '#80142f', '#33d293', '#bed233', '#3958e9', '#10c86f', '#654fb6', '#a44fb6',
    '#89728e', '#c85110', '#6d769d', '#1b6954', '#204494', '#94206b', '#948320', '#209493', '#292094', '#203a65',
    '#4e6fa5', '#e29031', '#e23168', '#31e0e2', '#e29131', '#319fe2', '#8131e2', '#31a8e2', '#31e2c0', '#31c3e2',
    '#e2a931', '#3157e2'];
    @endphp

    <script>
        // --------- credit chart ---------
        var ctx_recourse = document.getElementById("myChart");
        var myPieChart2 = new Chart(ctx_recourse, {
            type: 'doughnut'
            , data: {
                labels: [
                    @foreach($branch_pulses as $item)
                    "{{ $item->branch->name }}"
                    , @endforeach
                ]
                , datasets: [{
                    data: [
                        @foreach($branch_pulses as $item) {
                            {
                                $item - > total.
                                ','
                            }
                        }
                        @endforeach
                    ]
                    , @php
                    $i = 0;
                    @endphp
                    backgroundColor: [
                        @foreach($branch_pulses as $item)
                        '{{ $chart_color[$i] }}'
                        , @php
                        $i++;
                        @endphp
                        @endforeach
                    ]
                , }]
            , }
            , options: {
                maintainAspectRatio: false
                , tooltips: {
                    backgroundColor: "rgb(255,255,255)"
                    , bodyFontColor: "#858796"
                    , borderColor: '#dddfeb'
                    , borderWidth: 1
                    , xPadding: 15
                    , yPadding: 15
                    , displayColors: false
                    , caretPadding: 10
                    , callbacks: {
                        label: function(tooltipItem) {
                            return tooltipItem.yLabel;
                        }
                    }
                }
                , plugins: {
                    legend: {
                        display: true
                    }
                    , colorschemes: {
                        scheme: 'brewer.Paired12'
                    }
                }
                , cutoutPercentage: 80
            , }
        , });

        // --------- doctor chart ---------
        var ctx_recourse = document.getElementById("myChart-doctor");
        var myPieChart2 = new Chart(ctx_recourse, {
            type: 'doughnut'
            , data: {
                labels: [
                    @foreach($doctor_pulses as $item)
                    "{{ $item->doctor->name }}"
                    , @endforeach
                ]
                , datasets: [{
                    data: [
                        @foreach($doctor_pulses as $item) {
                            {
                                $item - > total.
                                ','
                            }
                        }
                        @endforeach
                    ]
                    , @php
                    $i = 0;
                    @endphp
                    backgroundColor: [
                        @foreach($doctor_pulses as $item)
                        '{{ $chart_color[$i] }}'
                        , @php
                        $i++;
                        @endphp
                        @endforeach
                    ]
                , }]
            , }
            , options: {
                maintainAspectRatio: false
                , tooltips: {
                    backgroundColor: "rgb(255,255,255)"
                    , bodyFontColor: "#858796"
                    , borderColor: '#dddfeb'
                    , borderWidth: 1
                    , xPadding: 15
                    , yPadding: 15
                    , displayColors: false
                    , caretPadding: 10
                    , callbacks: {
                        label: function(tooltipItem) {
                            return tooltipItem.yLabel;
                        }
                    }
                }
                , plugins: {
                    legend: {
                        display: true
                    }
                    , colorschemes: {
                        scheme: 'brewer.Paired12'
                    }
                }
                , cutoutPercentage: 80
            , }
        , });

        // --------- doctor chart ---------
        var ctx_recourse = document.getElementById("myChart-machine");
        var myPieChart2 = new Chart(ctx_recourse, {
            type: 'doughnut'
            , data: {
                labels: [
                    @foreach($machine_pulses as $item)
                    "{{ $item->machine->name }}"
                    , @endforeach
                ]
                , datasets: [{
                    data: [
                        @foreach($machine_pulses as $item) {
                            {
                                $item - > total.
                                ','
                            }
                        }
                        @endforeach
                    ]
                    , @php
                    $i = 0;
                    @endphp
                    backgroundColor: [
                        @foreach($machine_pulses as $item)
                        '{{ $chart_color[$i] }}'
                        , @php
                        $i++;
                        @endphp
                        @endforeach
                    ]
                , }]
            , }
            , options: {
                maintainAspectRatio: false
                , tooltips: {
                    backgroundColor: "rgb(255,255,255)"
                    , bodyFontColor: "#858796"
                    , borderColor: '#dddfeb'
                    , borderWidth: 1
                    , xPadding: 15
                    , yPadding: 15
                    , displayColors: false
                    , caretPadding: 10
                    , callbacks: {
                        label: function(tooltipItem) {
                            return tooltipItem.yLabel;
                        }
                    }
                }
                , plugins: {
                    legend: {
                        display: true
                    }
                    , colorschemes: {
                        scheme: 'brewer.Paired12'
                    }
                }
                , cutoutPercentage: 80
            , }
        , });

    </script>

    <!-- -- datatables plugin -- -->
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.bootstrap5.min.js"></script>

    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>

    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.colVis.min.js"></script>
    <script
        src="https://nightly.datatables.net/fixedheader/js/dataTables.fixedHeader.js?_=f0de745b101295e88f1504c17177ff49">
    </script>

    <script>
        $(document).ready(function() {

            var table = $('#table-income-all').DataTable({
                    lengthChange: false
                    , "pageLength": 10
                    , "order": [
                        [0, "ASC"]
                    ]
                    , buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        }
                        , buttons: [{
                                extend: 'copyHtml5'
                                , footer: true
                            }
                            , {
                                extend: 'excelHtml5'
                                , footer: true
                            }
                            , {
                                extend: 'pdfHtml5'
                                , footer: true
                            }
                            , {
                                extend: 'print'
                                , footer: true
                            }
                        ]
                    }
                }

            );
            table.buttons().container()
                .appendTo('#table-income-all_wrapper .col-md-6:eq(0)');

            var table = $('#table-expenses-all').DataTable({
                lengthChange: false
                , "pageLength": 10
                , "order": [
                    [0, "ASC"]
                ]
                , buttons: {
                    dom: {
                        button: {
                            className: 'btn btn-table-export me-0' //Primary class for all buttons
                        }
                    }
                    , buttons: [{
                            extend: 'copyHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'excelHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'pdfHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'print'
                            , footer: true
                        }
                    ]
                }
            });
            table.buttons().container()
                .appendTo('#table-expenses-all_wrapper .col-md-6:eq(0)');

            var table = $('#table-income-totals-cat').DataTable({
                lengthChange: false
                , "pageLength": 10
                , "order": [
                    [0, "ASC"]
                ]
                , buttons: {
                    dom: {
                        button: {
                            className: 'btn btn-table-export me-0' //Primary class for all buttons
                        }
                    }
                    , buttons: [{
                            extend: 'copyHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'excelHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'pdfHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'print'
                            , footer: true
                        }
                    ]
                }
            });
            table.buttons().container()
                .appendTo('#table-income-totals-cat_wrapper .col-md-6:eq(0)');


            var table = $('#table-machine-totals-cat').DataTable({
                lengthChange: false
                , "pageLength": 10
                , "order": [
                    [0, "ASC"]
                ]
                , buttons: {
                    dom: {
                        button: {
                            className: 'btn btn-table-export me-0' //Primary class for all buttons
                        }
                    }
                    , buttons: [{
                            extend: 'copyHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'excelHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'pdfHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'print'
                            , footer: true
                        }
                    ]
                }
            });
            table.buttons().container()
                .appendTo('#table-machine-totals-cat_wrapper .col-md-6:eq(0)');

            var table = $('#table-expenses-totals-cat').DataTable({
                lengthChange: false
                , "pageLength": 10
                , "order": [
                    [0, "ASC"]
                ]
                , buttons: {
                    dom: {
                        button: {
                            className: 'btn btn-table-export me-0' //Primary class for all buttons
                        }
                    }
                    , buttons: [{
                            extend: 'copyHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'excelHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'pdfHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'print'
                            , footer: true
                        }
                    ]
                }
            });
            table.buttons().container()
                .appendTo('#table-expenses-totals-cat_wrapper .col-md-6:eq(0)');

            var table = $('#table-income-totals').DataTable({
                lengthChange: false
                , "pageLength": 10
                , "order": [
                    [0, "ASC"]
                ]
                , buttons: {
                    dom: {
                        button: {
                            className: 'btn btn-table-export me-0' //Primary class for all buttons
                        }
                    }
                    , buttons: [{
                            extend: 'copyHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'excelHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'pdfHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'print'
                            , footer: true
                        }
                    ]
                }
            });
            table.buttons().container()
                .appendTo('#table-income-totals_wrapper .col-md-6:eq(0)');

            var table = $('#table-expenses-totals').DataTable({
                lengthChange: false
                , "pageLength": 10
                , "order": [
                    [0, "ASC"]
                ]
                , buttons: {
                    dom: {
                        button: {
                            className: 'btn btn-table-export me-0' //Primary class for all buttons
                        }
                    }
                    , buttons: [{
                            extend: 'copyHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'excelHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'pdfHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'print'
                            , footer: true
                        }
                    ]
                }
            });
            table.buttons().container()
                .appendTo('#table-expenses-totals_wrapper .col-md-6:eq(0)');

            var table = $('#table-operation-income-all').DataTable({
                lengthChange: false
                , "pageLength": 10
                , "order": [
                    [0, "ASC"]
                ]
                , buttons: {
                    dom: {
                        button: {
                            className: 'btn btn-table-export me-0' //Primary class for all buttons
                        }
                    }
                    , buttons: [{
                            extend: 'copyHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'excelHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'pdfHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'print'
                            , footer: true
                        }
                    ]
                }
            });
            table.buttons().container()
                .appendTo('#table-operation-income-all_wrapper .col-md-6:eq(0)');

            var table = $('#table-operation-expenses-all').DataTable({
                lengthChange: false
                , "pageLength": 10
                , "order": [
                    [0, "ASC"]
                ]
                , buttons: {
                    dom: {
                        button: {
                            className: 'btn btn-table-export me-0' //Primary class for all buttons
                        }
                    }
                    , buttons: [{
                            extend: 'copyHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'excelHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'pdfHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'print'
                            , footer: true
                        }
                    ]
                }
            });
            table.buttons().container()
                .appendTo('#table-operation-expenses-all_wrapper .col-md-6:eq(0)');

        });

    </script>

    @endsection