@extends('layouts.master')

@section('title', 'Edit Patient | Proxima - Medical Management app')

@section('title-topbar', 'Edit Patient')

<!-- css insert -->
@section('css')

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<!-- international telephone input -->
<link href="{{ URL::asset('plugins/intltelinput/intlTelInput.css') }}" rel="stylesheet">


@endsection


<!-- content insert -->
@section('content')

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-3">
        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">Dashboard |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.patient.index') }}">Patient | </a>
            <a class="text-gray-300">Edit Patient</a>
        </span>
    </div>

    <div class="card card-input shadow mb-3 pb-3">
        <!-- Card Header - Dropdown -->
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-user-edit me-2"></i> Edit
                {{ $patient->first_name }}
                Profile
            </h6>
        </div>


        @foreach ($errors->all() as $error)
        <div class="text-red"><i class="fas fa-exclamation me-1"></i> {{ $error }}</div>
        @endforeach


        <!-- Card Body -->
        <div class="card-body px-3">

            <div class="multi-setps-form-calander col-12">

                <form id="myform" method="POST" action="{{ route('sett.patient.update', $patient->id) }}"
                    enctype="multipart/form-data">

                    @csrf
                    @method('PUT')

                    <!-- progressbar -->
                    <ul class="ps-0 progressbar" id="progressbar">
                        <li class="active">
                            <a>
                                <!-- in case we want to use prog selector href="#clinics" -->
                                <div class="icon-circle checked d-flex align-items-center justify-content-center">
                                    <i class="bi bi-gear"></i>
                                </div>
                                Basic
                            </a>
                        </li>

                        <li>
                            <a>
                                <div class="icon-circle d-flex align-items-center justify-content-center">
                                    <i class="bi bi-person"></i>
                                </div>
                                Personal
                            </a>
                        </li>

                        <li>
                            <a>
                                <div class="icon-circle d-flex align-items-center justify-content-center">
                                    <i class="bi bi-pin-map"></i>
                                </div>
                                Medical
                            </a>
                        </li>
                        <li>
                            <a>
                                <div class="icon-circle d-flex align-items-center justify-content-center">
                                    <i class="far fa-paper-plane"></i>
                                </div>
                                Sending
                            </a>
                        </li>
                    </ul>

                    <!-- content -->

                    <div class="cont_tap " id="clinics">

                        <div class="row mb-1">
                            <div class="col-12 col-md-5 align-self-center mb-2">

                                <div class="avatar-update-container">
                                    <div class="picture">
                                        <img src="{{ URL::asset('img/useravatar/' . $patient->avatar) }}"
                                            class="picture-src" id="mib_PicturePreview" title="" />
                                        <input type="file" name='avatar' accept="image/*" id="mib_img_input">
                                    </div>
                                    <h6 class="text-gray-300">Choose Picture</h6>

                                    @error('avatar')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>

                            </div>

                            <div class="col-12 col-md-7 mb-2">

                                <div class="mb-3">
                                    <label class="form-label">{{ __('patientappo.first name') }}
                                        <small>({{ __('basic.required') }})</small></label>
                                    <input name="first_name" type="text"
                                        class="form-control @error('first_name') is-invalid @enderror"
                                        placeholder="Write your first name here" autofocus required
                                        value="{{ $patient->first_name }}">
                                </div>

                                @error('first_name')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                                <div class="mb-3">
                                    <label class="form-label">{{ __('patientappo.second name') }}
                                        <small>({{ __('basic.required') }})</small></label>
                                    <input name="second_name" type="text"
                                        class="form-control @error('second_name') is-invalid @enderror"
                                        placeholder="Write your second name here" required
                                        value="{{ $patient->second_name }}">
                                </div>

                                @error('second_name')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                            </div>
                        </div>

                        <div class="row mb-2">

                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Email <small>(optional)</small></label>
                                <input name="email" type="text"
                                    class="form-control @error('email') is-invalid @enderror"
                                    placeholder="Yousef@yahoo.com" value="{{ $patient->email }}">
                                @error('email')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <input name="old_email" type="hidden" value="{{ $patient->email }}">

                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Mother Name
                                    <small>(optional)</small></label>
                                <input name="mother_name" type="text"
                                    class="form-control @error('mother_name') is-invalid @enderror"
                                    value="{{ $patient->mother_name }}" placeholder="Write your mother's name here">

                                @error('mother_name')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                        </div>

                        <div class="row mb-2">
                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">New Password newpassword<small>(required)</small></label>
                                <input id="password" name="newpassword" type="password"
                                    class="form-control @error('newpassword') is-invalid @enderror"
                                    placeholder="Wrtie your password here...">

                                @if ($errors->has('newpassword'))
                                <span class="error-msg-form">
                                    {{ $errors->first('newpassword') }}
                                </span>
                                @else
                                <div class="form-text text-gray-200">Leave it empty if you do not want to change it.
                                </div>
                                @endif
                            </div>

                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Confirm New password <small>(required)</small></label>
                                <input name="newpassword_confirmation" type="password" class="form-control"
                                    placeholder="Confirm your password..." id="password-confirm">
                            </div>

                        </div>

                        <div class="d-flex justify-content-end mt-3">
                            <input type="button" name="next" class="next-form-steps btn btn-primary action-button-next"
                                value="Continue" />
                        </div>
                    </div>


                    <div class="cont_tap" id="time">

                        <div class="row mb-2">

                            <div class="col-12 col-md-3 mb-2">
                                <label class="form-label">Status <small>(required)</small></label>
                                <select
                                    class="js-example-basic-single select2-no-search select2-hidden-accessible @error('status') is-invalid @enderror"
                                    name="status" required>
                                    <option value="1" @if ($patient->status == 1) selected @endif>New</option>
                                    <option value="2" @if ($patient->status == 2) selected @endif>Old
                                    </option>
                                </select>
                                <div id="status-js-error-valid"></div>

                                @error('status')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                            </div>


                            <div class="col-12 col-md-3 mb-2">
                                <label class="form-label">{{ __('basic.main ask for') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <select
                                    class="js-example-basic-single select2-no-search select2-hidden-accessible @error('ask_for_main_id') is-invalid @enderror"
                                    name="ask_for_main_id" required>
                                    @foreach ($ask_for_main as $item)
                                    <option @if ($patient->ask_for_main_id == $item->id) selected @endif value="{{
                                        $item->id }}">{{ $item->name }}
                                    </option>
                                    @endforeach
                                </select>
                                <div id="main_ask_for_id-js-error-valid"></div>

                                @error('ask_for_main_id')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 col-md-3 mb-2">
                                <label class="form-label">{{ __('basic.ask for') }}
                                    <small>({{ __('basic.required') }})</small></label>

                                <select
                                    class="js-example-basic-single select2-hidden-accessible @error('ask_for_id') is-invalid @enderror"
                                    name="ask_for_id" required>
                                    @if($patient->ask_for)
                                    <option value="{{ $patient->ask_for['id'] }}" selected>
                                        {{ $patient->ask_for['name'] }}
                                    </option>
                                    @else
                                    <option value="" selected>
                                        - Select Main Ask for first -
                                    </option>
                                    @endif

                                </select>

                                <div id="ask_for_id-js-error-valid"></div>

                                @if ($errors->has('ask_for_id'))
                                <span class="error-msg-form">
                                    {{ $errors->first('ask_for_id') }}
                                </span>
                                @else
                                <div class="form-text text-gray-200">Select the main ask for first</div>
                                @endif
                            </div>

                            @role('Super-admin|Branch-manager')
                            <div class="col-12 col-md-3 mb-2">
                                <label class="form-label">Branch <small>(required)</small></label>
                                <select
                                    class="js-example-basic-single select2-no-search select2-hidden-accessible @error('first_branch_id') is-invalid @enderror"
                                    name="first_branch_id" required>
                                    @foreach ($branches as $item)
                                    <option value="{{ $item->id }}" @if ($patient->first_branch_id == $item->id)
                                        selected @endif>
                                        {{ $item->name }}
                                    </option>
                                    @endforeach
                                </select>
                                <div id="first_branch_id-js-error-valid"></div>

                                @error('first_branch_id')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>
                            @endrole

                        </div>

                        <hr>

                        <div class="row mb-2">

                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Gendar <small>(required)</small></label>
                                <select
                                    class="js-example-basic-single select2-no-search select2-hidden-accessible @error('gendar') is-invalid @enderror"
                                    name="gendar" required>
                                    <option value="male" @if ($patient->gendar === 'male') selected @endif>Male
                                    </option>
                                    <option value="female" @if ($patient->gendar === 'female') selected @endif>Female
                                    </option>
                                </select>
                                <div id="gendar-js-error-valid"></div>

                                @error('gendar')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                            </div>

                            <div class="col-12 col-md-6 mb-2">

                                <label class="form-label">Birthday <small>(required)</small></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i> </div>
                                    </div>
                                    <input name="birthday" type="text"
                                        class="form-control hasdatetimepicker @error('birthday') is-invalid @enderror"
                                        placeholder="YYYY/MM/DD" value="{{ $patient->birthday }}" required>
                                </div>
                                <div id="birthday-js-error-valid"></div>

                                @error('birthday')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                            </div>

                        </div>

                        <hr>

                        <div class="row mb-2">

                            <div class="col-12 col-md-4 mb-2">
                                <label class="form-label">Country <small>(required)</small></label>
                                <select
                                    class="js-example-basic-single select2-hidden-accessible @error('country_id') is-invalid @enderror"
                                    name="country_id" required>
                                    @foreach ($countries as $iteam)
                                    <option value="{{ $iteam->id }}" @if ($patient->country_id == $iteam->id) selected
                                        @endif>
                                        {{ $iteam->name }}</option>
                                    @endforeach
                                </select>
                                <div id="country-js-error-valid"></div>

                                @error('country_id')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                            </div>

                            <div class="col-12 col-md-4 mb-2">
                                <label class="form-label">City <small>(required)</small></label>
                                <select
                                    class="js-example-basic-single select2-hidden-accessible @error('city_id') is-invalid @enderror"
                                    name="city_id" required>
                                    <option value="{{ $patient->city['id'] }}" selected>
                                        {{ $patient->city['name'] }}
                                    </option>
                                </select>

                                <div id="city-js-error-valid"></div>

                                @if ($errors->has('city_id'))
                                <span class="error-msg-form">
                                    {{ $errors->first('city_id') }}
                                </span>
                                @else
                                <div class="form-text text-gray-200">Select the country first
                                </div>
                                @endif
                            </div>


                            <div class="col-12 col-md-4 mb-2">
                                <label class="form-label">How do you know us? <small>(required)</small></label>
                                <select
                                    class="js-example-basic-single select2-hidden-accessible @error('from_recourse_id') is-invalid @enderror"
                                    name="from_recourse_id" required>
                                    @foreach ($from_recourses as $iteam)
                                    <option value="{{ $iteam->id }}" @if ($patient->from_recourse_id == $iteam->id)
                                        selected @endif>
                                        {{ $iteam->name }}</option>
                                    @endforeach
                                </select>
                                <div id="from_recourse_id-js-error-valid"></div>

                                @error('from_recourse_id')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                            </div>

                        </div>

                        <hr>

                        <div class="row mb-2">

                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Phone Number <small>(required)</small></label>
                                <input id="int-miphone" name="phone_number" type="tel"
                                    class="form-control @error('phone_number') is-invalid @enderror"
                                    value="{{ $patient->phone_number }}" required>

                                <input name="old_phone_number" type="hidden" value="{{ $patient->phone_number }}">

                                <div id="phonenumber-js-error-valid">
                                </div>

                                @if ($errors->has('phone_number'))
                                <span class="error-msg-form">
                                    {{ $errors->first('phone_number') }}
                                </span>
                                @else
                                <div class="form-text text-gray-200">We'll never share your email with anyone else.
                                </div>
                                @endif
                            </div>



                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Second Phone Number <small>(optional)</small></label>
                                <input id="int-miphone2" name="sec_phone_number" type="tel"
                                    class="form-control @error('sec_phone_number') is-invalid @enderror"
                                    value="{{ $patient->sec_phone_number }}">

                                <div id="secphonenumber-js-error-valid"></div>

                                @error('sec_phone_number')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror


                            </div>


                        </div>

                        <div class="d-flex justify-content-between p-4">
                            <input type="button" name="previous"
                                class="previous-form-steps btn btn-secondary action-button-previous" value="Previous" />
                            <input type="button" name="next" class="next-form-steps btn btn-primary action-button-next"
                                value="Continue" />
                        </div>
                    </div>

                    <div class="cont_tap" id="about">


                        <div class="row mb-2">

                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Height <small>(optional)</small></label>
                                <input name="height" type="text" value="{{ $patient->height }}"
                                    class="form-control @error('height') is-invalid @enderror"
                                    placeholder="Write your height here">

                                @error('height')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                            </div>

                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Weight <small>(optional)</small></label>
                                <input name="weight" type="text" value="{{ $patient->weight }}"
                                    class="form-control @error('weight') is-invalid @enderror"
                                    placeholder="Write your weight here">

                                @error('weight')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                            </div>


                        </div>

                        <div class="row mb-2">

                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Blood type <small>(optional)</small></label>
                                <input name="blood_type" type="text" value="{{ $patient->blood_type }}"
                                    class="form-control @error('blood_type') is-invalid @enderror"
                                    placeholder="Write your blood type here">

                                @error('blood_type')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                            </div>

                            <div class="col-12 col-md-6 mb-2">
                                <label class="form-label">Insurance<small>(optional)</small></label>
                                <input name="insurance" type="text" value="{{ $patient->insurance }}"
                                    class="form-control @error('insurance') is-invalid @enderror"
                                    placeholder="Write your insurance company here">

                                @error('insurance')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                            </div>
                        </div>

                        <div class="row mb-2">
                            <div class="mb-3">
                                <label class="form-label">Note <small>(optional)</small></label>
                                <textarea name="note" class="form-control" placeholder="Write here your notes .."
                                    rows="4" spellcheck="false">{{ $patient->note }}</textarea>
                            </div>

                            @error('note')
                            <span class="error-msg-form">
                                {{ $message }}
                            </span>
                            @enderror
                        </div>

                        <div class="d-flex justify-content-between p-4">
                            <input type="button" name="previous"
                                class="previous-form-steps btn btn-secondary action-button-previous" value="Previous" />
                            <input type="submit" name="next" class="next-form-steps btn btn-primary action-button-next"
                                value="Continue" />
                        </div>
                    </div>

                    <div class="cont_tap" id="sending">
                        <div class="d-flex justify-content-center p2">
                            <img src="{{ URL::asset('img/dashboard/system/loading-dash.svg') }}" style="width: 195px;"
                                alt="Loading" />
                        </div>
                    </div>

                </form>
            </div>

        </div>

    </div>
</div>

@endsection

<!-- js insert -->
@section('js')

<!-- select 2 -->
<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('.js-example-basic-single').select2();
        //hide search
        $('.select2-no-search').select2({
            minimumResultsForSearch: -1
        });
    });

</script>

<!-- jquery ui datepicker -->
<script type="text/javascript"
    src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
<script>
    $(function() {
        $('.hasdatetimepicker').datepicker({
            todayHighlight: true
            , format: "yyyy-mm-dd"
        , });
    });

</script>

<!-- validate jquery -->
<script src="https://fastly.jsdelivr.net/npm/jquery-validation@1.19.3/dist/jquery.validate.min.js"
    type="text/javascript">
</script>
<script>
    //Rules for the Validator plugin
    var $validator = $('#myform').validate({
        rules: {
            first_name: {
                minlength: 3
            , }
            , second_name: {
                minlength: 3
            , }
            , email: {
                email: true
            , }
            , newpassword: {
                minlength: 7
                , maxlength: 100
            , }
            , newpassword_confirmation: {
                minlength: 7
                , maxlength: 100
                , equalTo: '#password'
            , }
        , }
        , messages: {
            email: {
                required: "We need your email address to contact you"
                , email: "Your email address must be in the format of name@domain.com"
            }
            , password_confirmation: {
                equalTo: "Password does not match"
            , }
        },
        //for inserting erros for some inputs that makes posation problem such as selector 2 and bt datapicker
        errorPlacement: function(error, element) {
            switch (element.attr("name")) {
                case 'role':
                    error.insertAfter($("#role-js-error-valid"));
                    break;
                case 'first_branch_id':
                    error.insertAfter($("#first_branch_id-js-error-valid"));
                    break;
                case 'gendar':
                    error.insertAfter($("#gendar-js-error-valid"));
                    break;
                case 'birthday':
                    error.insertAfter($("#birthday-js-error-valid"));
                    break;
                case 'country_id':
                    error.insertAfter($("#country-js-error-valid"));
                    break;
                case 'city_id':
                    error.insertAfter($("#city-js-error-valid"));
                    break;

                case 'started_work':
                    error.insertAfter($("#startedwork-js-error-valid"));
                    break;
                case 'phone_number':
                    error.insertAfter($("#phonenumber-js-error-valid"));
                    break;
                case 'sec_phone_number':
                    error.insertAfter($("#secphonenumber-js-error-valid"));
                    break;
                case 'deactivate':
                    error.insertAfter($("#deactivate-js-error-valid"));
                    break;

                default:
                    error.insertAfter(element);
            }

        }
    , });

</script>
<script>
    //for country and cities ajax inputs
    $('select[name="country_id"]').on('change', function(e) {
        e.preventDefault();

        var countryID = $(this).val();

        var url = "{{ route('sett.pat_createcityajax', ':id') }}";
        url = url.replace(':id', encodeURI(countryID));

        if (countryID) {
            $.ajax({
                url: url
                , type: "GET"
                , dataType: "json"
                , success: function(data) {
                    $('select[name="city_id"]').empty();
                    $.each(data, function(key, value) {
                        $('select[name="city_id"]').append('<option value="' +
                            value.id + '">' + value.name + '</option>');
                    });
                }
            });
        } else {
            $('select[name="city_id"]').empty();
        }
    });


    fetchAskFor();

    //for country and cities ajax inputs
    function fetchAskFor(ask_for_main_id = $('select[name="ask_for_main_id"]').val()) {

        var url = "{{ route('sett.pat_create_askfor_ajax', ':id') }}";
        url = url.replace(':id', ask_for_main_id);

        if (ask_for_main_id) {
            $.ajax({
                url: url
                , type: "GET"
                , dataType: "json"
                , success: function(data) {
                    $('select[name="ask_for_id"]').empty();
                    $.each(data, function(key, value) {
                        $('select[name="ask_for_id"]').append('<option value="' +
                            value.id + '">' + value.name + '</option>');
                    });
                }
            });
        } else {
            $('select[name="ask_for_id"]').empty();
        }
    }

    $('select[name="ask_for_main_id"]').on('change', function(e) {
        var ask_for_main_id = $(this).val();
        fetchAskFor(ask_for_main_id)
    });

</script>


<!-- international telephone input -->
<script src="{{ URL::asset('plugins/intltelinput/intlTelInput.min.js') }}"></script>

<script>
    //to enable international telephone input (#int-miphone) is where we need to insert it
    const phoneInputField = document.querySelector("#int-miphone");
    const phoneInput = window.intlTelInput(phoneInputField, {
        //preferred countries https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2
        preferredCountries: ["eg", "sa", "ae", "qa"]
        , utilsScript: "{{ URL::asset('plugins/intltelinput/utils.js') }}"
    , });
    const phoneInputField2 = document.querySelector("#int-miphone2");
    const phoneInput2 = window.intlTelInput(phoneInputField2, {
        //preferred countries https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2
        preferredCountries: ["eg", "sa", "ae", "qa"]
        , utilsScript: "{{ URL::asset('plugins/intltelinput/utils.js') }}"
    , });

</script>



@endsection