<?php

namespace App\Models\Patient;

use App\Models\Branch\Appointment;
use App\Models\Branch\Branch;
use App\Models\Invoice\Invoice_item;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service_package extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'services_cat_id',
        'patient_id',
        'type',
        'items_number',
        'items_number_left',
        'date',
    ];
    
    public $timestamps = false;

    public function service_item()
    {
        return $this->belongsTo(Service_item::class, 'services_cat_id', 'id');
    }

    public function invoice_item()
    {
        return $this->morphOne(Invoice_item::class, 'itemable');
    }

}