<?php

namespace App\Models\Patient;

use App\Models\Branch\Appointment;
use App\Models\Branch\Branch;
use App\Models\Invoice\Invoice_item;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pulse extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'services_cat_id',
        'pulses_machine_id',
        'appointment_id',
        'patient_id',
        'doctor_id',
        'branch_id',
        'type', //(0- add session, 1- taken from session package, 2- taken from pulses package)
        'status', //(0 not done, 1= done)
        'fluence',
        'pulse_area_id',
        'spot_size',
        'balance_before_session',
        'used_pulses',
        'package_id',
        'date',
    ];
    
    public function service_item()
    {
        return $this->belongsTo(Service_item::class, 'services_cat_id', 'id');
    }

    public function appointment()
    {
        return $this->belongsTo(Appointment::class, 'appointment_id', 'id');
    }

    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id', 'id');
    }
   
    public function doctor()
    {
        return $this->belongsTo(User::class, 'doctor_id', 'id');
    }
   
    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'id');
    } 

    public function pulse_area()
    {
        return $this->belongsTo(Pulse_area_cat::class, 'pulse_area_id', 'id');
    }

    public function invoice_item()
    {
        return $this->morphOne(Invoice_item::class, 'itemable');
    }

    public function machine()
    {
        return $this->belongsTo(Pulses_machine::class, 'pulses_machine_id', 'id');
    }


    public function package()
    {
        return $this->belongsTo(Service_package::class, 'package_id', 'id');
    }

}