<?php

namespace App\Models\Invoice;

use App\Models\Patient\Service_inv_cat;
use App\Models\Patient\Specialty_cat;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Expenses_item extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'specialty_id',
        'service_inv_cat_id',
        'name',
        'price',
    ];
    
    public $timestamps = false;
    
    public function specialty()
    {
        return $this->belongsTo(Specialty_cat::class, 'specialty_id', 'id');
    }

    public function service_inv_cat()
    {
        return $this->belongsTo(Service_inv_cat::class, 'service_inv_cat_id', 'id');
    }

}