<?php

namespace App\Models\Invoice;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Debtor extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'first_name',
        'second_name',
        'avatar',
        'company_name',
    ];

    public $timestamps = false;

    public function invoice()
    {
        return $this->morphOne(Invoice::class, 'receivable');
    }

    
}