<?php

namespace App\Models\Branch;

use App\Models\Branch\Appointment\Rate_appointment;
use App\Models\Branch\Branch;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\Invoice_item;
use App\Models\Patient\Disease;
use App\Models\Patient\Disease_draw;
use App\Models\Patient\Medicine;
use App\Models\Patient\Patient;
use App\Models\Patient\Service_item;
use App\Models\Patient\Session_pat;
use App\Models\Patient\Specialty_cat;
use App\Models\Patient\Treatment;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Appointment extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'code',
        'specialty_id',
        'branch_id',
        'unit_id',
        'patient_id',
        'doctor_id',
        'services_cat_id',
        'start_at',
        'end_at',
        'note',
        'note_doctor',
        'creator_id',
        'last_update_person_id',
        'status', //(not accepted = 0, accepted = 1, arrived = 2, with doctor = 3, done = 4, not responding = 5, canceled = 6)
        'queue_show',
        'rate',
        'meet_start_url',
        'meet_join_url',
        'calendar_index',
    ];

    public function specialty()
    {
        return $this->belongsTo(Specialty_cat::class, 'specialty_id', 'id');
    }

    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id', 'id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'id');
    }

    public function unit()
    {
        return $this->belongsTo(Unit::class, 'unit_id', 'id');
    }

    public function doctor()
    {
        return $this->belongsTo(User::class, 'doctor_id', 'id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'creator_id', 'id');
    }

    public function last_update_person()
    {
        return $this->belongsTo(User::class, 'last_update_person_id', 'id');
    }

    public function service_item()
    {
        return $this->belongsTo(Service_item::class, 'services_cat_id', 'id');
    }

    public function invoice_item()
    {
        return $this->morphOne(Invoice_item::class, 'itemable');
    }

    // -------- many relations --------

    public function diseases()
    {
        return $this->morphOne(Disease::class, 'calendable');
    }

    public function disease_draws()
    {
        return $this->morphOne(Disease_draw::class, 'calendable');
    }

    public function treatments()
    {
        return $this->hasMany(Treatment::class, 'appointment_id', 'id');
    }

    public function sessions()
    {
        return $this->hasMany(Session_pat::class, 'appointment_id', 'id');
    }

    public function medicines()
    {
        return $this->hasMany(Medicine::class, 'appointment_id', 'id');
    }

    public function labs()
    {
        return $this->hasMany(Lab::class, 'appointment_id', 'id');
    }

    public function rate()
    {
        return $this->hasOne(Rate_appointment::class, 'appointment_id', 'id');
    }

    public function rate_report()
    {
        return $this->hasMany(Rate_appointment::class, 'appointment_id', 'id');
    }
}