<?php

namespace App\Http\Controllers\Patient;

use App\Http\Controllers\Controller;
use App\Models\Branch\Appointment;
use App\Models\Branch\Branch;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\Invoice_item;
use App\Models\Patient\Patient;
use App\Models\Patient\Pulse;
use App\Models\Patient\Pulses_machine;
use App\Models\Patient\Pulses_machine_rec;
use App\Models\Patient\Service_item;
use App\Models\Patient\Service_package as PatientService_package;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\Rule;

class Service_package extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $this->validate($request, [
            'package_service_item_cat' => ['required', 'exists:service_items,id'],
            'last_appointment_id' => ['required', 'exists:appointments,id'],
        ]);

        //sessions
        $appo_branch = Appointment::select('branch_id')->find($request->input('last_appointment_id'));

        $service_id = $request->input('package_service_item_cat');

        $service_inv_cat = Service_item::where('id', $service_id)->where('deactivate', 0)->first();

        if ($request->input('old_new_package') == 1) {
            $invoice = Invoice::create([
                'code' => "IN" . $this->generateRandomString(6),
                'service_inv_cat_id' => $service_inv_cat->service_inv_cat_id,
                'specialty_id' => Auth::user()->specialty_id,
                'receivable_id' => $request->input('patient_id'),
                'receivable_type' => "App\Models\Patient\Patient",
                'branch_id' => $appo_branch->branch_id,
                'items_price' => $service_inv_cat->price,
                'final_price' => $service_inv_cat->price,
                'note' => $request->input('invoice_note'),
            ]);
        }
        //create pulses for patient
        $package = PatientService_package::create([
            'services_cat_id' => $service_id,
            'patient_id' => $request->input('patient_id'),
            'doctor_id' => $request->input('responsible_doc_pulses'),
            'type' => $service_inv_cat->package,
            'items_number' => $service_inv_cat->package_items_number,
            'items_number_left' => $service_inv_cat->package_items_number,
            'date' => date('Y-m-d'),
        ]);


        //if the package is pulses
        if ($service_inv_cat->package == 2) {
            $patient = Patient::select('id', 'balance')->find($request->input('patient_id'));
            $patient->increment('balance', $service_inv_cat->package_items_number);
            $patient->save();
        };

        if ($request->input('old_new_package') == 1) {
            $invoice_item = Invoice_item::create([
                'invoice_id' => $invoice->id,
                'itemable_id' => $package->id,
                'itemable_type' => "App\Models\Patient\Service_package",
                'categorizable_id' => $service_id,
                'categorizable_type' => "App\Models\Patient\Service_item",
                'price' => $service_inv_cat->price,
                'sold_price' => $service_inv_cat->price,
            ]);
        }


        session()->flash('success', 'The package has been created successfully');
        return redirect()->back();
    }

    public function generateRandomString($length = 20)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'pulses_id_update' => ['required', 'exists:pulses,id'],
            'fluence_update' => ['required'],
            'pulse_area_id_update' => ['required', 'exists:pulse_area_cats,id'],
            'spot_size_update' => ['required'],
            'used_pulses_update' => ['required'],
        ]);

        $pulses = Pulse::find($request->input('pulses_id_update'));

        $patient = Patient::select('id', 'balance')->find($pulses->patient_id);
        $patient->increment('balance', $pulses->used_pulses);
        $patient->save();

        $pulses->fluence = $request->input('fluence_update');
        $pulses->pulse_area_id = $request->input('pulse_area_id_update');
        $pulses->spot_size = $request->input('spot_size_update');
        $pulses->used_pulses = $request->input('used_pulses_update');
        $pulses->save();

        $patient = Patient::select('id', 'balance')->find($pulses->patient_id);
        $patient->decrement('balance', $request->input('used_pulses_update'));
        $patient->save();

        session()->flash('success', 'The session has been updated');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $id = $request->input('package_id_delete');
        $pulses = PatientService_package::find($id);

        $status = PatientService_package::whereHas('invoice_item', function ($q) {
            $q->whereHas('invoice', function ($q) {
                $q->where('status', 0);
            });
        })
            ->find($id);

        $invoice_items = Invoice_item::where('invoice_id', $status->invoice_item->invoice->id)->count();

        //if there is only pulses in the invoice (no other items)
        if ($invoice_items == 1) {
            if (!empty($status)) {
                Invoice_item::find($status->invoice_item->id)->delete();
                Invoice::find($status->invoice_item->invoice->id)->delete();
                PatientService_package::find($id)->delete();
                Pulse::where('package_id', $id)->delete();
                session()->flash('success', 'The session has been deleted');
                return redirect()->back();

                //decremnt the patient balance
                $patient = Patient::select('id', 'balance')->find($pulses->patient_id);
                //to withdraw pulses balance to the patient balance 
                $patient->decrement('balance', $pulses->items_number);
                $patient->save();
            } else {
                session()->flash('error_delete', 'The session can not before, it is paid');
                return redirect()->back();
            }
        } else {
            session()->flash('error_delete', 'there are other items in invoice');
            return redirect()->back();
        }

        session()->flash('success', 'The session has been deleted');
        return redirect()->back();
    }
}
