#!/bin/sh

# Script: init.server.sh
# Purpose: 
#   Install and configure the server
#   Install the dependancies 
#   Configure the web server (nginx/apache)

echo "Deploying Laam API Server..."

# NOTE: The repository files should be cloned into /var/www/laam-api
# NOTE: .env file should be created in /var/www/laam-api

# Update the package list and install server dependancies
echo "Updating the package list and installing server dependancies..."
apt update && apt upgrade
apt install -y curl wget net-tools git 

# Instal php and php dependancies
echo "Installing PHP and PHP dependancies..."
apt install -y php php-cli php-fpm php-mysql php-xml php-mbstring php-gd php-zip php-curl

# Install composer
echo "Installing Composer..."
apt install -y composer

# Install the web server
echo "Installing Apache..."
apt install -y apache2

# Copy laam.conf (apache configuration) to /etc/apache2/sites-available/
echo "Copying the laam.conf file to /etc/apache2/sites-available/..."
cp ./resources/laam.conf /etc/apache2/sites-available/

# Copy the JsonResource.php file to the Laravel Resources folder to fix vendor pagination issue
echo "Copying the JsonResource.php file to the Laravel Resources folder..."
cp ./resources/JsonResource.php /var/www/laam-api/vendor/laravel/framework/src/Illuminate/Http/Resources/Json/

# Grant permissions to the web server user, and set the correct permissions
echo "Granting permissions to the web server user, and setting the correct permissions..."
chown -R www-data /var/www/laam-api
chmod -R 755 /var/www/laam-api

# Run Composer install
echo "Running Composer install..."
composer install

# Disable the default site and enable the laam-api site
echo "Disabling the default site and enabling the laam-api site..."
a2dissite 000-default.conf

# Enable the laam-api site
echo "Enabling the laam-api site..."
a2ensite laam.conf

# Enable the rewrite module
echo "Enabling the rewrite module..."
a2enmod rewrite

# Enable the proxy and proxy_http modules
echo "Enabling the proxy and proxy_http modules..."
a2enmod proxy

# Enable the proxy_http module
echo "Enabling the proxy_http module..."
a2enmod proxy_http

# Restart the apache server
echo "Restarting the Apache server..."
systemctl restart apache2

# Output the server status
echo "Server status:"
systemctl status apache2

echo "Laam API Server deployed successfully!"

