<?php

use App\Http\Controllers\Api\TeacherDashboard\NamazegTeacherController;
use App\Http\Controllers\Api\TeacherDashboard\ReportController;
use App\Http\Controllers\Api\TeacherDashboard\TeacherSettingController;
use App\Http\Controllers\Api\TeacherDashboard\SupervisionCommiteeController;
use App\Http\Controllers\Api\TeacherDashboard\StudentAttendance\TeacherStudentAttendanceController;
use Illuminate\Support\Facades\Route;



Route::group(['prefix' => 'teacher-dashboard', 'middleware' => ['jwt.verify']], function () {

    Route::group(['prefix' => 'student-attendance', 'controller' => TeacherStudentAttendanceController::class], function () {
        Route::get('get-date-periods', 'getDatePeriods');
        Route::get('get-period-details', 'getPeriodDetails');
        Route::get('get-day-period-students', 'getDayPeriodStudents');
        Route::post('change-period-attendance-status', 'changePeriodAttendanceStatus');
        Route::post('make-all-period-students-absent', 'makeAllPeriodStudentsAbsent');
    });

    Route::group(['prefix' => 'settings', 'controller' => TeacherSettingController::class], function () {
        Route::post('change-password', 'changePassword');
        Route::get('index-page/{schoolId}', 'indexPage');
    });


    Route::group(['prefix' => 'namazeg', 'controller' => NamazegTeacherController::class], function () {
        Route::get('school/{school}/className/{className}', 'get_classes');
        Route::get('/{schedualData}/details', 'get_schedual_details');
    });


    Route::get('supervision-committee', SupervisionCommiteeController::class);


    Route::group(['prefix' => 'report', 'controller' => ReportController::class], function () {
        Route::post('student-absent-late-report', 'studentAbsentLateReport');
    });






});
