<?php

use App\Http\Controllers\Api\ManagerDashboard\Namazeg\NamazegController;
use App\Http\Controllers\Api\ManagerDashboard\Namazeg\NamazegDataController;
use Illuminate\Support\Facades\Route;



Route::group(['prefix' => 'namazeg', 'controller' => NamazegController::class], function () {

    Route::group(['prefix' => 'manager'], function () {

        //سجل دوام الموظفات
        Route::get('circular-attendance/{school_id}', 'circular_attendance');

        //بيان إطلاع الموظفات على التعاميم
        Route::get('circular-attendance-report/school/{school_id}', 'get_circular_attendance_report');
        Route::post('circular-attendance-report/school/{school_id}', 'store_circular_attendance_report');
        Route::post('circular-attendance-report-delete/{NamazegCircularAttendance}', 'delete_circular_attendance_report');
        
        //خطة المديرة
        Route::get('plans/school/{school_id}', 'get_manager_plans');
        Route::get('pointments-notes/school/{school}/semester/{semester}', 'get_tasks_plans');
        Route::post('plans/school/{school_id}/plan/{manager_plane_id}', 'store_manager_plans');
        Route::post('plans/school/{school_id}/plan/{manager_plane_id}/update', 'update_manager_plans');
        Route::post('plans/school/delete/{NamazegManagerPlane}', 'delete_manager_plans');
        
        Route::get('media-suggestions/school/{school}/semester/{semester}', 'get_media_suggestions');
        Route::post('media-suggestions/school/{school}/semester/{semester}', 'store_media_suggestions');
    });

    Route::group(['prefix' => 'teachingThing'], function () {

        //سجل متابعة آداء المعلمة
        Route::get('teacher-performance/school/{school_id}', 'get_teacher_performance');
        Route::post('teacher-performance/school/{school_id}', 'store_teacher_performance');
        Route::post('teacher-performance-delete/{NamazegTeacherPerformanceFollow}', 'delete_teacher_performance');
        
        
        //تكليف فريق مجتمعات التعلم المهنية
        Route::get('assign-professional-communities/school/{school_id}', 'get_assign_professional_communities');
        Route::post('assign-professional-communities/school/{school_id}', 'store_assign_professional_communities');
        Route::post('assign-professional-communities/update/{ProfessionalCommunities}', 'update_assign_professional_communities');
        Route::post('assign-professional-communities-delete/{AssignProfessionalCommunities}', 'delete_assign_professional_communities');
        
        //مساءلة
        Route::get('questioning/school/{school_id}', 'get_questioning');
        Route::post('questioning/school/{school_id}', 'store_questioning');
        Route::post('questioning/update/{NamazegQuestioning}', 'update_questioning');
        Route::post('questioning-delete/{NamazegQuestioning}', 'delete_questioning');
        
        //سجلات متابعة
        Route::get('records/school/{school_id}', 'get_records');
    });
    
    Route::group(['prefix' => 'studentThing'], function () {
        //نموذج الالتزام المدرس
        Route::get('school-commitment/school/{school_id}', 'get_school_commitment');
        Route::post('school-commitment/school/{school_id}', 'store_school_commitment');
        Route::post('school-commitment-delete/{NamazegSchoolCommitment}', 'delete_school_commitment');
        
        //الخطة العامة لأنشطة حصص الاتقان للعام الدراسي
        Route::get('class-plan-activity/school/{school_id}', 'get_ClassPlanActivity');
        Route::post('class-plan-activity/school/{school_id}', 'store_ClassPlanActivity');
        Route::post('class-plan-activity/update/{NamazegClassPlanActivity}', 'update_ClassPlanActivity');
        Route::post('class-plan-activity-delete/{ClassPlanActivity}', 'delete_ClassPlanActivity');
        
        //التقرير الختامي لحصص الاتقان للعام الدراسي
        Route::get('report-class-plan-activity/school/{school_id}', 'get_ReportClassPlanActivity');
        Route::post('report-class-plan-activity/school/{school_id}', 'store_ReportClassPlanActivity');
        Route::post('report-class-plan-activity/update/{NamazegFinalReportClassActivity}', 'update_ReportClassPlanActivity');
        Route::post('report-class-plan-activity-delete/{FinalReportClassActivity}', 'delete_ReportClassPlanActivity');
        
        //قبول طالبة
        Route::get('accept-student/school/{school_id}', 'get_accept_student');
        Route::post('accept-student/school/{school_id}', 'store_accept_student');
        Route::post('accept-student/update/{NamazegAcceptStudent}', 'update_accept_student');
        Route::post('accept-student-delete/{NamazegAcceptStudent}', 'delete_accept_student');
        
        //طلب تحويل من مدارس تحفيظ القرآن الكريم والمعاهد العلمية للتعليم العام
        Route::get('transform-quran-student/school/{school_id}', 'get_transform_quran_student');
        Route::post('transform-quran-student/school/{school_id}', 'store_transform_quran_student');
        Route::post('transform-quran-student/update/{namozeg_data_id}', 'update_transform_quran_student');
        Route::post('transform-quran-student-delete/{TransformQuranStudent}', 'delete_transform_quran_student');
        
        //استمارة البيانات الشخصية للطالبة
        Route::get('student-data/school/{school_id}', 'get_student_data');
        Route::post('student-data/school/{school_id}', 'store_student_data');
        Route::post('student-data-delete/{NamazegStudentData}', 'delete_student_data');
        
        
        //كشف تسليم الكتب المقررة 
        Route::get('books-delivery/school/{school_id}', 'get_books_delivery');
        Route::post('books-delivery/school/{school_id}', 'store_books_delivery');
        Route::post('books-delivery-delete/{NamazegBooksDelivery}', 'delete_books_delivery');
        
        
        //إجراءات المتابعة على مستوى المدرسة لحالة طالبة 224
        Route::get('student-follow/school/{school_id}', 'get_student_follow');
        Route::post('student-follow/school/{school_id}', 'store_student_follow');
        Route::post('student-follow/update/{NamazegStudentFollow}', 'update_student_follow');
        Route::post('student-follow-delete/{NamazegStudentFollow}', 'delete_student_follow');
    });

    Route::group(['prefix' => 'schoolThing'], function () {
        //168 سجل استئذان الموظفة أثناء الدوام
        Route::get('teacher-excuse/school/{school_id}', 'get_teacher_excuse');
        Route::post('teacher-excuse/school/{school_id}', 'store_teacher_excuse');
        Route::post('teacher-excuse-delete/{teacher_excuse}', 'delete_teacher_excuse');
        
        
        //مساءلة غياب  169
        Route::get('absence-questioning/school/{school_id}', 'get_absence_questioning');
        Route::post('absence-questioning/school/{school_id}', 'store_absence_questioning');
        Route::post('absence-questioning/update/{absence_questioning}', 'update_absence_questioning');
        Route::post('absence-questioning/{absence_questioning}/action', 'action_absence_questioning');
        Route::post('absence-questioning-delete/{absence_questioning}', 'delete_absence_questioning');
        
        //قرار مساءلة غياب  170
        Route::get('absence-descion-confirm/school/{school_id}', 'get_absence_descion_confirm');
        Route::post('absence-descion-confirm/school/{school_id}', 'store_absence_descion_confirm');
        Route::post('absence-descion-confirm/update/{NamazegAbsenceDescionConfirm}', 'update_absence_descion_confirm');
        Route::post('absence-descion-confirm-delete/{absence_descion_confirm}', 'delete_absence_descion_confirm');
        
        //تنبيه عن تأخر / انصراف 171
        Route::get('notify-late-leaving/school/{school_id}', 'get_notify_late_leaving');
        Route::post('notify-late-leaving/school/{school_id}', 'store_notify_late_leaving');
        Route::post('notify-late-leaving/update/{NamazegNotifyLateLeaving}', 'update_notify_late_leaving');
        Route::post('notify-late-leaving-delete/{notify_late_leaving}', 'delete_notify_late_leaving');
        
        //قرار حسم مجموع ساعات تأخر و خروج مبكر 172
        Route::get('descion-sum-hours/school/{school_id}', 'get_descion_sum_hours');
        Route::post('descion-sum-hours/school/{school_id}', 'store_descion_sum_hours');
        Route::post('descion-sum-hours/update/{DescionSumhoursLateleaving}', 'update_descion_sum_hours');
        Route::post('descion-sum-hours-delete/{descion_sum_hours}', 'delete_descion_sum_hours');
        
        //رصد غياب و تأخر المعلمات 177
        Route::get('monitoring-absence-teacher/school/{school_id}', 'get_monitoring_absence_teacher');
        Route::post('monitoring-absence-teacher/school/{school_id}', 'store_monitoring_absence_teacher');
        Route::post('monitoring-absence-teacher-delete/{monitoring_absence_teacher}', 'delete_monitoring_absence_teacher');
        
        // سجل جرد المعامل 164
        Route::get('labInventory-record/school/{school_id}', 'get_labInventory_record');
        Route::post('labInventory-record/school/{school_id}', 'store_labInventory_record');
        Route::post('labInventory-record-delete/{labInventory_record}', 'delete_labInventory_record');
        
        // سجل تنفيذ التجارب العلمية 166
        Route::get('experment-excution-record/school/{school_id}', 'get_experment_excution_record');
        Route::post('experment-excution-record/school/{school_id}', 'store_experment_excution_record');
        Route::post('experment-excution-record-delete/{experment_excution_record}', 'delete_experment_excution_record');
        
        // سجل جرد المختبر و المواد الكيميائية 179
        Route::get('chemist-labInventory-record/school/{school_id}', 'get_chemist_labInventory_record');
        Route::post('chemist-labInventory-record/school/{school_id}', 'store_chemist_labInventory_record');
        Route::post('chemist-labInventory-record-delete/{chemist_labInventory_record}', 'delete_chemist_labInventory_record');
        
        //  18سجل الزائد و الناقص و التالف0 
        Route::get('excessDamage-record/school/{school_id}', 'get_excessDamage_record');
        Route::post('excessDamage-record/school/{school_id}', 'store_excessDamage_record');
        Route::post('excessDamage-record-delete/{excessDamage_record}', 'delete_excessDamage_record');
        
        //  163 سجل استلام عهدة
        Route::get('reciept-record/school/{school_id}', 'get_reciept_record');
        Route::post('reciept-record/school/{school_id}', 'store_reciept_record');
        Route::post('reciept-record-delete/{reciept_record}', 'delete_reciept_record');
        
        //  167 استمارة موافقة ولي أمر الطالبة للاشتراك في النقل المدرسي
        Route::get('guardian-trans-from/school/{school_id}', 'get_guardian_trans_from');
        Route::post('guardian-trans-from/school/{school_id}', 'store_guardian_trans_from');
        Route::post('guardian-trans-from-delete/{guardian_trans_from}', 'delete_guardian_trans_from');
        
        //  165 الخطة الفصلية للتجارب العلمية
        Route::get('experments-plan/school/{school_id}', 'get_experments_plan');
        Route::post('experments-plan/school/{school_id}', 'store_experments_plan');
        Route::post('experments-plan-delete/{experments_plan}', 'delete_experments_plan');
        
        //  162 طلب صيانة
        Route::get('maintenance-form/school/{school_id}', 'get_maintenance_form');
        Route::post('maintenance-form/school/{school_id}', 'store_maintenance_form');
        Route::post('maintenance-form/update/{NamazegMaintenanceForm}', 'update_maintenance_form');
        Route::post('maintenance-form-delete/{maintenance_form}', 'delete_maintenance_form');
        
        //  189 قرير خطة الإخلاء
        Route::get('evacuation-planReport/school/{school_id}', 'get_evacuation_planReport');
        Route::post('evacuation-planReport/school/{school_id}', 'store_evacuation_planReport');
        Route::post('evacuation-planReport/update/{EvacuationPlanReport}', 'update_evacuation_planReport');
        Route::post('evacuation-planReport/delete-image', 'delete_image_evacuation_planReport');
        Route::post('evacuation-planReport-delete/{evacuation_planReport}', 'delete_evacuation_planReport');
        
        //  230 استئذان معلمة أثناء الدوام الرسمي
        Route::get('teacher-excuse-workday/school/{school_id}', 'get_teacher_excuse_workday');
        Route::post('teacher-excuse-workday/school/{school_id}', 'store_teacher_excuse_workday');
        Route::post('teacher-excuse-workday/update/{NamazegTeacherExcuse}', 'update_teacher_excuse_workday');
        Route::post('teacher-excuse-workday-delete/{teacher_excuse_workday}', 'delete_teacher_excuse_workday');
    });

    Route::get('school/{school_id}/get-data/{serial_number?}', 'get_namozeg_data');
   
});
Route::group(['prefix' => 'namazegData', 'controller' => NamazegDataController::class], function () {

    Route::get('school/{school_id}/get-data/{form_number}', 'get_data');
    
});
