<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\User\EmailVerificationController;


///////// user operations urls/////////////////
Route::group(['prefix' => 'auth', 'namespace' => 'User'], function () {

    Route::post('login', 'AuthController@authenticate');
    Route::post('verfiy-login', 'AuthController@verfiyLogin');
    Route::post('refreshToken', 'AuthController@refreshToken');
    Route::post('validateToken', 'AuthController@validateToken');
    Route::post('register', 'AuthController@register');
    Route::post('account-verfication', 'AuthController@accountVerfication');
    Route::post('send-reset-password-otp-via-email', 'AuthController@sendResetPasswordOtpViaEmail');
    Route::post('reset-password-verfication', 'AuthController@resetPasswordVerfication');

    Route::post('send-reset-password-otp-via-sms', 'AuthController@sendResetPasswordOtpViaSms');
    Route::post('resend-otp', 'AuthController@resndOtp');

});

////// routes group that need to be authorized user//////
Route::group(['middleware' => ['jwt.verify']], function () {
    Route::group(['prefix' => 'user', 'namespace' => 'User'], function () {

        /* return user info */
        Route::get('profile', 'UserController@getUserProfile');
        Route::post('update-profile', 'UserController@updateUserProfile');
        Route::post('change-password', 'UserController@changePassword');
        Route::post('reset-password', 'AuthController@resetPassword');

        Route::get('roles', 'UserController@getRoles');
        Route::post('change-status', 'UserController@changeStatus');
        Route::get('get-all-admins', 'UserController@getAllAdmins');
        Route::post('create-new-admin', 'UserController@createNewAdmin');
        Route::post('update-admin ', 'UserController@createNewAdmin');
        Route::post('removeUser', 'AuthController@removeUser');
        Route::get('get-user-account/{userId}', 'UserController@getUserAccount');



        /*  permissions url */
        Route::get('permissions/get-super-admin-permissions', 'PermissionController@SuperAdminPermissions');
        Route::get('permissions/get-school-manager-permissions', 'PermissionController@SchoolManagerPermissions');
        Route::post('permissions/create-pemission', 'PermissionController@store');
        Route::post('permissions/update-pemission-group', 'PermissionController@updatePermissionGroup');
        Route::post('permissions/update-pemission', 'PermissionController@updatePermission');
        Route::post('permissions/delete-pemission-group', 'PermissionController@deletePermissionGroup');
        Route::post('permissions/delete-pemission', 'PermissionController@deletePermission');

        /*  permissions url */
        Route::get('roles/get-all', 'RoleController@getAll');
        Route::post('roles/create', 'RoleController@store');
        Route::post('roles/update', 'RoleController@update');
        Route::post('roles/delete', 'RoleController@delete');
        Route::get('roles/{id}/details','RoleController@getById');


        /** email verfication url**/
        Route::post('email/verify-notification','EmailVerificationController@sendVerificationEmail');
        Route::get('email/is-verified','EmailVerificationController@isVerified');

    });

});

Route::get('/email/verify/{id}/{hash}', [EmailVerificationController::class, 'verify'])->name('verification.verify');


