<?php

use App\Http\Controllers\Api\AdminDashboard\Finances\BankTransferController;
use App\Http\Controllers\Api\AdminDashboard\Finances\SubscriptionDetailsRetrievalController;
use App\Http\Controllers\Api\AdminDashboard\Finances\TransactionPaymentGatewayController;
use App\Http\Middleware\UpdateLastSeen;
use Illuminate\Support\Facades\Route;




Route::prefix('finances')->group(function () {

    Route::group(['prefix' => 'bank-transfer/', 'controller' => BankTransferController::class], function () {
        Route::get('/get-all','index');
        Route::get('subscriptions/{subscription}/details','show');
        Route::post('subscriptions/{subscription}/confirm', 'confirm');
        Route::post('subscriptions/{subscription}/refuse', 'refuse');
        Route::get('export','export')->withoutMiddleware([UpdateLastSeen::class]);;
    });

    Route::group(['prefix' => 'transactions-payment-gateway/', 'controller' => TransactionPaymentGatewayController::class], function () {
        Route::get('/get-all','index');
        Route::get('subscriptions/{subscription}/details','show');
        Route::get('export','export')->withoutMiddleware([UpdateLastSeen::class]);;
    });

    Route::group(['prefix' => 'subscriptions/{subscription}/subscription-details-retrieval', 'controller' => SubscriptionDetailsRetrievalController::class], function () {
        Route::post('store','store');
        Route::get('show','show');
    });




});

