<?php

use App\Http\Controllers\Api\AdminDashboard\Category\CategoryController;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'categories/', 'controller' => CategoryController::class], function () {
    Route::get('get-all', 'getAll');
    Route::post('store', 'store');
    Route::get('{category}/details', 'getById');
    Route::get('{category}/edit', 'edit');
    Route::post('{category}/update', 'update');
    Route::post('{category}/changeStatus', 'changeStatus');
    Route::delete('{category}/archive', 'archive');
    Route::delete('{category}/destroy', 'destroy')->withTrashed();
    Route::get('{category}/restore', 'restore')->withTrashed();
});

