<?php

namespace Database\Seeders;

use App\Models\AdminDashboard\School\SchoolGrade;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\GradeViolation;
use App\Models\Violation;

class ViolationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {


        $names = ['المخالفات السلوكية الحضورية', 'المخالفات السلوكية عن بعد', 'المخالفات السلوكية تجاه الهيئة التعليمية و الإدارية '];
        $school_grades =  SchoolGrade::all();
        foreach ($school_grades as $school_grade) {
            foreach ($names as $name) {
                $Violation_check = Violation::where('name', 'like', '%' . $name . '%')
                    ->where('school_grade_id', $school_grade->id)->first();
                if (!$Violation_check) {
                    Violation::create(['name' => $name, 'school_grade_id' => $school_grade->id]);
                }
            }
        }
    }
}
