<?php

namespace Database\Seeders;

use App\Models\AdminDashboard\School\Subject;
use Carbon\Carbon;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SubjectSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $subjects = [
            ['name' => 'أصول الفقه', 'school_grade_id' => 3],
            ['name' => 'أنظمة جسم الإنسان', 'school_grade_id' => 3],
            ['name' => 'إدارة الفعاليات', 'school_grade_id' => 3],
            ['name' => 'إنترنت الأشياء', 'school_grade_id' => 3],
            ['name' => 'الأحياء', 'school_grade_id' => 3],
            ['name' => 'الأمن السيبراني', 'school_grade_id' => 3],
            ['name' => 'الإحصاء', 'school_grade_id' => 3],
            ['name' => 'الإدارة المالية', 'school_grade_id' => 3],
            ['name' => 'البحث ومصادر المعلومات', 'school_grade_id' => 3],
            ['name' => 'التاريخ', 'school_grade_id' => 3],
            ['name' => 'التربية الصحية والبدنية', 'school_grade_id' => 3],
            ['name' => 'التربية المهنية', 'school_grade_id' => 3],
            ['name' => 'التفسير', 'school_grade_id' => 3],
            ['name' => 'التفكير الناقد', 'school_grade_id' => 3],
            ['name' => 'التقنية الرقمية', 'school_grade_id' => 3],
            ['name' => 'التصميم الهندسي', 'school_grade_id' => 3],
            ['name' => 'الثقافة الصحية', 'school_grade_id' => 3],
            ['name' => 'الحديث', 'school_grade_id' => 3],
            ['name' => 'الدراسات الاجتماعية', 'school_grade_id' => 3],
            ['name' => 'الدراسات البلاغية والنقدية', 'school_grade_id' => 3],
            ['name' => 'الدراسات النفسية والاجتماعية', 'school_grade_id' => 3],
            ['name' => 'الدراسات الأدبية', 'school_grade_id' => 3],
            ['name' => 'الذكاء الاصطناعي', 'school_grade_id' => 3],
            ['name' => 'الرعاية الصحية', 'school_grade_id' => 3],
            ['name' => 'الرياضيات', 'school_grade_id' => 3],
            ['name' => 'السكرتارية والإدارة المكتبية', 'school_grade_id' => 3],
            ['name' => 'الشريعة الإسلامية', 'school_grade_id' => 3],
            ['name' => 'الصحة العامة', 'school_grade_id' => 3],
            ['name' => 'الفيزياء', 'school_grade_id' => 3],
            ['name' => 'الكيمياء', 'school_grade_id' => 3],
            ['name' => 'الكفايات اللغوية', 'school_grade_id' => 3],
            ['name' => 'المعرفة المالية', 'school_grade_id' => 3],
            ['name' => 'المواطنة الرقمية', 'school_grade_id' => 3],
            ['name' => 'النحو والصرف', 'school_grade_id' => 3],
            ['name' => 'الهندسة', 'school_grade_id' => 3],
            ['name' => 'إدارة الموارد البشرية', 'school_grade_id' => 3],
            ['name' => 'إدارة المشروعات', 'school_grade_id' => 3],
            ['name' => 'إدارة المخاطر', 'school_grade_id' => 3],
            ['name' => 'إدارة المشروعات الصغيرة', 'school_grade_id' => 3],
            ['name' => 'إدارة الخدمات', 'school_grade_id' => 3],
            ['name' => 'إدارة العلاقات العامة', 'school_grade_id' => 3],
            ['name' => 'إدارة المكتبات', 'school_grade_id' => 3],
            ['name' => 'إدارة الفضاء', 'school_grade_id' => 3],
            ['name' => 'إدارة الهندسة', 'school_grade_id' => 3],
            ['name' => 'إدارة الحروب', 'school_grade_id' => 3],
            ['name' => 'إدارة السياسات العامة', 'school_grade_id' => 3],
            ['name' => 'إدارة الحملات التسويقية', 'school_grade_id' => 3],
            ['name' => 'إدارة البرامج', 'school_grade_id' => 3]
        ];

        foreach ($subjects as $subject) {
            DB::table('subjects')->insert([
                'name' => $subject['name'],
                'school_grade_id' => $subject['school_grade_id'],
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'deleted_at' => null
            ]);
        }
    }
}
