<?php

namespace Database\Seeders;

use App\Helpers\Helper;
use App\Http\Controllers\Api\School\SchoolRegistrationController;
use App\Models\AdminDashboard\School\ClassName;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolFacilitie;
use App\Models\AdminDashboard\School\SchoolReference;
use App\Models\AdminDashboard\School\Student;
use App\Models\ManagerDashboard\Settings\Subscription;
use App\Models\User;
use Faker\Factory as Faker;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class SchoolSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $just_admin = true;
        $super_admin = [
            "name" => "admin",
            "email" => "admin@app.laam.sa",
            "phone" => "0512345678",
            "user_type" => "super_admin",
            "status" => "active",
            "password" => Hash::make('123456')
        ];
        $user_managers = [
            [
                "name" => "manager_1",
                "email" => "manager_1@app.laam.sa",
                "phone" => "0512345671",
                "user_type" => "school_manager",
                "status" => "active",
            ],
            [
                "name" => "manager_2",
                "email" => "manager_2@app.laam.sa",
                "phone" => "0512345672",
                "user_type" => "school_manager",
                "status" => "active",
            ],
            [
                "name" => "manager_3",
                "email" => "manager_3@app.laam.sa",
                "phone" => "0512345673",
                "user_type" => "school_manager",
                "status" => "active",
            ],
            [
                "name" => "manager_4",
                "email" => "manager_4@app.laam.sa",
                "phone" => "0512345674",
                "user_type" => "school_manager",
                "status" => "active",
            ],
            [
                "name" => "manager_5",
                "email" => "manager_5@app.laam.sa",
                "phone" => "0512345674",
                "user_type" => "school_manager",
                "status" => "active",
            ]
        ];

        $user_teachers =
            [
                [
                    "name" => "teacher_1",
                    "email" => "teacher_1@app.laam.sa",
                    "phone" => "0512345611",
                    "user_type" => "teacher",
                    "status" => "active"
                ],
                [
                    "name" => "teacher_2",
                    "email" => "teacher_2@app.laam.sa",
                    "phone" => "0512345629",
                    "user_type" => "teacher",
                    "status" => "active"
                ],
                [
                    "name" => "teacher_3",
                    "email" => "teacher_3@app.laam.sa",
                    "phone" => "0512345620",
                    "user_type" => "teacher",
                    "status" => "active"
                ],
                [
                    "name" => "teacher_4",
                    "email" => "teacher_4@app.laam.sa",
                    "phone" => "0512345625",
                    "user_type" => "teacher",
                    "status" => "active"
                ],
                [
                    "name" => "teacher_5",
                    "email" => "teacher_5@app.laam.sa",
                    "phone" => "0512345625",
                    "user_type" => "teacher",
                    "status" => "active"
                ],
                [
                    "name" => "teacher_6",
                    "email" => "teacher_6@app.laam.sa",
                    "phone" => "0512345622",
                    "user_type" => "teacher",
                    "status" => "active"
                ]
            ];

        $class_names = [
            ["name" => 'الاول المتوسطه', "category" => "عام بنين - We can Mc Graw Hill"],
            ["name" => 'الاولى الثانوي', "category" => "المسار العام"],
            ["name" => 'الثاني الثانوي', "category" => "مسار الصحة والحياة"],
            ["name" => 'مرحلة الطفولة', "category" => "طفولة مبكرة"],
            ["name" => 'مرحلة الطفولة', "category" => "طفولة مبكرة"],
        ];
        $class_numbers = [
            1,
            2,
            3,
            4,
            4
        ];
        $school_year = Helper::getSchoolYear();


        foreach ($user_managers as $index => $user_manager) {
            if ($index === count($user_managers) - 1 ) {
                $admin_account = User::create($super_admin);
                $admin_school = School::create([
                    'user_id' => $admin_account->id,
                    'current_school_year' => $school_year,
                    'reg_step1' => 'completed',
                    'reg_step2' => 'completed',
                    'reg_step3' => 'completed',
                    'reg_step4' => 'completed',
                    'reg_step5' => 'completed',
                    'reg_step6' => 'completed',
                    'reg_step7' => 'completed',
                    'registration_complete' => 'yes',
                ]);
                Subscription::create([
                    'user_id'=> $admin_account->id,
                    'product_id'=>2,
                    'status'=> 'subscribed',
                    'service_type'=>'sms',
                    'paid_status'=>'paid'
                ]);
                $admin_schoolFacilitie = SchoolFacilitie::create(['school_id' => $admin_school->id]);
                $admin_faker = Faker::create();
                SchoolReference::create([
                    'school_id' => $admin_school->id,
                    'tel_phone' => $admin_faker->unique()->numerify('#########'),
                    'phone' => $admin_faker->unique()->numerify('#########'),
                    'whatsapp' => '010110100101',
                    'facebook' => 'link',
                    'x_link' => 'link',
                    'website' => 'link',
                    'snap_chat' => 'link',
                    'tiktok' => 'link',
                    'telegram' => 'link',
                ]);
                $step_2_request = [
                    "shift" => "morning",
                    "childhood" => "no",
                    "school_grade_id" => 4,
                    "gender" => "female",
                    "name" => "مدرسة مدير المنصه",
                    "ministry_number" => '535902' . $admin_account->id,
                    "education_type" => "governmental",
                    "education_department_id" => 1,
                    "educational_office_id" => 1,
                    "founding_date" => "20/09/1430",
                    "founding_date_type" => "hijri",
                    "address" => "عنوان أفتراضي لا يمثل شئ من الواقع",
                    "area_id" => 1,
                    "city_id" => 1,
                    "current_school_year" => $school_year,
                    "reg_step2" => "completed"
                ];
                $admin_school->update($step_2_request);

                //$step =3
                $step_3_request = [
                    "building_type" => "governmental",
                    "building_status" => "well_equipped",
                    "n_class" => 20,
                    "n_bathrooms" => 8,
                    "n_floors" => 5,
                    "n_team_rooms" => 10,
                    "n_management_rooms" => 6,
                    "n_computer_laps" => 5,
                    "n_science_laps" => 4,
                    "n_ware_houses" => 1,
                    "n_learning_resources" => 20,
                    "n_activity_rooms" => 12,
                    "n_meeting_rooms" => 2,
                    "n_sport_houses" => 4,
                    "n_theaters" => 3,
                    "n_playgrouonds" => 2,
                    "n_outdoors_court" => 3,
                    "n_indoors_court" => 4,
                ];
                $school = School::where('user_id', $admin_account->id)->where('id', $admin_school->id)->firstOrFail();
                $admin_schoolFacilitie->update($step_3_request);
                $school->update(['reg_step3' => 'completed']);

                // $step 4
                $school = School::where('user_id', $admin_account->id)->where('id', $admin_school->id)->firstOrFail();

                $className = new ClassName();
                $className->school_id = $admin_school->id;
                $className->school_grade_id = $admin_school->school_grade_id;
                $className->name = $class_names[$index]['name'];
                $className->category = $class_names[$index]['category'];
                $className->save();

                $admin_schoolClass = new SchoolClass();
                $admin_schoolClass->school_id = $admin_school->id;
                $admin_schoolClass->school_year = $school_year;
                $admin_schoolClass->class_name_id = $className->id;
                $admin_schoolClass->class_number = $class_numbers[$index];
                $admin_schoolClass->n_students = 20;
                $admin_schoolClass->save();

                $admin_student_faker = Faker::create();
                for ($i = 0; $i < 20; $i++) {
                    Student::create([
                        'name' => $admin_student_faker->name,
                        'ssn' => $admin_student_faker->unique()->numerify('#########'),
                        'nationality' => "سعودى",
                        'phone' => $admin_student_faker->unique()->numerify('05########'),
                        'class_id' => $admin_schoolClass->id,
                        'school_id' => $admin_school->id,
                        'current_school_year' => $school_year
                    ]);
                }
                // manager
                SchoolEmployee::create([
                    'name' => $admin_account->name,
                    'ssn' => $admin_faker->unique()->numerify('#########'),
                    'email' => $admin_account->email,
                    'phone' => $admin_account->phone,
                    'type' => 'adminstrative',
                    'current_work_id' => 1,
                    'specialization_id' => NULL,
                    'school_id' => $admin_school->id,
                    'have_account' => 'yes',
                    'current_school_year' => $school_year,
                    'user_id' => $admin_account->id,
                ]);
                /**save teacher schedules*/
                Helper::saveTeacherSchedules($admin_school->id);

                /**save  super vision schedules*/
                Helper::saveSupervisionSchedules($admin_school->id);

                /** store SchoolManager Assignment*/
                Helper::storeSchoolManagerAssignment($admin_school->id);

                /* save manager plans*/
                Helper::managerPLans($admin_school->id);


                $school->update(['reg_step4' => 'completed']);

            }
            if($just_admin == false){

                // for 5 schools
                $user_manager['password'] = Hash::make('123456');
                $user_teachers[$index]['password'] = Hash::make('123456');
                $user = User::create($user_manager);
                $teacher =  User::create($user_teachers[$index]);
                //$step =1
                $school = School::create([
                    'user_id' => $user->id,
                    'current_school_year' => $school_year,
                    'reg_step1' => 'completed',
                    'reg_step5' => 'completed',
                    'reg_step6' => 'completed',
                    'reg_step7' => 'completed',
                    'registration_complete' => 'yes'
                ]);

                $schoolFacilitie = SchoolFacilitie::create(['school_id' => $school->id]);
                $ref_faker = Faker::create();
                SchoolReference::create([
                    'school_id' => $school->id,
                    'tel_phone' => $ref_faker->unique()->numerify('#########'),
                    'phone' => $ref_faker->unique()->numerify('#########'),
                    'whatsapp' => '966512344628',
                    'facebook' => 'link',
                    'x_link' => 'link',
                    'website' => 'link',
                    'snap_chat' => 'link',
                    'tiktok' => 'link',
                    'telegram' => 'link',
                ]);
                //$step =2
                $school_faker = Faker::create();
                $step_2_request = [
                    "shift" => "morning",
                    "childhood" => "no",
                    "school_grade_id" => ($index + 1)==5?4: $index + 1,
                    "gender" => "female",
                    "name" => $school_faker->name,
                    "ministry_number" => '53590842' . $user->id,
                    "education_type" => "governmental",
                    "education_department_id" => 1,
                    "educational_office_id" => 1,
                    "founding_date" => "20/09/1430",
                    "founding_date_type" => "hijri",
                    "address" => "عنوان أفتراضي لا يمثل شئ من الواقع",
                    "area_id" => 1,
                    "city_id" => 1,
                    "current_school_year" => $school_year,
                    "reg_step2" => "completed"
                ];
                $school->update($step_2_request);

                //$step =3
                $step_3_request = [
                    "building_type" => "governmental",
                    "building_status" => "well_equipped",
                    "n_class" => 20,
                    "n_bathrooms" => 8,
                    "n_floors" => 5,
                    "n_team_rooms" => 10,
                    "n_management_rooms" => 6,
                    "n_computer_laps" => 5,
                    "n_science_laps" => 4,
                    "n_ware_houses" => 1,
                    "n_learning_resources" => 20,
                    "n_activity_rooms" => 12,
                    "n_meeting_rooms" => 2,
                    "n_sport_houses" => 4,
                    "n_theaters" => 3,
                    "n_playgrouonds" => 2,
                    "n_outdoors_court" => 3,
                    "n_indoors_court" => 4,
                ];
                $school = School::where('user_id', $user->id)->where('id', $school->id)->firstOrFail();
                $schoolFacilitie->update($step_3_request);
                $school->update(['reg_step3' => 'completed']);


                // $step 4
                $school = School::where('user_id', $user->id)->where('id', $school->id)->firstOrFail();

                $className = new ClassName();
                $className->school_id = $school->id;
                $className->school_grade_id = $school->school_grade_id;
                $className->name = $class_names[$index]['name'];
                $className->category = $class_names[$index]['category'];
                $className->save();

                $schoolClass = new SchoolClass();
                $schoolClass->school_id = $school->id;
                $schoolClass->school_year = $school_year;
                $schoolClass->class_name_id = $className->id;
                $schoolClass->class_number = $class_numbers[$index];
                $schoolClass->n_students = 20;
                $schoolClass->save();

                $faker = Faker::create();
                for ($i = 0; $i < 20; $i++) {
                    Student::create([
                        'name' => $faker->name,
                        'ssn' => $faker->unique()->numerify('#########'),
                        'nationality' => "سعودى",
                        'phone' => $faker->unique()->numerify('05########'),
                        'class_id' => $schoolClass->id,
                        'school_id' => $school->id,
                        'current_school_year' => $school_year
                    ]);
                }

                // manager
                SchoolEmployee::create([
                    'name' => $user->name,
                    'ssn' => $faker->unique()->numerify('#########'),
                    'email' => $user->email,
                    'phone' => $user->phone,
                    'user_id' => $user->id,
                    'type' => 'adminstrative',
                    'current_work_id' => 1,
                    'specialization_id' => NULL,
                    'school_id' => $school->id,
                    'have_account' => 'yes',
                    'current_school_year' => $school_year,
                ]);
                // teacher
                SchoolEmployee::create([
                    'name' => $teacher->name,
                    'user_id' => $teacher->id,
                    'ssn' => $faker->unique()->numerify('#########'),
                    'email' => $teacher->email,
                    'phone' => $teacher->phone,
                    'type' => 'teacher',
                    'current_work_id' => 2,
                    'specialization_id' => 1,
                    'school_id' => $school->id,
                    'have_account' => 'yes',
                    'current_school_year' => $school_year,
                ]);


                /**save teacher schedules*/
                Helper::saveTeacherSchedules($school->id);

                /**save  super vision schedules*/
                Helper::saveSupervisionSchedules($school->id);

                /** store SchoolManager Assignment*/
                Helper::storeSchoolManagerAssignment($school->id);

                /* save manager plans*/
                Helper::managerPLans($school->id);


                $school->update(['reg_step4' => 'completed']);
            }
        }
    }
}
