<?php

namespace Database\Seeders;

use App\Models\AdminDashboard\EducationalDepartment\EducationalDepartment;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class EducationalDepartmentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $departments = [
            ['id' => 1, 'name' => 'الإدارة العامة للتعليم بمنطقة الرياض', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 2, 'name' => 'الإدارة العامة للتعليم بمنطقة جدة', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 3, 'name' => 'الإدارة العامة للتعليم بمنطقة المدينة المنورة', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 4, 'name' => 'إدارة التعليم بمحافظة الطائف', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 5, 'name' => 'الإدارة العامة للتعليم بمنطقة نجران', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 6, 'name' => 'الإدارة العامة للتعليم بمنطقة الجوف', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 7, 'name' => 'الإدارة العامة للتعليم بمنطقة حائل', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 8, 'name' => 'الإدارة العامة للتعليم بمنطقة الباحة', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 9, 'name' => 'إدارة التعليم بمحافظة الدوادمي', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 10, 'name' => 'إدارة التعليم بمحافظة ينبع', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 11, 'name' => 'إدارة التعليم بمحافظة المجمعة', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 12, 'name' => 'إدارة التعليم بمحافظة الليث', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 13, 'name' => 'إدارة التعليم بمحافظة صبيا', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 14, 'name' => 'إدارة التعليم بمحافظة العال', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 15, 'name' => 'إدارة التعليم بمحافظة حوطة بني تميم والحريق', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 16, 'name' => 'إدارة التعليم بمحافظة شقراء', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 17, 'name' => 'إدارة التعليم بمحافظة القويعية', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 18, 'name' => 'الإدارة العامة للتعليم بمنطقة مكة المكرمة', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 19, 'name' => 'الإدارة العامة للتعليم بمنطقة القصيم', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 20, 'name' => 'الإدارة العامة للتعليم بمحافظة الأحساء', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 21, 'name' => 'الإدارة العامة للتعليم بالمنطقة الشرقية', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 22, 'name' => 'الإدارة العامة للتعليم بمنطقة تبوك', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 23, 'name' => 'إدارة التعليم بمحافظة المخواة', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 24, 'name' => 'الإدارة العامة للتعليم بمنطقة جازان', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 25, 'name' => 'الإدارة العامة للتعليم بمنطقة الحدود الشمالية', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 26, 'name' => 'إدارة التعليم بمحافظة الرس', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 27, 'name' => 'إدارة التعليم بمحافظة سراة عبيدة', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 28, 'name' => 'إدارة التعليم بمحافظة عفيف', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 29, 'name' => 'إدارة التعليم بمحافظة ظهران الجنوب', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 30, 'name' => 'إدارة التعليم بمحافظة وادي الدواسر', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 31, 'name' => 'إدارة التعليم بمحافظة محايل', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 32, 'name' => 'إدارة التعليم بمحافظة بيشة', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 33, 'name' => 'إدارة التعليم بمحافظة رجال ألمع', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 34, 'name' => 'إدارة التعليم بمحافظة تثليث', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 35, 'name' => 'إدارة التعليم بمحافظة القنفذة', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 36, 'name' => 'إدارة التعليم بمحافظة النماص', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 37, 'name' => 'إدارة التعليم بمحافظة بيشة', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 38, 'name' => 'إدارة التعليم بمحافظة رجال ألمع', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
            ['id' => 39, 'name' => 'إدارة التعليم بمحافظة شرورة', 'status' => 1, 'created_at' => '2024-09-07 08:38:37', 'updated_at' => '2024-09-07 08:38:37', 'deleted_at' => null],
        ];
        foreach ($departments as $department) {
            // Check if the department with this 'id' already exists
            if (!EducationalDepartment::where('id', $department['id'])->exists()) {
                EducationalDepartment::create($department);
            }
        }
    }
}
