<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\ManagerDashboard\Assignments\AssignmentCategory;
use App\Models\ManagerDashboard\Tklfats\TklfatSubCategory;

class AssignmentCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categoryNames = [
            'إدارة المدرسة'=>[
                ['name' => 'تكليف مدير المدرسة', 'assignment_form_number' => '014'],
                ['name' => 'تكليف وكيل الشؤون التعليمية', 'assignment_form_number' => '011'],
                ['name' => 'تكليف وكيل شؤون الطلاب', 'assignment_form_number' => '012'],
                ['name' => 'تكليف وكيل الشؤون المدرسية', 'assignment_form_number' => '013']
            ],
            'المعلمات'=>[
                ['name' => 'تكليف المعلمين', 'assignment_form_number' => '018'],
                ['name' => 'تكليف معلمين التربية الخاصة', 'assignment_form_number' => '016'],
                ['name' => 'تكليف معلم الموهوبين', 'assignment_form_number' => '015'],
                ['name' => 'تكليف مساعد معلم التربية الخاصة', 'assignment_form_number' => '017']
            ],
            'منسوبي المدرسة' => [
                ['name' => 'تكليف الموجه الطلابي', 'assignment_form_number' => '021'],
                ['name' => 'تكليف رائد النشاط', 'assignment_form_number' => '026'],
                ['name' => 'تكليف أمين مصادر التعليم', 'assignment_form_number' => '002'],
                ['name' => '(السكرتير)تكليف مساعد إداري', 'assignment_form_number' => '019'],
                ['name' => 'تكليف محضر المختبر', 'assignment_form_number' => '023'],
                ['name' => 'تكليف الموجه الصحي', 'assignment_form_number' => '020'],
                ['name' => 'تكليف مسجل المعلومات', 'assignment_form_number' => '024'],
                ['name' => 'تكليف حارس المدرسة', 'assignment_form_number' => '025'],
                ['name' => 'تكليف عامل الخدمات', 'assignment_form_number' => '027'],
            ],
            'اللجان و الفرق' => [
                ['name' => 'تكليف اللجان'],
                ['name' => 'تكليف الفرق']
            ],
            'التكليفات العامة' => [
                ['name' => 'تكليفات عامة', 'assignment_form_number' => '037']
            ]
        ];
    
        foreach($categoryNames as $categoryName => $subCategoryDetails){
            AssignmentCategory::create(['name'=> $categoryName]);
        }
    }
    
}
