<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('class_visit_cards', function (Blueprint $table) {
           $table->string('qualification_date')->after('teacher_qualification')->nullable();
           $table->enum('qualification_date_type', ['coptic', 'hijri'])->after('qualification_date')->nullable();
           $table->enum('direct_school_date_type', ['coptic', 'hijri'])->after('direct_school_date')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('class_visit_cards', function (Blueprint $table) {
            $table->dropColumn('qualification_date');
            $table->dropColumn('qualification_date_type');
            $table->dropColumn('direct_school_date_type');
        });
    }
};
