<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('namazeg_versions', function (Blueprint $table) {
            // Check if the foreign key exists before dropping it
            $foreignKeyExists = DB::select("
                SELECT CONSTRAINT_NAME
                FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE
                WHERE TABLE_NAME = 'namazeg_versions'
                AND CONSTRAINT_NAME = 'namazeg_versions_namazeg_id_foreign'
            ");

            if (!empty($foreignKeyExists)) {
                $table->dropForeign('namazeg_versions_namazeg_id_foreign');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::table('namazeg_versions', function (Blueprint $table) {
            // Add the foreign key back if needed
            $table->foreign('namazeg_id')
                ->references('id')
                ->on('namazeg')
                ->onDelete('cascade');
        });
    }
};
