<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('table_exam_namazegs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('table_exam_id');
            $table->unsignedBigInteger('namazeg_version_id');
            $table->foreign('table_exam_id')->references('id')->on('table_exams')->onDelete('cascade');
            $table->foreign('namazeg_version_id')->references('id')->on('namazeg_versions')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('table_exam_namazegs');
    }
};
