<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('violation_students', function (Blueprint $table) {
            if (!Schema::hasColumn('violation_students', 'namazeg_version_id')) {
                Schema::table('violation_students', function (Blueprint $table) {
                    $table->unsignedBigInteger('namazeg_version_id')->after('id');
                });
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('violation_students', function (Blueprint $table) {
            if (Schema::hasColumn('violation_students', 'namazeg_version_id')) {
                Schema::table('violation_students', function (Blueprint $table) {
                    $table->dropForeign(['namazeg_version_id']);
                    $table->dropColumn('namazeg_version_id');
                });
            }
        });
    }
};
