<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('specializations', function (Blueprint $table) {
            $table->unsignedBigInteger('school_grade_id')->nullable(); // Adjust the column type if needed
            $table->enum('gender', ['male', 'female'])->nullable(); // Set nullable if it's optional
            $table->foreign('school_grade_id')->references('id')->on('school_grades')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('specializations', function (Blueprint $table) {
            $table->dropColumn(['school_grade_id', 'gender']);
        });
    }
};
