<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('notifications', function (Blueprint $table) {
            if (!Schema::hasColumn('notifications', 'note_enum_id')) {
                $table->integer('note_enum_id')->nullable()->after('id');
            }
        });
        Schema::table('notification_receptors', function (Blueprint $table) {
            if (!Schema::hasColumn('notification_receptors', 'note_enum_id')) {
                $table->integer('note_enum_id')->nullable()->after('id');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('notifications', function (Blueprint $table) {
            if (Schema::hasColumn('notifications', 'note_enum_id')) {
                $table->dropColumn('note_enum_id');
            }
        });
        Schema::table('notification_receptors', function (Blueprint $table) {
            if (Schema::hasColumn('notification_receptors', 'note_enum_id')) {
                $table->dropColumn('note_enum_id');
            }
        });
    }
};
