<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('notification_school_settings', function (Blueprint $table) {
            $table->boolean('website_disability')->default(0)->after('website');
            $table->boolean('app_disability')->default(0)->after('app');
            $table->boolean('messages_disability')->default(0)->after('messages');
        });
        Schema::table('notification_settings', function (Blueprint $table) {
            $table->boolean('website_disability')->default(0)->after('name');
            $table->boolean('app_disability')->default(0)->after('name');
            $table->boolean('messages_disability')->default(0)->after('name');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('notification_school_settings', function (Blueprint $table) {
            $table->dropColumn('website_disability');
            $table->dropColumn('app_disability');
            $table->dropColumn('messages_disability');
        });
        Schema::table('notification_settings', function (Blueprint $table) {
            $table->dropColumn('website_disability');
            $table->dropColumn('app_disability');
            $table->dropColumn('messages_disability');
        });
    }
};
