<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('basic_relative_punishments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('relation_violation_punishment_id');
            $table->foreign('relation_violation_punishment_id', 'fk_relation_violation_punishment')
                ->references('id')->on('violation_punishments')
                ->cascadeOnDelete();
            $table->foreignId('violation_punishment_id');
            $table->foreign('violation_punishment_id', 'fk_violation_punishment')
                ->references('id')->on('namazeg')
                ->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('basic_relative_punishments');
    }
};
