<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exams_namazeg_daily_observers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('namazeg_version_id');
            $table->foreignId('school_id')->constrained('schools')->onDelete('cascade');
            $table->unsignedBigInteger('monitor_id');
            $table->unsignedBigInteger('committee_id');
            $table->unsignedBigInteger('subject_id');
            $table->string('exam_time');
            $table->json('employees_ids');
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('monitor_id')->references('id')->on('exams_namazeg_distribution_assignment_monitors')->onDelete('cascade');
            $table->foreign('committee_id')->references('id')->on('exams_student_committees_table')->onDelete('cascade');
            $table->foreign('subject_id')->references('id')->on('subjects')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exams_namazeg_daily_observers');
    }
};
